/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.gimpact;

import org.cpp4j.java.RefBoolean;
import org.cpp4j.java.RefFloat;
import org.cpp4j.java.RefInt;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimTrimeshTrimeshCol;

public class GimTriCollision
extends GimGeometry {
    static final int MAX_TRI_CLIPPING = 8;

    static int PLANE_CLIP_POLYGON(GimGeometry.vec4f plane, GimGeometry.vec3f[] polygon_points, int polygon_point_count, GimGeometry.vec3f[] clipped, int max_clipped) {
        int clipped_count = 0;
        int _prevclassif = 32000;
        int _i = 0;
        while (_i <= polygon_point_count) {
            boolean _classif;
            int _vi = _i % polygon_point_count;
            float _d = GimTriCollision.DISTANCE_PLANE_POINT(plane, polygon_points[_vi]);
            boolean bl = _classif = _d > 1.0E-7f;
            if (!_classif) {
                if (_prevclassif == 1 && clipped_count < max_clipped) {
                    GimTriCollision.PLANE_CLIP_SEGMENT(polygon_points[_i - 1], polygon_points[_vi], plane, clipped[clipped_count]);
                    ++clipped_count;
                }
                if (clipped_count < max_clipped && _i < polygon_point_count) {
                    GimTriCollision.VEC_COPY(clipped[clipped_count], polygon_points[_vi]);
                    ++clipped_count;
                }
                _prevclassif = 0;
            } else {
                if (_prevclassif == 0 && clipped_count < max_clipped) {
                    GimTriCollision.PLANE_CLIP_SEGMENT(polygon_points[_i - 1], polygon_points[_vi], plane, clipped[clipped_count]);
                    ++clipped_count;
                }
                _prevclassif = 1;
            }
            ++_i;
        }
        return clipped_count;
    }

    void GIM_CALC_TRIANGLE_DATA_PLANES(GIM_TRIANGLE_DATA tri_data) {
        GimTriCollision.TRIANGLE_PLANE(tri_data.m_vertices[0], tri_data.m_vertices[1], tri_data.m_vertices[2], tri_data.m_planes.m_planes[0]);
        GimTriCollision.EDGE_PLANE(tri_data.m_vertices[0], tri_data.m_vertices[1], tri_data.m_planes.m_planes[0], tri_data.m_planes.m_planes[1]);
        GimTriCollision.EDGE_PLANE(tri_data.m_vertices[1], tri_data.m_vertices[2], tri_data.m_planes.m_planes[0], tri_data.m_planes.m_planes[2]);
        GimTriCollision.EDGE_PLANE(tri_data.m_vertices[2], tri_data.m_vertices[0], tri_data.m_planes.m_planes[0], tri_data.m_planes.m_planes[3]);
    }

    boolean gim_triangle_triangle_collision(GIM_TRIANGLE_DATA tri1, GIM_TRIANGLE_DATA tri2, GIM_TRIANGLE_CONTACT_DATA contact_data) {
        return GimTrimeshTrimeshCol.gim_triangle_triangle_collision(tri1, tri2, contact_data);
    }

    static void TRIANGLE_GET_UVPARAMETERS(GimGeometry.vec3f point, GimGeometry.vec3f vec1, GimGeometry.vec3f vec2, GimGeometry.vec3f vec3, GimGeometry.vec4f tri_plane, RefFloat u, RefFloat v, RefBoolean outside) {
        float sumuv;
        GimGeometry.vec3f _axe1 = new GimGeometry.vec3f();
        GimGeometry.vec3f _axe2 = new GimGeometry.vec3f();
        GimGeometry.vec3f _vecproj = new GimGeometry.vec3f();
        GimTriCollision.VEC_DIFF(_axe1, vec2, vec1);
        GimTriCollision.VEC_DIFF(_axe2, vec3, vec1);
        GimTriCollision.VEC_DIFF(_vecproj, point, vec1);
        RefInt _i1 = new RefInt();
        RefInt _i2 = new RefInt();
        GimTriCollision.PLANE_MINOR_AXES(tri_plane, _i1, _i2);
        if (Math.abs(_axe2.f[_i2.i]) < 1.0E-7f) {
            u.d = (_vecproj.f[_i2.i] * _axe2.f[_i1.i] - _vecproj.f[_i1.i] * _axe2.f[_i2.i]) / (_axe1.f[_i2.i] * _axe2.f[_i1.i] - _axe1.f[_i1.i] * _axe2.f[_i2.i]);
            v.d = (_vecproj.f[_i1.i] - u.d * _axe1.f[_i1.i]) / _axe2.f[_i1.i];
        } else {
            u.d = (_vecproj.f[_i1.i] * _axe2.f[_i2.i] - _vecproj.f[_i2.i] * _axe2.f[_i1.i]) / (_axe1.f[_i1.i] * _axe2.f[_i2.i] - _axe1.f[_i2.i] * _axe2.f[_i1.i]);
            v.d = (_vecproj.f[_i2.i] - u.d * _axe1.f[_i2.i]) / _axe2.f[_i2.i];
        }
        outside.b = u.d < -1.0E-7f ? true : (v.d < -1.0E-7f ? true : ((sumuv = u.d + v.d) < -1.0E-7f ? true : sumuv - 1.0f > 1.0E-7f));
    }

    static void RAY_TRIANGLE_INTERSECTION(GimGeometry.vec3f vOrigin, GimGeometry.vec3f vDir, GimGeometry.vec3f vec1, GimGeometry.vec3f vec2, GimGeometry.vec3f vec3, GimGeometry.vec4f tri_plane, GimGeometry.vec3f pout, RefFloat u, RefFloat v, RefFloat tparam, float tmax, RefBoolean does_intersect) {
        GimTriCollision.RAY_PLANE_COLLISION(tri_plane, vDir, vOrigin, pout, tparam, does_intersect);
        if (does_intersect.b) {
            if (tparam.d < -1.0E-7f || tparam.d > tmax + 1.0E-7f) {
                does_intersect.b = false;
            } else {
                GimTriCollision.TRIANGLE_GET_UVPARAMETERS(pout, vec1, vec2, vec3, tri_plane, u, v, does_intersect);
                does_intersect.b = !does_intersect.b;
            }
        }
    }

    private static float FABS(float x) {
        return Math.abs(x);
    }

    private int CLASSIFY_TRIPOINTS_BY_FACE(GimGeometry.vec3f v1, GimGeometry.vec3f v2, GimGeometry.vec3f v3, GimGeometry.vec4f faceplane, GimGeometry.vec3f _distances) {
        _distances.f[0] = GimTriCollision.DISTANCE_PLANE_POINT(faceplane, v1);
        _distances.f[1] = _distances.f[0] * GimTriCollision.DISTANCE_PLANE_POINT(faceplane, v2);
        _distances.f[2] = _distances.f[0] * GimTriCollision.DISTANCE_PLANE_POINT(faceplane, v3);
        if (_distances.f[1] > 0.0f && _distances.f[2] > 0.0f) {
            return 1;
        }
        return 0;
    }

    private void SORT(float[] f) {
        if (f[0] > f[1]) {
            float c = f[0];
            f[0] = f[1];
            f[1] = c;
        }
    }

    private boolean EDGE_EDGE_TEST(GimGeometry.vec3f V0, GimGeometry.vec3f U0, GimGeometry.vec3f U1, float Ax, float Ay, int i0, int i1) {
        float Bx = U0.f[i0] - U1.f[i0];
        float By = U0.f[i1] - U1.f[i1];
        float Cx = V0.f[i0] - U0.f[i0];
        float Cy = V0.f[i1] - U0.f[i1];
        float f = Ay * Bx - Ax * By;
        float d = By * Cx - Bx * Cy;
        if (f > 0.0f && d >= 0.0f && d <= f || f < 0.0f && d <= 0.0f && d >= f) {
            float e = Ax * Cy - Ay * Cx;
            if (f > 0.0f ? e >= 0.0f && e <= f : e <= 0.0f && e >= f) {
                return true;
            }
        }
        return false;
    }

    private boolean EDGE_AGAINST_TRI_EDGES(GimGeometry.vec3f V0, GimGeometry.vec3f V1, GimGeometry.vec3f U0, GimGeometry.vec3f U1, GimGeometry.vec3f U2, int i0, int i1) {
        float Ax = V1.f[i0] - V0.f[i0];
        float Ay = V1.f[i1] - V0.f[i1];
        if (this.EDGE_EDGE_TEST(V0, U0, U1, Ax, Ay, i0, i1)) {
            return true;
        }
        if (this.EDGE_EDGE_TEST(V0, U1, U2, Ax, Ay, i0, i1)) {
            return true;
        }
        return this.EDGE_EDGE_TEST(V0, U2, U0, Ax, Ay, i0, i1);
    }

    int coplanar_tri_tri(GIM_TRIANGLE_DATA tri1, GIM_TRIANGLE_DATA tri2) {
        RefInt i0 = new RefInt();
        RefInt i1 = new RefInt();
        GimTriCollision.PLANE_MINOR_AXES(tri1.m_planes.m_planes[0], i0, i1);
        if (this.EDGE_AGAINST_TRI_EDGES(tri1.m_vertices[0], tri1.m_vertices[1], tri2.m_vertices[0], tri2.m_vertices[1], tri2.m_vertices[2], i0.i, i1.i)) {
            return 1;
        }
        if (this.EDGE_AGAINST_TRI_EDGES(tri1.m_vertices[1], tri1.m_vertices[2], tri2.m_vertices[0], tri2.m_vertices[1], tri2.m_vertices[2], i0.i, i1.i)) {
            return 1;
        }
        if (this.EDGE_AGAINST_TRI_EDGES(tri1.m_vertices[2], tri1.m_vertices[0], tri2.m_vertices[0], tri2.m_vertices[1], tri2.m_vertices[2], i0.i, i1.i)) {
            return 1;
        }
        i0.i = GimTriCollision.POINT_IN_HULL_TZ(tri1.m_vertices[0], tri2.m_planes.m_planes, 1, 3);
        if (i0.i == 0) {
            return 1;
        }
        i0.i = GimTriCollision.POINT_IN_HULL_TZ(tri2.m_vertices[0], tri1.m_planes.m_planes, 1, 3);
        if (i0.i == 0) {
            return 1;
        }
        return 0;
    }

    int gim_triangle_triangle_overlap(GIM_TRIANGLE_DATA tri1, GIM_TRIANGLE_DATA tri2) {
        float y1;
        float y0;
        float f;
        float e;
        float d;
        float x1;
        float x0;
        float c;
        float b;
        float a;
        GimGeometry.vec3f _distances = new GimGeometry.vec3f();
        int out_of_face = this.CLASSIFY_TRIPOINTS_BY_FACE(tri1.m_vertices[0], tri1.m_vertices[1], tri1.m_vertices[2], tri2.m_planes.m_planes[0], _distances);
        if (out_of_face == 1) {
            return 0;
        }
        out_of_face = this.CLASSIFY_TRIPOINTS_BY_FACE(tri2.m_vertices[0], tri2.m_vertices[1], tri2.m_vertices[2], tri1.m_planes.m_planes[0], _distances);
        if (out_of_face == 1) {
            return 0;
        }
        float du0 = 0.0f;
        float du1 = 0.0f;
        float du2 = 0.0f;
        float dv0 = 0.0f;
        float dv1 = 0.0f;
        float dv2 = 0.0f;
        GimGeometry.vec3f D = new GimGeometry.vec3f();
        float[] isect1 = new float[2];
        float[] isect2 = new float[2];
        float du0du1 = 0.0f;
        float du0du2 = 0.0f;
        float dv0dv1 = 0.0f;
        float dv0dv2 = 0.0f;
        GimTriCollision.VEC_CROSS(D, tri1.m_planes.m_planes[0], tri2.m_planes.m_planes[0]);
        float max = GimTriCollision.FABS(D.f[0]);
        int index = 0;
        float bb = GimTriCollision.FABS(D.f[1]);
        float cc = GimTriCollision.FABS(D.f[2]);
        if (bb > max) {
            max = bb;
            index = 1;
        }
        if (cc > max) {
            max = cc;
            index = 2;
        }
        float vp0 = tri1.m_vertices[0].f[index];
        float vp1 = tri1.m_vertices[1].f[index];
        float vp2 = tri1.m_vertices[2].f[index];
        float up0 = tri2.m_vertices[0].f[index];
        float up1 = tri2.m_vertices[1].f[index];
        float up2 = tri2.m_vertices[2].f[index];
        float VV0 = vp0;
        float VV1 = vp1;
        float VV2 = vp2;
        float D0 = dv0;
        float D1 = dv1;
        float D2 = dv2;
        float D0D1 = dv0dv1;
        float D0D2 = dv0dv2;
        if (D0D1 > 0.0f) {
            a = VV2;
            b = (VV0 - VV2) * D2;
            c = (VV1 - VV2) * D2;
            x0 = D2 - D0;
            x1 = D2 - D1;
        } else if (D0D2 > 0.0f) {
            a = VV1;
            b = (VV0 - VV1) * D1;
            c = (VV2 - VV1) * D1;
            x0 = D1 - D0;
            x1 = D1 - D2;
        } else if (D1 * D2 > 0.0f || D0 != 0.0f) {
            a = VV0;
            b = (VV1 - VV0) * D0;
            c = (VV2 - VV0) * D0;
            x0 = D0 - D1;
            x1 = D0 - D2;
        } else if (D1 != 0.0f) {
            a = VV1;
            b = (VV0 - VV1) * D1;
            c = (VV2 - VV1) * D1;
            x0 = D1 - D0;
            x1 = D1 - D2;
        } else if (D2 != 0.0f) {
            a = VV2;
            b = (VV0 - VV2) * D2;
            c = (VV1 - VV2) * D2;
            x0 = D2 - D0;
            x1 = D2 - D1;
        } else {
            return this.coplanar_tri_tri(tri1, tri2);
        }
        float VV02 = up0;
        float VV12 = up1;
        float VV22 = up2;
        float D02 = du0;
        float D12 = du1;
        float D22 = du2;
        float D0D12 = du0du1;
        float D0D22 = du0du2;
        if (D0D12 > 0.0f) {
            d = VV22;
            e = (VV02 - VV22) * D22;
            f = (VV12 - VV22) * D22;
            y0 = D22 - D02;
            y1 = D22 - D12;
        } else if (D0D22 > 0.0f) {
            d = VV12;
            e = (VV02 - VV12) * D12;
            f = (VV22 - VV12) * D12;
            y0 = D12 - D02;
            y1 = D12 - D22;
        } else if (D12 * D22 > 0.0f || D02 != 0.0f) {
            d = VV02;
            e = (VV12 - VV02) * D02;
            f = (VV22 - VV02) * D02;
            y0 = D02 - D12;
            y1 = D02 - D22;
        } else if (D12 != 0.0f) {
            d = VV12;
            e = (VV02 - VV12) * D12;
            f = (VV22 - VV12) * D12;
            y0 = D12 - D02;
            y1 = D12 - D22;
        } else if (D22 != 0.0f) {
            d = VV22;
            e = (VV02 - VV22) * D22;
            f = (VV12 - VV22) * D22;
            y0 = D22 - D02;
            y1 = D22 - D12;
        } else {
            return this.coplanar_tri_tri(tri1, tri2);
        }
        float xx = x0 * x1;
        float yy = y0 * y1;
        float xxyy = xx * yy;
        float tmp = a * xxyy;
        isect1[0] = tmp + b * x1 * yy;
        isect1[1] = tmp + c * x0 * yy;
        tmp = d * xxyy;
        isect2[0] = tmp + e * xx * y1;
        isect2[1] = tmp + f * xx * y0;
        this.SORT(isect1);
        this.SORT(isect2);
        if (isect1[1] < isect2[0] || isect2[1] < isect1[0]) {
            return 0;
        }
        return 1;
    }

    static class GIM_TRIANGLE_CONTACT_DATA {
        float m_penetration_depth;
        int m_point_count;
        final GimGeometry.vec3f m_separating_normal = new GimGeometry.vec3f();
        final GimGeometry.vec3f[] m_points = new GimGeometry.vec3f[8];

        GIM_TRIANGLE_CONTACT_DATA() {
            int i = 0;
            while (i < this.m_points.length) {
                this.m_points[i] = new GimGeometry.vec3f();
                ++i;
            }
        }
    }

    static class GIM_TRIANGLE_DATA {
        final GimGeometry.vec3f[] m_vertices = new GimGeometry.vec3f[]{new GimGeometry.vec3f(), new GimGeometry.vec3f(), new GimGeometry.vec3f()};
        final GIM_TRIPLANES_CACHE m_planes = new GIM_TRIPLANES_CACHE();

        GIM_TRIANGLE_DATA() {
        }
    }

    public static class GIM_TRIANGLE_RAY_CONTACT_DATA {
        float u;
        float v;
        float tparam;
        int m_face_id;
        final GimGeometry.vec3f m_point = new GimGeometry.vec3f();
        final GimGeometry.vec3f m_normal = new GimGeometry.vec3f();

        public GimGeometry.vec3f getPoint() {
            return this.m_point;
        }

        public GimGeometry.vec3f getNormal() {
            return this.m_normal;
        }

        public float getU() {
            return this.u;
        }

        public float getV() {
            return this.v;
        }

        public float getTParam() {
            return this.tparam;
        }

        public int getFaceID() {
            return this.m_face_id;
        }
    }

    static class GIM_TRIPLANES_CACHE {
        final GimGeometry.vec4f[] m_planes = new GimGeometry.vec4f[]{new GimGeometry.vec4f(), new GimGeometry.vec4f(), new GimGeometry.vec4f(), new GimGeometry.vec4f()};

        GIM_TRIPLANES_CACHE() {
        }
    }
}

