/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.gimpact;

import org.cpp4j.java.FloatArray;
import org.cpp4j.java.RefBoolean;
import org.cpp4j.java.RefFloat;
import org.cpp4j.java.RefInt;
import org.ode4j.ode.internal.gimpact.GimMath;

public class GimGeometry
extends GimMath {
    static final float PLANEDIREPSILON = 1.0E-7f;
    static final float PARALELENORMALS = 1.0E-6f;

    private static final int M(int y, int x) {
        return y * 4 + x;
    }

    static final void VEC_ZERO_2(vec2f a) {
        a.f[1] = 0.0f;
        a.f[0] = 0.0f;
    }

    static final void VEC_ZERO(vec3f a) {
        a.f[2] = 0.0f;
        a.f[1] = 0.0f;
        a.f[0] = 0.0f;
    }

    static final void VEC_ZERO_4(vec4f a) {
        a.f[3] = 0.0f;
        a.f[2] = 0.0f;
        a.f[1] = 0.0f;
        a.f[0] = 0.0f;
    }

    static final void VEC_COPY_2(vec2f b, vec2f a) {
        b.f[0] = a.f[0];
        b.f[1] = a.f[1];
    }

    static final void VEC_COPY(vec3f b, vec3f a) {
        b.f[0] = a.f[0];
        b.f[1] = a.f[1];
        b.f[2] = a.f[2];
    }

    static final void VEC_COPY(vec3f b, vec4f a) {
        b.f[0] = a.f[0];
        b.f[1] = a.f[1];
        b.f[2] = a.f[2];
    }

    static final void VEC_COPY(vec4f b, vec3f a) {
        b.f[0] = a.f[0];
        b.f[1] = a.f[1];
        b.f[2] = a.f[2];
    }

    static final void VEC_COPY_4(vec4f b, vec4f a) {
        b.f[0] = a.f[0];
        b.f[1] = a.f[1];
        b.f[2] = a.f[2];
        b.f[3] = a.f[3];
    }

    static final void VEC_DIFF_2(vec2f v21, vec2f v2, vec2f v1) {
        v21.f[0] = v2.f[0] - v1.f[0];
        v21.f[1] = v2.f[1] - v1.f[1];
    }

    static final void VEC_DIFF(vec3f v21, vec3f v2, vec3f v1) {
        v21.f[0] = v2.f[0] - v1.f[0];
        v21.f[1] = v2.f[1] - v1.f[1];
        v21.f[2] = v2.f[2] - v1.f[2];
    }

    static final void VEC_DIFF(vec4f v21, vec3f v2, vec3f v1) {
        v21.f[0] = v2.f[0] - v1.f[0];
        v21.f[1] = v2.f[1] - v1.f[1];
        v21.f[2] = v2.f[2] - v1.f[2];
    }

    static final void VEC_DIFF_4(vec4f v21, vec4f v2, vec4f v1) {
        v21.f[0] = v2.f[0] - v1.f[0];
        v21.f[1] = v2.f[1] - v1.f[1];
        v21.f[2] = v2.f[2] - v1.f[2];
        v21.f[3] = v2.f[3] - v1.f[3];
    }

    static final void VEC_SUM_2(vec2f v21, vec2f v2, vec2f v1) {
        v21.f[0] = v2.f[0] + v1.f[0];
        v21.f[1] = v2.f[1] + v1.f[1];
    }

    static final void VEC_SUM(vec3f v21, vec3f v2, vec3f v1) {
        v21.f[0] = v2.f[0] + v1.f[0];
        v21.f[1] = v2.f[1] + v1.f[1];
        v21.f[2] = v2.f[2] + v1.f[2];
    }

    static final void VEC_SUM_4(vec4f v21, vec4f v2, vec4f v1) {
        v21.f[0] = v2.f[0] + v1.f[0];
        v21.f[1] = v2.f[1] + v1.f[1];
        v21.f[2] = v2.f[2] + v1.f[2];
        v21.f[3] = v2.f[3] + v1.f[3];
    }

    static final void VEC_SCALE_2(vec2f c, float a, vec2f b) {
        c.f[0] = a * b.f[0];
        c.f[1] = a * b.f[1];
    }

    static final void VEC_SCALE(vec3f c, float a, vec3f b) {
        c.f[0] = a * b.f[0];
        c.f[1] = a * b.f[1];
        c.f[2] = a * b.f[2];
    }

    static final void VEC_SCALE(vec3f c, float a, vec4f b) {
        c.f[0] = a * b.f[0];
        c.f[1] = a * b.f[1];
        c.f[2] = a * b.f[2];
    }

    static final void VEC_SCALE_4(vec4f c, float a, vec4f b) {
        c.f[0] = a * b.f[0];
        c.f[1] = a * b.f[1];
        c.f[2] = a * b.f[2];
        c.f[3] = a * b.f[3];
    }

    static final void VEC_ACCUM_2(vec2f c, float a, vec2f b) {
        c.f[0] = c.f[0] + a * b.f[0];
        c.f[1] = c.f[1] + a * b.f[1];
    }

    static final void VEC_ACCUM(vec3f c, float a, vec3f b) {
        c.f[0] = c.f[0] + a * b.f[0];
        c.f[1] = c.f[1] + a * b.f[1];
        c.f[2] = c.f[2] + a * b.f[2];
    }

    static final void VEC_ACCUM_4(vec4f c, float a, vec4f b) {
        c.f[0] = c.f[0] + a * b.f[0];
        c.f[1] = c.f[1] + a * b.f[1];
        c.f[2] = c.f[2] + a * b.f[2];
        c.f[3] = c.f[3] + a * b.f[3];
    }

    static final float VEC_DOT_2(vec2f a, vec2f b) {
        return a.f[0] * b.f[0] + a.f[1] * b.f[1];
    }

    static final float VEC_DOT(vec3f a, vec3f b) {
        return a.f[0] * b.f[0] + a.f[1] * b.f[1] + a.f[2] * b.f[2];
    }

    static final float VEC_DOT(vec4f a, vec3f b) {
        return a.f[0] * b.f[0] + a.f[1] * b.f[1] + a.f[2] * b.f[2];
    }

    static final float VEC_DOT(vec3f a, vec4f b) {
        return a.f[0] * b.f[0] + a.f[1] * b.f[1] + a.f[2] * b.f[2];
    }

    static final float VEC_DOT(vec4f a, vec4f b) {
        return a.f[0] * b.f[0] + a.f[1] * b.f[1] + a.f[2] * b.f[2];
    }

    static final float VEC_DOT(vec4f a, float[] b) {
        return a.f[0] * b[0] + a.f[1] * b[1] + a.f[2] * b[2];
    }

    static final float VEC_DOT_4(vec4f a, vec4f b) {
        return a.f[0] * b.f[0] + a.f[1] * b.f[1] + a.f[2] * b.f[2] + a.f[3] * b.f[3];
    }

    static final void VEC_IMPACT_SQ(RefFloat bsq, vec3f direction, vec3f position) {
        float _llel_ = GimGeometry.VEC_DOT(direction, position);
        bsq.d = GimGeometry.VEC_DOT(position, position) - _llel_ * _llel_;
    }

    static final float VEC_IMPACT_SQ(vec3f direction, vec3f position) {
        float _llel_ = GimGeometry.VEC_DOT(direction, position);
        return GimGeometry.VEC_DOT(position, position) - _llel_ * _llel_;
    }

    static final void VEC_IMPACT(RefFloat bsq, vec3f direction, vec3f position) {
        GimGeometry.VEC_IMPACT_SQ(bsq, direction, position);
        bsq.d = GimGeometry.GIM_SQRT(bsq.d);
    }

    static final float VEC_IMPACT(vec3f direction, vec3f position) {
        float bsq = GimGeometry.VEC_IMPACT_SQ(direction, position);
        bsq = GimGeometry.GIM_SQRT(bsq);
        return bsq;
    }

    static final void VEC_LENGTH_2(vec2f a, RefFloat l) {
        float _pp = GimGeometry.VEC_DOT_2(a, a);
        l.d = GimGeometry.GIM_SQRT(_pp);
    }

    static final void VEC_LENGTH(vec3f a, RefFloat l) {
        float _pp = GimGeometry.VEC_DOT(a, a);
        l.d = GimGeometry.GIM_SQRT(_pp);
    }

    static final float VEC_LENGTH(vec3f a) {
        float _pp = GimGeometry.VEC_DOT(a, a);
        return GimGeometry.GIM_SQRT(_pp);
    }

    static final void VEC_LENGTH_4(vec4f a, RefFloat l) {
        float _pp = GimGeometry.VEC_DOT_4(a, a);
        l.d = GimGeometry.GIM_SQRT(_pp);
    }

    static final void VEC_INV_LENGTH_2(vec2f a, RefFloat l) {
        float _pp = GimGeometry.VEC_DOT_2(a, a);
        l.d = GimGeometry.GIM_INV_SQRT(_pp);
    }

    static final float VEC_INV_LENGTH(vec3f a) {
        float _pp = GimGeometry.VEC_DOT(a, a);
        return GimGeometry.GIM_INV_SQRT(_pp);
    }

    static final float VEC_INV_LENGTH(vec4f a) {
        float _pp = GimGeometry.VEC_DOT(a, a);
        return GimGeometry.GIM_INV_SQRT(_pp);
    }

    static final void VEC_INV_LENGTH_4(vec4f a, RefFloat l) {
        float _pp = GimGeometry.VEC_DOT_4(a, a);
        l.d = GimGeometry.GIM_INV_SQRT(_pp);
    }

    private static final void VEC_DISTANCE(RefFloat _len, vec3f _va, vec3f _vb) {
        vec3f _tmp_ = new vec3f();
        GimGeometry.VEC_DIFF(_tmp_, _vb, _va);
        GimGeometry.VEC_LENGTH(_tmp_, _len);
    }

    static final void VEC_CONJUGATE_LENGTH(vec3f a, RefFloat l) {
        float _pp = 1.0f - a.f[0] * a.f[0] - a.f[1] * a.f[1] - a.f[2] * a.f[2];
        l.d = GimGeometry.GIM_SQRT(_pp);
    }

    static final void VEC_NORMALIZE(vec3f a) {
        float len = GimGeometry.VEC_INV_LENGTH(a);
        if (len < Float.POSITIVE_INFINITY) {
            a.f[0] = a.f[0] * len;
            a.f[1] = a.f[1] * len;
            a.f[2] = a.f[2] * len;
        }
    }

    static final void VEC_NORMALIZE(vec4f a) {
        float len = GimGeometry.VEC_INV_LENGTH(a);
        if (len < Float.POSITIVE_INFINITY) {
            a.f[0] = a.f[0] * len;
            a.f[1] = a.f[1] * len;
            a.f[2] = a.f[2] * len;
        }
    }

    static final void VEC_RENORMALIZE(vec3f a, float newlen) {
        float len = GimGeometry.VEC_INV_LENGTH(a);
        if (len < Float.POSITIVE_INFINITY) {
            a.f[0] = a.f[0] * (len *= newlen);
            a.f[1] = a.f[1] * len;
            a.f[2] = a.f[2] * len;
        }
    }

    static final void VEC_CROSS(vec3f c, vec3f a, vec3f b) {
        c.f[0] = a.f[1] * b.f[2] - a.f[2] * b.f[1];
        c.f[1] = a.f[2] * b.f[0] - a.f[0] * b.f[2];
        c.f[2] = a.f[0] * b.f[1] - a.f[1] * b.f[0];
    }

    static final void VEC_CROSS(vec4f c, vec3f a, vec3f b) {
        c.f[0] = a.f[1] * b.f[2] - a.f[2] * b.f[1];
        c.f[1] = a.f[2] * b.f[0] - a.f[0] * b.f[2];
        c.f[2] = a.f[0] * b.f[1] - a.f[1] * b.f[0];
    }

    static final void VEC_CROSS(vec4f c, vec3f a, vec4f b) {
        c.f[0] = a.f[1] * b.f[2] - a.f[2] * b.f[1];
        c.f[1] = a.f[2] * b.f[0] - a.f[0] * b.f[2];
        c.f[2] = a.f[0] * b.f[1] - a.f[1] * b.f[0];
    }

    static final void VEC_CROSS(vec3f c, vec4f a, vec4f b) {
        c.f[0] = a.f[1] * b.f[2] - a.f[2] * b.f[1];
        c.f[1] = a.f[2] * b.f[0] - a.f[0] * b.f[2];
        c.f[2] = a.f[0] * b.f[1] - a.f[1] * b.f[0];
    }

    static final void VEC_PERPENDICULAR(vec3f vp, vec3f v, vec3f n) {
        float dot = GimGeometry.VEC_DOT(v, n);
        vp.f[0] = v.f[0] - dot * n.f[0];
        vp.f[1] = v.f[1] - dot * n.f[1];
        vp.f[2] = v.f[2] - dot * n.f[2];
    }

    static final void VEC_PARALLEL(vec3f vp, vec3f v, vec3f n) {
        float dot = GimGeometry.VEC_DOT(v, n);
        vp.f[0] = dot * n.f[0];
        vp.f[1] = dot * n.f[1];
        vp.f[2] = dot * n.f[2];
    }

    static final void VEC_PROJECT(vec3f vp, vec3f v, vec3f n) {
        float scalar = GimGeometry.VEC_DOT(v, n);
        vp.f[0] = (scalar /= GimGeometry.VEC_DOT(n, n)) * n.f[0];
        vp.f[1] = scalar * n.f[1];
        vp.f[2] = scalar * n.f[2];
    }

    static final void VEC_UNPROJECT(vec3f vp, vec3f v, vec3f n) {
        float scalar = GimGeometry.VEC_DOT(v, n);
        scalar = GimGeometry.VEC_DOT(n, n) / scalar;
        vp.f[0] = scalar * n.f[0];
        vp.f[1] = scalar * n.f[1];
        vp.f[2] = scalar * n.f[2];
    }

    static final void VEC_REFLECT(vec3f vr, vec3f v, vec3f n) {
        float dot = GimGeometry.VEC_DOT(v, n);
        vr.f[0] = v.f[0] - 2.0f * dot * n.f[0];
        vr.f[1] = v.f[1] - 2.0f * dot * n.f[1];
        vr.f[2] = v.f[2] - 2.0f * dot * n.f[2];
    }

    static final void VEC_BLEND_AB(vec3f vr, float sa, vec3f a, float sb, vec3f b) {
        vr.f[0] = sa * a.f[0] + sb * b.f[0];
        vr.f[1] = sa * a.f[1] + sb * b.f[1];
        vr.f[2] = sa * a.f[2] + sb * b.f[2];
    }

    static final void IDENTIFY_MATRIX_3X3(mat3f m) {
        m.f[GimGeometry.M((int)0, (int)0)] = 1.0f;
        m.f[GimGeometry.M((int)0, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)0, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)1)] = 1.0f;
        m.f[GimGeometry.M((int)1, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)2)] = 1.0f;
    }

    public static final void IDENTIFY_MATRIX_4X4(mat4f m) {
        m.f[GimGeometry.M((int)0, (int)0)] = 1.0f;
        m.f[GimGeometry.M((int)0, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)0, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)0, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)1)] = 1.0f;
        m.f[GimGeometry.M((int)1, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)2)] = 1.0f;
        m.f[GimGeometry.M((int)2, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)3)] = 1.0f;
    }

    static final void ZERO_MATRIX_4X4(mat4f m) {
        m.f[GimGeometry.M((int)0, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)0, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)0, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)0, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)3)] = 0.0f;
    }

    static final void ROTX_CS(mat4f m, float cosine, float sine) {
        m.f[GimGeometry.M((int)0, (int)0)] = 1.0f;
        m.f[GimGeometry.M((int)0, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)0, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)0, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)1)] = cosine;
        m.f[GimGeometry.M((int)1, (int)2)] = sine;
        m.f[GimGeometry.M((int)1, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)1)] = -sine;
        m.f[GimGeometry.M((int)2, (int)2)] = cosine;
        m.f[GimGeometry.M((int)2, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)3)] = 1.0f;
    }

    static final void ROTY_CS(mat4f m, float cosine, float sine) {
        m.f[GimGeometry.M((int)0, (int)0)] = cosine;
        m.f[GimGeometry.M((int)0, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)0, (int)2)] = -sine;
        m.f[GimGeometry.M((int)0, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)1)] = 1.0f;
        m.f[GimGeometry.M((int)1, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)0)] = sine;
        m.f[GimGeometry.M((int)2, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)2)] = cosine;
        m.f[GimGeometry.M((int)2, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)3)] = 1.0f;
    }

    static final void ROTZ_CS(mat4f m, float cosine, float sine) {
        m.f[GimGeometry.M((int)0, (int)0)] = cosine;
        m.f[GimGeometry.M((int)0, (int)1)] = sine;
        m.f[GimGeometry.M((int)0, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)0, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)0)] = -sine;
        m.f[GimGeometry.M((int)1, (int)1)] = cosine;
        m.f[GimGeometry.M((int)1, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)1, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)2, (int)2)] = 1.0f;
        m.f[GimGeometry.M((int)2, (int)3)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)0)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)1)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)2)] = 0.0f;
        m.f[GimGeometry.M((int)3, (int)3)] = 1.0f;
    }

    static final void COPY_MATRIX_2X2(mat2f b, mat2f a) {
        b.f[GimGeometry.M((int)0, (int)0)] = a.f[GimGeometry.M(0, 0)];
        b.f[GimGeometry.M((int)0, (int)1)] = a.f[GimGeometry.M(0, 1)];
        b.f[GimGeometry.M((int)1, (int)0)] = a.f[GimGeometry.M(1, 0)];
        b.f[GimGeometry.M((int)1, (int)1)] = a.f[GimGeometry.M(1, 1)];
    }

    static final void COPY_MATRIX_3X3(mat3f b, mat3f a) {
        b.f[GimGeometry.M((int)0, (int)0)] = a.f[GimGeometry.M(0, 0)];
        b.f[GimGeometry.M((int)0, (int)1)] = a.f[GimGeometry.M(0, 1)];
        b.f[GimGeometry.M((int)0, (int)2)] = a.f[GimGeometry.M(0, 2)];
        b.f[GimGeometry.M((int)1, (int)0)] = a.f[GimGeometry.M(1, 0)];
        b.f[GimGeometry.M((int)1, (int)1)] = a.f[GimGeometry.M(1, 1)];
        b.f[GimGeometry.M((int)1, (int)2)] = a.f[GimGeometry.M(1, 2)];
        b.f[GimGeometry.M((int)2, (int)0)] = a.f[GimGeometry.M(2, 0)];
        b.f[GimGeometry.M((int)2, (int)1)] = a.f[GimGeometry.M(2, 1)];
        b.f[GimGeometry.M((int)2, (int)2)] = a.f[GimGeometry.M(2, 2)];
    }

    static final void COPY_MATRIX_4X4(mat4f b, mat4f a) {
        b.f[GimGeometry.M((int)0, (int)0)] = a.f[GimGeometry.M(0, 0)];
        b.f[GimGeometry.M((int)0, (int)1)] = a.f[GimGeometry.M(0, 1)];
        b.f[GimGeometry.M((int)0, (int)2)] = a.f[GimGeometry.M(0, 2)];
        b.f[GimGeometry.M((int)0, (int)3)] = a.f[GimGeometry.M(0, 3)];
        b.f[GimGeometry.M((int)1, (int)0)] = a.f[GimGeometry.M(1, 0)];
        b.f[GimGeometry.M((int)1, (int)1)] = a.f[GimGeometry.M(1, 1)];
        b.f[GimGeometry.M((int)1, (int)2)] = a.f[GimGeometry.M(1, 2)];
        b.f[GimGeometry.M((int)1, (int)3)] = a.f[GimGeometry.M(1, 3)];
        b.f[GimGeometry.M((int)2, (int)0)] = a.f[GimGeometry.M(2, 0)];
        b.f[GimGeometry.M((int)2, (int)1)] = a.f[GimGeometry.M(2, 1)];
        b.f[GimGeometry.M((int)2, (int)2)] = a.f[GimGeometry.M(2, 2)];
        b.f[GimGeometry.M((int)2, (int)3)] = a.f[GimGeometry.M(2, 3)];
        b.f[GimGeometry.M((int)3, (int)0)] = a.f[GimGeometry.M(3, 0)];
        b.f[GimGeometry.M((int)3, (int)1)] = a.f[GimGeometry.M(3, 1)];
        b.f[GimGeometry.M((int)3, (int)2)] = a.f[GimGeometry.M(3, 2)];
        b.f[GimGeometry.M((int)3, (int)3)] = a.f[GimGeometry.M(3, 3)];
    }

    static final void TRANSPOSE_MATRIX_2X2(mat2f b, mat2f a) {
        b.f[GimGeometry.M((int)0, (int)0)] = a.f[GimGeometry.M(0, 0)];
        b.f[GimGeometry.M((int)0, (int)1)] = a.f[GimGeometry.M(1, 0)];
        b.f[GimGeometry.M((int)1, (int)0)] = a.f[GimGeometry.M(0, 1)];
        b.f[GimGeometry.M((int)1, (int)1)] = a.f[GimGeometry.M(1, 1)];
    }

    static final void TRANSPOSE_MATRIX_3X3(mat3f b, mat3f a) {
        b.f[GimGeometry.M((int)0, (int)0)] = a.f[GimGeometry.M(0, 0)];
        b.f[GimGeometry.M((int)0, (int)1)] = a.f[GimGeometry.M(1, 0)];
        b.f[GimGeometry.M((int)0, (int)2)] = a.f[GimGeometry.M(2, 0)];
        b.f[GimGeometry.M((int)1, (int)0)] = a.f[GimGeometry.M(0, 1)];
        b.f[GimGeometry.M((int)1, (int)1)] = a.f[GimGeometry.M(1, 1)];
        b.f[GimGeometry.M((int)1, (int)2)] = a.f[GimGeometry.M(2, 1)];
        b.f[GimGeometry.M((int)2, (int)0)] = a.f[GimGeometry.M(0, 2)];
        b.f[GimGeometry.M((int)2, (int)1)] = a.f[GimGeometry.M(1, 2)];
        b.f[GimGeometry.M((int)2, (int)2)] = a.f[GimGeometry.M(2, 2)];
    }

    static final void TRANSPOSE_MATRIX_4X4(mat4f b, mat4f a) {
        b.f[GimGeometry.M((int)0, (int)0)] = a.f[GimGeometry.M(0, 0)];
        b.f[GimGeometry.M((int)0, (int)1)] = a.f[GimGeometry.M(1, 0)];
        b.f[GimGeometry.M((int)0, (int)2)] = a.f[GimGeometry.M(2, 0)];
        b.f[GimGeometry.M((int)0, (int)3)] = a.f[GimGeometry.M(3, 0)];
        b.f[GimGeometry.M((int)1, (int)0)] = a.f[GimGeometry.M(0, 1)];
        b.f[GimGeometry.M((int)1, (int)1)] = a.f[GimGeometry.M(1, 1)];
        b.f[GimGeometry.M((int)1, (int)2)] = a.f[GimGeometry.M(2, 1)];
        b.f[GimGeometry.M((int)1, (int)3)] = a.f[GimGeometry.M(3, 1)];
        b.f[GimGeometry.M((int)2, (int)0)] = a.f[GimGeometry.M(0, 2)];
        b.f[GimGeometry.M((int)2, (int)1)] = a.f[GimGeometry.M(1, 2)];
        b.f[GimGeometry.M((int)2, (int)2)] = a.f[GimGeometry.M(2, 2)];
        b.f[GimGeometry.M((int)2, (int)3)] = a.f[GimGeometry.M(3, 2)];
        b.f[GimGeometry.M((int)3, (int)0)] = a.f[GimGeometry.M(0, 3)];
        b.f[GimGeometry.M((int)3, (int)1)] = a.f[GimGeometry.M(1, 3)];
        b.f[GimGeometry.M((int)3, (int)2)] = a.f[GimGeometry.M(2, 3)];
        b.f[GimGeometry.M((int)3, (int)3)] = a.f[GimGeometry.M(3, 3)];
    }

    static final void SCALE_MATRIX_2X2(mat2f b, float s, mat2f a) {
        b.f[GimGeometry.M((int)0, (int)0)] = s * a.f[GimGeometry.M(0, 0)];
        b.f[GimGeometry.M((int)0, (int)1)] = s * a.f[GimGeometry.M(0, 1)];
        b.f[GimGeometry.M((int)1, (int)0)] = s * a.f[GimGeometry.M(1, 0)];
        b.f[GimGeometry.M((int)1, (int)1)] = s * a.f[GimGeometry.M(1, 1)];
    }

    static final void SCALE_MATRIX_3X3(mat3f b, float s, mat3f a) {
        b.f[GimGeometry.M((int)0, (int)0)] = s * a.f[GimGeometry.M(0, 0)];
        b.f[GimGeometry.M((int)0, (int)1)] = s * a.f[GimGeometry.M(0, 1)];
        b.f[GimGeometry.M((int)0, (int)2)] = s * a.f[GimGeometry.M(0, 2)];
        b.f[GimGeometry.M((int)1, (int)0)] = s * a.f[GimGeometry.M(1, 0)];
        b.f[GimGeometry.M((int)1, (int)1)] = s * a.f[GimGeometry.M(1, 1)];
        b.f[GimGeometry.M((int)1, (int)2)] = s * a.f[GimGeometry.M(1, 2)];
        b.f[GimGeometry.M((int)2, (int)0)] = s * a.f[GimGeometry.M(2, 0)];
        b.f[GimGeometry.M((int)2, (int)1)] = s * a.f[GimGeometry.M(2, 1)];
        b.f[GimGeometry.M((int)2, (int)2)] = s * a.f[GimGeometry.M(2, 2)];
    }

    static final void SCALE_MATRIX_4X4(mat4f b, float s, mat4f a) {
        b.f[GimGeometry.M((int)0, (int)0)] = s * a.f[GimGeometry.M(0, 0)];
        b.f[GimGeometry.M((int)0, (int)1)] = s * a.f[GimGeometry.M(0, 1)];
        b.f[GimGeometry.M((int)0, (int)2)] = s * a.f[GimGeometry.M(0, 2)];
        b.f[GimGeometry.M((int)0, (int)3)] = s * a.f[GimGeometry.M(0, 3)];
        b.f[GimGeometry.M((int)1, (int)0)] = s * a.f[GimGeometry.M(1, 0)];
        b.f[GimGeometry.M((int)1, (int)1)] = s * a.f[GimGeometry.M(1, 1)];
        b.f[GimGeometry.M((int)1, (int)2)] = s * a.f[GimGeometry.M(1, 2)];
        b.f[GimGeometry.M((int)1, (int)3)] = s * a.f[GimGeometry.M(1, 3)];
        b.f[GimGeometry.M((int)2, (int)0)] = s * a.f[GimGeometry.M(2, 0)];
        b.f[GimGeometry.M((int)2, (int)1)] = s * a.f[GimGeometry.M(2, 1)];
        b.f[GimGeometry.M((int)2, (int)2)] = s * a.f[GimGeometry.M(2, 2)];
        b.f[GimGeometry.M((int)2, (int)3)] = s * a.f[GimGeometry.M(2, 3)];
        b.f[GimGeometry.M((int)3, (int)0)] = s * a.f[GimGeometry.M(3, 0)];
        b.f[GimGeometry.M((int)3, (int)1)] = s * a.f[GimGeometry.M(3, 1)];
        b.f[GimGeometry.M((int)3, (int)2)] = s * a.f[GimGeometry.M(3, 2)];
        b.f[GimGeometry.M((int)3, (int)3)] = s * a.f[GimGeometry.M(3, 3)];
    }

    static final void ACCUM_SCALE_MATRIX_2X2(mat2f b, float s, mat2f a) {
        int n = GimGeometry.M(0, 0);
        b.f[n] = b.f[n] + s * a.f[GimGeometry.M(0, 0)];
        int n2 = GimGeometry.M(0, 1);
        b.f[n2] = b.f[n2] + s * a.f[GimGeometry.M(0, 1)];
        int n3 = GimGeometry.M(1, 0);
        b.f[n3] = b.f[n3] + s * a.f[GimGeometry.M(1, 0)];
        int n4 = GimGeometry.M(1, 1);
        b.f[n4] = b.f[n4] + s * a.f[GimGeometry.M(1, 1)];
    }

    static final void ACCUM_SCALE_MATRIX_3X3(mat3f b, float s, mat3f a) {
        int n = GimGeometry.M(0, 0);
        b.f[n] = b.f[n] + s * a.f[GimGeometry.M(0, 0)];
        int n2 = GimGeometry.M(0, 1);
        b.f[n2] = b.f[n2] + s * a.f[GimGeometry.M(0, 1)];
        int n3 = GimGeometry.M(0, 2);
        b.f[n3] = b.f[n3] + s * a.f[GimGeometry.M(0, 2)];
        int n4 = GimGeometry.M(1, 0);
        b.f[n4] = b.f[n4] + s * a.f[GimGeometry.M(1, 0)];
        int n5 = GimGeometry.M(1, 1);
        b.f[n5] = b.f[n5] + s * a.f[GimGeometry.M(1, 1)];
        int n6 = GimGeometry.M(1, 2);
        b.f[n6] = b.f[n6] + s * a.f[GimGeometry.M(1, 2)];
        int n7 = GimGeometry.M(2, 0);
        b.f[n7] = b.f[n7] + s * a.f[GimGeometry.M(2, 0)];
        int n8 = GimGeometry.M(2, 1);
        b.f[n8] = b.f[n8] + s * a.f[GimGeometry.M(2, 1)];
        int n9 = GimGeometry.M(2, 2);
        b.f[n9] = b.f[n9] + s * a.f[GimGeometry.M(2, 2)];
    }

    static final void ACCUM_SCALE_MATRIX_4X4(mat4f b, float s, mat4f a) {
        int n = GimGeometry.M(0, 0);
        b.f[n] = b.f[n] + s * a.f[GimGeometry.M(0, 0)];
        int n2 = GimGeometry.M(0, 1);
        b.f[n2] = b.f[n2] + s * a.f[GimGeometry.M(0, 1)];
        int n3 = GimGeometry.M(0, 2);
        b.f[n3] = b.f[n3] + s * a.f[GimGeometry.M(0, 2)];
        int n4 = GimGeometry.M(0, 3);
        b.f[n4] = b.f[n4] + s * a.f[GimGeometry.M(0, 3)];
        int n5 = GimGeometry.M(1, 0);
        b.f[n5] = b.f[n5] + s * a.f[GimGeometry.M(1, 0)];
        int n6 = GimGeometry.M(1, 1);
        b.f[n6] = b.f[n6] + s * a.f[GimGeometry.M(1, 1)];
        int n7 = GimGeometry.M(1, 2);
        b.f[n7] = b.f[n7] + s * a.f[GimGeometry.M(1, 2)];
        int n8 = GimGeometry.M(1, 3);
        b.f[n8] = b.f[n8] + s * a.f[GimGeometry.M(1, 3)];
        int n9 = GimGeometry.M(2, 0);
        b.f[n9] = b.f[n9] + s * a.f[GimGeometry.M(2, 0)];
        int n10 = GimGeometry.M(2, 1);
        b.f[n10] = b.f[n10] + s * a.f[GimGeometry.M(2, 1)];
        int n11 = GimGeometry.M(2, 2);
        b.f[n11] = b.f[n11] + s * a.f[GimGeometry.M(2, 2)];
        int n12 = GimGeometry.M(2, 3);
        b.f[n12] = b.f[n12] + s * a.f[GimGeometry.M(2, 3)];
        int n13 = GimGeometry.M(3, 0);
        b.f[n13] = b.f[n13] + s * a.f[GimGeometry.M(3, 0)];
        int n14 = GimGeometry.M(3, 1);
        b.f[n14] = b.f[n14] + s * a.f[GimGeometry.M(3, 1)];
        int n15 = GimGeometry.M(3, 2);
        b.f[n15] = b.f[n15] + s * a.f[GimGeometry.M(3, 2)];
        int n16 = GimGeometry.M(3, 3);
        b.f[n16] = b.f[n16] + s * a.f[GimGeometry.M(3, 3)];
    }

    static final void MATRIX_PRODUCT_2X2(mat2f c, mat2f a, mat2f b) {
        c.f[GimGeometry.M((int)0, (int)0)] = a.f[GimGeometry.M(0, 0)] * b.f[GimGeometry.M(0, 0)] + a.f[GimGeometry.M(0, 1)] * b.f[GimGeometry.M(1, 0)];
        c.f[GimGeometry.M((int)0, (int)1)] = a.f[GimGeometry.M(0, 0)] * b.f[GimGeometry.M(0, 1)] + a.f[GimGeometry.M(0, 1)] * b.f[GimGeometry.M(1, 1)];
        c.f[GimGeometry.M((int)1, (int)0)] = a.f[GimGeometry.M(1, 0)] * b.f[GimGeometry.M(0, 0)] + a.f[GimGeometry.M(1, 1)] * b.f[GimGeometry.M(1, 0)];
        c.f[GimGeometry.M((int)1, (int)1)] = a.f[GimGeometry.M(1, 0)] * b.f[GimGeometry.M(0, 1)] + a.f[GimGeometry.M(1, 1)] * b.f[GimGeometry.M(1, 1)];
    }

    static final void MATRIX_PRODUCT_3X3(mat3f c, mat3f a, mat3f b) {
        c.f[GimGeometry.M((int)0, (int)0)] = a.f[GimGeometry.M(0, 0)] * b.f[GimGeometry.M(0, 0)] + a.f[GimGeometry.M(0, 1)] * b.f[GimGeometry.M(1, 0)] + a.f[GimGeometry.M(0, 2)] * b.f[GimGeometry.M(2, 0)];
        c.f[GimGeometry.M((int)0, (int)1)] = a.f[GimGeometry.M(0, 0)] * b.f[GimGeometry.M(0, 1)] + a.f[GimGeometry.M(0, 1)] * b.f[GimGeometry.M(1, 1)] + a.f[GimGeometry.M(0, 2)] * b.f[GimGeometry.M(2, 1)];
        c.f[GimGeometry.M((int)0, (int)2)] = a.f[GimGeometry.M(0, 0)] * b.f[GimGeometry.M(0, 2)] + a.f[GimGeometry.M(0, 1)] * b.f[GimGeometry.M(1, 2)] + a.f[GimGeometry.M(0, 2)] * b.f[GimGeometry.M(2, 2)];
        c.f[GimGeometry.M((int)1, (int)0)] = a.f[GimGeometry.M(1, 0)] * b.f[GimGeometry.M(0, 0)] + a.f[GimGeometry.M(1, 1)] * b.f[GimGeometry.M(1, 0)] + a.f[GimGeometry.M(1, 2)] * b.f[GimGeometry.M(2, 0)];
        c.f[GimGeometry.M((int)1, (int)1)] = a.f[GimGeometry.M(1, 0)] * b.f[GimGeometry.M(0, 1)] + a.f[GimGeometry.M(1, 1)] * b.f[GimGeometry.M(1, 1)] + a.f[GimGeometry.M(1, 2)] * b.f[GimGeometry.M(2, 1)];
        c.f[GimGeometry.M((int)1, (int)2)] = a.f[GimGeometry.M(1, 0)] * b.f[GimGeometry.M(0, 2)] + a.f[GimGeometry.M(1, 1)] * b.f[GimGeometry.M(1, 2)] + a.f[GimGeometry.M(1, 2)] * b.f[GimGeometry.M(2, 2)];
        c.f[GimGeometry.M((int)2, (int)0)] = a.f[GimGeometry.M(2, 0)] * b.f[GimGeometry.M(0, 0)] + a.f[GimGeometry.M(2, 1)] * b.f[GimGeometry.M(1, 0)] + a.f[GimGeometry.M(2, 2)] * b.f[GimGeometry.M(2, 0)];
        c.f[GimGeometry.M((int)2, (int)1)] = a.f[GimGeometry.M(2, 0)] * b.f[GimGeometry.M(0, 1)] + a.f[GimGeometry.M(2, 1)] * b.f[GimGeometry.M(1, 1)] + a.f[GimGeometry.M(2, 2)] * b.f[GimGeometry.M(2, 1)];
        c.f[GimGeometry.M((int)2, (int)2)] = a.f[GimGeometry.M(2, 0)] * b.f[GimGeometry.M(0, 2)] + a.f[GimGeometry.M(2, 1)] * b.f[GimGeometry.M(1, 2)] + a.f[GimGeometry.M(2, 2)] * b.f[GimGeometry.M(2, 2)];
    }

    static final void MATRIX_PRODUCT_4X4(mat4f c, mat4f a, mat4f b) {
        c.f[GimGeometry.M((int)0, (int)0)] = a.f[GimGeometry.M(0, 0)] * b.f[GimGeometry.M(0, 0)] + a.f[GimGeometry.M(0, 1)] * b.f[GimGeometry.M(1, 0)] + a.f[GimGeometry.M(0, 2)] * b.f[GimGeometry.M(2, 0)] + a.f[GimGeometry.M(0, 3)] * b.f[GimGeometry.M(3, 0)];
        c.f[GimGeometry.M((int)0, (int)1)] = a.f[GimGeometry.M(0, 0)] * b.f[GimGeometry.M(0, 1)] + a.f[GimGeometry.M(0, 1)] * b.f[GimGeometry.M(1, 1)] + a.f[GimGeometry.M(0, 2)] * b.f[GimGeometry.M(2, 1)] + a.f[GimGeometry.M(0, 3)] * b.f[GimGeometry.M(3, 1)];
        c.f[GimGeometry.M((int)0, (int)2)] = a.f[GimGeometry.M(0, 0)] * b.f[GimGeometry.M(0, 2)] + a.f[GimGeometry.M(0, 1)] * b.f[GimGeometry.M(1, 2)] + a.f[GimGeometry.M(0, 2)] * b.f[GimGeometry.M(2, 2)] + a.f[GimGeometry.M(0, 3)] * b.f[GimGeometry.M(3, 2)];
        c.f[GimGeometry.M((int)0, (int)3)] = a.f[GimGeometry.M(0, 0)] * b.f[GimGeometry.M(0, 3)] + a.f[GimGeometry.M(0, 1)] * b.f[GimGeometry.M(1, 3)] + a.f[GimGeometry.M(0, 2)] * b.f[GimGeometry.M(2, 3)] + a.f[GimGeometry.M(0, 3)] * b.f[GimGeometry.M(3, 3)];
        c.f[GimGeometry.M((int)1, (int)0)] = a.f[GimGeometry.M(1, 0)] * b.f[GimGeometry.M(0, 0)] + a.f[GimGeometry.M(1, 1)] * b.f[GimGeometry.M(1, 0)] + a.f[GimGeometry.M(1, 2)] * b.f[GimGeometry.M(2, 0)] + a.f[GimGeometry.M(1, 3)] * b.f[GimGeometry.M(3, 0)];
        c.f[GimGeometry.M((int)1, (int)1)] = a.f[GimGeometry.M(1, 0)] * b.f[GimGeometry.M(0, 1)] + a.f[GimGeometry.M(1, 1)] * b.f[GimGeometry.M(1, 1)] + a.f[GimGeometry.M(1, 2)] * b.f[GimGeometry.M(2, 1)] + a.f[GimGeometry.M(1, 3)] * b.f[GimGeometry.M(3, 1)];
        c.f[GimGeometry.M((int)1, (int)2)] = a.f[GimGeometry.M(1, 0)] * b.f[GimGeometry.M(0, 2)] + a.f[GimGeometry.M(1, 1)] * b.f[GimGeometry.M(1, 2)] + a.f[GimGeometry.M(1, 2)] * b.f[GimGeometry.M(2, 2)] + a.f[GimGeometry.M(1, 3)] * b.f[GimGeometry.M(3, 2)];
        c.f[GimGeometry.M((int)1, (int)3)] = a.f[GimGeometry.M(1, 0)] * b.f[GimGeometry.M(0, 3)] + a.f[GimGeometry.M(1, 1)] * b.f[GimGeometry.M(1, 3)] + a.f[GimGeometry.M(1, 2)] * b.f[GimGeometry.M(2, 3)] + a.f[GimGeometry.M(1, 3)] * b.f[GimGeometry.M(3, 3)];
        c.f[GimGeometry.M((int)2, (int)0)] = a.f[GimGeometry.M(2, 0)] * b.f[GimGeometry.M(0, 0)] + a.f[GimGeometry.M(2, 1)] * b.f[GimGeometry.M(1, 0)] + a.f[GimGeometry.M(2, 2)] * b.f[GimGeometry.M(2, 0)] + a.f[GimGeometry.M(2, 3)] * b.f[GimGeometry.M(3, 0)];
        c.f[GimGeometry.M((int)2, (int)1)] = a.f[GimGeometry.M(2, 0)] * b.f[GimGeometry.M(0, 1)] + a.f[GimGeometry.M(2, 1)] * b.f[GimGeometry.M(1, 1)] + a.f[GimGeometry.M(2, 2)] * b.f[GimGeometry.M(2, 1)] + a.f[GimGeometry.M(2, 3)] * b.f[GimGeometry.M(3, 1)];
        c.f[GimGeometry.M((int)2, (int)2)] = a.f[GimGeometry.M(2, 0)] * b.f[GimGeometry.M(0, 2)] + a.f[GimGeometry.M(2, 1)] * b.f[GimGeometry.M(1, 2)] + a.f[GimGeometry.M(2, 2)] * b.f[GimGeometry.M(2, 2)] + a.f[GimGeometry.M(2, 3)] * b.f[GimGeometry.M(3, 2)];
        c.f[GimGeometry.M((int)2, (int)3)] = a.f[GimGeometry.M(2, 0)] * b.f[GimGeometry.M(0, 3)] + a.f[GimGeometry.M(2, 1)] * b.f[GimGeometry.M(1, 3)] + a.f[GimGeometry.M(2, 2)] * b.f[GimGeometry.M(2, 3)] + a.f[GimGeometry.M(2, 3)] * b.f[GimGeometry.M(3, 3)];
        c.f[GimGeometry.M((int)3, (int)0)] = a.f[GimGeometry.M(3, 0)] * b.f[GimGeometry.M(0, 0)] + a.f[GimGeometry.M(3, 1)] * b.f[GimGeometry.M(1, 0)] + a.f[GimGeometry.M(3, 2)] * b.f[GimGeometry.M(2, 0)] + a.f[GimGeometry.M(3, 3)] * b.f[GimGeometry.M(3, 0)];
        c.f[GimGeometry.M((int)3, (int)1)] = a.f[GimGeometry.M(3, 0)] * b.f[GimGeometry.M(0, 1)] + a.f[GimGeometry.M(3, 1)] * b.f[GimGeometry.M(1, 1)] + a.f[GimGeometry.M(3, 2)] * b.f[GimGeometry.M(2, 1)] + a.f[GimGeometry.M(3, 3)] * b.f[GimGeometry.M(3, 1)];
        c.f[GimGeometry.M((int)3, (int)2)] = a.f[GimGeometry.M(3, 0)] * b.f[GimGeometry.M(0, 2)] + a.f[GimGeometry.M(3, 1)] * b.f[GimGeometry.M(1, 2)] + a.f[GimGeometry.M(3, 2)] * b.f[GimGeometry.M(2, 2)] + a.f[GimGeometry.M(3, 3)] * b.f[GimGeometry.M(3, 2)];
        c.f[GimGeometry.M((int)3, (int)3)] = a.f[GimGeometry.M(3, 0)] * b.f[GimGeometry.M(0, 3)] + a.f[GimGeometry.M(3, 1)] * b.f[GimGeometry.M(1, 3)] + a.f[GimGeometry.M(3, 2)] * b.f[GimGeometry.M(2, 3)] + a.f[GimGeometry.M(3, 3)] * b.f[GimGeometry.M(3, 3)];
    }

    static final void MAT_DOT_VEC_2X2(vec2f p, mat2f m, vec2f v) {
        p.f[0] = m.f[GimGeometry.M(0, 0)] * v.f[0] + m.f[GimGeometry.M(0, 1)] * v.f[1];
        p.f[1] = m.f[GimGeometry.M(1, 0)] * v.f[0] + m.f[GimGeometry.M(1, 1)] * v.f[1];
    }

    static final void MAT_DOT_VEC_3X3(vec3f p, mat3f m, vec3f v) {
        p.f[0] = m.f[GimGeometry.M(0, 0)] * v.f[0] + m.f[GimGeometry.M(0, 1)] * v.f[1] + m.f[GimGeometry.M(0, 2)] * v.f[2];
        p.f[1] = m.f[GimGeometry.M(1, 0)] * v.f[0] + m.f[GimGeometry.M(1, 1)] * v.f[1] + m.f[GimGeometry.M(1, 2)] * v.f[2];
        p.f[2] = m.f[GimGeometry.M(2, 0)] * v.f[0] + m.f[GimGeometry.M(2, 1)] * v.f[1] + m.f[GimGeometry.M(2, 2)] * v.f[2];
    }

    static final void MAT_DOT_VEC_4X4(vec4f p, mat4f m, vec4f v) {
        p.f[0] = m.f[GimGeometry.M(0, 0)] * v.f[0] + m.f[GimGeometry.M(0, 1)] * v.f[1] + m.f[GimGeometry.M(0, 2)] * v.f[2] + m.f[GimGeometry.M(0, 3)] * v.f[3];
        p.f[1] = m.f[GimGeometry.M(1, 0)] * v.f[0] + m.f[GimGeometry.M(1, 1)] * v.f[1] + m.f[GimGeometry.M(1, 2)] * v.f[2] + m.f[GimGeometry.M(1, 3)] * v.f[3];
        p.f[2] = m.f[GimGeometry.M(2, 0)] * v.f[0] + m.f[GimGeometry.M(2, 1)] * v.f[1] + m.f[GimGeometry.M(2, 2)] * v.f[2] + m.f[GimGeometry.M(2, 3)] * v.f[3];
        p.f[3] = m.f[GimGeometry.M(3, 0)] * v.f[0] + m.f[GimGeometry.M(3, 1)] * v.f[1] + m.f[GimGeometry.M(3, 2)] * v.f[2] + m.f[GimGeometry.M(3, 3)] * v.f[3];
    }

    static final void MAT_DOT_VEC_3X4(vec3f p, mat4f m, vec3f v) {
        p.f[0] = m.f[GimGeometry.M(0, 0)] * v.f[0] + m.f[GimGeometry.M(0, 1)] * v.f[1] + m.f[GimGeometry.M(0, 2)] * v.f[2] + m.f[GimGeometry.M(0, 3)];
        p.f[1] = m.f[GimGeometry.M(1, 0)] * v.f[0] + m.f[GimGeometry.M(1, 1)] * v.f[1] + m.f[GimGeometry.M(1, 2)] * v.f[2] + m.f[GimGeometry.M(1, 3)];
        p.f[2] = m.f[GimGeometry.M(2, 0)] * v.f[0] + m.f[GimGeometry.M(2, 1)] * v.f[1] + m.f[GimGeometry.M(2, 2)] * v.f[2] + m.f[GimGeometry.M(2, 3)];
    }

    static final void MAT_DOT_VEC_3X4(FloatArray p, mat4f m, FloatArray v) {
        p.setAt(0, m.f[GimGeometry.M(0, 0)] * v.at(0) + m.f[GimGeometry.M(0, 1)] * v.at(1) + m.f[GimGeometry.M(0, 2)] * v.at(2) + m.f[GimGeometry.M(0, 3)]);
        p.setAt(1, m.f[GimGeometry.M(1, 0)] * v.at(0) + m.f[GimGeometry.M(1, 1)] * v.at(1) + m.f[GimGeometry.M(1, 2)] * v.at(2) + m.f[GimGeometry.M(1, 3)]);
        p.setAt(2, m.f[GimGeometry.M(2, 0)] * v.at(0) + m.f[GimGeometry.M(2, 1)] * v.at(1) + m.f[GimGeometry.M(2, 2)] * v.at(2) + m.f[GimGeometry.M(2, 3)]);
    }

    static final void VEC_DOT_MAT_3X3(vec3f p, vec3f v, mat3f m) {
        p.f[0] = v.f[0] * m.f[GimGeometry.M(0, 0)] + v.f[1] * m.f[GimGeometry.M(1, 0)] + v.f[2] * m.f[GimGeometry.M(2, 0)];
        p.f[1] = v.f[0] * m.f[GimGeometry.M(0, 1)] + v.f[1] * m.f[GimGeometry.M(1, 1)] + v.f[2] * m.f[GimGeometry.M(2, 1)];
        p.f[2] = v.f[0] * m.f[GimGeometry.M(0, 2)] + v.f[1] * m.f[GimGeometry.M(1, 2)] + v.f[2] * m.f[GimGeometry.M(2, 2)];
    }

    static final void MAT_DOT_VEC_2X3(vec2f p, mat3f m, vec2f v) {
        p.f[0] = m.f[GimGeometry.M(0, 0)] * v.f[0] + m.f[GimGeometry.M(0, 1)] * v.f[1] + m.f[GimGeometry.M(0, 2)];
        p.f[1] = m.f[GimGeometry.M(1, 0)] * v.f[0] + m.f[GimGeometry.M(1, 1)] * v.f[1] + m.f[GimGeometry.M(1, 2)];
    }

    static final void INV_TRANSP_MAT_DOT_VEC_2X2(vec2f p, mat2f m, vec2f v) {
        float det = m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(1, 1)] - m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(1, 0)];
        p.f[0] = m.f[GimGeometry.M(1, 1)] * v.f[0] - m.f[GimGeometry.M(1, 0)] * v.f[1];
        p.f[1] = -m.f[GimGeometry.M(0, 1)] * v.f[0] + m.f[GimGeometry.M(0, 0)] * v.f[1];
        if (det != 1.0f && det != 0.0f) {
            det = 1.0f / det;
            p.f[0] = p.f[0] * det;
            p.f[1] = p.f[1] * det;
        }
    }

    static final void NORM_XFORM_2X2(vec2f p, mat2f m, vec2f v) {
        if ((double)m.f[GimGeometry.M(0, 1)] != 0.0 || (double)m.f[GimGeometry.M(1, 0)] != 0.0 || m.f[GimGeometry.M(0, 0)] != m.f[GimGeometry.M(1, 1)]) {
            p.f[0] = m.f[GimGeometry.M(1, 1)] * v.f[0] - m.f[GimGeometry.M(1, 0)] * v.f[1];
            p.f[1] = -m.f[GimGeometry.M(0, 1)] * v.f[0] + m.f[GimGeometry.M(0, 0)] * v.f[1];
            double len = p.f[0] * p.f[0] + p.f[1] * p.f[1];
            len = GimGeometry.GIM_INV_SQRT((float)len);
            p.f[0] = (float)((double)p.f[0] * len);
            p.f[1] = (float)((double)p.f[1] * len);
        } else {
            GimGeometry.VEC_COPY_2(p, v);
        }
    }

    static final void OUTER_PRODUCT_2X2(mat2f m, vec2f v, vec2f t) {
        m.f[GimGeometry.M((int)0, (int)0)] = v.f[0] * t.f[0];
        m.f[GimGeometry.M((int)0, (int)1)] = v.f[0] * t.f[1];
        m.f[GimGeometry.M((int)1, (int)0)] = v.f[1] * t.f[0];
        m.f[GimGeometry.M((int)1, (int)1)] = v.f[1] * t.f[1];
    }

    static final void OUTER_PRODUCT_3X3(mat3f m, vec3f v, vec3f t) {
        m.f[GimGeometry.M((int)0, (int)0)] = v.f[0] * t.f[0];
        m.f[GimGeometry.M((int)0, (int)1)] = v.f[0] * t.f[1];
        m.f[GimGeometry.M((int)0, (int)2)] = v.f[0] * t.f[2];
        m.f[GimGeometry.M((int)1, (int)0)] = v.f[1] * t.f[0];
        m.f[GimGeometry.M((int)1, (int)1)] = v.f[1] * t.f[1];
        m.f[GimGeometry.M((int)1, (int)2)] = v.f[1] * t.f[2];
        m.f[GimGeometry.M((int)2, (int)0)] = v.f[2] * t.f[0];
        m.f[GimGeometry.M((int)2, (int)1)] = v.f[2] * t.f[1];
        m.f[GimGeometry.M((int)2, (int)2)] = v.f[2] * t.f[2];
    }

    static final void OUTER_PRODUCT_4X4(mat4f m, vec4f v, vec4f t) {
        m.f[GimGeometry.M((int)0, (int)0)] = v.f[0] * t.f[0];
        m.f[GimGeometry.M((int)0, (int)1)] = v.f[0] * t.f[1];
        m.f[GimGeometry.M((int)0, (int)2)] = v.f[0] * t.f[2];
        m.f[GimGeometry.M((int)0, (int)3)] = v.f[0] * t.f[3];
        m.f[GimGeometry.M((int)1, (int)0)] = v.f[1] * t.f[0];
        m.f[GimGeometry.M((int)1, (int)1)] = v.f[1] * t.f[1];
        m.f[GimGeometry.M((int)1, (int)2)] = v.f[1] * t.f[2];
        m.f[GimGeometry.M((int)1, (int)3)] = v.f[1] * t.f[3];
        m.f[GimGeometry.M((int)2, (int)0)] = v.f[2] * t.f[0];
        m.f[GimGeometry.M((int)2, (int)1)] = v.f[2] * t.f[1];
        m.f[GimGeometry.M((int)2, (int)2)] = v.f[2] * t.f[2];
        m.f[GimGeometry.M((int)2, (int)3)] = v.f[2] * t.f[3];
        m.f[GimGeometry.M((int)3, (int)0)] = v.f[3] * t.f[0];
        m.f[GimGeometry.M((int)3, (int)1)] = v.f[3] * t.f[1];
        m.f[GimGeometry.M((int)3, (int)2)] = v.f[3] * t.f[2];
        m.f[GimGeometry.M((int)3, (int)3)] = v.f[3] * t.f[3];
    }

    static final void ACCUM_OUTER_PRODUCT_2X2(mat2f m, vec2f v, vec2f t) {
        int n = GimGeometry.M(0, 0);
        m.f[n] = m.f[n] + v.f[0] * t.f[0];
        int n2 = GimGeometry.M(0, 1);
        m.f[n2] = m.f[n2] + v.f[0] * t.f[1];
        int n3 = GimGeometry.M(1, 0);
        m.f[n3] = m.f[n3] + v.f[1] * t.f[0];
        int n4 = GimGeometry.M(1, 1);
        m.f[n4] = m.f[n4] + v.f[1] * t.f[1];
    }

    static final void ACCUM_OUTER_PRODUCT_3X3(mat3f m, vec3f v, vec3f t) {
        int n = GimGeometry.M(0, 0);
        m.f[n] = m.f[n] + v.f[0] * t.f[0];
        int n2 = GimGeometry.M(0, 1);
        m.f[n2] = m.f[n2] + v.f[0] * t.f[1];
        int n3 = GimGeometry.M(0, 2);
        m.f[n3] = m.f[n3] + v.f[0] * t.f[2];
        int n4 = GimGeometry.M(1, 0);
        m.f[n4] = m.f[n4] + v.f[1] * t.f[0];
        int n5 = GimGeometry.M(1, 1);
        m.f[n5] = m.f[n5] + v.f[1] * t.f[1];
        int n6 = GimGeometry.M(1, 2);
        m.f[n6] = m.f[n6] + v.f[1] * t.f[2];
        int n7 = GimGeometry.M(2, 0);
        m.f[n7] = m.f[n7] + v.f[2] * t.f[0];
        int n8 = GimGeometry.M(2, 1);
        m.f[n8] = m.f[n8] + v.f[2] * t.f[1];
        int n9 = GimGeometry.M(2, 2);
        m.f[n9] = m.f[n9] + v.f[2] * t.f[2];
    }

    static final void ACCUM_OUTER_PRODUCT_4X4(mat4f m, vec4f v, vec4f t) {
        int n = GimGeometry.M(0, 0);
        m.f[n] = m.f[n] + v.f[0] * t.f[0];
        int n2 = GimGeometry.M(0, 1);
        m.f[n2] = m.f[n2] + v.f[0] * t.f[1];
        int n3 = GimGeometry.M(0, 2);
        m.f[n3] = m.f[n3] + v.f[0] * t.f[2];
        int n4 = GimGeometry.M(0, 3);
        m.f[n4] = m.f[n4] + v.f[0] * t.f[3];
        int n5 = GimGeometry.M(1, 0);
        m.f[n5] = m.f[n5] + v.f[1] * t.f[0];
        int n6 = GimGeometry.M(1, 1);
        m.f[n6] = m.f[n6] + v.f[1] * t.f[1];
        int n7 = GimGeometry.M(1, 2);
        m.f[n7] = m.f[n7] + v.f[1] * t.f[2];
        int n8 = GimGeometry.M(1, 3);
        m.f[n8] = m.f[n8] + v.f[1] * t.f[3];
        int n9 = GimGeometry.M(2, 0);
        m.f[n9] = m.f[n9] + v.f[2] * t.f[0];
        int n10 = GimGeometry.M(2, 1);
        m.f[n10] = m.f[n10] + v.f[2] * t.f[1];
        int n11 = GimGeometry.M(2, 2);
        m.f[n11] = m.f[n11] + v.f[2] * t.f[2];
        int n12 = GimGeometry.M(2, 3);
        m.f[n12] = m.f[n12] + v.f[2] * t.f[3];
        int n13 = GimGeometry.M(3, 0);
        m.f[n13] = m.f[n13] + v.f[3] * t.f[0];
        int n14 = GimGeometry.M(3, 1);
        m.f[n14] = m.f[n14] + v.f[3] * t.f[1];
        int n15 = GimGeometry.M(3, 2);
        m.f[n15] = m.f[n15] + v.f[3] * t.f[2];
        int n16 = GimGeometry.M(3, 3);
        m.f[n16] = m.f[n16] + v.f[3] * t.f[3];
    }

    static final void DETERMINANT_2X2(RefFloat d, mat2f m) {
        d.d = m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(1, 1)] - m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(1, 0)];
    }

    static final void DETERMINANT_3X3(RefFloat d, mat3f m) {
        d.d = m.f[GimGeometry.M(0, 0)] * (m.f[GimGeometry.M(1, 1)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(1, 2)] * m.f[GimGeometry.M(2, 1)]);
        d.d -= m.f[GimGeometry.M(0, 1)] * (m.f[GimGeometry.M(1, 0)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(1, 2)] * m.f[GimGeometry.M(2, 0)]);
        d.d += m.f[GimGeometry.M(0, 2)] * (m.f[GimGeometry.M(1, 0)] * m.f[GimGeometry.M(2, 1)] - m.f[GimGeometry.M(1, 1)] * m.f[GimGeometry.M(2, 0)]);
    }

    static final float COFACTOR_4X4_IJ(mat4f m, int i, int j) {
        float fac = 0.0f;
        int[] __ii = new int[4];
        int[] __jj = new int[4];
        int __k = 0;
        while (__k < i) {
            __ii[__k] = __k;
            ++__k;
        }
        __k = i;
        while (__k < 3) {
            __ii[__k] = __k + 1;
            ++__k;
        }
        __k = 0;
        while (__k < j) {
            __jj[__k] = __k;
            ++__k;
        }
        __k = j;
        while (__k < 3) {
            __jj[__k] = __k + 1;
            ++__k;
        }
        fac = m.f[GimGeometry.M(__ii[0], __jj[0])] * (m.f[GimGeometry.M(__ii[1], __jj[1])] * m.f[GimGeometry.M(__ii[2], __jj[2])] - m.f[GimGeometry.M(__ii[1], __jj[2])] * m.f[GimGeometry.M(__ii[2], __jj[1])]);
        fac -= m.f[GimGeometry.M(__ii[0], __jj[1])] * (m.f[GimGeometry.M(__ii[1], __jj[0])] * m.f[GimGeometry.M(__ii[2], __jj[2])] - m.f[GimGeometry.M(__ii[1], __jj[2])] * m.f[GimGeometry.M(__ii[2], __jj[0])]);
        fac += m.f[GimGeometry.M(__ii[0], __jj[2])] * (m.f[GimGeometry.M(__ii[1], __jj[0])] * m.f[GimGeometry.M(__ii[2], __jj[1])] - m.f[GimGeometry.M(__ii[1], __jj[1])] * m.f[GimGeometry.M(__ii[2], __jj[0])]);
        __k = i + j;
        if (__k != __k / 2 * 2) {
            fac = -fac;
        }
        return fac;
    }

    static final void DETERMINANT_4X4(RefFloat d, mat4f m) {
        double cofac = GimGeometry.COFACTOR_4X4_IJ(m, 0, 0);
        d.d = (float)((double)m.f[GimGeometry.M(0, 0)] * cofac);
        cofac = GimGeometry.COFACTOR_4X4_IJ(m, 0, 1);
        d.d = (float)((double)d.d + (double)m.f[GimGeometry.M(0, 1)] * cofac);
        cofac = GimGeometry.COFACTOR_4X4_IJ(m, 0, 2);
        d.d = (float)((double)d.d + (double)m.f[GimGeometry.M(0, 2)] * cofac);
        cofac = GimGeometry.COFACTOR_4X4_IJ(m, 0, 3);
        d.d = (float)((double)d.d + (double)m.f[GimGeometry.M(0, 3)] * cofac);
    }

    static final void COFACTOR_2X2(mat2f a, mat2f m) {
        a.f[GimGeometry.M((int)0, (int)0)] = m.f[GimGeometry.M(1, 1)];
        a.f[GimGeometry.M((int)0, (int)1)] = -m.f[GimGeometry.M(1, 0)];
        a.f[GimGeometry.M((int)1, (int)0)] = -m.f[GimGeometry.M(0, 1)];
        a.f[GimGeometry.M((int)1, (int)1)] = m.f[GimGeometry.M(0, 0)];
    }

    private static final void COFACTOR_3X3(mat3f a, mat3f m) {
        a.f[GimGeometry.M((int)0, (int)0)] = m.f[GimGeometry.M(1, 1)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(1, 2)] * m.f[GimGeometry.M(2, 1)];
        a.f[GimGeometry.M((int)0, (int)1)] = -(m.f[GimGeometry.M(1, 0)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(2, 0)] * m.f[GimGeometry.M(1, 2)]);
        a.f[GimGeometry.M((int)0, (int)2)] = m.f[GimGeometry.M(1, 0)] * m.f[GimGeometry.M(2, 1)] - m.f[GimGeometry.M(1, 1)] * m.f[GimGeometry.M(2, 0)];
        a.f[GimGeometry.M((int)1, (int)0)] = -(m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(2, 1)]);
        a.f[GimGeometry.M((int)1, (int)1)] = m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(2, 0)];
        a.f[GimGeometry.M((int)1, (int)2)] = -(m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(2, 1)] - m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(2, 0)]);
        a.f[GimGeometry.M((int)2, (int)0)] = m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(1, 2)] - m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(1, 1)];
        a.f[GimGeometry.M((int)2, (int)1)] = -(m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(1, 2)] - m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(1, 0)]);
        a.f[GimGeometry.M((int)2, (int)2)] = m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(1, 1)] - m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(1, 0)];
    }

    static final void COFACTOR_4X4(mat4f a, mat4f m) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                a.f[GimGeometry.M((int)i, (int)j)] = GimGeometry.COFACTOR_4X4_IJ(m, i, j);
                ++j;
            }
            ++i;
        }
    }

    static final void ADJOINT_2X2(mat2f a, mat2f m) {
        a.f[GimGeometry.M((int)0, (int)0)] = m.f[GimGeometry.M(1, 1)];
        a.f[GimGeometry.M((int)1, (int)0)] = -m.f[GimGeometry.M(1, 0)];
        a.f[GimGeometry.M((int)0, (int)1)] = -m.f[GimGeometry.M(0, 1)];
        a.f[GimGeometry.M((int)1, (int)1)] = m.f[GimGeometry.M(0, 0)];
    }

    private static final void ADJOINT_3X3(mat3f a, mat3f m) {
        a.f[GimGeometry.M((int)0, (int)0)] = m.f[GimGeometry.M(1, 1)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(1, 2)] * m.f[GimGeometry.M(2, 1)];
        a.f[GimGeometry.M((int)1, (int)0)] = -(m.f[GimGeometry.M(1, 0)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(2, 0)] * m.f[GimGeometry.M(1, 2)]);
        a.f[GimGeometry.M((int)2, (int)0)] = m.f[GimGeometry.M(1, 0)] * m.f[GimGeometry.M(2, 1)] - m.f[GimGeometry.M(1, 1)] * m.f[GimGeometry.M(2, 0)];
        a.f[GimGeometry.M((int)0, (int)1)] = -(m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(2, 1)]);
        a.f[GimGeometry.M((int)1, (int)1)] = m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(2, 0)];
        a.f[GimGeometry.M((int)2, (int)1)] = -(m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(2, 1)] - m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(2, 0)]);
        a.f[GimGeometry.M((int)0, (int)2)] = m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(1, 2)] - m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(1, 1)];
        a.f[GimGeometry.M((int)1, (int)2)] = -(m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(1, 2)] - m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(1, 0)]);
        a.f[GimGeometry.M((int)2, (int)2)] = m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(1, 1)] - m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(1, 0)];
    }

    static final void ADJOINT_4X4(mat4f a, mat4f m) {
        int _i_ = 0;
        while (_i_ < 4) {
            int _j_ = 0;
            while (_j_ < 4) {
                a.f[GimGeometry.M((int)_j_, (int)_i_)] = GimGeometry.COFACTOR_4X4_IJ(m, _i_, _j_);
                _j_ = (char)(_j_ + 1);
            }
            _i_ = (char)(_i_ + 1);
        }
    }

    static final void SCALE_ADJOINT_2X2(mat2f a, float s, mat2f m) {
        a.f[GimGeometry.M((int)0, (int)0)] = s * m.f[GimGeometry.M(1, 1)];
        a.f[GimGeometry.M((int)1, (int)0)] = -s * m.f[GimGeometry.M(1, 0)];
        a.f[GimGeometry.M((int)0, (int)1)] = -s * m.f[GimGeometry.M(0, 1)];
        a.f[GimGeometry.M((int)1, (int)1)] = s * m.f[GimGeometry.M(0, 0)];
    }

    static final void SCALE_ADJOINT_3X3(mat3f a, float s, mat3f m) {
        a.f[GimGeometry.M((int)0, (int)0)] = s * (m.f[GimGeometry.M(1, 1)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(1, 2)] * m.f[GimGeometry.M(2, 1)]);
        a.f[GimGeometry.M((int)1, (int)0)] = s * (m.f[GimGeometry.M(1, 2)] * m.f[GimGeometry.M(2, 0)] - m.f[GimGeometry.M(1, 0)] * m.f[GimGeometry.M(2, 2)]);
        a.f[GimGeometry.M((int)2, (int)0)] = s * (m.f[GimGeometry.M(1, 0)] * m.f[GimGeometry.M(2, 1)] - m.f[GimGeometry.M(1, 1)] * m.f[GimGeometry.M(2, 0)]);
        a.f[GimGeometry.M((int)0, (int)1)] = s * (m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(2, 1)] - m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(2, 2)]);
        a.f[GimGeometry.M((int)1, (int)1)] = s * (m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(2, 2)] - m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(2, 0)]);
        a.f[GimGeometry.M((int)2, (int)1)] = s * (m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(2, 0)] - m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(2, 1)]);
        a.f[GimGeometry.M((int)0, (int)2)] = s * (m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(1, 2)] - m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(1, 1)]);
        a.f[GimGeometry.M((int)1, (int)2)] = s * (m.f[GimGeometry.M(0, 2)] * m.f[GimGeometry.M(1, 0)] - m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(1, 2)]);
        a.f[GimGeometry.M((int)2, (int)2)] = s * (m.f[GimGeometry.M(0, 0)] * m.f[GimGeometry.M(1, 1)] - m.f[GimGeometry.M(0, 1)] * m.f[GimGeometry.M(1, 0)]);
    }

    static final void SCALE_ADJOINT_4X4(mat4f a, float s, mat4f m) {
        int _i_ = 0;
        while (_i_ < 4) {
            int _j_ = 0;
            while (_j_ < 4) {
                a.f[GimGeometry.M((int)_j_, (int)_i_)] = GimGeometry.COFACTOR_4X4_IJ(m, _i_, _j_);
                int n = GimGeometry.M(_j_, _i_);
                a.f[n] = a.f[n] * s;
                _j_ = (char)(_j_ + 1);
            }
            _i_ = (char)(_i_ + 1);
        }
    }

    static final void INVERT_2X2(mat2f b, RefFloat det, mat2f a) {
        GimGeometry.DETERMINANT_2X2(det, a);
        float _tmp_ = 1.0f / det.d;
        GimGeometry.SCALE_ADJOINT_2X2(b, _tmp_, a);
    }

    static final void INVERT_3X3(mat3f b, RefFloat det, mat3f a) {
        GimGeometry.DETERMINANT_3X3(det, a);
        float _tmp_ = 1.0f / det.d;
        GimGeometry.SCALE_ADJOINT_3X3(b, _tmp_, a);
    }

    static final void INVERT_4X4(mat4f b, RefFloat det, mat4f a) {
        GimGeometry.DETERMINANT_4X4(det, a);
        float _tmp_ = 1.0f / det.d;
        GimGeometry.SCALE_ADJOINT_4X4(b, _tmp_, a);
    }

    static final void INVALIDATE_AABB(aabb3f aabb) {
        aabb.minX = Float.POSITIVE_INFINITY;
        aabb.maxX = Float.NEGATIVE_INFINITY;
        aabb.minY = Float.POSITIVE_INFINITY;
        aabb.maxY = Float.NEGATIVE_INFINITY;
        aabb.minZ = Float.POSITIVE_INFINITY;
        aabb.maxZ = Float.NEGATIVE_INFINITY;
    }

    static final void AABB_GET_MIN(aabb3f aabb, vec3f vmin) {
        vmin.f[0] = aabb.minX;
        vmin.f[1] = aabb.minY;
        vmin.f[2] = aabb.minZ;
    }

    static final void AABB_GET_MAX(aabb3f aabb, vec3f vmax) {
        vmax.f[0] = aabb.maxX;
        vmax.f[1] = aabb.maxY;
        vmax.f[2] = aabb.maxZ;
    }

    static final void AABB_COPY(aabb3f dest_aabb, aabb3f src_aabb) {
        dest_aabb.minX = src_aabb.minX;
        dest_aabb.maxX = src_aabb.maxX;
        dest_aabb.minY = src_aabb.minY;
        dest_aabb.maxY = src_aabb.maxY;
        dest_aabb.minZ = src_aabb.minZ;
        dest_aabb.maxZ = src_aabb.maxZ;
    }

    static final void COMPUTEAABB_FOR_TRIANGLE(aabb3f aabb, vec3f V1, vec3f V2, vec3f V3) {
        aabb.minX = GimGeometry.MIN3(V1.f[0], V2.f[0], V3.f[0]);
        aabb.maxX = GimGeometry.MAX3(V1.f[0], V2.f[0], V3.f[0]);
        aabb.minY = GimGeometry.MIN3(V1.f[1], V2.f[1], V3.f[1]);
        aabb.maxY = GimGeometry.MAX3(V1.f[1], V2.f[1], V3.f[1]);
        aabb.minZ = GimGeometry.MIN3(V1.f[2], V2.f[2], V3.f[2]);
        aabb.maxZ = GimGeometry.MAX3(V1.f[2], V2.f[2], V3.f[2]);
    }

    static final void COMPUTEAABB_FOR_TRIANGLE(aabb3f aabb, FloatArray V1, int o1, FloatArray V2, int o2, FloatArray V3, int o3) {
        aabb.minX = GimGeometry.MIN3(V1.at(o1 + 0), V2.at(o2 + 0), V3.at(o3 + 0));
        aabb.maxX = GimGeometry.MAX3(V1.at(o1 + 0), V2.at(o2 + 0), V3.at(o3 + 0));
        aabb.minY = GimGeometry.MIN3(V1.at(o1 + 1), V2.at(o2 + 1), V3.at(o3 + 1));
        aabb.maxY = GimGeometry.MAX3(V1.at(o1 + 1), V2.at(o2 + 1), V3.at(o3 + 1));
        aabb.minZ = GimGeometry.MIN3(V1.at(o1 + 2), V2.at(o2 + 2), V3.at(o3 + 2));
        aabb.maxZ = GimGeometry.MAX3(V1.at(o1 + 2), V2.at(o2 + 2), V3.at(o3 + 2));
    }

    static final void MERGEBOXES(aabb3f destaabb, aabb3f aabb) {
        destaabb.minX = GimGeometry.MIN(aabb.minX, destaabb.minX);
        destaabb.minY = GimGeometry.MIN(aabb.minY, destaabb.minY);
        destaabb.minZ = GimGeometry.MIN(aabb.minZ, destaabb.minZ);
        destaabb.maxX = GimGeometry.MAX(aabb.maxX, destaabb.maxX);
        destaabb.maxY = GimGeometry.MAX(aabb.maxY, destaabb.maxY);
        destaabb.maxZ = GimGeometry.MAX(aabb.maxZ, destaabb.maxZ);
    }

    static final void AABB_POINT_EXTEND(aabb3f destaabb, vec3f p) {
        destaabb.minX = GimGeometry.MIN(p.f[0], destaabb.minX);
        destaabb.maxX = GimGeometry.MAX(p.f[0], destaabb.maxX);
        destaabb.minY = GimGeometry.MIN(p.f[1], destaabb.minY);
        destaabb.maxY = GimGeometry.MAX(p.f[1], destaabb.maxY);
        destaabb.minZ = GimGeometry.MIN(p.f[2], destaabb.minZ);
        destaabb.maxZ = GimGeometry.MAX(p.f[2], destaabb.maxZ);
    }

    static final void BOXINTERSECTION(aabb3f aabb1, aabb3f aabb2, aabb3f iaabb) {
        iaabb.minX = GimGeometry.MAX(aabb1.minX, aabb2.minX);
        iaabb.minY = GimGeometry.MAX(aabb1.minY, aabb2.minY);
        iaabb.minZ = GimGeometry.MAX(aabb1.minZ, aabb2.minZ);
        iaabb.maxX = GimGeometry.MIN(aabb1.maxX, aabb2.maxX);
        iaabb.maxY = GimGeometry.MIN(aabb1.maxY, aabb2.maxY);
        iaabb.maxZ = GimGeometry.MIN(aabb1.maxZ, aabb2.maxZ);
    }

    static final boolean AABBCOLLISION(aabb3f aabb1, aabb3f aabb2) {
        return !(aabb1.minX > aabb2.maxX || aabb1.maxX < aabb2.minX || aabb1.minY > aabb2.maxY || aabb1.maxY < aabb2.minY || aabb1.minZ > aabb2.maxZ) && !(aabb1.maxZ < aabb2.minZ);
    }

    static final void AXIS_INTERSECT(float min, float max, float a, float d, RefFloat tfirst, RefFloat tlast, RefBoolean is_intersected) {
        if (GimGeometry.IS_ZERO(d)) {
            is_intersected.b = !(a < min) && !(a > max);
        } else {
            float a0 = (min - a) / d;
            float a1 = (max - a) / d;
            if (a0 > a1) {
                float ax = a0;
                a0 = a1;
                a1 = ax;
            }
            tfirst.d = GimGeometry.MAX(a0, tfirst.d);
            tlast.d = GimGeometry.MIN(a1, tlast.d);
            is_intersected.b = !(tlast.d < tfirst.d);
        }
    }

    static final void BOX_INTERSECTS_RAY(aabb3f aabb, vec3f vorigin, vec3f vdir, RefFloat tparam, float tmax, RefBoolean is_intersected) {
        RefFloat _tfirst = new RefFloat(0.0f);
        RefFloat _tlast = new RefFloat(tmax);
        GimGeometry.AXIS_INTERSECT(aabb.minX, aabb.maxX, vorigin.f[0], vdir.f[0], _tfirst, _tlast, is_intersected);
        if (is_intersected.b) {
            GimGeometry.AXIS_INTERSECT(aabb.minY, aabb.maxY, vorigin.f[1], vdir.f[1], _tfirst, _tlast, is_intersected);
        }
        if (is_intersected.b) {
            GimGeometry.AXIS_INTERSECT(aabb.minZ, aabb.maxZ, vorigin.f[2], vdir.f[2], _tfirst, _tlast, is_intersected);
        }
        tparam.d = _tfirst.d;
    }

    static final void AABB_PROJECTION_INTERVAL(aabb3f aabb, vec4f direction, RefFloat vmin, RefFloat vmax) {
        float[] _center = new float[]{(aabb.minX + aabb.maxX) * 0.5f, (aabb.minY + aabb.maxY) * 0.5f, (aabb.minZ + aabb.maxZ) * 0.5f};
        float[] _extend = new float[]{aabb.maxX - _center[0], aabb.maxY - _center[1], aabb.maxZ - _center[2]};
        float _fOrigin = GimGeometry.VEC_DOT(direction, _center);
        float _fMaximumExtent = _extend[0] * Math.abs(direction.f[0]) + _extend[1] * Math.abs(direction.f[1]) + _extend[2] * Math.abs(direction.f[2]);
        vmin.d = _fOrigin - _fMaximumExtent;
        vmax.d = _fOrigin + _fMaximumExtent;
    }

    private static final void PLANE_CLASSIFY_BOX(vec4f plane, aabb3f aabb, RefInt classify) {
        RefFloat _fmin = new RefFloat();
        RefFloat _fmax = new RefFloat();
        GimGeometry.AABB_PROJECTION_INTERVAL(aabb, plane, _fmin, _fmax);
        classify.i = plane.f[3] >= _fmax.d ? 0 : (plane.f[3] + 1.0E-6f >= _fmin.d ? 1 : 2);
    }

    static final int PLANE_CLASSIFY_BOX(vec4f plane, aabb3f aabb) {
        RefFloat _fmin = new RefFloat();
        RefFloat _fmax = new RefFloat();
        GimGeometry.AABB_PROJECTION_INTERVAL(aabb, plane, _fmin, _fmax);
        if (plane.f[3] >= _fmax.d) {
            return 0;
        }
        if (plane.f[3] + 1.0E-6f >= _fmin.d) {
            return 1;
        }
        return 2;
    }

    static final int PLANE_CLASSIFY_BOX_TZ(vec4f plane, aabb3f aabb) {
        RefFloat _fmin = new RefFloat();
        RefFloat _fmax = new RefFloat();
        GimGeometry.AABB_PROJECTION_INTERVAL(aabb, plane, _fmin, _fmax);
        if (plane.f[3] >= _fmax.d) {
            return 0;
        }
        if (plane.f[3] + 1.0E-6f >= _fmin.d) {
            return 1;
        }
        return 2;
    }

    static final void TRIANGLE_NORMAL(vec3f v1, vec3f v2, vec3f v3, vec4f n) {
        vec3f _dif1 = new vec3f();
        vec3f _dif2 = new vec3f();
        GimGeometry.VEC_DIFF(_dif1, v2, v1);
        GimGeometry.VEC_DIFF(_dif2, v3, v1);
        GimGeometry.VEC_CROSS(n, _dif1, _dif2);
        GimGeometry.VEC_NORMALIZE(n);
    }

    static final void TRIANGLE_PLANE(vec3f v1, vec3f v2, vec3f v3, vec4f plane) {
        GimGeometry.TRIANGLE_NORMAL(v1, v2, v3, plane);
        plane.f[3] = GimGeometry.VEC_DOT(plane, v1);
    }

    static final void EDGE_PLANE(vec3f e1, vec3f e2, vec4f n, vec4f plane) {
        vec3f _dif = new vec3f();
        GimGeometry.VEC_DIFF(_dif, e2, e1);
        GimGeometry.VEC_CROSS(plane, _dif, n);
        GimGeometry.VEC_NORMALIZE(plane);
        plane.f[3] = GimGeometry.VEC_DOT(plane, e1);
    }

    static final float DISTANCE_PLANE_POINT(vec4f plane, vec3f point) {
        return GimGeometry.VEC_DOT(plane, point) - plane.f[3];
    }

    static final void PROJECT_POINT_PLANE(vec3f point, vec4f plane, vec3f projected) {
        float _dis = GimGeometry.DISTANCE_PLANE_POINT(plane, point);
        GimGeometry.VEC_SCALE(projected, -_dis, plane);
        GimGeometry.VEC_SUM(projected, projected, point);
    }

    static final int POINT_IN_HULL(vec3f point, vec4f[] planes, int plane_count) {
        int outside = 0;
        int _i = 0;
        do {
            float _dis;
            if (!((_dis = GimGeometry.DISTANCE_PLANE_POINT(planes[_i], point)) > 0.0f)) continue;
            outside = 1;
        } while (++_i < plane_count && outside == 0);
        return outside;
    }

    static final int POINT_IN_HULL_TZ(vec3f point, vec4f[] planes, int pos, int plane_count) {
        int outside = 0;
        int _i = 0;
        do {
            float _dis;
            if (!((_dis = GimGeometry.DISTANCE_PLANE_POINT(planes[_i + pos], point)) > 0.0f)) continue;
            outside = 1;
        } while (++_i < plane_count && outside == 0);
        return outside;
    }

    static final void PLANE_CLIP_SEGMENT(vec3f s1, vec3f s2, vec4f plane, vec3f clipped) {
        float _dis1 = GimGeometry.DISTANCE_PLANE_POINT(plane, s1);
        GimGeometry.VEC_DIFF(clipped, s2, s1);
        float _dis2 = GimGeometry.VEC_DOT(plane, clipped);
        GimGeometry.VEC_SCALE(clipped, -_dis1 / _dis2, clipped);
        GimGeometry.VEC_SUM(clipped, clipped, s1);
    }

    static final int PLANE_CLIP_SEGMENT2(vec3f s1, vec3f s2, vec4f plane, vec3f clipped) {
        int intersection_type;
        float _dis1 = GimGeometry.DISTANCE_PLANE_POINT(plane, s1);
        float _dis2 = GimGeometry.DISTANCE_PLANE_POINT(plane, s2);
        if (_dis1 > -1.0E-7f && _dis2 > -1.0E-7f) {
            intersection_type = _dis1 < _dis2 ? 0 : 1;
        } else if (_dis1 < 1.0E-7f && _dis2 < 1.0E-7f) {
            intersection_type = _dis1 > _dis2 ? 2 : 3;
        } else {
            intersection_type = _dis1 < _dis2 ? 4 : 5;
            GimGeometry.VEC_DIFF(clipped, s2, s1);
            _dis2 = GimGeometry.VEC_DOT(plane, clipped);
            GimGeometry.VEC_SCALE(clipped, -_dis1 / _dis2, clipped);
            GimGeometry.VEC_SUM(clipped, clipped, s1);
        }
        return intersection_type;
    }

    static final int PLANE_CLIP_SEGMENT_CLOSEST(vec3f s1, vec3f s2, vec4f plane, vec3f clipped1, vec3f clipped2) {
        int intersection_type = GimGeometry.PLANE_CLIP_SEGMENT2(s1, s2, plane, clipped1);
        if (intersection_type == 0) {
            GimGeometry.VEC_COPY(clipped1, s1);
            GimGeometry.VEC_COPY(clipped2, s2);
        } else if (intersection_type == 1) {
            GimGeometry.VEC_COPY(clipped1, s2);
            GimGeometry.VEC_COPY(clipped2, s1);
        } else if (intersection_type == 2) {
            GimGeometry.VEC_COPY(clipped1, s1);
            GimGeometry.VEC_COPY(clipped2, s2);
        } else if (intersection_type == 3) {
            GimGeometry.VEC_COPY(clipped1, s2);
            GimGeometry.VEC_COPY(clipped2, s1);
        } else if (intersection_type == 4) {
            GimGeometry.VEC_COPY(clipped2, s1);
        } else if (intersection_type == 5) {
            GimGeometry.VEC_COPY(clipped2, s2);
        }
        return intersection_type;
    }

    static final void PLANE_MINOR_AXES(vec4f plane, RefInt i0, RefInt i1) {
        float[] fArray = new float[]{Math.abs(plane.f[0]), Math.abs(plane.f[1]), Math.abs(plane.f[2])};
        float[] A = fArray;
        if (A[0] > A[1]) {
            if (A[0] > A[2]) {
                i0.i = 1;
                i1.i = 2;
            } else {
                i0.i = 0;
                i1.i = 1;
            }
        } else if (A[2] > A[1]) {
            i0.i = 0;
            i1.i = 1;
        } else {
            i0.i = 0;
            i1.i = 2;
        }
    }

    static final void RAY_PLANE_COLLISION(vec4f plane, vec3f vDir, vec3f vPoint, vec3f pout, RefFloat tparam, RefBoolean does_intersect) {
        float _dotdir = GimGeometry.VEC_DOT(plane, vDir);
        if (_dotdir < 1.0E-7f) {
            does_intersect.b = false;
        } else {
            float _dis = GimGeometry.DISTANCE_PLANE_POINT(plane, vPoint);
            tparam.d = -_dis / _dotdir;
            GimGeometry.VEC_SCALE(pout, tparam.d, vDir);
            GimGeometry.VEC_SUM(pout, vPoint, pout);
            does_intersect.b = true;
        }
    }

    static final void LINE_PLANE_COLLISION(vec4f plane, vec3f vDir, vec3f vPoint, vec3f pout, RefFloat tparam, float tmin, float tmax) {
        tparam.d = -GimGeometry.DISTANCE_PLANE_POINT(plane, vPoint);
        tparam.d /= GimGeometry.VEC_DOT(plane, vDir);
        tparam.d = GimGeometry.CLAMP(tparam.d, tmin, tmax);
        GimGeometry.VEC_SCALE(pout, tparam.d, vDir);
        GimGeometry.VEC_SUM(pout, vPoint, pout);
    }

    private static final void INTERSECT_PLANES(vec3f p1, vec3f p2, vec3f p, vec3f d, RefBoolean dointersect) {
        GimGeometry.VEC_CROSS(d, p1, p2);
        float denom = GimGeometry.VEC_DOT(d, d);
        if (GimGeometry.IS_ZERO(denom)) {
            dointersect.b = false;
        } else {
            vec3f _n = new vec3f();
            _n.f[0] = p1.f[3] * p2.f[0] - p2.f[3] * p1.f[0];
            _n.f[1] = p1.f[3] * p2.f[1] - p2.f[3] * p1.f[1];
            _n.f[2] = p1.f[3] * p2.f[2] - p2.f[3] * p1.f[2];
            GimGeometry.VEC_CROSS(p, _n, d);
            p.f[0] = p.f[0] / denom;
            p.f[1] = p.f[1] / denom;
            p.f[2] = p.f[2] / denom;
            dointersect.b = true;
        }
    }

    static final void CLOSEST_POINT_ON_SEGMENT(vec3f cp, vec3f v, vec3f e1, vec3f e2) {
        vec3f _n = new vec3f();
        GimGeometry.VEC_DIFF(_n, e2, e1);
        GimGeometry.VEC_DIFF(cp, v, e1);
        float _scalar = GimGeometry.VEC_DOT(cp, _n);
        _scalar /= GimGeometry.VEC_DOT(_n, _n);
        if (_scalar < 0.0f) {
            GimGeometry.VEC_COPY(cp, e1);
        } else if (_scalar > 1.0f) {
            GimGeometry.VEC_COPY(cp, e2);
        } else {
            GimGeometry.VEC_SCALE(cp, _scalar, _n);
            GimGeometry.VEC_SUM(cp, cp, e1);
        }
    }

    private static final void LINE_INTERSECTION_PARAMS(vec3f dir1, vec3f point1, vec3f dir2, vec3f point2, RefFloat t1, RefFloat t2, RefBoolean dointersect) {
        float e1e1 = GimGeometry.VEC_DOT(dir1, dir1);
        float e1e2 = GimGeometry.VEC_DOT(dir1, dir2);
        float e2e2 = GimGeometry.VEC_DOT(dir2, dir2);
        vec3f p1p2 = new vec3f();
        GimGeometry.VEC_DIFF(p1p2, point1, point2);
        float p1p2e1 = GimGeometry.VEC_DOT(p1p2, dir1);
        float p1p2e2 = GimGeometry.VEC_DOT(p1p2, dir2);
        float det = e1e2 * e1e2 - e1e1 * e2e2;
        if (GimGeometry.IS_ZERO(det)) {
            dointersect.b = false;
        } else {
            t1.d = (e1e2 * p1p2e2 - e2e2 * p1p2e1) / det;
            t2.d = (e1e1 * p1p2e2 - e1e2 * p1p2e1) / det;
            dointersect.b = true;
        }
    }

    static final void SEGMENT_COLLISION(vec3f vA1, vec3f vA2, vec3f vB1, vec3f vB2, vec3f vPointA, vec3f vPointB) {
        vec3f _AD = new vec3f();
        vec3f _BD = new vec3f();
        vec3f _N = new vec3f();
        vec4f _M = new vec4f();
        GimGeometry.VEC_DIFF(_AD, vA2, vA1);
        GimGeometry.VEC_DIFF(_BD, vB2, vB1);
        GimGeometry.VEC_CROSS(_N, _AD, _BD);
        GimGeometry.VEC_CROSS(_M, _N, _BD);
        _M.f[3] = GimGeometry.VEC_DOT(_M, vB1);
        RefFloat _tp = new RefFloat();
        GimGeometry.LINE_PLANE_COLLISION(_M, _AD, vA1, vPointA, _tp, 0.0f, 1.0f);
        GimGeometry.VEC_DIFF(vPointB, vPointA, vB1);
        _tp.d = GimGeometry.VEC_DOT(vPointB, _BD);
        _tp.d /= GimGeometry.VEC_DOT(_BD, _BD);
        _tp.d = GimGeometry.CLAMP(_tp.d, 0.0f, 1.0f);
        GimGeometry.VEC_SCALE(vPointB, _tp.d, _BD);
        GimGeometry.VEC_SUM(vPointB, vPointB, vB1);
    }

    public static class aabb3f {
        public float minX;
        public float maxX;
        public float minY;
        public float maxY;
        public float minZ;
        public float maxZ;
    }

    static class mat2f {
        float[] f = new float[4];

        mat2f() {
        }
    }

    static class mat3f {
        float[] f = new float[9];

        mat3f() {
        }
    }

    public static class mat4f {
        public float[] f = new float[16];
    }

    static class quatf {
        float[] f = new float[4];

        quatf() {
        }
    }

    static class vec2f {
        float[] f = new float[2];

        vec2f() {
        }
    }

    static class vec2i {
        int[] i = new int[2];

        vec2i() {
        }
    }

    public static class vec3f {
        public float[] f = new float[3];
    }

    static class vec3i {
        int[] i = new int[3];

        vec3i() {
        }
    }

    public static class vec4f {
        public float[] f = new float[4];
    }

    static class vec4i {
        int[] i = new int[4];

        vec4i() {
        }
    }
}

