/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.gimpact;

import java.util.Comparator;
import org.cpp4j.java.ObjArray;
import org.ode4j.ode.internal.gimpact.GimDynArray;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimMath;
import org.ode4j.ode.internal.gimpact.GimRadixSort;
import org.ode4j.ode.internal.gimpact.GimTrimesh;

public class GimContact {
    final GimGeometry.vec3f m_point = new GimGeometry.vec3f();
    final GimGeometry.vec3f m_normal = new GimGeometry.vec3f();
    float m_depth;
    Object m_handle1;
    Object m_handle2;
    int m_feature1;
    int m_feature2;
    private static final float CONTACT_DIFF_EPSILON = 1.0E-5f;
    private static final ComparatorTZ COMPARATOT_TZ = new ComparatorTZ();

    public GimGeometry.vec3f getPoint() {
        return this.m_point;
    }

    public GimGeometry.vec3f getNormal() {
        return this.m_normal;
    }

    public float getDepth() {
        return this.m_depth;
    }

    public int getFeature1() {
        return this.m_feature1;
    }

    public int getFeature2() {
        return this.m_feature2;
    }

    private static int GIM_CALC_KEY_CONTACT(GimGeometry.vec3f pos) {
        int _coords1 = (int)(pos.f[0] * 1000.0f + 1.0f);
        int _coords2 = (int)(pos.f[1] * 1333.0f);
        int _coords3 = (int)(pos.f[2] * 2133.0f + 3.0f);
        int _hash = 0;
        _hash = _coords1;
        _hash += _coords2 << 4;
        return _hash += _coords3 << 8;
    }

    public static GimDynArray<GimContact> GIM_CREATE_CONTACT_LIST() {
        return GimDynArray.GIM_DYNARRAY_CREATE(100);
    }

    static void GIM_PUSH_CONTACT(GimDynArray<GimContact> contact_array, GimGeometry.vec3f point, GimGeometry.vec3f normal, float deep, GimTrimesh handle1, GimTrimesh handle2, int feat1, int feat2) {
        GimContact _last = new GimContact();
        GimGeometry.VEC_COPY(_last.m_point, point);
        GimGeometry.VEC_COPY(_last.m_normal, normal);
        _last.m_depth = deep;
        _last.m_handle1 = handle1;
        _last.m_handle2 = handle2;
        _last.m_feature1 = feat1;
        _last.m_feature2 = feat2;
        contact_array.GIM_DYNARRAY_PUSH_ITEM_TZ(_last);
    }

    static void GIM_PUSH_CONTACT(GimDynArray<GimContact> contact_array, GimGeometry.vec3f point, GimGeometry.vec4f normal, float deep, GimTrimesh handle1, GimTrimesh handle2, int feat1, int feat2) {
        GimContact _last = new GimContact();
        GimGeometry.VEC_COPY(_last.m_point, point);
        GimGeometry.VEC_COPY(_last.m_normal, normal);
        _last.m_depth = deep;
        _last.m_handle1 = handle1;
        _last.m_handle2 = handle2;
        _last.m_feature1 = feat1;
        _last.m_feature2 = feat2;
        contact_array.GIM_DYNARRAY_PUSH_ITEM_TZ(_last);
    }

    static void GIM_COPY_CONTACTS(GimContact dest_contact, GimContact source_contact) {
        GimGeometry.VEC_COPY(dest_contact.m_point, source_contact.m_point);
        GimGeometry.VEC_COPY(dest_contact.m_normal, source_contact.m_normal);
        dest_contact.m_depth = source_contact.m_depth;
        dest_contact.m_handle1 = source_contact.m_handle1;
        dest_contact.m_handle2 = source_contact.m_handle2;
        dest_contact.m_feature1 = source_contact.m_feature1;
        dest_contact.m_feature2 = source_contact.m_feature2;
    }

    static void gim_merge_contacts(GimDynArray<GimContact> source_contacts, GimDynArray<GimContact> dest_contacts) {
        dest_contacts.m_size = 0;
        int source_count = source_contacts.size();
        ObjArray<GimContact> psource_contacts = source_contacts.GIM_DYNARRAY_POINTER_V();
        GimRadixSort.GIM_RSORT_TOKEN[] keycontacts = new GimRadixSort.GIM_RSORT_TOKEN[source_count];
        int i = 0;
        while (i < source_count) {
            keycontacts[i] = new GimRadixSort.GIM_RSORT_TOKEN();
            ++i;
        }
        i = 0;
        while (i < source_count) {
            keycontacts[i].m_value = i;
            keycontacts[i].m_key = GimContact.GIM_CALC_KEY_CONTACT(psource_contacts.at((int)i).m_point);
            ++i;
        }
        GimRadixSort.GIM_QUICK_SORT_ARRAY(keycontacts, source_count, GimRadixSort.RSORT_TOKEN_COMPARATOR, GimRadixSort.GIM_DEF_EXCHANGE_MACRO);
        GimContact pcontact = null;
        GimContact scontact = null;
        long last_key = 0L;
        i = 0;
        while (i < source_contacts.size()) {
            long key = keycontacts[i].m_key;
            scontact = psource_contacts.at(keycontacts[i].m_value);
            if (i > 0 && last_key == key) {
                if (pcontact.m_depth > scontact.m_depth + 1.0E-5f) {
                    GimContact.GIM_COPY_CONTACTS(pcontact, scontact);
                }
            } else {
                pcontact = new GimContact();
                GimContact.GIM_COPY_CONTACTS(pcontact, scontact);
                dest_contacts.GIM_DYNARRAY_PUSH_ITEM_TZ(pcontact);
            }
            last_key = key;
            ++i;
        }
    }

    void gim_merge_contacts_unique(GimDynArray<GimContact> source_contacts, GimDynArray<GimContact> dest_contacts) {
        dest_contacts.m_size = 0;
        int source_count = source_contacts.size();
        if (source_count == 0) {
            return;
        }
        ObjArray<GimContact> psource_contacts = source_contacts.GIM_DYNARRAY_POINTER_V();
        GimContact pcontact = null;
        dest_contacts.GIM_DYNARRAY_PUSH_EMPTY();
        pcontact = dest_contacts.GIM_DYNARRAY_POINTER_LAST();
        GimContact.GIM_COPY_CONTACTS(pcontact, psource_contacts.at0());
        if (source_count == 1) {
            return;
        }
        GimGeometry.VEC_SCALE(pcontact.m_normal, pcontact.m_depth, pcontact.m_normal);
        psource_contacts.inc();
        int i = 1;
        while (i < source_count) {
            GimGeometry.VEC_SUM(pcontact.m_point, pcontact.m_point, psource_contacts.at0().m_point);
            GimGeometry.VEC_ACCUM(pcontact.m_normal, psource_contacts.at0().m_depth, psource_contacts.at0().m_normal);
            psource_contacts.inc();
            ++i;
        }
        float divide_average = 1.0f / (float)source_count;
        GimGeometry.VEC_SCALE(pcontact.m_point, divide_average, pcontact.m_point);
        pcontact.m_depth = GimGeometry.VEC_DOT(pcontact.m_normal, pcontact.m_normal) * divide_average;
        pcontact.m_depth = GimMath.GIM_SQRT(pcontact.m_depth);
        GimGeometry.VEC_NORMALIZE(pcontact.m_normal);
    }

    private static final class ComparatorTZ
    implements Comparator<GimRadixSort.GIM_RSORT_TOKEN> {
        private ComparatorTZ() {
        }

        @Override
        public int compare(GimRadixSort.GIM_RSORT_TOKEN o1, GimRadixSort.GIM_RSORT_TOKEN o2) {
            return (int)(-(o1.m_key - o2.m_key));
        }
    }
}

