/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.gimpact;

import java.util.Comparator;
import org.cpp4j.java.RefBoolean;
import org.cpp4j.java.RefFloat;
import org.ode4j.ode.internal.gimpact.GimDynArray;
import org.ode4j.ode.internal.gimpact.GimDynArrayInt;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimMath;
import org.ode4j.ode.internal.gimpact.GimRadixSort;

public class GimAABBSet {
    int m_count;
    GimGeometry.aabb3f m_global_bound = new GimGeometry.aabb3f();
    private final GimGeometry.aabb3f[] m_boxes;
    long[] m_maxcoords;
    GimRadixSort.GIM_RSORT_TOKEN[] m_sorted_mincoords;
    char m_shared;
    private static final int GIM_MIN_SORTED_BIPARTITE_PRUNING_BOXES = 600;
    private static final int GIM_MIN_SORTED_PRUNING_BOXES = 140;
    private static final float ERROR_AABB = 20.0f;
    private static final float MAX_AABB_SIZE = 1638.0f;
    private static final ComparatorTZ COMPARATOT_TZ = new ComparatorTZ();
    private static final PushPairMacro PUSH_PAIR = new PushPairMacro(){

        @Override
        public void run(int i, int j, GimDynArray<GIM_PAIR> pairset) {
            GimAABBSet.PUSH_PAIR(i, j, pairset);
        }
    };
    private static final PushPairMacro PUSH_PAIR_INV = new PushPairMacro(){

        @Override
        public void run(int i, int j, GimDynArray<GIM_PAIR> pairset) {
            GimAABBSet.PUSH_PAIR_INV(i, j, pairset);
        }
    };

    public GimGeometry.aabb3f getGlobalBound() {
        return this.m_global_bound;
    }

    static GimDynArray<GIM_PAIR> GIM_CREATE_PAIR_SET() {
        return GimDynArray.GIM_DYNARRAY_CREATE(64);
    }

    long GIM_CONVERT_VEC3F_GUINT_XZ(float vx, float vz) {
        long _z = (long)(vz * 20.0f) + 32768L;
        long uint_key = (long)(vx * 20.0f) + 32768L;
        return (uint_key << 16) + _z;
    }

    long GIM_CONVERT_VEC3F_GUINT_XZ_UPPER(float vx, float vz) {
        long _z = (long)Math.ceil(vz * 20.0f) + 32768L;
        long uint_key = (long)Math.ceil(vx * 20.0f) + 32768L;
        return (uint_key << 16) + _z;
    }

    long GIM_CONVERT_VEC3F_GUINT_XZ_CLAMPED(float vx, float vz) {
        float _cx = GimMath.CLAMP(vx, -1638.0f, 1638.0f);
        float _cz = GimMath.CLAMP(vz, -1638.0f, 1638.0f);
        long _z = (long)(_cz * 20.0f) + 32768L;
        long uint_key = (long)(_cx * 20.0f) + 32768L;
        return (uint_key << 16) + _z;
    }

    long GIM_CONVERT_VEC3F_GUINT_XZ_UPPER_CLAMPED(float vx, float vz) {
        float _cx = GimMath.CLAMP(vx, -1638.0f, 1638.0f);
        float _cz = GimMath.CLAMP(vz, -1638.0f, 1638.0f);
        long _z = (long)Math.ceil(_cz * 20.0f) + 32768L;
        long uint_key = (long)Math.ceil(_cx * 20.0f) + 32768L;
        return (uint_key << 16) + _z;
    }

    private GimAABBSet(int count) {
        this.m_boxes = new GimGeometry.aabb3f[count];
    }

    static GimAABBSet gim_aabbset_alloc(int count) {
        GimAABBSet x = new GimAABBSet(count);
        x.m_count = count;
        int i = 0;
        while (i < count) {
            x.m_boxes[i] = new GimGeometry.aabb3f();
            ++i;
        }
        if (count < 600) {
            x.m_maxcoords = null;
            x.m_sorted_mincoords = null;
        } else {
            x.m_maxcoords = new long[x.m_count];
            x.m_sorted_mincoords = new GimRadixSort.GIM_RSORT_TOKEN[x.m_count];
            i = 0;
            while (i < x.m_count) {
                x.m_sorted_mincoords[i] = new GimRadixSort.GIM_RSORT_TOKEN();
                ++i;
            }
        }
        x.m_shared = '\u0000';
        GimGeometry.INVALIDATE_AABB(x.m_global_bound);
        return x;
    }

    void gim_aabbset_destroy() {
        this.m_count = 0;
        this.m_sorted_mincoords = null;
        this.m_maxcoords = null;
    }

    void gim_aabbset_calc_global_bound() {
        GimGeometry.AABB_COPY(this.m_global_bound, this.m_boxes[0]);
        GimGeometry.aabb3f[] aabb3fArray = this.m_boxes;
        int n = this.m_boxes.length;
        int n2 = 0;
        while (n2 < n) {
            GimGeometry.aabb3f aabb = aabb3fArray[n2];
            GimGeometry.MERGEBOXES(this.m_global_bound, aabb);
            ++n2;
        }
    }

    void gim_aabbset_sort(boolean calc_global_bound) {
        if (this.m_sorted_mincoords == null) {
            this.m_maxcoords = new long[this.m_count];
            this.m_sorted_mincoords = new GimRadixSort.GIM_RSORT_TOKEN[this.m_count];
        }
        int count = this.m_count;
        GimGeometry.aabb3f[] paabb = this.m_boxes;
        long[] maxcoords = this.m_maxcoords;
        GimRadixSort.GIM_RSORT_TOKEN[] sorted_tokens = this.m_sorted_mincoords;
        if (count < 860) {
            int i = 0;
            while (i < count) {
                maxcoords[i] = this.GIM_CONVERT_VEC3F_GUINT_XZ_UPPER(paabb[i].maxX, paabb[i].maxZ);
                sorted_tokens[i].m_key = this.GIM_CONVERT_VEC3F_GUINT_XZ(paabb[i].minX, paabb[i].minZ);
                sorted_tokens[i].m_value = i;
                ++i;
            }
            GimRadixSort.GIM_QUICK_SORT_ARRAY(sorted_tokens, count, GimRadixSort.RSORT_TOKEN_COMPARATOR, GimRadixSort.GIM_DEF_EXCHANGE_MACRO);
        } else {
            GimRadixSort.GIM_RSORT_TOKEN[] unsorted = new GimRadixSort.GIM_RSORT_TOKEN[count];
            int i = 0;
            while (i < count) {
                unsorted[i] = new GimRadixSort.GIM_RSORT_TOKEN();
                maxcoords[i] = this.GIM_CONVERT_VEC3F_GUINT_XZ_UPPER(paabb[i].maxX, paabb[i].maxZ);
                unsorted[i].m_key = this.GIM_CONVERT_VEC3F_GUINT_XZ(paabb[i].minX, paabb[i].minZ);
                unsorted[i].m_value = i;
                ++i;
            }
            GimRadixSort.GIM_RADIX_SORT_RTOKENS(unsorted, sorted_tokens, count);
        }
        if (calc_global_bound) {
            this.gim_aabbset_calc_global_bound();
        }
    }

    static void PUSH_PAIR(int i, int j, GimDynArray<GIM_PAIR> pairset) {
        GIM_PAIR _pair = new GIM_PAIR();
        _pair.m_index1 = i;
        _pair.m_index2 = j;
        pairset.GIM_DYNARRAY_PUSH_ITEM_TZ(_pair);
    }

    static void PUSH_PAIR_INV(int i, int j, GimDynArray<GIM_PAIR> pairset) {
        GIM_PAIR _pair = new GIM_PAIR();
        _pair.m_index1 = j;
        _pair.m_index2 = i;
        pairset.GIM_DYNARRAY_PUSH_ITEM_TZ(_pair);
    }

    static void FIND_OVERLAPPING_FOWARD(int curr_index, int test_count, GimGeometry.aabb3f test_aabb, long max_coord_uint, GimRadixSort.GIM_RSORT_TOKEN[] sorted_tokensA, int sorted_tokensP, GimGeometry.aabb3f[] aabbarray, GimDynArray<GIM_PAIR> pairset, PushPairMacro push_pair_macro) {
        int _i = test_count;
        GimRadixSort.GIM_RSORT_TOKEN[] _psorted_tokensA = sorted_tokensA;
        int _psorted_tokensP = sorted_tokensP;
        while (_i > 0 && max_coord_uint >= _psorted_tokensA[_psorted_tokensP].m_key) {
            boolean _intersected = GimGeometry.AABBCOLLISION(test_aabb, aabbarray[_psorted_tokensA[_psorted_tokensP].m_value]);
            if (_intersected) {
                push_pair_macro.run(curr_index, _psorted_tokensA[_psorted_tokensP].m_value, pairset);
            }
            ++_psorted_tokensP;
            --_i;
        }
    }

    static void gim_aabbset_bipartite_intersections_sorted(GimAABBSet aabbset1, GimAABBSet aabbset2, GimDynArray<GIM_PAIR> collision_pairs) {
        int curr_index;
        collision_pairs.m_size = 0;
        boolean intersected = GimGeometry.AABBCOLLISION(aabbset1.m_global_bound, aabbset2.m_global_bound);
        if (!intersected) {
            return;
        }
        int count1 = aabbset1.m_count;
        GimGeometry.aabb3f[] paabb1 = aabbset1.m_boxes;
        long[] maxcoords1 = aabbset1.m_maxcoords;
        GimRadixSort.GIM_RSORT_TOKEN[] sorted_tokens1 = aabbset1.m_sorted_mincoords;
        int count2 = aabbset2.m_count;
        GimGeometry.aabb3f[] paabb2 = aabbset2.m_boxes;
        long[] maxcoords2 = aabbset2.m_maxcoords;
        GimRadixSort.GIM_RSORT_TOKEN[] sorted_tokens2 = aabbset2.m_sorted_mincoords;
        GimGeometry.aabb3f test_aabb = new GimGeometry.aabb3f();
        GimGeometry.aabb3f int_abbb = new GimGeometry.aabb3f();
        GimGeometry.BOXINTERSECTION(aabbset1.m_global_bound, aabbset2.m_global_bound, int_abbb);
        GimRadixSort.GIM_RSORT_TOKEN[] classified_tokens1 = new GimRadixSort.GIM_RSORT_TOKEN[count1];
        int classified_count1 = 0;
        int classified_count2 = 0;
        int i = 0;
        while (i < count1) {
            curr_index = sorted_tokens1[i].m_value;
            intersected = GimGeometry.AABBCOLLISION(paabb1[curr_index], int_abbb);
            if (intersected) {
                classified_tokens1[classified_count1] = sorted_tokens1[i];
                ++classified_count1;
            }
            ++i;
        }
        if (classified_count1 == 0) {
            return;
        }
        GimRadixSort.GIM_RSORT_TOKEN[] classified_tokens2 = new GimRadixSort.GIM_RSORT_TOKEN[count2];
        i = 0;
        while (i < count2) {
            curr_index = sorted_tokens2[i].m_value;
            intersected = GimGeometry.AABBCOLLISION(paabb2[curr_index], int_abbb);
            if (intersected) {
                classified_tokens2[classified_count2] = sorted_tokens2[i];
                ++classified_count2;
            }
            ++i;
        }
        if (classified_count2 == 0) {
            return;
        }
        sorted_tokens1 = classified_tokens1;
        sorted_tokens2 = classified_tokens2;
        int pos1 = 0;
        int pos2 = 0;
        while (classified_count1 > 0 && classified_count2 > 0) {
            long max_coord_uint;
            if (sorted_tokens1[pos1].m_key <= sorted_tokens2[pos2].m_key) {
                curr_index = sorted_tokens1[pos1].m_value;
                max_coord_uint = maxcoords1[curr_index];
                GimGeometry.AABB_COPY(test_aabb, paabb1[curr_index]);
                ++pos1;
                --classified_count1;
                GimAABBSet.FIND_OVERLAPPING_FOWARD(curr_index, classified_count2, test_aabb, max_coord_uint, sorted_tokens2, 0, paabb2, collision_pairs, PUSH_PAIR);
                continue;
            }
            curr_index = sorted_tokens2[pos2].m_value;
            max_coord_uint = maxcoords2[curr_index];
            GimGeometry.AABB_COPY(test_aabb, paabb2[curr_index]);
            ++pos2;
            --classified_count2;
            GimAABBSet.FIND_OVERLAPPING_FOWARD(curr_index, classified_count1, test_aabb, max_coord_uint, sorted_tokens1, 0, paabb1, collision_pairs, PUSH_PAIR_INV);
        }
    }

    static void gim_aabbset_bipartite_intersections_brute_force(GimAABBSet aabbset1, GimAABBSet aabbset2, GimDynArray<GIM_PAIR> collision_pairs) {
        collision_pairs.m_size = 0;
        boolean intersected = GimGeometry.AABBCOLLISION(aabbset1.m_global_bound, aabbset2.m_global_bound);
        if (!intersected) {
            return;
        }
        GimGeometry.aabb3f int_abbb = new GimGeometry.aabb3f();
        GimGeometry.BOXINTERSECTION(aabbset1.m_global_bound, aabbset2.m_global_bound, int_abbb);
        int classified_count = 0;
        int count = aabbset1.m_count;
        GimGeometry.aabb3f[] paabb1 = aabbset1.m_boxes;
        GimGeometry.aabb3f[] paabb2 = aabbset2.m_boxes;
        int[] classified = new int[count];
        int i = 0;
        while (i < count) {
            intersected = GimGeometry.AABBCOLLISION(paabb1[i], int_abbb);
            if (intersected) {
                classified[classified_count] = i;
                ++classified_count;
            }
            ++i;
        }
        if (classified_count == 0) {
            return;
        }
        count = aabbset2.m_count;
        i = 0;
        while (i < count) {
            intersected = GimGeometry.AABBCOLLISION(paabb2[i], int_abbb);
            if (intersected) {
                int j = 0;
                while (j < classified_count) {
                    intersected = GimGeometry.AABBCOLLISION(paabb2[i], paabb1[classified[j]]);
                    if (intersected) {
                        GimAABBSet.PUSH_PAIR(classified[j], i, collision_pairs);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void gim_aabbset_update() {
        if (this.m_count < 600) {
            this.gim_aabbset_calc_global_bound();
        } else {
            this.gim_aabbset_sort(true);
        }
    }

    static void gim_aabbset_bipartite_intersections(GimAABBSet aabbset1, GimAABBSet aabbset2, GimDynArray<GIM_PAIR> collision_pairs) {
        if (aabbset1.m_sorted_mincoords == null || aabbset2.m_sorted_mincoords == null) {
            GimAABBSet.gim_aabbset_bipartite_intersections_brute_force(aabbset1, aabbset2, collision_pairs);
        } else {
            GimAABBSet.gim_aabbset_bipartite_intersections_sorted(aabbset1, aabbset2, collision_pairs);
        }
    }

    public void gim_aabbset_box_collision(GimGeometry.aabb3f test_aabb, GimDynArrayInt collided) {
        collided.m_size = 0;
        boolean intersected = GimGeometry.AABBCOLLISION(this.m_global_bound, test_aabb);
        if (!intersected) {
            return;
        }
        int count = this.m_count;
        GimGeometry.aabb3f[] paabb = this.m_boxes;
        GimGeometry.aabb3f _testaabb = new GimGeometry.aabb3f();
        GimGeometry.AABB_COPY(_testaabb, test_aabb);
        int i = 0;
        while (i < count) {
            intersected = GimGeometry.AABBCOLLISION(paabb[i], _testaabb);
            if (intersected) {
                collided.GIM_DYNARRAY_PUSH_ITEM(i);
            }
            ++i;
        }
    }

    void gim_aabbset_ray_collision(GimGeometry.vec3f vorigin, GimGeometry.vec3f vdir, float tmax, GimDynArrayInt collided) {
        collided.m_size = 0;
        RefBoolean intersected = new RefBoolean(false);
        RefFloat tparam = new RefFloat();
        GimGeometry.BOX_INTERSECTS_RAY(this.m_global_bound, vorigin, vdir, tparam, tmax, intersected);
        if (!intersected.b) {
            return;
        }
        int count = this.m_count;
        GimGeometry.aabb3f[] paabb = this.m_boxes;
        int i = 0;
        while (i < count) {
            GimGeometry.BOX_INTERSECTS_RAY(paabb[i], vorigin, vdir, tparam, tmax, intersected);
            if (intersected.b) {
                collided.GIM_DYNARRAY_PUSH_ITEM(i);
            }
            ++i;
        }
    }

    public GimGeometry.aabb3f at(int i) {
        return this.m_boxes[i];
    }

    private static final class ComparatorTZ
    implements Comparator<GimRadixSort.GIM_RSORT_TOKEN> {
        private ComparatorTZ() {
        }

        @Override
        public int compare(GimRadixSort.GIM_RSORT_TOKEN o1, GimRadixSort.GIM_RSORT_TOKEN o2) {
            return (int)(-(o1.m_key - o2.m_key));
        }
    }

    static class GIM_PAIR {
        int m_index1;
        int m_index2;

        GIM_PAIR() {
        }
    }

    private static interface PushPairMacro {
        public void run(int var1, int var2, GimDynArray<GIM_PAIR> var3);
    }
}

