/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cstdio;
import org.cpp4j.FILE;
import org.ode4j.ode.DStopwatch;

public class Timer {
    private static final int MAXNUM = 100;
    private static int num = 0;
    private static final Event[] event = new Event[100];

    static {
        int i = 0;
        while (i < event.length) {
            Timer.event[i] = new Event();
            ++i;
        }
    }

    private static long getClockCount() {
        return System.nanoTime();
    }

    private static void serialize() {
    }

    private static double loadClockCount(long a) {
        return a;
    }

    public static double dTimerResolution() {
        long cc2;
        long cc1 = System.nanoTime();
        while (cc1 == (cc2 = System.nanoTime())) {
        }
        while ((cc1 = System.nanoTime()) == cc2) {
        }
        return (double)(cc1 - cc2) / Timer.dTimerTicksPerSecond();
    }

    public static double dTimerTicksPerSecond() {
        return 1.0E9;
    }

    public static void dStopwatchReset(DStopwatch s) {
        s.reset();
    }

    public static void dStopwatchStart(DStopwatch s) {
        s.start();
    }

    public static void dStopwatchStop(DStopwatch s) {
        s.stop();
    }

    public static double dStopwatchTime(DStopwatch s) {
        return s.getTime();
    }

    public static void dTimerStart(String description) {
        Timer.event[0].description = description;
        num = 1;
        Timer.serialize();
        Timer.event[0].cc = Timer.getClockCount();
    }

    public static void dTimerNow(String description) {
        if (num < 100) {
            Timer.event[Timer.num].cc = Timer.getClockCount();
            Timer.event[Timer.num].description = description;
            ++num;
        }
    }

    public static void dTimerEnd() {
        if (num < 100) {
            Timer.serialize();
            Timer.event[Timer.num].cc = Timer.getClockCount();
            Timer.event[Timer.num].description = "TOTAL";
            ++num;
        }
    }

    private static void fprintDoubleWithPrefix(FILE f, double a, String fmt) {
        if (a >= 0.999999) {
            Cstdio.fprintf(f, fmt, a);
            return;
        }
        if ((a *= 1000.0) >= 0.999999) {
            Cstdio.fprintf(f, fmt, a);
            Cstdio.fprintf(f, "m", new Object[0]);
            return;
        }
        if ((a *= 1000.0) >= 0.999999) {
            Cstdio.fprintf(f, fmt, a);
            Cstdio.fprintf(f, "u", new Object[0]);
            return;
        }
        Cstdio.fprintf(f, fmt, a *= 1000.0);
        Cstdio.fprintf(f, "n", new Object[0]);
    }

    public static void dTimerReport(FILE fout, int average) {
        double ccunit = 1.0 / Timer.dTimerTicksPerSecond();
        Cstdio.fprintf(fout, "\nTimer Report (", new Object[0]);
        Timer.fprintDoubleWithPrefix(fout, ccunit, "%.2f ");
        Cstdio.fprintf(fout, "s resolution)\n------------\n", new Object[0]);
        if (num < 1) {
            return;
        }
        int maxl = 0;
        int i = 0;
        while (i < num) {
            int l = Timer.event[i].description.length();
            if (l > maxl) {
                maxl = l;
            }
            ++i;
        }
        double tt1 = Timer.loadClockCount(Timer.event[0].cc);
        double tt2 = Timer.loadClockCount(Timer.event[Timer.num - 1].cc);
        double total = tt2 - tt1;
        if (total <= 0.0) {
            total = 1.0;
        }
        double[] times = new double[num];
        i = 0;
        while (i < num - 1) {
            double t1 = Timer.loadClockCount(Timer.event[i].cc);
            double t2 = Timer.loadClockCount(Timer.event[i + 1].cc);
            times[i] = t2 - t1;
            ++Timer.event[i].count;
            Timer.event[i].total_t += times[i];
            Timer.event[i].total_p += times[i] / total * 100.0;
            ++i;
        }
        i = 0;
        while (i < num) {
            double p;
            double t;
            if (i < num - 1) {
                t = times[i];
                p = t / total * 100.0;
            } else {
                t = total;
                p = 100.0;
            }
            Cstdio.fprintf(fout, "%s %7.2fms %6.2f%%", Timer.event[i].description, t * ccunit * 1000.0, p);
            if (average != 0 && i < num - 1) {
                Cstdio.fprintf(fout, "  (avg %7.2fms %6.2f%%)", Timer.event[i].total_t / (double)Timer.event[i].count * ccunit * 1000.0, Timer.event[i].total_p / (double)Timer.event[i].count);
            }
            Cstdio.fprintf(fout, "\n", new Object[0]);
            ++i;
        }
        Cstdio.fprintf(fout, "\n", new Object[0]);
    }

    private static class Event {
        long cc;
        double total_t = 0.0;
        double total_p = 0.0;
        int count = 0;
        String description;

        private Event() {
        }
    }
}

