/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cstdio;
import org.cpp4j.FILE;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.AbstractStepper;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DLCP;
import org.ode4j.ode.internal.DxBody;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.Matrix;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointNode;
import org.ode4j.ode.internal.processmem.DxUtil;
import org.ode4j.ode.internal.processmem.DxWorldProcessIslandsInfo;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemArena;

class Step
extends AbstractStepper
implements DxWorld.dstepper_fn_t,
DxWorldProcessIslandsInfo.dmemestimate_fn_t {
    public static final Step INSTANCE = new Step();
    private static final boolean TIMING = false;
    public static final boolean DIRECT_CHOLESKY = true;
    public static final boolean REPORT_ERROR = false;

    Step() {
    }

    private static final void IFTIMING_dTimerStart(String name) {
    }

    private static final void IFTIMING_dTimerNow(String name) {
    }

    private static final void IFTIMING_dTimerEnd() {
    }

    private static final void IFTIMING_dTimerReport(FILE fout, int average) {
    }

    private static void Multiply2_p8r(double[] A, int APos, double[] B, int BPos, double[] C, int CPos, int p, int r, int Askip) {
        Common.dIASSERT(p > 0 && r > 0);
        int Askip_munus_r = Askip - r;
        int aa = APos;
        int bb = BPos;
        int i = p;
        while (i != 0) {
            int cc = CPos;
            int j = r;
            while (j != 0) {
                double sum = B[bb] * C[cc];
                sum += B[bb + 1] * C[cc + 1];
                sum += B[bb + 2] * C[cc + 2];
                sum += B[bb + 4] * C[cc + 4];
                sum += B[bb + 5] * C[cc + 5];
                A[aa++] = sum += B[bb + 6] * C[cc + 6];
                cc += 8;
                --j;
            }
            bb += 8;
            aa += Askip_munus_r;
            --i;
        }
    }

    private static void MultiplyAdd2_p8r(double[] A, int APos, double[] B, int BPos, double[] C, int CPos, int p, int r, int Askip) {
        Common.dIASSERT(p > 0 && r > 0);
        int Askip_munus_r = Askip - r;
        Common.dIASSERT(Askip >= r);
        int aa = APos;
        int bb = BPos;
        int i = p;
        while (i != 0) {
            int cc = CPos;
            int j = r;
            while (j != 0) {
                double sum = B[bb] * C[cc];
                sum += B[bb + 1] * C[cc + 1];
                sum += B[bb + 2] * C[cc + 2];
                sum += B[bb + 4] * C[cc + 4];
                sum += B[bb + 5] * C[cc + 5];
                int n = aa++;
                A[n] = A[n] + (sum += B[bb + 6] * C[cc + 6]);
                cc += 8;
                --j;
            }
            bb += 8;
            aa += Askip_munus_r;
            --i;
        }
    }

    private static void MultiplySub0_p81(double[] A, int APos, double[] B, int BPos, double[] C, int CPos, int p) {
        Common.dIASSERT(p > 0);
        int aa = APos;
        int bb = BPos;
        int i = p;
        while (i != 0) {
            double sum = B[0 + bb] * C[0 + CPos];
            sum += B[1 + bb] * C[1 + CPos];
            sum += B[2 + bb] * C[2 + CPos];
            sum += B[4 + bb] * C[4 + CPos];
            sum += B[5 + bb] * C[5 + CPos];
            int n = aa++;
            A[n] = A[n] - (sum += B[6 + bb] * C[6 + CPos]);
            bb += 8;
            --i;
        }
    }

    private static void MultiplyAdd1_8q1(double[] A, int APos, double[] B, int BPos, double[] C, int CPos, int q) {
        Common.dIASSERT(q > 0);
        int bb = BPos;
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum4 = 0.0;
        double sum5 = 0.0;
        double sum6 = 0.0;
        int k = 0;
        while (k < q) {
            double C_k = C[k + CPos];
            sum0 += B[bb + 0] * C_k;
            sum1 += B[bb + 1] * C_k;
            sum2 += B[bb + 2] * C_k;
            sum4 += B[bb + 4] * C_k;
            sum5 += B[bb + 5] * C_k;
            sum6 += B[bb + 6] * C_k;
            bb += 8;
            ++k;
        }
        int n = 0 + APos;
        A[n] = A[n] + sum0;
        int n2 = 1 + APos;
        A[n2] = A[n2] + sum1;
        int n3 = 2 + APos;
        A[n3] = A[n3] + sum2;
        int n4 = 4 + APos;
        A[n4] = A[n4] + sum4;
        int n5 = 5 + APos;
        A[n5] = A[n5] + sum5;
        int n6 = 6 + APos;
        A[n6] = A[n6] + sum6;
    }

    private static void Multiply1_8q1(double[] A, int APos, double[] B, int BPos, double[] C, int CPos, int q) {
        int bb = BPos;
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum4 = 0.0;
        double sum5 = 0.0;
        double sum6 = 0.0;
        int k = 0;
        while (k < q) {
            double C_k = C[k + CPos];
            sum0 += B[bb + 0] * C_k;
            sum1 += B[bb + 1] * C_k;
            sum2 += B[bb + 2] * C_k;
            sum4 += B[bb + 4] * C_k;
            sum5 += B[bb + 5] * C_k;
            sum6 += B[bb + 6] * C_k;
            bb += 8;
            ++k;
        }
        A[0 + APos] = sum0;
        A[1 + APos] = sum1;
        A[2 + APos] = sum2;
        A[4 + APos] = sum4;
        A[5 + APos] = sum5;
        A[6 + APos] = sum6;
    }

    private void dInternalStepIsland_x2(DxWorldProcessMemArena memarena, DxWorld world, DxBody[] bodyA, int bOfs, int nb, DxJoint[] _jointA, int jOfs, int _nj, double stepsize) {
        boolean bkw_end_reached;
        int lcp_end;
        double gravity_z;
        double gravity_y;
        Step.IFTIMING_dTimerStart("preprocessing");
        double stepsizeRecip = Common.dRecip(stepsize);
        int i = 0;
        while (i < nb) {
            bodyA[bOfs + i].tag = i;
            ++i;
        }
        DxWorldProcessMemArena.dummy();
        double[] invI = new double[12 * nb];
        int invIrow = 0;
        DMatrix3 tmp = new DMatrix3();
        DMatrix3 I = new DMatrix3();
        int ii = 0;
        while (ii < nb) {
            DxBody b = bodyA[bOfs + ii];
            OdeMath.dMultiply2_333(tmp, b.invI, b._posr.R);
            OdeMath.dMultiply0_333(invI, invIrow, b._posr.R, tmp);
            if (b.isFlagsGyroscopic()) {
                OdeMath.dMultiply2_333(tmp, b.mass._I, b._posr.R);
                OdeMath.dMultiply0_333(I, b._posr.R, tmp);
                OdeMath.dMultiply0_331(tmp, (DMatrix3C)I, (DVector3C)b.avel);
                OdeMath.dSubtractVectorCross3(b.tacc, (DVector3C)b.avel, tmp);
            }
            ++ii;
            invIrow += 12;
        }
        double gravity_x = world.gravity.get0();
        if (gravity_x != 0.0) {
            int ii2 = bOfs;
            while (ii2 < bOfs + nb) {
                DxBody b = bodyA[ii2];
                if (b.getGravityMode()) {
                    b.facc.add(0, b.mass._mass * gravity_x);
                }
                ++ii2;
            }
        }
        if ((gravity_y = world.gravity.get1()) != 0.0) {
            int ii3 = bOfs;
            while (ii3 < bOfs + nb) {
                DxBody b = bodyA[ii3];
                if (b.getGravityMode()) {
                    b.facc.add(1, b.mass._mass * gravity_y);
                }
                ++ii3;
            }
        }
        if ((gravity_z = world.gravity.get2()) != 0.0) {
            int ii4 = bOfs;
            while (ii4 < bOfs + nb) {
                DxBody b = bodyA[ii4];
                if (b.getGravityMode()) {
                    b.facc.add(2, b.mass._mass * gravity_z);
                }
                ++ii4;
            }
        }
        int ji_reserve_count = 2 * _nj;
        DxWorldProcessMemArena.dummy();
        dJointWithInfo1[] jointiinfosA = new dJointWithInfo1[ji_reserve_count];
        int i2 = 0;
        while (i2 < jointiinfosA.length) {
            jointiinfosA[i2] = new dJointWithInfo1();
            ++i2;
        }
        int jiP = 0;
        int mix_end = lcp_end = _nj;
        int mix_start = lcp_end;
        int unb_start = lcp_end;
        dJointWithInfo1 jicurrO = jointiinfosA.length > 0 ? jointiinfosA[lcp_end + jiP] : null;
        int jicurrP = lcp_end;
        int _jend = _nj;
        int _jcurrP = 0;
        block6: do {
            DxJoint.Info1 tmp_info;
            DxJoint j;
            boolean fwd_end_reached = false;
            dJointWithInfo1 jimixendO = jointiinfosA.length > 0 ? jointiinfosA[mix_end + jiP] : null;
            int jimixendP = mix_end;
            while (true) {
                if (_jcurrP == _jend) {
                    lcp_end = jicurrP;
                    fwd_end_reached = true;
                    break;
                }
                j = _jointA[jOfs + _jcurrP++];
                j.getInfo1(jicurrO.info);
                Common.dIASSERT(jicurrO.info.m >= 0 && jicurrO.info.m <= 6 && jicurrO.info.nub >= 0 && jicurrO.info.nub <= jicurrO.info.m);
                if (jicurrO.info.m > 0) {
                    if (jicurrO.info.nub == 0) {
                        jicurrO.joint = j;
                        jicurrO = ++jicurrP + jiP < jointiinfosA.length ? jointiinfosA[jicurrP + jiP] : null;
                        continue;
                    }
                    if (jicurrO.info.nub < jicurrO.info.m) {
                        if (unb_start == mix_start) {
                            unb_start = --mix_start;
                            dJointWithInfo1 jimixstart = jointiinfosA[mix_start + jiP];
                            jimixstart.info.set(jicurrO.info);
                            jimixstart.joint = j;
                            continue;
                        }
                        if (jimixendP != jicurrP) {
                            tmp_info = jicurrO.info;
                            jicurrP = jimixendP++;
                            jicurrO = jointiinfosA[jicurrP + jiP];
                            jimixendO.info.set(tmp_info);
                            jimixendO.joint = j;
                            jicurrO = jointiinfosA[++jicurrP + jiP];
                            jimixendO = jointiinfosA[jimixendP + jiP];
                            continue;
                        }
                        jicurrO.joint = j;
                        jimixendP = ++jicurrP;
                        jicurrO = jointiinfosA[jicurrP + jiP];
                        jimixendO = jointiinfosA[jimixendP + jiP];
                        continue;
                    }
                    dJointWithInfo1 jiunbstartO = jointiinfosA[--unb_start + jiP];
                    int jiunbstartP = unb_start;
                    jiunbstartO.info.set(jicurrO.info);
                    jiunbstartO.joint = j;
                    lcp_end = jicurrP;
                    mix_end = jimixendP;
                    jicurrP = jiunbstartP - 1;
                    if (jicurrP >= 0) {
                        jicurrO = jointiinfosA[jicurrP + jiP];
                        break;
                    }
                    jicurrO = null;
                    break;
                }
                j.tag = -1;
            }
            if (fwd_end_reached) break;
            bkw_end_reached = false;
            dJointWithInfo1 jimixstartO = jointiinfosA[mix_start - 1 + jiP];
            int jimixstartP = mix_start - 1;
            while (true) {
                if (_jcurrP == _jend) {
                    unb_start = jicurrP + 1;
                    mix_start = jimixstartP + 1;
                    bkw_end_reached = true;
                    continue block6;
                }
                j = _jointA[jOfs + _jcurrP++];
                j.getInfo1(jicurrO.info);
                Common.dIASSERT(jicurrO.info.m >= 0 && jicurrO.info.m <= 6 && jicurrO.info.nub >= 0 && jicurrO.info.nub <= jicurrO.info.m);
                if (jicurrO.info.m > 0) {
                    if (jicurrO.info.nub == jicurrO.info.m) {
                        jicurrO.joint = j;
                        if (--jicurrP + jiP >= 0) {
                            jicurrO = jointiinfosA[jicurrP + jiP];
                            continue;
                        }
                        jicurrO = null;
                        continue;
                    }
                    if (jicurrO.info.nub > 0) {
                        if (mix_end == lcp_end) {
                            dJointWithInfo1 jimixend = jointiinfosA[mix_end + jiP];
                            lcp_end = ++mix_end;
                            jimixend.info.set(jicurrO.info);
                            jimixend.joint = j;
                            continue;
                        }
                        if (jimixstartP != jicurrP) {
                            tmp_info = jicurrO.info;
                            jicurrP = jimixstartP--;
                            jicurrO = jointiinfosA[jicurrP + jiP];
                            jimixstartO.info.set(tmp_info);
                            jimixstartO.joint = j;
                            jicurrO = jointiinfosA[--jicurrP + jiP];
                            jimixstartO = jointiinfosA[jimixstartP + jiP];
                            continue;
                        }
                        jicurrO.joint = j;
                        jimixstartP = --jicurrP;
                        jicurrO = jointiinfosA[jicurrP + jiP];
                        jimixstartO = jointiinfosA[jimixstartP + jiP];
                        continue;
                    }
                    dJointWithInfo1 jilcpendO = jointiinfosA[lcp_end + jiP];
                    int jilcpendP = lcp_end++;
                    jilcpendO.info.set(jicurrO.info);
                    jilcpendO.joint = j;
                    unb_start = jicurrP + 1;
                    mix_start = jimixstartP + 1;
                    jicurrP = jilcpendP + 1;
                    jicurrO = jointiinfosA[jicurrP + jiP];
                    continue block6;
                }
                j.tag = -1;
            }
        } while (!bkw_end_reached);
        int nub = mix_start - unb_start;
        int ji_start = unb_start;
        int ji_end = lcp_end;
        DxWorldProcessMemArena.dummy();
        jiP = ji_start;
        int nj = ji_end - ji_start;
        int m = 0;
        int mcurr = 0;
        dJointWithInfo1 jicurrO2 = null;
        int jicurrP2 = 0;
        int jiend = jicurrP2 + nj;
        int i3 = 0;
        while (jicurrP2 != jiend) {
            jicurrO2 = jointiinfosA[jiP + jicurrP2];
            jicurrO2.joint.tag = i3++;
            int jm = jicurrO2.info.m;
            mcurr += jm;
            ++jicurrP2;
        }
        m = mcurr;
        DxWorldProcessMemArena.dummy();
        double[] cforce = new double[nb * 8];
        if (m > 0) {
            int infom;
            double[] rhs;
            int mlocal = m;
            DxWorldProcessMemArena.dummy();
            double[] lo = new double[mlocal];
            Matrix.dSetValue(lo, mlocal, Double.NEGATIVE_INFINITY);
            double[] hi = new double[mlocal];
            Matrix.dSetValue(hi, mlocal, Double.POSITIVE_INFINITY);
            double[] J = new double[16 * mlocal];
            int[] findex = new int[mlocal];
            int i4 = 0;
            while (i4 < mlocal) {
                findex[i4] = -1;
                ++i4;
            }
            int mskip = Common.dPAD(mlocal);
            double[] A = new double[mlocal * mskip];
            double[] c = rhs = new double[mlocal];
            rhs = null;
            DxUtil.BlockPointer cfmstate = memarena.BEGIN_STATE_SAVE();
            DxWorldProcessMemArena.dummy();
            double[] cfm = new double[m];
            Matrix.dSetValue(cfm, m, world.global_cfm);
            DxWorldProcessMemArena.dummy();
            double[] JinvM = new double[16 * m];
            Step.IFTIMING_dTimerNow("create J");
            DxJoint.Info2 Jinfo = new DxJoint.Info2();
            Jinfo.setRowskip(8);
            Jinfo.setArrays(J, c, cfm, lo, hi, findex);
            Jinfo.fps = stepsizeRecip;
            Jinfo.erp = world.getERP();
            int ofsi = 0;
            int ii5 = 0;
            while (ii5 < nj) {
                int J2rowP;
                int J1rowP;
                dJointWithInfo1 jicurr = jointiinfosA[jiP + ii5];
                infom = jicurr.info.m;
                Jinfo.J1lp = J1rowP = 0 + 16 * ofsi;
                Jinfo.J1ap = J1rowP + 4;
                Jinfo.J2lp = J2rowP = J1rowP + 8 * infom;
                Jinfo.J2ap = J2rowP + 4;
                Jinfo.setAllP(ofsi);
                DxJoint joint = jicurr.joint;
                joint.getInfo2(Jinfo);
                int findex_ofsiP = ofsi;
                int j = 0;
                while (j < infom) {
                    int fival = findex[findex_ofsiP + j];
                    if (fival != -1) {
                        findex[findex_ofsiP + j] = fival + ofsi;
                    }
                    ++j;
                }
                ofsi += infom;
                ++ii5;
            }
            Step.IFTIMING_dTimerNow("compute A");
            int ofsi2 = 0;
            dJointWithInfo1 jicurrO3 = jointiinfosA[jiP];
            int jicurrP3 = 0;
            int jiendP = jicurrP3 + nj;
            while (jicurrP3 != jiendP) {
                jicurrO3 = jointiinfosA[jiP + jicurrP3];
                infom = jicurrO3.info.m;
                DxJoint joint = jicurrO3.joint;
                int b0 = joint.node[0].body.tag;
                double body_invMass0 = bodyA[bOfs + b0].invMass;
                int body_invI0 = b0 * 12;
                int Jsrc = 16 * ofsi2;
                int Jdst = 16 * ofsi2;
                int j = infom;
                while (j > 0) {
                    --j;
                    int k = 0;
                    while (k < 3) {
                        JinvM[Jdst + k] = J[Jsrc + k] * body_invMass0;
                        ++k;
                    }
                    OdeMath.dMultiply0_133(JinvM, Jdst + 4, J, Jsrc + 4, invI, body_invI0);
                    Jsrc += 8;
                    Jdst += 8;
                }
                if (joint.node[1].body != null) {
                    int b1 = joint.node[1].body.tag;
                    double body_invMass1 = bodyA[bOfs + b1].invMass;
                    int body_invI1 = b1 * 12;
                    int j2 = infom;
                    while (j2 > 0) {
                        --j2;
                        int k = 0;
                        while (k < 3) {
                            JinvM[Jdst + k] = J[Jsrc + k] * body_invMass1;
                            ++k;
                        }
                        OdeMath.dMultiply0_133(JinvM, Jdst + 4, J, Jsrc + 4, invI, body_invI1);
                        Jsrc += 8;
                        Jdst += 8;
                    }
                }
                ofsi2 += infom;
                ++jicurrP3;
            }
            DxUtil.BlockPointer ofsstate = memarena.BEGIN_STATE_SAVE();
            DxWorldProcessMemArena.dummy();
            int[] ofs = new int[m];
            int mskip2 = Common.dPAD(m);
            int ofsi3 = 0;
            dJointWithInfo1 jicurrO4 = jointiinfosA[jiP];
            int jicurrP4 = 0;
            int jiendP2 = jicurrP4 + nj;
            int i5 = 0;
            while (jicurrP4 != jiendP2) {
                jicurrO4 = jointiinfosA[jiP + jicurrP4];
                int infom2 = jicurrO4.info.m;
                DxJoint joint = jicurrO4.joint;
                int Arow = mskip2 * ofsi3;
                int JinvMrow = 16 * ofsi3;
                DxBody jb0 = joint.node[0].body;
                DxJointNode n0 = jb0.firstjoint.get();
                while (n0 != null) {
                    int j0 = n0.joint.tag;
                    if (j0 != -1 && j0 < i5) {
                        dJointWithInfo1 jiother = jointiinfosA[jiP + j0];
                        int ofsother = jiother.joint.node[1].body == jb0 ? 8 * jiother.info.m : 0;
                        Step.MultiplyAdd2_p8r(A, Arow + ofs[j0], JinvM, JinvMrow, J, 16 * ofs[j0] + ofsother, infom2, jiother.info.m, mskip2);
                    }
                    n0 = n0.next;
                }
                DxBody jb1 = joint.node[1].body;
                Common.dIASSERT(jb1 != jb0);
                if (jb1 != null) {
                    DxJointNode n1 = jb1.firstjoint.get();
                    while (n1 != null) {
                        int j1 = n1.joint.tag;
                        if (j1 != -1 && j1 < i5) {
                            dJointWithInfo1 jiother = jointiinfosA[jiP + j1];
                            int ofsother = jiother.joint.node[1].body == jb1 ? 8 * jiother.info.m : 0;
                            Step.MultiplyAdd2_p8r(A, Arow + ofs[j1], JinvM, JinvMrow + 8 * infom2, J, 16 * ofs[j1] + ofsother, infom2, jiother.info.m, mskip2);
                        }
                        n1 = n1.next;
                    }
                }
                ofs[i5] = ofsi3;
                ofsi3 += infom2;
                ++i5;
                ++jicurrP4;
            }
            memarena.END_STATE_SAVE(ofsstate);
            int mskip3 = Common.dPAD(m);
            ofsi = 0;
            dJointWithInfo1 jicurrO5 = jointiinfosA[jiP];
            int jicurrP5 = 0;
            int jiend2 = jicurrP5 + nj;
            while (jicurrP5 != jiend2) {
                jicurrO5 = jointiinfosA[jiP + jicurrP5];
                int infom3 = jicurrO5.info.m;
                int Arow = (mskip3 + 1) * ofsi;
                int JinvMrow = 16 * ofsi;
                int Jrow = 16 * ofsi;
                Step.Multiply2_p8r(A, Arow, JinvM, JinvMrow, J, Jrow, infom3, infom3, mskip3);
                if (jicurrO5.joint.node[1].body != null) {
                    Step.MultiplyAdd2_p8r(A, Arow, JinvM, JinvMrow + 8 * infom3, J, Jrow + 8 * infom3, infom3, infom3, mskip3);
                }
                ofsi += infom3;
                ++jicurrP5;
            }
            mskip3 = Common.dPAD(m);
            int Arow = 0;
            int i6 = 0;
            while (i6 < m) {
                int n = Arow + i6;
                A[n] = A[n] + cfm[i6] * stepsizeRecip;
                Arow += mskip3;
                ++i6;
            }
            memarena.END_STATE_SAVE(cfmstate);
            DxUtil.BlockPointer tmp1state = memarena.BEGIN_STATE_SAVE();
            Step.IFTIMING_dTimerNow("compute rhs");
            DxWorldProcessMemArena.dummy();
            double[] tmp1 = new double[nb * 8];
            int tmp1currP = 0;
            int invIrow2 = 0;
            ii = bOfs;
            while (ii < bOfs + nb) {
                DxBody b = bodyA[ii];
                tmp1[tmp1currP + 0] = b.facc.get0() * b.invMass + b.lvel.get0() * stepsizeRecip;
                tmp1[tmp1currP + 1] = b.facc.get1() * b.invMass + b.lvel.get1() * stepsizeRecip;
                tmp1[tmp1currP + 2] = b.facc.get2() * b.invMass + b.lvel.get2() * stepsizeRecip;
                OdeMath.dMultiply0_331(tmp1, tmp1currP + 4, invI, invIrow2, b.tacc);
                int n = tmp1currP + 4 + 0;
                tmp1[n] = tmp1[n] + b.avel.get0() * stepsizeRecip;
                int n2 = tmp1currP + 4 + 1;
                tmp1[n2] = tmp1[n2] + b.avel.get1() * stepsizeRecip;
                int n3 = tmp1currP + 4 + 2;
                tmp1[n3] = tmp1[n3] + b.avel.get2() * stepsizeRecip;
                ++ii;
                tmp1currP += 8;
                invIrow2 += 12;
            }
            rhs = c;
            int i7 = 0;
            while (i7 < m) {
                rhs[i7] = c[i7] * stepsizeRecip;
                ++i7;
            }
            c = null;
            ofsi = 0;
            jicurrO = jointiinfosA[jiP];
            jicurrP = 0;
            int jiend3 = jicurrP + nj;
            while (jicurrP != jiend3) {
                jicurrO = jointiinfosA[jiP + jicurrP];
                int infom4 = jicurrO.info.m;
                DxJoint joint = jicurrO.joint;
                int rhscurr = ofsi;
                int Jrow = 16 * ofsi;
                Step.MultiplySub0_p81(rhs, rhscurr, J, Jrow, tmp1, 8 * joint.node[0].body.tag, infom4);
                if (joint.node[1].body != null) {
                    Step.MultiplySub0_p81(rhs, rhscurr, J, Jrow + 8 * infom4, tmp1, 8 * joint.node[1].body.tag, infom4);
                }
                ofsi += infom4;
                ++jicurrP;
            }
            memarena.END_STATE_SAVE(tmp1state);
            DxWorldProcessMemArena.dummy();
            double[] lambda = new double[m];
            DxUtil.BlockPointer lcpstate = memarena.BEGIN_STATE_SAVE();
            Step.IFTIMING_dTimerNow("solving LCP problem");
            DLCP.dSolveLCP(memarena, m, A, lambda, rhs, null, nub, lo, hi, findex);
            memarena.END_STATE_SAVE(lcpstate);
            Step.IFTIMING_dTimerNow("compute constraint force");
            ofsi = 0;
            jicurrO = jointiinfosA[jiP];
            jicurrP = 0;
            jiend2 = jicurrP + nj;
            while (jicurrP != jiend2) {
                jicurrO = jointiinfosA[jiP + jicurrP];
                int infom5 = jicurrO.info.m;
                DxJoint joint = jicurrO.joint;
                int JJ = 16 * ofsi;
                int lambdarow = ofsi;
                DJoint.DJointFeedback fb = joint.feedback;
                if (fb != null) {
                    double[] data = new double[8];
                    Step.Multiply1_8q1(data, 0, J, JJ, lambda, lambdarow, infom5);
                    DxBody b1 = joint.node[0].body;
                    int cf1 = 8 * b1.tag;
                    fb.f1.set(data[0], data[1], data[2]);
                    fb.t1.set(data[4], data[5], data[6]);
                    int n = cf1 + 0;
                    cforce[n] = cforce[n] + data[0];
                    int n4 = cf1 + 1;
                    cforce[n4] = cforce[n4] + data[1];
                    int n5 = cf1 + 2;
                    cforce[n5] = cforce[n5] + data[2];
                    int n6 = cf1 + 4;
                    cforce[n6] = cforce[n6] + data[4];
                    int n7 = cf1 + 5;
                    cforce[n7] = cforce[n7] + data[5];
                    int n8 = cf1 + 6;
                    cforce[n8] = cforce[n8] + data[6];
                    DxBody b2 = joint.node[1].body;
                    if (b2 != null) {
                        Step.Multiply1_8q1(data, 0, J, JJ + 8 * infom5, lambda, lambdarow, infom5);
                        int cf2 = 8 * b2.tag;
                        fb.f2.set(data[0], data[1], data[2]);
                        fb.t2.set(data[4], data[5], data[6]);
                        int n9 = cf2 + 0;
                        cforce[n9] = cforce[n9] + data[0];
                        int n10 = cf2 + 1;
                        cforce[n10] = cforce[n10] + data[1];
                        int n11 = cf2 + 2;
                        cforce[n11] = cforce[n11] + data[2];
                        int n12 = cf2 + 4;
                        cforce[n12] = cforce[n12] + data[4];
                        int n13 = cf2 + 5;
                        cforce[n13] = cforce[n13] + data[5];
                        int n14 = cf2 + 6;
                        cforce[n14] = cforce[n14] + data[6];
                    }
                } else {
                    DxBody b1 = joint.node[0].body;
                    int cf1 = 8 * b1.tag;
                    Step.MultiplyAdd1_8q1(cforce, cf1, J, JJ, lambda, lambdarow, infom5);
                    DxBody b2 = joint.node[1].body;
                    if (b2 != null) {
                        int cf2 = 8 * b2.tag;
                        Step.MultiplyAdd1_8q1(cforce, cf2, J, JJ + 8 * infom5, lambda, lambdarow, infom5);
                    }
                }
                ofsi += infom5;
                ++jicurrP;
            }
        }
        Step.IFTIMING_dTimerNow("compute velocity update");
        double[] data = new double[4];
        int invIrowP = 0;
        int cforcecurrP = 0;
        int ii6 = bOfs;
        while (ii6 < bOfs + nb) {
            DxBody b = bodyA[ii6];
            double body_invMass_mul_stepsize = stepsize * b.invMass;
            b.lvel.add0((cforce[cforcecurrP + 0] + b.facc.get0()) * body_invMass_mul_stepsize);
            b.lvel.add1((cforce[cforcecurrP + 1] + b.facc.get1()) * body_invMass_mul_stepsize);
            b.lvel.add2((cforce[cforcecurrP + 2] + b.facc.get2()) * body_invMass_mul_stepsize);
            data[0] = (cforce[cforcecurrP + 4 + 0] + b.tacc.get0()) * stepsize;
            data[1] = (cforce[cforcecurrP + 4 + 1] + b.tacc.get1()) * stepsize;
            data[2] = (cforce[cforcecurrP + 4 + 2] + b.tacc.get2()) * stepsize;
            OdeMath.dMultiplyAdd0_331(b.avel, invI, invIrowP, data, 0);
            ++ii6;
            invIrowP += 12;
            cforcecurrP += 8;
        }
        Step.IFTIMING_dTimerNow("update position");
        int ii7 = bOfs;
        while (ii7 < bOfs + nb) {
            DxBody b = bodyA[ii7];
            b.dxStepBody(stepsize);
            ++ii7;
        }
        Step.IFTIMING_dTimerNow("tidy up");
        ii7 = bOfs;
        while (ii7 < bOfs + nb) {
            DxBody b = bodyA[ii7];
            b.facc.setZero();
            b.tacc.setZero();
            ++ii7;
        }
        Step.IFTIMING_dTimerEnd();
        if (m > 0) {
            Step.IFTIMING_dTimerReport(Cstdio.stdout, 1);
        }
    }

    private final void dInternalStepIsland(DxWorldProcessMemArena memarena, DxWorld world, DxBody[] bodyA, int bOfs, int nb, DxJoint[] jointA, int jOfs, int nj, double stepsize) {
        this.dInternalStepIsland_x2(memarena, world, bodyA, bOfs, nb, jointA, jOfs, nj, stepsize);
    }

    int dxEstimateStepMemoryRequirements(DxBody[] body, int nb, DxJoint[] _joint, int _nj) {
        return -1;
    }

    @Override
    public int dxEstimateMemoryRequirements(DxBody[] body, int bodyOfs, int nb, DxJoint[] _joint, int jointOfs, int _nj) {
        return 0;
    }

    @Override
    public void run(DxWorldProcessMemArena memarena, DxWorld world, DxBody[] body, int bodyOfs, int nb, DxJoint[] _joint, int jointOfs, int nj, double stepsize) {
        this.dInternalStepIsland(memarena, world, body, bodyOfs, nb, _joint, jointOfs, nj, stepsize);
    }

    private static class dJointWithInfo1 {
        DxJoint joint;
        final DxJoint.Info1 info = new DxJoint.Info1();

        private dJointWithInfo1() {
        }
    }
}

