/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DQuaternionC;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Matrix;

public class Rotation
extends Matrix {
    public static void dRSetIdentity(DMatrix3 R) {
        R.setIdentity();
    }

    public static void dRFromAxisAndAngle(DMatrix3 R, double ax, double ay, double az, double angle) {
        DQuaternion q = new DQuaternion();
        Rotation.dQFromAxisAndAngle(q, ax, ay, az, angle);
        Rotation.dRfromQ(R, q);
    }

    public static void dRFromAxisAndAngle(DMatrix3 R, DVector3C axyz, double angle) {
        DQuaternion q = new DQuaternion();
        Rotation.dQFromAxisAndAngle(q, axyz, angle);
        Rotation.dRfromQ(R, q);
    }

    public static void dRFromEulerAngles(DMatrix3 R, double phi, double theta, double psi) {
        double sphi = Rotation.dSin(phi);
        double cphi = Rotation.dCos(phi);
        double stheta = Rotation.dSin(theta);
        double ctheta = Rotation.dCos(theta);
        double spsi = Rotation.dSin(psi);
        double cpsi = Rotation.dCos(psi);
        R.set00(cpsi * ctheta);
        R.set01(spsi * ctheta);
        R.set02(-stheta);
        R.set10(cpsi * stheta * sphi - spsi * cphi);
        R.set11(spsi * stheta * sphi + cpsi * cphi);
        R.set12(ctheta * sphi);
        R.set20(cpsi * stheta * cphi + spsi * sphi);
        R.set21(spsi * stheta * cphi - cpsi * sphi);
        R.set22(ctheta * cphi);
    }

    public static void dRFrom2Axes(DMatrix3 R, DVector3C a, DVector3C b) {
        Rotation.dRFrom2Axes(R, a.get0(), a.get1(), a.get2(), b.get0(), b.get1(), b.get2());
    }

    public static void dRFrom2Axes(DMatrix3 R, double ax, double ay, double az, double bx, double by, double bz) {
        double k;
        double l = Rotation.dSqrt(ax * ax + ay * ay + az * az);
        if (l <= 0.0) {
            Rotation.dDEBUGMSG("zero length vector");
            return;
        }
        l = Rotation.dRecip(l);
        if ((l = Rotation.dSqrt((bx -= (k = (ax *= l) * bx + (ay *= l) * by + (az *= l) * bz) * ax) * bx + (by -= k * ay) * by + (bz -= k * az) * bz)) <= 0.0) {
            Rotation.dDEBUGMSG("zero length vector");
            return;
        }
        l = Rotation.dRecip(l);
        bx *= l;
        by *= l;
        bz *= l;
        R.set00(ax);
        R.set10(ay);
        R.set20(az);
        R.set01(bx);
        R.set11(by);
        R.set21(bz);
        R.set02(-by * az + ay * bz);
        R.set12(-bz * ax + az * bx);
        R.set22(-bx * ay + ax * by);
    }

    public static void dRFromZAxis(DMatrix3 R, double ax, double ay, double az) {
        DVector3 n = new DVector3();
        DVector3 p = new DVector3();
        DVector3 q = new DVector3();
        n.set(ax, ay, az);
        OdeMath.dNormalize3(n);
        OdeMath.dPlaneSpace(n, p, q);
        R.setCol(0, p);
        R.setCol(1, q);
        R.setCol(2, n);
    }

    public static void dRFromZAxis(DMatrix3 R, DVector3C xyz) {
        DVector3 n = new DVector3();
        DVector3 p = new DVector3();
        DVector3 q = new DVector3();
        n.set(xyz);
        n.normalize();
        OdeMath.dPlaneSpace(n, p, q);
        R.set(p.get0(), q.get0(), n.get0(), p.get1(), q.get1(), n.get1(), p.get2(), q.get2(), n.get2());
    }

    public static void dQSetIdentity(DQuaternion q) {
        q.setIdentity();
    }

    public static void dQFromAxisAndAngle(DQuaternion q, double ax, double ay, double az, double angle) {
        double l = ax * ax + ay * ay + az * az;
        if (l > 0.0) {
            l = Rotation.dSin(angle *= 0.5) * Rotation.dRecipSqrt(l);
            q.set(Math.cos(angle), ax * l, ay * l, az * l);
        } else {
            q.set(1.0, 0.0, 0.0, 0.0);
        }
    }

    public static void dQFromAxisAndAngle(DQuaternion q, DVector3C axyz, double angle) {
        double l = axyz.lengthSquared();
        if (l > 0.0) {
            l = Rotation.dSin(angle *= 0.5) * Rotation.dRecipSqrt(l);
            q.set(Math.cos(angle), axyz.get0() * l, axyz.get1() * l, axyz.get2() * l);
        } else {
            q.set(1.0, 0.0, 0.0, 0.0);
        }
    }

    public static void dQMultiply0(DQuaternion qa, DQuaternionC qb, DQuaternionC qc) {
        qa.set0(qb.get0() * qc.get0() - qb.get1() * qc.get1() - qb.get2() * qc.get2() - qb.get3() * qc.get3());
        qa.set1(qb.get0() * qc.get1() + qb.get1() * qc.get0() + qb.get2() * qc.get3() - qb.get3() * qc.get2());
        qa.set2(qb.get0() * qc.get2() + qb.get2() * qc.get0() + qb.get3() * qc.get1() - qb.get1() * qc.get3());
        qa.set3(qb.get0() * qc.get3() + qb.get3() * qc.get0() + qb.get1() * qc.get2() - qb.get2() * qc.get1());
    }

    public static void dQMultiply1(DQuaternion qa, DQuaternionC qb, DQuaternionC qc) {
        qa.set0(qb.get0() * qc.get0() + qb.get1() * qc.get1() + qb.get2() * qc.get2() + qb.get3() * qc.get3());
        qa.set1(qb.get0() * qc.get1() - qb.get1() * qc.get0() - qb.get2() * qc.get3() + qb.get3() * qc.get2());
        qa.set2(qb.get0() * qc.get2() - qb.get2() * qc.get0() - qb.get3() * qc.get1() + qb.get1() * qc.get3());
        qa.set3(qb.get0() * qc.get3() - qb.get3() * qc.get0() - qb.get1() * qc.get2() + qb.get2() * qc.get1());
    }

    public static void dQMultiply2(DQuaternion qa, DQuaternionC qb, DQuaternionC qc) {
        qa.set0(qb.get0() * qc.get0() + qb.get1() * qc.get1() + qb.get2() * qc.get2() + qb.get3() * qc.get3());
        qa.set1(-qb.get0() * qc.get1() + qb.get1() * qc.get0() - qb.get2() * qc.get3() + qb.get3() * qc.get2());
        qa.set2(-qb.get0() * qc.get2() + qb.get2() * qc.get0() - qb.get3() * qc.get1() + qb.get1() * qc.get3());
        qa.set3(-qb.get0() * qc.get3() + qb.get3() * qc.get0() - qb.get1() * qc.get2() + qb.get2() * qc.get1());
    }

    public static void dQMultiply3(DQuaternion qa, DQuaternionC qb, DQuaternionC qc) {
        qa.set0(qb.get0() * qc.get0() - qb.get1() * qc.get1() - qb.get2() * qc.get2() - qb.get3() * qc.get3());
        qa.set1(-qb.get0() * qc.get1() - qb.get1() * qc.get0() + qb.get2() * qc.get3() - qb.get3() * qc.get2());
        qa.set2(-qb.get0() * qc.get2() - qb.get2() * qc.get0() + qb.get3() * qc.get1() - qb.get1() * qc.get3());
        qa.set3(-qb.get0() * qc.get3() - qb.get3() * qc.get0() + qb.get1() * qc.get2() - qb.get2() * qc.get1());
    }

    public static void dRfromQ(DMatrix3 R, DQuaternionC q) {
        double q0 = q.get0();
        double q1 = q.get1();
        double q2 = q.get2();
        double q3 = q.get3();
        double qq1 = 2.0 * q1 * q1;
        double qq2 = 2.0 * q2 * q2;
        double qq3 = 2.0 * q3 * q3;
        R.set00(1.0 - qq2 - qq3);
        R.set01(2.0 * (q1 * q2 - q0 * q3));
        R.set02(2.0 * (q1 * q3 + q0 * q2));
        R.set10(2.0 * (q1 * q2 + q0 * q3));
        R.set11(1.0 - qq1 - qq3);
        R.set12(2.0 * (q2 * q3 - q0 * q1));
        R.set20(2.0 * (q1 * q3 - q0 * q2));
        R.set21(2.0 * (q2 * q3 + q0 * q1));
        R.set22(1.0 - qq1 - qq2);
    }

    public static void dQtoR(DQuaternionC q, DMatrix3 R) {
        Rotation.dRfromQ(R, q);
    }

    public static void dRtoQ(DMatrix3C R, DQuaternion q) {
        Rotation.dQfromR(q, R);
    }

    public static void dQfromR(DQuaternion q, DMatrix3C R) {
        double tr = R.get00() + R.get11() + R.get22();
        if (tr >= 0.0) {
            double s = Rotation.dSqrt(tr + 1.0);
            q.set0(0.5 * s);
            s = 0.5 * Rotation.dRecip(s);
            q.set1((R.get21() - R.get12()) * s);
            q.set2((R.get02() - R.get20()) * s);
            q.set3((R.get10() - R.get01()) * s);
        } else {
            if (R.get11() > R.get00()) {
                if (R.get22() > R.get11()) {
                    Rotation.DQFR_case_2(q, R);
                    return;
                }
                Rotation.DQFR_case_1(q, R);
                return;
            }
            if (R.get22() > R.get00()) {
                Rotation.DQFR_case_2(q, R);
                return;
            }
            Rotation.DQFR_case_0(q, R);
        }
    }

    private static void DQFR_case_0(DQuaternion q, DMatrix3C R) {
        double s = Rotation.dSqrt(R.get00() - (R.get11() + R.get22()) + 1.0);
        q.set1(0.5 * s);
        s = 0.5 * Rotation.dRecip(s);
        q.set2((R.get01() + R.get10()) * s);
        q.set3((R.get20() + R.get02()) * s);
        q.set0((R.get21() - R.get12()) * s);
    }

    private static void DQFR_case_1(DQuaternion q, DMatrix3C R) {
        double s = Rotation.dSqrt(R.get11() - (R.get22() + R.get00()) + 1.0);
        q.set2(0.5 * s);
        s = 0.5 * Rotation.dRecip(s);
        q.set3((R.get12() + R.get21()) * s);
        q.set1((R.get01() + R.get10()) * s);
        q.set0((R.get02() - R.get20()) * s);
    }

    private static void DQFR_case_2(DQuaternion q, DMatrix3C R) {
        double s = Rotation.dSqrt(R.get22() - (R.get00() + R.get11()) + 1.0);
        q.set3(0.5 * s);
        s = 0.5 * Rotation.dRecip(s);
        q.set1((R.get20() + R.get02()) * s);
        q.set2((R.get12() + R.get21()) * s);
        q.set0((R.get10() - R.get01()) * s);
    }

    public static void dWtoDQ(DVector3C w, DQuaternionC q, DQuaternion dq) {
        Rotation.dDQfromW(dq, w, q);
    }

    public static void dDQfromW(DQuaternion dq, DVector3C w, DQuaternionC q) {
        dq.set(0, 0.5 * (-w.get0() * q.get1() - w.get1() * q.get2() - w.get2() * q.get3()));
        dq.set(1, 0.5 * (w.get0() * q.get0() + w.get1() * q.get3() - w.get2() * q.get2()));
        dq.set(2, 0.5 * (-w.get0() * q.get3() + w.get1() * q.get0() + w.get2() * q.get1()));
        dq.set(3, 0.5 * (w.get0() * q.get2() - w.get1() * q.get1() + w.get2() * q.get0()));
    }
}

