/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.RefBoolean;
import org.ode4j.ode.internal.CollideSpaceGeom;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.gimpact.Gimpact;

public class OdeInit {
    private static int g_uiODEInitCounter = 0;
    private static int g_uiODEInitModes = 0;
    private static final int dInitFlagManualThreadCleanup = 1;
    private static final int dAllocateFlagBasicData = 0;
    private static final int dAllocateFlagCollisionData = 1;
    private static final int dAllocateMaskAll = -1;

    private static boolean IsODEModeInitialized(EODEINITMODE imInitMode) {
        return (g_uiODEInitModes & 1 << imInitMode.ordinal()) != 0;
    }

    private static void SetODEModeInitialized(EODEINITMODE imInitMode) {
        g_uiODEInitModes |= 1 << imInitMode.ordinal();
    }

    private static void ResetODEModeInitialized(EODEINITMODE imInitMode) {
        g_uiODEInitModes &= ~(1 << imInitMode.ordinal());
    }

    private static boolean IsODEAnyModeInitialized() {
        return g_uiODEInitModes != 0;
    }

    private static boolean AllocateThreadBasicDataIfNecessary(EODEINITMODE imInitMode) {
        boolean bResult = false;
        bResult = true;
        return bResult;
    }

    private static void FreeThreadBasicDataOnFailureIfNecessary(EODEINITMODE imInitMode) {
    }

    private static boolean AllocateThreadCollisionDataIfNecessary(EODEINITMODE imInitMode, RefBoolean bOutDataAllocated) {
        boolean bResult = false;
        bOutDataAllocated.set(false);
        bResult = true;
        return bResult;
    }

    private static void FreeThreadCollisionData(EODEINITMODE imInitMode) {
    }

    private static boolean InitODEForMode(EODEINITMODE imInitMode) {
        boolean bResult = false;
        boolean bAnyModeAlreadyInitialized = OdeInit.IsODEAnyModeInitialized();
        if (!bAnyModeAlreadyInitialized) {
            Gimpact.gimpact_init();
            DxGeom.dInitColliders();
        }
        bResult = true;
        return bResult;
    }

    private static boolean AllocateODEDataForThreadForMode(EODEINITMODE imInitMode, int uiAllocateFlags) {
        boolean bResult = false;
        RefBoolean bCollisionDataAllocated = new RefBoolean(false);
        if (OdeInit.AllocateThreadBasicDataIfNecessary(imInitMode) && ((uiAllocateFlags & 1) == 0 || OdeInit.AllocateThreadCollisionDataIfNecessary(imInitMode, bCollisionDataAllocated))) {
            bResult = true;
        }
        if (!bResult) {
            if (bCollisionDataAllocated.get()) {
                OdeInit.FreeThreadCollisionData(imInitMode);
            }
            OdeInit.FreeThreadBasicDataOnFailureIfNecessary(imInitMode);
        }
        return bResult;
    }

    static void CloseODEForMode(EODEINITMODE imInitMode) {
        boolean bAnyModeStillInitialized = OdeInit.IsODEAnyModeInitialized();
        if (!bAnyModeStillInitialized) {
            CollideSpaceGeom.dClearPosrCache();
            DxGeom.dFinitUserClasses();
            DxGeom.dFinitColliders();
            Gimpact.gimpact_terminate();
        }
    }

    private static boolean InternalInitODE(int uiInitFlags) {
        boolean bResult;
        block3: {
            block2: {
                EODEINITMODE imInitMode;
                bResult = false;
                EODEINITMODE eODEINITMODE = imInitMode = (uiInitFlags & 1) != 0 ? EODEINITMODE.OIM_MANUALTLSCLEANUP : EODEINITMODE.OIM_AUTOTLSCLEANUP;
                if (OdeInit.IsODEModeInitialized(imInitMode)) break block2;
                if (!OdeInit.InitODEForMode(imInitMode)) break block3;
                OdeInit.SetODEModeInitialized(imInitMode);
            }
            ++g_uiODEInitCounter;
            bResult = true;
        }
        return bResult;
    }

    private static void InternalCloseODE() {
        int max = --g_uiODEInitCounter == 0 ? 0 : EODEINITMODE.values().length;
        while (max != EODEINITMODE.values().length) {
            EODEINITMODE uiCurrentMode = EODEINITMODE.values()[max];
            if (OdeInit.IsODEModeInitialized(uiCurrentMode)) {
                OdeInit.ResetODEModeInitialized(uiCurrentMode);
                OdeInit.CloseODEForMode(uiCurrentMode);
            }
            ++max;
        }
    }

    private static boolean InternalAllocateODEDataForThread(int uiAllocateFlags) {
        boolean bAnyFailure = false;
        EODEINITMODE[] eODEINITMODEArray = EODEINITMODE.values();
        int n = eODEINITMODEArray.length;
        int n2 = 0;
        while (n2 < n) {
            EODEINITMODE uiCurrentMode = eODEINITMODEArray[n2];
            if (OdeInit.IsODEModeInitialized(uiCurrentMode) && !OdeInit.AllocateODEDataForThreadForMode(uiCurrentMode, uiAllocateFlags)) {
                bAnyFailure = true;
                break;
            }
            ++n2;
        }
        boolean bResult = !bAnyFailure;
        return bResult;
    }

    static void InternalCleanupODEAllDataForThread() {
    }

    public static void dInitODE() {
        boolean bInitResult = OdeInit.InternalInitODE(0);
        Common.dIVERIFY(bInitResult);
        boolean ibAllocResult = OdeInit.InternalAllocateODEDataForThread(-1);
        Common.dIVERIFY(ibAllocResult);
    }

    public static boolean dInitODE2(int uiInitFlags) {
        boolean bResult = false;
        boolean bODEInitialized = false;
        if (OdeInit.InternalInitODE(uiInitFlags)) {
            bODEInitialized = true;
            if (OdeInit.InternalAllocateODEDataForThread(0)) {
                bResult = true;
            }
        }
        if (!bResult && bODEInitialized) {
            OdeInit.InternalCloseODE();
        }
        return bResult;
    }

    public static boolean dAllocateODEDataForThread(int uiAllocateFlags) {
        Common.dUASSERT(g_uiODEInitCounter != 0, "Call dInitODE2 first");
        boolean bResult = OdeInit.InternalAllocateODEDataForThread(uiAllocateFlags);
        return bResult;
    }

    void dCleanupODEAllDataForThread() {
        Common.dUASSERT(g_uiODEInitCounter != 0, "Call dInitODE2 first or delay dCloseODE until all threads exit");
        OdeInit.InternalCleanupODEAllDataForThread();
    }

    public static void dCloseODE() {
        Common.dUASSERT(g_uiODEInitCounter != 0, "dCloseODE must not be called without dInitODE2 or if dInitODE2 fails");
        OdeInit.InternalCloseODE();
    }

    static enum EODEINITMODE {
        OIM_AUTOTLSCLEANUP,
        OIM_MANUALTLSCLEANUP;

    }
}

