/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cstdio;
import org.cpp4j.java.Ref;
import org.ode4j.ode.DMisc;
import org.ode4j.ode.internal.DObject;
import org.ode4j.ode.internal.DxBody;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.ErrorHandler;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.OdeJointsFactoryImpl;

public class OdeFactoryImpl
extends OdeJointsFactoryImpl {
    private static int g_world_check_tag_generator = 0;
    private static final int NUM = 100;
    private static String ode_configuration = "ODE ";

    static {
        OdeFactoryImpl.REGISTER_EXTENSION("ODE_EXT_trimesh");
        OdeFactoryImpl.REGISTER_EXTENSION("ODE_EXT_gimpact");
        ode_configuration = String.valueOf(ode_configuration) + "ODE_double_precision";
    }

    static <T extends DObject> boolean listHasLoops(Ref<T> first) {
        if (first.get() == null || ((DObject)first.get()).getNext() == null) {
            return false;
        }
        DObject a = (DObject)first.get();
        DObject b = ((DObject)first.get()).getNext();
        boolean skip = false;
        while (b != null) {
            if (a == b) {
                return true;
            }
            b = b.getNext();
            if (skip) {
                a = a.getNext();
            }
            skip ^= true;
        }
        return false;
    }

    static int generateWorldCheckTag() {
        return ++g_world_check_tag_generator;
    }

    static void checkWorld(DxWorld w) {
        if (OdeFactoryImpl.listHasLoops(w.firstbody)) {
            ErrorHandler.dDebug(0, "body list has loops", new Object[0]);
        }
        if (OdeFactoryImpl.listHasLoops(w.firstjoint)) {
            ErrorHandler.dDebug(0, "joint list has loops", new Object[0]);
        }
        throw new UnsupportedOperationException();
    }

    void dWorldCheck(DxWorld w) {
        OdeFactoryImpl.checkWorld(w);
    }

    public void dTestDataStructures() {
        Cstdio.printf("testDynamicsStuff()\n", new Object[0]);
        DxBody[] body = new DxBody[100];
        int nb = 0;
        DxJoint[] joint = new DxJoint[100];
        int nj = 0;
        int i = 0;
        while (i < 100) {
            body[i] = null;
            ++i;
        }
        i = 0;
        while (i < 100) {
            joint[i] = null;
            ++i;
        }
        Cstdio.printf("creating world\n", new Object[0]);
        DxWorld w = DxWorld.dWorldCreate();
        OdeFactoryImpl.checkWorld(w);
        while (true) {
            DxBody b2;
            DxBody b1;
            if (nb < 100 && DMisc.dRandReal() > 0.5) {
                Cstdio.printf("creating body\n", new Object[0]);
                body[nb] = DxBody.dBodyCreate(w);
                Cstdio.printf("\t--> %p\n", body[nb].toString());
                OdeFactoryImpl.checkWorld(w);
                Cstdio.printf("%d BODIES, %d JOINTS\n", ++nb, nj);
            }
            if (nj < 100 && nb > 2 && DMisc.dRandReal() > 0.5 && (b1 = body[(int)(DMisc.dRand() % (long)nb)]) != (b2 = body[(int)(DMisc.dRand() % (long)nb)])) {
                Cstdio.printf("creating joint, attaching to %p,%p\n", b1, b2);
                joint[nj] = this.dJointCreateBall(w, null);
                Cstdio.printf("\t-->%p\n", joint[nj]);
                OdeFactoryImpl.checkWorld(w);
                joint[nj].dJointAttach(b1, b2);
                OdeFactoryImpl.checkWorld(w);
                Cstdio.printf("%d BODIES, %d JOINTS\n", nb, ++nj);
            }
            if (nj > 0 && nb > 2 && DMisc.dRandReal() > 0.5 && (b1 = body[(int)(DMisc.dRand() % (long)nb)]) != (b2 = body[(int)(DMisc.dRand() % (long)nb)])) {
                int k = (int)(DMisc.dRand() % (long)nj);
                Cstdio.printf("reattaching joint %p\n", joint[k]);
                joint[k].dJointAttach(b1, b2);
                OdeFactoryImpl.checkWorld(w);
                Cstdio.printf("%d BODIES, %d JOINTS\n", nb, nj);
            }
            if (nb > 0 && DMisc.dRandReal() > 0.5) {
                int k = (int)(DMisc.dRand() % (long)nb);
                Cstdio.printf("destroying body %p\n", body[k]);
                body[k].dBodyDestroy();
                OdeFactoryImpl.checkWorld(w);
                while (k < 99) {
                    body[k] = body[k + 1];
                    ++k;
                }
                Cstdio.printf("%d BODIES, %d JOINTS\n", --nb, nj);
            }
            if (nj <= 0 || !(DMisc.dRandReal() > 0.5)) continue;
            int k = (int)(DMisc.dRand() % (long)nj);
            Cstdio.printf("destroying joint %p\n", joint[k]);
            OdeFactoryImpl.dJointDestroy(joint[k]);
            OdeFactoryImpl.checkWorld(w);
            while (k < 99) {
                joint[k] = joint[k + 1];
                ++k;
            }
            Cstdio.printf("%d BODIES, %d JOINTS\n", nb, --nj);
        }
    }

    private static void REGISTER_EXTENSION(String s) {
        ode_configuration = String.valueOf(ode_configuration) + s + " ";
    }

    public String _dGetConfiguration() {
        return ode_configuration;
    }

    public boolean _dCheckConfiguration(String extension) {
        int where;
        if (extension.indexOf(32) >= 0 || extension.length() == 0) {
            return true;
        }
        String config = OdeFactoryImpl.getConfiguration();
        int ext_length = extension.length();
        int start = 0;
        while ((where = config.indexOf(extension, start)) != -1) {
            int terminator = where + ext_length;
            if (!(where != start && extension.charAt(where - 1) != ' ' || extension.charAt(terminator) != ' ' && terminator != extension.length())) {
                return true;
            }
            start = terminator;
        }
        return false;
    }
}

