/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cstdio;
import org.cpp4j.FILE;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DQuaternionC;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.internal.Common;

public class Misc
extends Common {
    private static volatile long seed = 0L;

    protected Misc() {
    }

    public static long dRand() {
        seed = 1664525L * seed + 1013904223L & 0xFFFFFFFFL;
        return seed;
    }

    public static long dRandGetSeed() {
        return Math.abs(seed);
    }

    public static void dRandSetSeed(long s) {
        seed = s;
    }

    public static boolean dTestRand() {
        long oldseed = seed;
        boolean ret = true;
        seed = 0L;
        if (Misc.dRand() != 1013904223L || Misc.dRand() != 1196435762L || Misc.dRand() != 3519870697L || Misc.dRand() != 2868466484L || Misc.dRand() != 1649599747L || Misc.dRand() != 2670642822L || Misc.dRand() != 1476291629L || Misc.dRand() != 2748932008L || Misc.dRand() != 2180890343L || Misc.dRand() != 2498801434L || Misc.dRand() != 3421909937L) {
            ret = false;
        }
        seed = oldseed;
        return ret;
    }

    public static int dRandInt(long n) {
        long un = n;
        long r = Misc.dRand();
        if (un <= 16L) {
            r ^= r >> 16;
            r ^= r >> 8;
            r ^= r >> 4;
            if (un <= 2L) {
                r ^= r >> 2;
                r ^= r >> 1;
            } else if (un <= 4L) {
                r ^= r >> 2;
            }
        } else if (un <= 256L) {
            r ^= r >> 16;
            r ^= r >> 8;
        } else if (un <= 65536L) {
            r ^= r >> 16;
        }
        return (int)(r % un);
    }

    public static double dRandReal() {
        return (double)Misc.dRand() / 4.294967295E9;
    }

    void dPrintMatrix(double[] A, int n, int m, String fmt, FILE f) {
        int skip = Misc.dPAD(m);
        int Arowp = 0;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                Cstdio.fprintf(f, fmt, A[Arowp + j]);
                ++j;
            }
            Cstdio.fprintf(f, "\n", new Object[0]);
            Arowp += skip;
            ++i;
        }
    }

    public static void dMakeRandomVector(DVector3 A, double range) {
        int i = 0;
        while (i < 3) {
            A.set(i, (Misc.dRandReal() * 2.0 - 1.0) * range);
            ++i;
        }
    }

    public static void dMakeRandomVector(DQuaternion A, double range) {
        int i = 0;
        while (i < 4) {
            A.set(i, (Misc.dRandReal() * 2.0 - 1.0) * range);
            ++i;
        }
    }

    public static void dMakeRandomVector(double[] A, int n, double range) {
        int i = 0;
        while (i < n) {
            A[i] = (Misc.dRandReal() * 2.0 - 1.0) * range;
            ++i;
        }
    }

    public static void dMakeRandomMatrix(DMatrix3 A, double range) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                A.set(i, j, (Misc.dRandReal() * 2.0 - 1.0) * range);
                ++j;
            }
            ++i;
        }
    }

    public static void dMakeRandomMatrix(double[] A, int n, int m, double range) {
        int skip = Misc.dPAD(m);
        int ArowP = 0;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                A[ArowP + j] = (Misc.dRandReal() * 2.0 - 1.0) * range;
                ++j;
            }
            ArowP += skip;
            ++i;
        }
    }

    public static void dClearUpperTriangle(double[] A, int n) {
        int skip = Misc.dPAD(n);
        int ArowP = 0;
        int i = 0;
        while (i < n) {
            int j = i + 1;
            while (j < n) {
                A[ArowP + j] = 0.0;
                ++j;
            }
            ArowP += skip;
            ++i;
        }
    }

    public static void dClearUpperTriangle(DMatrix3 A) {
        A.set01(0.0);
        A.set02(0.0);
        A.set12(0.0);
    }

    public static double dMaxDifference(double[] A, double[] B, int n, int m) {
        int skip = Misc.dPAD(m);
        double max = 0.0;
        int Arow = 0;
        int Brow = 0;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                double diff = Misc.dFabs(A[Arow + j] - B[Brow + j]);
                if (diff > max) {
                    max = diff;
                }
                ++j;
            }
            Arow += skip;
            Brow += skip;
            ++i;
        }
        return max;
    }

    public static double dMaxDifference(DMatrix3C A, DMatrix3C B) {
        double max = 0.0;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                double diff = Math.abs(A.get(i, j) - B.get(i, j));
                if (diff > max) {
                    max = diff;
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public static double dMaxDifference(DVector3C A, DVector3C B) {
        double max = Math.abs(A.get0() - B.get0());
        double diff = Math.abs(A.get1() - B.get1());
        if (diff > max) {
            max = diff;
        }
        if ((diff = Math.abs(A.get2() - B.get2())) > max) {
            max = diff;
        }
        return max;
    }

    public static double dMaxDifference(DQuaternionC A, DQuaternionC B, int n, int m) {
        double max = Math.abs(A.get0() - B.get0());
        double diff = Math.abs(A.get1() - B.get1());
        if (diff > max) {
            max = diff;
        }
        if ((diff = Math.abs(A.get2() - B.get2())) > max) {
            max = diff;
        }
        if ((diff = Math.abs(A.get3() - B.get3())) > max) {
            max = diff;
        }
        return max;
    }

    public static double dMaxDifferenceLowerTriangle(double[] A, double[] B, int n) {
        int skip = Misc.dPAD(n);
        double max = 0.0;
        int Arow = 0;
        int Brow = 0;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j <= i) {
                double diff = Misc.dFabs(A[Arow + j] - B[Brow + j]);
                if (diff > max) {
                    max = diff;
                }
                ++j;
            }
            Arow += skip;
            Brow += skip;
            ++i;
        }
        return max;
    }
}

