/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import java.util.Arrays;
import org.cpp4j.Cstring;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.internal.FastDot;
import org.ode4j.ode.internal.FastLDLT;
import org.ode4j.ode.internal.processmem.DxUtil;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemArena;

public class Matrix
extends FastDot {
    private static final FastLDLT D_LDLT = new FastLDLT();

    protected Matrix() {
    }

    public static void dSetZero(double[] a, int n) {
        Matrix.dAASSERT(n >= 0);
        while (n > 0) {
            a[n - 1] = 0.0;
            --n;
        }
    }

    public static void dSetZero(double[] a) {
        Arrays.fill(a, 0.0);
    }

    public static void dSetValue(double[] a, int n, double value) {
        Matrix.dAASSERT(n >= 0);
        while (n > 0) {
            a[n - 1] = value;
            --n;
        }
    }

    public static void dMultiply0(DVector3 A, DMatrix3C B, DVector3C C) {
        A.set0(B.get00() * C.get0() + B.get01() * C.get1() + B.get02() * C.get2());
        A.set1(B.get10() * C.get0() + B.get11() * C.get1() + B.get12() * C.get2());
        A.set2(B.get20() * C.get0() + B.get21() * C.get1() + B.get22() * C.get2());
    }

    public static void dMultiply0(DVector3 a, DVector3C b, DMatrix3C C) {
        a.set0(b.get0() * C.get00() + b.get1() * C.get10() + b.get2() * C.get20());
        a.set1(b.get0() * C.get01() + b.get1() * C.get11() + b.get2() * C.get21());
        a.set2(b.get0() * C.get02() + b.get1() * C.get12() + b.get2() * C.get22());
    }

    public static void dMultiply0(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        A.eqMul(B, C);
    }

    public static void dMultiply0_OLD(double[] A, double[] B, double[] C, int p, int q, int r) {
        Matrix.dAASSERT(p > 0 && q > 0 && r > 0);
        int qskip = Matrix.dPAD(q);
        int rskip = Matrix.dPAD(r);
        int rpad = rskip - r;
        int aPos = 0;
        int bbPos = 0;
        int i = p;
        while (i > 0) {
            int j = 0;
            while (j < r) {
                int cPos = j;
                int bPos = bbPos;
                double sum = 0.0;
                int k = q;
                while (k > 0) {
                    sum += B[bPos++] * C[cPos];
                    --k;
                    cPos += rskip;
                }
                A[aPos++] = sum;
                ++j;
            }
            aPos += rpad;
            bbPos += qskip;
            --i;
        }
    }

    public static void dMultiply0(double[] A, double[] B, double[] C, int p, int q, int r) {
        Matrix.dAASSERT(p > 0 && q > 0 && r > 0);
        int qskip = Matrix.dPAD(q);
        int rskip = Matrix.dPAD(r);
        int aa = 0;
        int bb = 0;
        int i = p;
        while (i != 0) {
            int a = aa;
            int cc = 0;
            int ccend = r;
            while (cc != ccend) {
                double sum = 0.0;
                int c = cc;
                int b = bb;
                int bend = bb + q;
                while (b != bend) {
                    sum += B[b] * C[c];
                    c += rskip;
                    ++b;
                }
                A[a] = sum;
                ++a;
                ++cc;
            }
            aa += rskip;
            bb += qskip;
            --i;
        }
    }

    public static void dMultiply1(DVector3 A, DMatrix3C B, DVector3C C) {
        A.set0(B.get00() * C.get0() + B.get10() * C.get1() + B.get20() * C.get2());
        A.set1(B.get01() * C.get0() + B.get11() * C.get1() + B.get21() * C.get2());
        A.set2(B.get02() * C.get0() + B.get12() * C.get1() + B.get22() * C.get2());
    }

    public static void dMultiply1(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        Matrix.dMultiply0(A, (DMatrix3C)B.clone().eqTranspose(), C);
    }

    public static void dMultiply1(double[] A, double[] B, double[] C, int p, int q, int r) {
        Matrix.dAASSERT(p > 0 && q > 0 && r > 0);
        int pskip = Matrix.dPAD(p);
        int rskip = Matrix.dPAD(r);
        int aa = 0;
        int bb = 0;
        int bbend = p;
        while (bb != bbend) {
            int a = aa;
            int cc = 0;
            int ccend = r;
            while (cc != ccend) {
                double sum = 0.0;
                int b = bb;
                int c = cc;
                int k = q;
                while (k != 0) {
                    sum += B[b] * C[c];
                    b += pskip;
                    c += rskip;
                    --k;
                }
                A[a] = sum;
                ++a;
                ++cc;
            }
            aa += rskip;
            ++bb;
        }
    }

    public static void dMultiply2(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        Matrix.dMultiply0(A, B, (DMatrix3C)C.clone().eqTranspose());
    }

    public static void dMultiply2(DVector3 A, DMatrix3C B, DVector3C C) {
        A.set0(B.get00() * C.get0() + B.get01() * C.get1() + B.get02() * C.get2());
        A.set1(B.get10() * C.get0() + B.get11() * C.get1() + B.get12() * C.get2());
        A.set2(B.get20() * C.get0() + B.get21() * C.get1() + B.get22() * C.get2());
    }

    public static void dMultiply2(double[] A, double[] B, double[] C, int p, int q, int r) {
        Matrix.dAASSERT(p > 0 && q > 0 && r > 0);
        int rskip = Matrix.dPAD(r);
        int qskip = Matrix.dPAD(q);
        int aa = 0;
        int bb = 0;
        int i = p;
        while (i != 0) {
            int a = aa;
            int aend = aa + r;
            int cc = 0;
            while (a != aend) {
                double sum = 0.0;
                int b = bb;
                int c = cc;
                int cend = cc + q;
                while (c != cend) {
                    sum += B[b] * C[c];
                    ++b;
                    ++c;
                }
                A[a] = sum;
                cc += qskip;
                ++a;
            }
            aa += rskip;
            bb += qskip;
            --i;
        }
    }

    public static boolean dFactorCholesky(double[] A, int n, double[] tmpbuf) {
        boolean failure = false;
        int nskip = Matrix.dPAD(n);
        double[] recip = tmpbuf != null ? tmpbuf : new double[n];
        int aa = 0;
        int i = 0;
        while (i < n) {
            double sumsqrt;
            int cc = aa;
            int bb = 0;
            int j = 0;
            while (j < i) {
                double sum = A[cc];
                int a = aa;
                int b = bb;
                int bend = bb + j;
                while (b != bend) {
                    sum -= A[a] * A[b];
                    ++a;
                    ++b;
                }
                A[cc] = sum * recip[j];
                bb += nskip;
                ++cc;
                ++j;
            }
            double sum = A[cc];
            int a = aa;
            int aend = aa + i;
            while (a != aend) {
                sum -= A[a] * A[a];
                ++a;
            }
            if (sum <= 0.0) {
                failure = true;
                break;
            }
            A[cc] = sumsqrt = Matrix.dSqrt(sum);
            recip[i] = Matrix.dRecip(sumsqrt);
            aa += nskip;
            ++i;
        }
        return !failure;
    }

    public static boolean dFactorCholesky(DMatrix3 A) {
        double sum = A.get00();
        if (sum <= 0.0) {
            return false;
        }
        A.set00(Matrix.dSqrt(sum));
        double recip0 = Matrix.dRecip(A.get00());
        A.set10(A.get10() * recip0);
        sum = A.get11() - A.get10() * A.get10();
        if (sum <= 0.0) {
            return false;
        }
        A.set11(Matrix.dSqrt(sum));
        double recip1 = Matrix.dRecip(A.get11());
        A.set20(A.get20() * recip0);
        sum = A.get21() - A.get20() * A.get10();
        A.set21(sum * recip1);
        sum = A.get22() - A.get20() * A.get20() - A.get21() * A.get21();
        if (sum <= 0.0) {
            return false;
        }
        A.set22(Matrix.dSqrt(sum));
        return true;
    }

    public static void dSolveCholesky(double[] L, double[] b, int n, double[] tmpbuf) {
        double sum;
        int nskip = Matrix.dPAD(n);
        double[] y = tmpbuf != null ? tmpbuf : new double[n];
        Matrix.dAASSERT(n > 0);
        int ll = 0;
        int i = 0;
        while (i < n) {
            sum = 0.0;
            int k = 0;
            while (k < i) {
                sum += L[ll + k] * y[k];
                ++k;
            }
            y[i] = (b[i] - sum) / L[ll + i];
            ll += nskip;
            ++i;
        }
        ll = (n - 1) * (nskip + 1);
        i = n - 1;
        while (i >= 0) {
            sum = 0.0;
            int l = ll + nskip;
            int k = i + 1;
            while (k < n) {
                sum += L[l] * b[k];
                l += nskip;
                ++k;
            }
            b[i] = (y[i] - sum) / L[ll];
            ll -= nskip + 1;
            --i;
        }
    }

    public static void dSolveCholesky(DMatrix3C L, DVector3 b) {
        DVector3 y = new DVector3();
        double sum = 0.0;
        y.set0((b.get(0) - sum) / L.get00());
        sum = L.get10() * y.get0();
        y.set1((b.get(1) - sum) / L.get11());
        sum = L.get20() * y.get0() + L.get21() * y.get1();
        y.set2((b.get(2) - sum) / L.get22());
        sum = 0.0;
        b.set2((y.get2() - sum) / L.get22());
        sum = L.get21() * b.get2();
        b.set1((y.get1() - sum) / L.get11());
        sum = L.get10() * b.get1() + L.get20() * b.get2();
        b.set0((y.get0() - sum) / L.get00());
    }

    public static boolean dInvertPDMatrix(DMatrix3C A, DMatrix3 Ainv) {
        DMatrix3 L = new DMatrix3(A);
        DVector3 x = new DVector3();
        if (!Matrix.dFactorCholesky(L)) {
            return false;
        }
        Ainv.setZero();
        int i = 0;
        while (i < 3) {
            x.setZero();
            x.set(i, 1.0);
            Matrix.dSolveCholesky(L, x);
            Ainv.setCol(i, x);
            ++i;
        }
        return true;
    }

    public static boolean dInvertPDMatrix(double[] A, double[] Ainv, int n, double[] tmpbuf) {
        Matrix.dAASSERT(n > 0);
        int nskip = Matrix.dPAD(n);
        double[] L = new double[nskip * n];
        System.arraycopy(A, 0, L, 0, nskip * n);
        double[] X = new double[n];
        if (!Matrix.dFactorCholesky(L, n, tmpbuf)) {
            return false;
        }
        Matrix.dSetZero(Ainv, n * nskip);
        int aa = 0;
        int xi = 0;
        while (xi < n) {
            int j = 0;
            while (j < n) {
                X[j] = 0.0;
                ++j;
            }
            X[xi] = 1.0;
            Matrix.dSolveCholesky(L, X, n, tmpbuf);
            int a = aa;
            int x = 0;
            while (x < n) {
                Ainv[a] = X[x];
                a += nskip;
                ++x;
            }
            ++aa;
            ++xi;
        }
        return true;
    }

    public static boolean dIsPositiveDefinite(double[] A, int n, double[] tmpbuf) {
        Matrix.dAASSERT(n > 0);
        int nskip = Matrix.dPAD(n);
        DxWorldProcessMemArena.dummy();
        double[] Acopy = new double[nskip * n];
        System.arraycopy(A, 0, Acopy, 0, nskip * n);
        return Matrix.dFactorCholesky(Acopy, n, tmpbuf);
    }

    public static boolean dIsPositiveDefinite(double[] A, int n) {
        return Matrix.dIsPositiveDefinite(A, n, null);
    }

    public static boolean dIsPositiveDefinite(DMatrix3C A) {
        return Matrix.dFactorCholesky(A.clone());
    }

    private static void dVectorScale(double[] a, double[] d, int n) {
        int i = 0;
        while (i < n) {
            int n2 = i;
            a[n2] = a[n2] * d[i];
            ++i;
        }
    }

    public static void dSolveLDLT(double[] L, double[] d, double[] b, int n, int nskip) {
        Matrix.dAASSERT(n > 0 && nskip >= n);
        Matrix.dSolveL1(L, b, n, nskip);
        Matrix.dVectorScale(b, d, n);
        Matrix.dSolveL1T(L, b, n, nskip);
    }

    public static void dLDLTAddTL(double[] L, double[] d, double[] a, int n, int nskip) {
        Matrix.dLDLTAddTL(L, 0, d, 0, a, n, nskip, null);
    }

    public static void dLDLTAddTL(double[] L, int lOfs, double[] d, int dOfs, double[] a, int n, int nskip, double[] tmpbuf) {
        Matrix.dAASSERT(n > 0 && nskip >= n);
        if (n < 2) {
            return;
        }
        DxWorldProcessMemArena.dummy();
        double[] W1 = new double[n];
        double[] W2 = new double[n];
        W1[0] = 0.0;
        W2[0] = 0.0;
        int j = 1;
        while (j < n) {
            W1[j] = W2[j] = a[j] * 0.7071067811865476;
            ++j;
        }
        double W11 = (0.5 * a[0] + 1.0) * 0.7071067811865476;
        double W21 = (0.5 * a[0] - 1.0) * 0.7071067811865476;
        double alpha1 = 1.0;
        double alpha2 = 1.0;
        double dee = d[dOfs + 0];
        double alphanew = alpha1 + W11 * W11 * dee;
        double gamma1 = W11 * (dee /= alphanew);
        dee *= alpha1;
        alpha1 = alphanew;
        alphanew = alpha2 - W21 * W21 * dee;
        dee /= alphanew;
        alpha2 = alphanew;
        double k1 = 1.0 - W21 * gamma1;
        double k2 = W21 * gamma1 * W11 - W21;
        int ll = nskip + lOfs;
        int p = 1;
        while (p < n) {
            double Wp = W1[p];
            double ell = L[ll];
            W1[p] = Wp - W11 * ell;
            W2[p] = k1 * Wp + k2 * ell;
            ll += nskip;
            ++p;
        }
        int ll2 = lOfs + nskip + 1;
        int j2 = 1;
        while (j2 < n) {
            double k12 = W1[j2];
            double k22 = W2[j2];
            double dee2 = d[dOfs + j2];
            double alphanew2 = alpha1 + k12 * k12 * dee2;
            double gamma12 = k12 * (dee2 /= alphanew2);
            alpha1 = alphanew2;
            alphanew2 = alpha2 - k22 * k22 * (dee2 *= alpha1);
            double gamma2 = k22 * (dee2 /= alphanew2);
            d[dOfs + j2] = dee2 *= alpha2;
            alpha2 = alphanew2;
            int l = ll2 + nskip;
            int p2 = j2 + 1;
            while (p2 < n) {
                double ell = L[l];
                double Wp = W1[p2] - k12 * ell;
                ell += gamma12 * Wp;
                W1[p2] = Wp;
                Wp = W2[p2] - k22 * ell;
                W2[p2] = Wp;
                L[l] = ell -= gamma2 * Wp;
                l += nskip;
                ++p2;
            }
            ll2 += nskip + 1;
            ++j2;
        }
    }

    private static double GETA(double[] A, int i, int j, int nskip) {
        return i > j ? A[i * nskip + j] : A[j * nskip + i];
    }

    public static void dLDLTRemove(double[] A, int[] p, double[] L, double[] d, int n1, int n2, int r, int nskip, DxUtil.BlockPointer tmpbuf) {
        Matrix.dAASSERT(n1 > 0 && n2 > 0 && r >= 0 && r < n2 && n1 >= n2 && nskip >= n1);
        int i = 0;
        while (i < n2) {
            Matrix.dIASSERT(p[i] >= 0 && p[i] < n1);
            ++i;
        }
        if (r == n2 - 1) {
            return;
        }
        DxWorldProcessMemArena.dummy();
        if (r == 0) {
            double[] a = new double[n2];
            int p_0 = p[0];
            int i2 = 0;
            while (i2 < n2) {
                a[i2] = -Matrix.GETA(A, p[i2], p_0, nskip);
                ++i2;
            }
            a[0] = a[0] + 1.0;
            Matrix.dLDLTAddTL(L, d, a, n2, nskip);
        } else {
            double[] t = new double[r];
            int Lcurr = r * nskip;
            int i3 = 0;
            while (i3 < r) {
                Matrix.dIASSERT(d[i3] != 0.0);
                t[i3] = L[Lcurr] / d[i3];
                ++Lcurr;
                ++i3;
            }
            double[] a = new double[n2 - r];
            int Lcurr2 = r * nskip;
            int pp_rP = r;
            int p_rP = r;
            int n2_minus_r = n2 - r;
            int i4 = 0;
            while (i4 < n2_minus_r) {
                a[i4] = Matrix.dDot(L, Lcurr2, t, 0, r) - Matrix.GETA(A, p[pp_rP + i4], p[p_rP], nskip);
                Lcurr2 += nskip;
                ++i4;
            }
            a[0] = a[0] + 1.0;
            Matrix.dLDLTAddTL(L, r * nskip + r, d, r, a, n2 - r, nskip, null);
        }
        Matrix.dRemoveRowCol(L, n2, nskip, r);
        if (r < n2 - 1) {
            Cstring.memmove(d, r, d, r + 1, n2 - r - 1);
        }
    }

    public static void dRemoveRowCol(double[] A, int n, int nskip, int r) {
        int cpy_size;
        int Asrc;
        int i;
        int Adst;
        Matrix.dAASSERT(A != null && n > 0 && nskip >= n && r >= 0 && r < n);
        if (r >= n - 1) {
            return;
        }
        if (r > 0) {
            int move_size = n - r - 1;
            Adst = r;
            i = 0;
            while (i < r) {
                Asrc = Adst + 1;
                Cstring.memmove(A, Adst, A, Asrc, move_size);
                Adst += nskip;
                ++i;
            }
            cpy_size = r;
            Adst = r * nskip;
            i = r;
            while (i < n - 1) {
                Asrc = Adst + nskip;
                Cstring.memcpy(A, Adst, A, Asrc, cpy_size);
                Adst = Asrc;
                ++i;
            }
        }
        cpy_size = n - r - 1;
        Adst = r * (nskip + 1);
        i = r;
        while (i < n - 1) {
            Asrc = Adst + (nskip + 1);
            Cstring.memcpy(A, Adst, A, Asrc, cpy_size);
            Adst = Asrc - 1;
            ++i;
        }
    }

    static void dSolveL1(double[] L, double[] B, int n, int lskip1) {
        double q1;
        double p1;
        int k;
        int j;
        int exP;
        int ellP;
        double Z11;
        int lskip2 = 2 * lskip1;
        int lskip3 = 3 * lskip1;
        int i = 0;
        while (i <= n - 4) {
            double p4;
            double p3;
            double p2;
            Z11 = 0.0;
            double Z21 = 0.0;
            double Z31 = 0.0;
            double Z41 = 0.0;
            ellP = i * lskip1;
            exP = 0;
            j = i - 12;
            while (j >= 0) {
                k = 0;
                while (k < 12) {
                    p1 = L[ellP + k];
                    q1 = B[exP + k];
                    p2 = L[ellP + k + lskip1];
                    p3 = L[ellP + k + lskip2];
                    p4 = L[ellP + k + lskip3];
                    Z11 += p1 * q1;
                    Z21 += p2 * q1;
                    Z31 += p3 * q1;
                    Z41 += p4 * q1;
                    ++k;
                }
                ellP += 12;
                exP += 12;
                j -= 12;
            }
            j += 12;
            while (j > 0) {
                p1 = L[ellP];
                q1 = B[exP];
                p2 = L[ellP + lskip1];
                p3 = L[ellP + lskip2];
                p4 = L[ellP + lskip3];
                Z11 += p1 * q1;
                Z21 += p2 * q1;
                Z31 += p3 * q1;
                Z41 += p4 * q1;
                ++ellP;
                ++exP;
                --j;
            }
            B[exP] = Z11 = B[exP] - Z11;
            p1 = L[ellP + lskip1];
            B[exP + 1] = Z21 = B[exP + 1] - Z21 - p1 * Z11;
            p1 = L[ellP + lskip2];
            p2 = L[ellP + 1 + lskip2];
            B[exP + 2] = Z31 = B[exP + 2] - Z31 - p1 * Z11 - p2 * Z21;
            p1 = L[ellP + lskip3];
            p2 = L[ellP + 1 + lskip3];
            p3 = L[ellP + 2 + lskip3];
            B[exP + 3] = Z41 = B[exP + 3] - Z41 - p1 * Z11 - p2 * Z21 - p3 * Z31;
            i += 4;
        }
        while (i < n) {
            Z11 = 0.0;
            ellP = i * lskip1;
            exP = 0;
            j = i - 12;
            while (j >= 0) {
                k = 0;
                while (k < 12) {
                    p1 = L[ellP + k];
                    q1 = B[exP + k];
                    Z11 += p1 * q1;
                    ++k;
                }
                ellP += 12;
                exP += 12;
                j -= 12;
            }
            j += 12;
            while (j > 0) {
                p1 = L[ellP];
                q1 = B[exP];
                Z11 += p1 * q1;
                ++ellP;
                ++exP;
                --j;
            }
            B[exP] = Z11 = B[exP] - Z11;
            ++i;
        }
    }

    static void dSolveL1T(double[] L, double[] B, int n, int lskip1) {
        double m11;
        double q1;
        double p1;
        int j;
        int exP;
        int ellP;
        double Z11;
        int Lp = (n - 1) * (lskip1 + 1);
        int Bp = n - 1;
        lskip1 = -lskip1;
        int lskip2 = 2 * lskip1;
        int i = 0;
        while (i <= n - 4) {
            double m41;
            double m31;
            double m21;
            double p4;
            double p3;
            double p2;
            Z11 = 0.0;
            double Z21 = 0.0;
            double Z31 = 0.0;
            double Z41 = 0.0;
            ellP = Lp - i;
            exP = Bp;
            j = i - 4;
            while (j >= 0) {
                int ij = 0;
                while (ij < 4) {
                    p1 = L[ellP];
                    q1 = B[exP - ij];
                    p2 = L[ellP - 1];
                    p3 = L[ellP - 2];
                    p4 = L[ellP - 3];
                    m11 = p1 * q1;
                    m21 = p2 * q1;
                    m31 = p3 * q1;
                    m41 = p4 * q1;
                    ellP += lskip1;
                    Z11 += m11;
                    Z21 += m21;
                    Z31 += m31;
                    Z41 += m41;
                    ++ij;
                }
                exP -= 4;
                j -= 4;
            }
            j += 4;
            while (j > 0) {
                p1 = L[ellP];
                q1 = B[exP];
                p2 = L[ellP - 1];
                p3 = L[ellP - 2];
                p4 = L[ellP - 3];
                m11 = p1 * q1;
                m21 = p2 * q1;
                m31 = p3 * q1;
                m41 = p4 * q1;
                ellP += lskip1;
                --exP;
                Z11 += m11;
                Z21 += m21;
                Z31 += m31;
                Z41 += m41;
                --j;
            }
            B[exP] = Z11 = B[exP] - Z11;
            p1 = L[ellP - 1];
            B[exP - 1] = Z21 = B[exP - 1] - Z21 - p1 * Z11;
            p1 = L[ellP - 2];
            p2 = L[ellP - 2 + lskip1];
            B[exP - 2] = Z31 = B[exP - 2] - Z31 - p1 * Z11 - p2 * Z21;
            p1 = L[ellP - 3];
            p2 = L[ellP - 3 + lskip1];
            p3 = L[ellP - 3 + lskip2];
            B[exP - 3] = Z41 = B[exP - 3] - Z41 - p1 * Z11 - p2 * Z21 - p3 * Z31;
            i += 4;
        }
        while (i < n) {
            Z11 = 0.0;
            ellP = Lp - i;
            exP = Bp;
            j = i - 4;
            while (j >= 0) {
                p1 = L[ellP];
                q1 = B[exP];
                m11 = p1 * q1;
                Z11 += m11;
                p1 = L[ellP += lskip1];
                q1 = B[exP - 1];
                m11 = p1 * q1;
                Z11 += m11;
                p1 = L[ellP += lskip1];
                q1 = B[exP - 2];
                m11 = p1 * q1;
                Z11 += m11;
                p1 = L[ellP += lskip1];
                q1 = B[exP - 3];
                m11 = p1 * q1;
                ellP += lskip1;
                exP -= 4;
                Z11 += m11;
                j -= 4;
            }
            j += 4;
            while (j > 0) {
                p1 = L[ellP];
                q1 = B[exP];
                m11 = p1 * q1;
                ellP += lskip1;
                --exP;
                Z11 += m11;
                --j;
            }
            B[exP] = Z11 = B[exP] - Z11;
            ++i;
        }
    }

    public static void dFactorLDLT(double[] A, double[] d, int n, int nskip1) {
        D_LDLT.dFactorLDLT(A, d, n, nskip1);
    }

    private static final int _dEstimateFactorCholeskyTmpbufSize(int n) {
        return Matrix.dPAD(n) * 8;
    }

    private static final int _dEstimateSolveCholeskyTmpbufSize(int n) {
        return Matrix.dPAD(n) * 8;
    }

    private static final int _dEstimateInvertPDMatrixTmpbufSize(int n) {
        int SolveCholesky_size;
        int FactorCholesky_size = Matrix._dEstimateFactorCholeskyTmpbufSize(n);
        int MaxCholesky_size = FactorCholesky_size > (SolveCholesky_size = Matrix._dEstimateSolveCholeskyTmpbufSize(n)) ? FactorCholesky_size : SolveCholesky_size;
        return Matrix.dPAD(n) * (n + 1) * 8 + MaxCholesky_size;
    }

    private static final int _dEstimateIsPositiveDefiniteTmpbufSize(int n) {
        return Matrix.dPAD(n) * n * 8 + Matrix._dEstimateFactorCholeskyTmpbufSize(n);
    }

    private static final int _dEstimateLDLTAddTLTmpbufSize(int nskip) {
        return nskip * 2 * 8;
    }

    private static final int _dEstimateLDLTRemoveTmpbufSize(int n2, int nskip) {
        return n2 * 8 + Matrix._dEstimateLDLTAddTLTmpbufSize(nskip);
    }

    public static final int dEstimateFactorCholeskyTmpbufSize(int n) {
        return Matrix._dEstimateFactorCholeskyTmpbufSize(n);
    }

    public static final int dEstimateSolveCholeskyTmpbufSize(int n) {
        return Matrix._dEstimateSolveCholeskyTmpbufSize(n);
    }

    public static final int dEstimateInvertPDMatrixTmpbufSize(int n) {
        return Matrix._dEstimateInvertPDMatrixTmpbufSize(n);
    }

    public static final int dEstimateIsPositiveDefiniteTmpbufSize(int n) {
        return Matrix._dEstimateIsPositiveDefiniteTmpbufSize(n);
    }

    public static final int dEstimateLDLTAddTLTmpbufSize(int nskip) {
        return Matrix._dEstimateLDLTAddTLTmpbufSize(nskip);
    }

    public static final int dEstimateLDLTRemoveTmpbufSize(int n2, int nskip) {
        return Matrix._dEstimateLDLTRemoveTmpbufSize(n2, nskip);
    }
}

