/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.ode.internal.Common;

class FastLDLT {
    FastLDLT() {
    }

    private static void dSolveL1_1(double[] L, int offsetBL, int n, int lskip1) {
        double p2 = 0.0;
        double[] B = L;
        int i = 0;
        while (i < n) {
            double m21;
            double m11;
            double q1;
            double p1;
            double Z11 = 0.0;
            double Z21 = 0.0;
            int ellPos = i * lskip1;
            int exPos = offsetBL;
            int j = i - 2;
            while (j >= 0) {
                p1 = L[ellPos];
                q1 = B[exPos];
                m11 = p1 * q1;
                p2 = L[ellPos + lskip1];
                m21 = p2 * q1;
                Z11 += m11;
                Z21 += m21;
                p1 = L[ellPos + 1];
                q1 = B[exPos + 1];
                m11 = p1 * q1;
                p2 = L[ellPos + 1 + lskip1];
                m21 = p2 * q1;
                ellPos += 2;
                exPos += 2;
                Z11 += m11;
                Z21 += m21;
                j -= 2;
            }
            j += 2;
            while (j > 0) {
                p1 = L[ellPos];
                q1 = B[exPos];
                m11 = p1 * q1;
                p2 = L[ellPos + lskip1];
                m21 = p2 * q1;
                ++ellPos;
                ++exPos;
                Z11 += m11;
                Z21 += m21;
                --j;
            }
            B[exPos] = Z11 = B[exPos] - Z11;
            p1 = L[ellPos + lskip1];
            B[exPos + 1] = Z21 = B[exPos + 1] - Z21 - p1 * Z11;
            i += 2;
        }
    }

    private static void dSolveL1_2(double[] L, int offsetBL, int n, int lskip1) {
        double[] B = L;
        int i = 0;
        while (i < n) {
            double m22;
            double m21;
            double p2;
            double m12;
            double q2;
            double m11;
            double q1;
            double p1;
            double Z11 = 0.0;
            double Z12 = 0.0;
            double Z21 = 0.0;
            double Z22 = 0.0;
            int ellP = i * lskip1;
            int exP = offsetBL;
            int j = i - 2;
            while (j >= 0) {
                p1 = L[ellP];
                q1 = B[exP];
                m11 = p1 * q1;
                q2 = B[exP + lskip1];
                m12 = p1 * q2;
                p2 = L[ellP + lskip1];
                m21 = p2 * q1;
                m22 = p2 * q2;
                Z11 += m11;
                Z12 += m12;
                Z21 += m21;
                Z22 += m22;
                p1 = L[ellP + 1];
                q1 = B[exP + 1];
                m11 = p1 * q1;
                q2 = B[exP + 1 + lskip1];
                m12 = p1 * q2;
                p2 = L[ellP + 1 + lskip1];
                m21 = p2 * q1;
                m22 = p2 * q2;
                ellP += 2;
                exP += 2;
                Z11 += m11;
                Z12 += m12;
                Z21 += m21;
                Z22 += m22;
                j -= 2;
            }
            j += 2;
            while (j > 0) {
                p1 = L[ellP];
                q1 = B[exP];
                m11 = p1 * q1;
                q2 = B[exP + lskip1];
                m12 = p1 * q2;
                p2 = L[ellP + lskip1];
                m21 = p2 * q1;
                m22 = p2 * q2;
                ++ellP;
                ++exP;
                Z11 += m11;
                Z12 += m12;
                Z21 += m21;
                Z22 += m22;
                --j;
            }
            B[exP] = Z11 = B[exP] - Z11;
            B[exP + lskip1] = Z12 = B[exP + lskip1] - Z12;
            p1 = L[ellP + lskip1];
            B[exP + 1] = Z21 = B[exP + 1] - Z21 - p1 * Z11;
            B[exP + 1 + lskip1] = Z22 = B[exP + 1 + lskip1] - Z22 - p1 * Z12;
            i += 2;
        }
    }

    void dFactorLDLT(double[] A, double[] d, int n, int nskip1) {
        double m11;
        double q1;
        double dd;
        double p1;
        int k;
        int j;
        int deeP;
        int ellP;
        double Z11;
        if (n < 1) {
            return;
        }
        int i = 0;
        while (i <= n - 2) {
            double m22;
            double m21;
            double q2;
            double p2;
            FastLDLT.dSolveL1_2(A, i * nskip1, i, nskip1);
            Z11 = 0.0;
            double Z21 = 0.0;
            double Z22 = 0.0;
            ellP = i * nskip1;
            deeP = 0;
            j = i - 6;
            while (j >= 0) {
                k = 0;
                while (k < 6) {
                    p1 = A[ellP + k];
                    p2 = A[ellP + k + nskip1];
                    dd = d[deeP + k];
                    q1 = p1 * dd;
                    q2 = p2 * dd;
                    A[ellP + k] = q1;
                    A[ellP + k + nskip1] = q2;
                    m11 = p1 * q1;
                    m21 = p2 * q1;
                    m22 = p2 * q2;
                    Z11 += m11;
                    Z21 += m21;
                    Z22 += m22;
                    ++k;
                }
                ellP += 6;
                deeP += 6;
                j -= 6;
            }
            j += 6;
            while (j > 0) {
                p1 = A[ellP];
                p2 = A[ellP + nskip1];
                dd = d[deeP];
                q1 = p1 * dd;
                q2 = p2 * dd;
                A[ellP] = q1;
                A[ellP + nskip1] = q2;
                m11 = p1 * q1;
                m21 = p2 * q1;
                m22 = p2 * q2;
                Z11 += m11;
                Z21 += m21;
                Z22 += m22;
                ++ellP;
                ++deeP;
                --j;
            }
            Z11 = A[ellP] - Z11;
            Z21 = A[ellP + nskip1] - Z21;
            Z22 = A[ellP + 1 + nskip1] - Z22;
            deeP = i;
            d[deeP] = Common.dRecip(Z11);
            double sum = 0.0;
            q1 = Z21;
            Z21 = q2 = q1 * d[deeP];
            d[deeP + 1] = Common.dRecip(Z22 - (sum += q1 * q2));
            A[ellP + nskip1] = Z21;
            i += 2;
        }
        switch (n - i) {
            case 0: {
                break;
            }
            case 1: {
                FastLDLT.dSolveL1_1(A, i * nskip1, i, nskip1);
                Z11 = 0.0;
                ellP = i * nskip1;
                deeP = 0;
                j = i - 6;
                while (j >= 0) {
                    k = 0;
                    while (k < 6) {
                        p1 = A[ellP + k];
                        dd = d[deeP + k];
                        A[ellP + k] = q1 = p1 * dd;
                        m11 = p1 * q1;
                        Z11 += m11;
                        ++k;
                    }
                    ellP += 6;
                    deeP += 6;
                    j -= 6;
                }
                j += 6;
                while (j > 0) {
                    p1 = A[ellP];
                    dd = d[deeP];
                    A[ellP] = q1 = p1 * dd;
                    m11 = p1 * q1;
                    Z11 += m11;
                    ++ellP;
                    ++deeP;
                    --j;
                }
                Z11 = A[ellP] - Z11;
                deeP = i;
                d[deeP] = Common.dRecip(Z11);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

