/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.ode.internal.ErrorHandler;

public class ErrorHdl {
    private static ErrorHandler.dMessageFunction error_function = null;
    private static ErrorHandler.dMessageFunction debug_function = null;
    private static ErrorHandler.dMessageFunction message_function = null;

    public static void dSetErrorHandler(ErrorHandler.dMessageFunction fn) {
        error_function = fn;
    }

    public static void dSetDebugHandler(ErrorHandler.dMessageFunction fn) {
        debug_function = fn;
    }

    public static void dSetMessageHandler(ErrorHandler.dMessageFunction fn) {
        message_function = fn;
    }

    public static ErrorHandler.dMessageFunction dGetErrorHandler() {
        return error_function;
    }

    public static ErrorHandler.dMessageFunction dGetDebugHandler() {
        return debug_function;
    }

    public static ErrorHandler.dMessageFunction dGetMessageHandler() {
        return message_function;
    }

    private static void printMessage(int num, String msg1, String msg2, Object ... ap) {
        System.err.flush();
        System.out.flush();
        if (num != 0) {
            System.err.printf("\n%s %d: ", msg1, num);
        } else {
            System.err.printf("\n%s: ", msg1);
        }
        System.err.printf(msg2, ap);
        System.err.println();
        System.err.flush();
    }

    public static void dError(int num, String msg, Object ... ap) {
        if (error_function != null) {
            error_function.call(num, msg, ap);
        } else {
            ErrorHdl.printMessage(num, "ODE Error", msg, ap);
        }
        ErrorHdl.printMessage(num, "ODE Error", msg, ap);
        throw new RuntimeException("#" + num + ": " + msg);
    }

    public static void dDebug(int num, String msg, Object ... ap) {
        if (debug_function != null) {
            debug_function.call(num, msg, ap);
        } else {
            ErrorHdl.printMessage(num, "ODE INTERNAL ERROR", msg, ap);
        }
        ErrorHdl.printMessage(num, "ODE INTERNAL ERROR", msg, ap);
        msg = String.valueOf(msg) + " -> ";
        Object[] objectArray = ap;
        int n = ap.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            msg = String.valueOf(msg) + o.toString() + " , ";
            ++n2;
        }
        throw new RuntimeException("#" + num + ": " + msg);
    }

    public static void dMessage(int num, String msg, Object ... ap) {
        if (message_function != null) {
            message_function.call(num, msg, ap);
        } else {
            ErrorHdl.printMessage(num, "ODE Message", msg, ap);
        }
    }

    public static class ErrorJump
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

