/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.Ref;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DWorld;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DBase;
import org.ode4j.ode.internal.DxBody;
import org.ode4j.ode.internal.DxQuickStep;
import org.ode4j.ode.internal.ErrorHandler;
import org.ode4j.ode.internal.Objects_H;
import org.ode4j.ode.internal.Step;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.processmem.DxStepWorkingMemory;
import org.ode4j.ode.internal.processmem.DxUtil;
import org.ode4j.ode.internal.processmem.DxWorldProcessContext;
import org.ode4j.ode.internal.processmem.DxWorldProcessIslandsInfo;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemArena;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemoryManager;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemoryReserveInfo;

public class DxWorld
extends DBase
implements DWorld {
    public final Ref<DxBody> firstbody = new Ref();
    public final Ref<DxJoint> firstjoint = new Ref();
    public int nb;
    public int nj;
    DVector3 gravity;
    private double global_erp;
    double global_cfm;
    Objects_H.dxAutoDisable adis;
    int body_flags;
    public DxStepWorkingMemory wmem;
    Objects_H.dxQuickStepParameters qs;
    public Objects_H.dxContactParameters contactp;
    Objects_H.dxDampingParameters dampingp;
    double max_angular_speed;

    private DxWorld() {
    }

    public static DxWorld dWorldCreate() {
        DxWorld w = new DxWorld();
        w.firstbody.set(null);
        w.firstjoint.set(null);
        w.nb = 0;
        w.nj = 0;
        w.gravity = new DVector3();
        w.global_erp = 0.2;
        w.global_cfm = 1.0E-10;
        w.body_flags = 0;
        w.wmem = null;
        w.adis = new Objects_H.dxAutoDisable();
        w.adis.idle_steps = 10;
        w.adis.idle_time = 0.0;
        w.adis.average_samples = 1;
        w.adis.angular_average_threshold = 1.0E-4;
        w.adis.linear_average_threshold = 1.0E-4;
        w.qs = new Objects_H.dxQuickStepParameters();
        w.qs.num_iterations = 20;
        w.qs.w = 1.3;
        w.contactp = new Objects_H.dxContactParameters();
        w.contactp.max_vel = Double.POSITIVE_INFINITY;
        w.contactp.min_depth = 0.0;
        w.dampingp = new Objects_H.dxDampingParameters();
        w.dampingp.linear_scale = 0.0;
        w.dampingp.angular_scale = 0.0;
        w.dampingp.linear_threshold = 1.0E-4;
        w.dampingp.angular_threshold = 1.0E-4;
        w.max_angular_speed = Double.POSITIVE_INFINITY;
        return w;
    }

    public void dWorldDestroy() {
        DxBody b = this.firstbody.get();
        while (b != null) {
            DxBody nextb = (DxBody)b.getNext();
            b.dBodyDestroy();
            b = nextb;
        }
        DxJoint j = this.firstjoint.get();
        while (j != null) {
            DxJoint nextj = (DxJoint)j.getNext();
            if (j.isFlagsInGroup()) {
                j.world = null;
                j.node[0].body = null;
                j.node[0].next = null;
                j.node[1].body = null;
                j.node[1].next = null;
                ErrorHandler.dMessage(0, "warning: destroying world containing grouped joints", new Object[0]);
            } else {
                j.DESTRUCTOR();
            }
            j = nextj;
        }
        if (this.wmem != null) {
            this.wmem.Release();
        }
        this.DESTRUCTOR();
    }

    public void dWorldSetGravity(double x, double y, double z) {
        this.gravity.set(x, y, z);
    }

    private void dWorldGetGravity(DVector3 g) {
        g.set(this.gravity);
    }

    public void dWorldSetERP(double erp) {
        this.global_erp = erp;
    }

    private double dWorldGetERP() {
        return this.global_erp;
    }

    public void dWorldSetCFM(double cfm) {
        this.global_cfm = cfm;
    }

    private double dWorldGetCFM() {
        return this.global_cfm;
    }

    boolean dWorldUseSharedWorkingMemory(DxWorld from_world) {
        boolean result = false;
        if (from_world != null) {
            DxStepWorkingMemory wmem;
            Common.dUASSERT(this.wmem == null, "world does already have working memory allocated");
            if (from_world.wmem == null) {
                from_world.wmem = new DxStepWorkingMemory();
            }
            if ((wmem = this.wmem) != null) {
                if (this.wmem != null) {
                    this.wmem.Release();
                    this.wmem = null;
                }
                wmem.Addref();
                this.wmem = wmem;
                result = true;
            }
        } else {
            DxStepWorkingMemory wmem = this.wmem;
            if (wmem != null) {
                wmem.Release();
                this.wmem = null;
            }
            result = true;
        }
        return result;
    }

    void dWorldCleanupWorkingMemory() {
        if (this.wmem != null) {
            this.wmem.CleanupMemory();
        }
    }

    boolean dWorldSetStepMemoryReservationPolicy(DWorld.DWorldStepReserveInfo policyinfo) {
        DxStepWorkingMemory wmem;
        Common.dUASSERT(policyinfo == null || policyinfo.struct_size >= DxUtil.sizeof(policyinfo) && policyinfo.reserve_factor >= 1.0, "Bad policy info");
        boolean result = false;
        if (policyinfo != null) {
            if (this.wmem == null) {
                this.wmem = new DxStepWorkingMemory();
            }
            wmem = this.wmem;
        } else {
            wmem = this.wmem;
        }
        if (wmem != null) {
            if (policyinfo != null) {
                wmem.SetMemoryReserveInfo(policyinfo.reserve_factor, policyinfo.reserve_minimum);
                result = wmem.GetMemoryReserveInfo() != null;
            } else {
                wmem.ResetMemoryReserveInfoToDefault();
                result = true;
            }
        } else if (policyinfo == null) {
            result = true;
        }
        return result;
    }

    boolean dWorldSetStepMemoryManager(DWorld.DWorldStepMemoryFunctionsInfo memfuncs) {
        DxStepWorkingMemory wmem;
        Common.dUASSERT(memfuncs == null || memfuncs.struct_size >= DxUtil.sizeof(memfuncs), "Bad functions info");
        boolean result = false;
        if (memfuncs != null) {
            if (this.wmem == null) {
                this.wmem = new DxStepWorkingMemory();
            }
            wmem = this.wmem;
        } else {
            wmem = this.wmem;
        }
        if (wmem != null) {
            if (memfuncs != null) {
                wmem.SetMemoryManager(memfuncs.alloc_block, memfuncs.shrink_block, memfuncs.free_block);
                result = wmem.GetMemoryManager() != null;
            } else {
                wmem.ResetMemoryManagerToDefault();
                result = true;
            }
        } else if (memfuncs == null) {
            result = true;
        }
        return result;
    }

    boolean dWorldStep(double stepsize) {
        Common.dUASSERT(stepsize > 0.0, "stepsize must be > 0");
        boolean result = false;
        DxWorldProcessIslandsInfo islandsinfo = new DxWorldProcessIslandsInfo();
        if (DxWorldProcessContext.dxReallocateWorldProcessContext(this, islandsinfo, stepsize, Step.INSTANCE)) {
            this.dxProcessIslands(islandsinfo, stepsize, Step.INSTANCE);
            result = true;
        }
        DxWorldProcessContext.dxCleanupWorldProcessContext(this);
        return result;
    }

    boolean dWorldQuickStep(double stepsize) {
        Common.dUASSERT(stepsize > 0.0, "stepsize must be > 0");
        boolean result = false;
        DxWorldProcessIslandsInfo islandsinfo = new DxWorldProcessIslandsInfo();
        if (DxWorldProcessContext.dxReallocateWorldProcessContext(this, islandsinfo, stepsize, DxQuickStep.INSTANCE)) {
            this.dxProcessIslands(islandsinfo, stepsize, DxQuickStep.INSTANCE);
            result = true;
        }
        DxWorldProcessContext.dxCleanupWorldProcessContext(this);
        return result;
    }

    private void dWorldImpulseToForce(double stepsize, double ix, double iy, double iz, DVector3 force) {
        stepsize = Common.dRecip(stepsize);
        force.set(stepsize * ix, stepsize * iy, stepsize * iz);
    }

    private double dWorldGetAutoDisableLinearThreshold() {
        return Common.dSqrt(this.adis.linear_average_threshold);
    }

    private void dWorldSetAutoDisableLinearThreshold(double linear_average_threshold) {
        this.adis.linear_average_threshold = linear_average_threshold * linear_average_threshold;
    }

    private double dWorldGetAutoDisableAngularThreshold() {
        return Common.dSqrt(this.adis.angular_average_threshold);
    }

    private void dWorldSetAutoDisableAngularThreshold(double angular_average_threshold) {
        this.adis.angular_average_threshold = angular_average_threshold * angular_average_threshold;
    }

    private int dWorldGetAutoDisableAverageSamplesCount() {
        return this.adis.average_samples;
    }

    public void dWorldSetAutoDisableAverageSamplesCount(int average_samples_count) {
        this.adis.average_samples = average_samples_count;
    }

    private int dWorldGetAutoDisableSteps() {
        return this.adis.idle_steps;
    }

    private void dWorldSetAutoDisableSteps(int steps) {
        this.adis.idle_steps = steps;
    }

    private double dWorldGetAutoDisableTime() {
        return this.adis.idle_time;
    }

    private void dWorldSetAutoDisableTime(double time) {
        this.adis.idle_time = time;
    }

    private boolean dWorldGetAutoDisableFlag() {
        return (this.body_flags & 0x10) != 0;
    }

    public void dWorldSetAutoDisableFlag(boolean do_auto_disable) {
        this.body_flags = do_auto_disable ? (this.body_flags |= 0x10) : (this.body_flags &= 0xFFFFFFEF);
    }

    private double dWorldGetLinearDampingThreshold() {
        return Common.dSqrt(this.dampingp.linear_threshold);
    }

    private void dWorldSetLinearDampingThreshold(double threshold) {
        this.dampingp.linear_threshold = threshold * threshold;
    }

    private double dWorldGetAngularDampingThreshold() {
        return Common.dSqrt(this.dampingp.angular_threshold);
    }

    private void dWorldSetAngularDampingThreshold(double threshold) {
        this.dampingp.angular_threshold = threshold * threshold;
    }

    private double dWorldGetLinearDamping() {
        return this.dampingp.linear_scale;
    }

    public void dWorldSetLinearDamping(double scale) {
        this.body_flags = scale != 0.0 ? (this.body_flags |= 0x20) : (this.body_flags &= 0xFFFFFFDF);
        this.dampingp.linear_scale = scale;
    }

    public double dWorldGetAngularDamping() {
        return this.dampingp.angular_scale;
    }

    public void dWorldSetAngularDamping(double scale) {
        this.body_flags = scale != 0.0 ? (this.body_flags |= 0x40) : (this.body_flags &= 0xFFFFFFBF);
        this.dampingp.angular_scale = scale;
    }

    private void dWorldSetDamping(double linear_scale, double angular_scale) {
        this.dWorldSetLinearDamping(linear_scale);
        this.dWorldSetAngularDamping(angular_scale);
    }

    private double dWorldGetMaxAngularSpeed() {
        return this.max_angular_speed;
    }

    public void dWorldSetMaxAngularSpeed(double max_speed) {
        this.body_flags = max_speed < Double.POSITIVE_INFINITY ? (this.body_flags |= 0x80) : (this.body_flags &= 0xFFFFFF7F);
        this.max_angular_speed = max_speed;
    }

    public void dWorldSetQuickStepNumIterations(int num) {
        this.qs.num_iterations = num;
    }

    private int dWorldGetQuickStepNumIterations() {
        return this.qs.num_iterations;
    }

    private void dWorldSetQuickStepW(double param) {
        this.qs.w = param;
    }

    private double dWorldGetQuickStepW() {
        return this.qs.w;
    }

    public void dWorldSetContactMaxCorrectingVel(double vel) {
        this.contactp.max_vel = vel;
    }

    private double dWorldGetContactMaxCorrectingVel() {
        return this.contactp.max_vel;
    }

    public void dWorldSetContactSurfaceLayer(double depth) {
        this.contactp.min_depth = depth;
    }

    private double dWorldGetContactSurfaceLayer() {
        return this.contactp.min_depth;
    }

    public static DxWorldProcessMemArena dxAllocateTemporaryWorldProcessMemArena(int memreq, DxWorldProcessMemoryManager memmgr, DxWorldProcessMemoryReserveInfo reserveinfo) {
        throw new UnsupportedOperationException();
    }

    public static void dxFreeTemporaryWorldProcessMemArena(DxWorldProcessMemArena arena) {
    }

    public static <T> T AllocateOnDemandX(T pctStorage) {
        throw new UnsupportedOperationException();
    }

    public int EstimateIslandsProcessingMemoryRequirements() {
        return -1;
    }

    void dxProcessIslands(DxWorldProcessIslandsInfo islandsinfo, double stepsize, dstepper_fn_t stepper) {
        int sizeelements = 2;
        DxStepWorkingMemory wmem = this.wmem;
        Common.dIASSERT(wmem != null);
        DxWorldProcessContext context = wmem.GetWorldProcessingContext();
        Common.dIASSERT(context != null);
        int islandcount = islandsinfo.GetIslandsCount();
        int[] islandsizes = islandsinfo.GetIslandSizes();
        DxBody[] body = islandsinfo.GetBodiesArray();
        DxJoint[] joint = islandsinfo.GetJointsArray();
        DxWorldProcessMemArena stepperarena = context.GetStepperMemArena();
        int bodystart = 0;
        int jointstart = 0;
        int sizesend = islandcount * 2;
        int sizescurr = 0;
        while (sizescurr != sizesend) {
            int bcount = islandsizes[sizescurr + 0];
            int jcount = islandsizes[sizescurr + 1];
            DxUtil.BlockPointer stepperstate = stepperarena.BEGIN_STATE_SAVE();
            stepper.run(stepperarena, this, body, bodystart, bcount, joint, jointstart, jcount, stepsize);
            stepperarena.END_STATE_SAVE(stepperstate);
            bodystart += bcount;
            jointstart += jcount;
            sizescurr += 2;
        }
    }

    public void dInternalHandleAutoDisabling(double stepsize) {
        DxBody bb = this.firstbody.get();
        while (bb != null) {
            if (bb.firstjoint.get() != null && (bb.flags & 0x14) == 16 && bb.adis.average_samples != 0) {
                if (bb.average_counter >= bb.adis.average_samples) {
                    Common.dUASSERT(bb.average_counter < bb.adis.average_samples, "buffer overflow");
                    bb.average_ready = 0;
                    bb.average_counter = 0;
                }
                bb.average_lvel_buffer[bb.average_counter].set(bb.lvel);
                bb.average_avel_buffer[bb.average_counter].set(bb.avel);
                ++bb.average_counter;
                if (bb.average_counter >= bb.adis.average_samples) {
                    bb.average_counter = 0;
                    bb.average_ready = 1;
                }
                boolean idle = false;
                if (bb.average_ready != 0) {
                    double av_lspeed;
                    idle = true;
                    DVector3 average_lvel = new DVector3();
                    DVector3 average_avel = new DVector3();
                    average_lvel.set(bb.average_lvel_buffer[0]);
                    average_avel.set(bb.average_avel_buffer[0]);
                    if (bb.adis.average_samples > 1) {
                        int i = 1;
                        while (i < bb.adis.average_samples) {
                            average_lvel.add(bb.average_lvel_buffer[i]);
                            average_avel.add(bb.average_avel_buffer[i]);
                            ++i;
                        }
                        double r1 = 1.0 / (double)bb.adis.average_samples;
                        average_lvel.scale(r1);
                        average_avel.scale(r1);
                    }
                    if ((av_lspeed = OdeMath.dCalcVectorDot3(average_lvel, average_lvel)) > bb.adis.linear_average_threshold) {
                        idle = false;
                    } else {
                        double av_aspeed = OdeMath.dCalcVectorDot3(average_avel, average_avel);
                        if (av_aspeed > bb.adis.angular_average_threshold) {
                            idle = false;
                        }
                    }
                }
                if (idle) {
                    --bb.adis_stepsleft;
                    bb.adis_timeleft -= stepsize;
                } else {
                    bb.adis_stepsleft = bb.adis.idle_steps;
                    bb.adis_timeleft = bb.adis.idle_time;
                }
                if (bb.adis_stepsleft <= 0 && bb.adis_timeleft <= 0.0) {
                    bb.flags |= 4;
                    bb.lvel.setZero();
                    bb.avel.setZero();
                }
            }
            bb = (DxBody)bb.getNext();
        }
    }

    @Override
    public void DESTRUCTOR() {
        super.DESTRUCTOR();
    }

    @Override
    public void setGravity(double x, double y, double z) {
        this.dWorldSetGravity(x, y, z);
    }

    @Override
    public void setGravity(DVector3C g) {
        this.setGravity(g.get0(), g.get1(), g.get2());
    }

    @Override
    public void getGravity(DVector3 g) {
        this.dWorldGetGravity(g);
    }

    @Override
    public void setERP(double erp) {
        this.dWorldSetERP(erp);
    }

    @Override
    public double getERP() {
        return this.dWorldGetERP();
    }

    @Override
    public void setCFM(double cfm) {
        this.dWorldSetCFM(cfm);
    }

    @Override
    public double getCFM() {
        return this.dWorldGetCFM();
    }

    @Override
    public void step(double stepsize) {
        this.dWorldStep(stepsize);
    }

    @Override
    public boolean quickStep(double stepsize) {
        return this.dWorldQuickStep(stepsize);
    }

    @Override
    public void setQuickStepNumIterations(int num) {
        this.dWorldSetQuickStepNumIterations(num);
    }

    @Override
    public int getQuickStepNumIterations() {
        return this.dWorldGetQuickStepNumIterations();
    }

    @Override
    public void setQuickStepW(double over_relaxation) {
        this.dWorldSetQuickStepW(over_relaxation);
    }

    @Override
    public double getQuickStepW() {
        return this.dWorldGetQuickStepW();
    }

    @Override
    public void setAutoDisableLinearThreshold(double threshold) {
        this.dWorldSetAutoDisableLinearThreshold(threshold);
    }

    @Override
    public double getAutoDisableLinearThreshold() {
        return this.dWorldGetAutoDisableLinearThreshold();
    }

    @Override
    public void setAutoDisableAngularThreshold(double threshold) {
        this.dWorldSetAutoDisableAngularThreshold(threshold);
    }

    @Override
    public double getAutoDisableAngularThreshold() {
        return this.dWorldGetAutoDisableAngularThreshold();
    }

    @Override
    public void setAutoDisableSteps(int steps) {
        this.dWorldSetAutoDisableSteps(steps);
    }

    @Override
    public int getAutoDisableSteps() {
        return this.dWorldGetAutoDisableSteps();
    }

    @Override
    public void setAutoDisableTime(double time) {
        this.dWorldSetAutoDisableTime(time);
    }

    @Override
    public double getAutoDisableTime() {
        return this.dWorldGetAutoDisableTime();
    }

    @Override
    public void setAutoDisableFlag(boolean do_auto_disable) {
        this.dWorldSetAutoDisableFlag(do_auto_disable);
    }

    @Override
    public boolean getAutoDisableFlag() {
        return this.dWorldGetAutoDisableFlag();
    }

    @Override
    public double getLinearDampingThreshold() {
        return this.dWorldGetLinearDampingThreshold();
    }

    @Override
    public void setLinearDampingThreshold(double threshold) {
        this.dWorldSetLinearDampingThreshold(threshold);
    }

    @Override
    public double getAngularDampingThreshold() {
        return this.dWorldGetAngularDampingThreshold();
    }

    @Override
    public void setAngularDampingThreshold(double threshold) {
        this.dWorldSetAngularDampingThreshold(threshold);
    }

    @Override
    public double getLinearDamping() {
        return this.dWorldGetLinearDamping();
    }

    @Override
    public void setLinearDamping(double scale) {
        this.dWorldSetLinearDamping(scale);
    }

    @Override
    public double getAngularDamping() {
        return this.dWorldGetAngularDamping();
    }

    @Override
    public void setAngularDamping(double scale) {
        this.dWorldSetAngularDamping(scale);
    }

    @Override
    public void setDamping(double linear_scale, double angular_scale) {
        this.dWorldSetDamping(linear_scale, angular_scale);
    }

    @Override
    public double getMaxAngularSpeed() {
        return this.dWorldGetMaxAngularSpeed();
    }

    @Override
    public void setMaxAngularSpeed(double max_speed) {
        this.dWorldSetMaxAngularSpeed(max_speed);
    }

    @Override
    public void setContactSurfaceLayer(double depth) {
        this.dWorldSetContactSurfaceLayer(depth);
    }

    @Override
    public double getContactSurfaceLayer() {
        return this.dWorldGetContactSurfaceLayer();
    }

    @Override
    public void impulseToForce(double stepsize, double ix, double iy, double iz, DVector3 force) {
        this.dWorldImpulseToForce(stepsize, ix, iy, iz, force);
    }

    @Override
    public void setAutoDisableAverageSamplesCount(int average_samples_count) {
        this.dWorldSetAutoDisableAverageSamplesCount(average_samples_count);
    }

    @Override
    public void setContactMaxCorrectingVel(double vel) {
        this.dWorldSetContactMaxCorrectingVel(vel);
    }

    @Override
    public void destroy() {
        this.dWorldDestroy();
    }

    @Override
    public double getAutoDisableAngularAverageThreshold() {
        throw new UnsupportedOperationException("Not implemented in ODE.");
    }

    @Override
    public int getAutoDisableAverageSamplesCount() {
        return this.dWorldGetAutoDisableAverageSamplesCount();
    }

    @Override
    public double getAutoDisableLinearAverageThreshold() {
        throw new UnsupportedOperationException("Not implemented in ODE.");
    }

    @Override
    public double getContactMaxCorrectingVel() {
        return this.dWorldGetContactMaxCorrectingVel();
    }

    @Override
    public void setAutoDisableAngularAverageThreshold(double angularAverageThreshold) {
        throw new UnsupportedOperationException("Not implemented in ODE.");
    }

    @Override
    public void setAutoDisableLinearAverageThreshold(double linearAverageThreshold) {
        throw new UnsupportedOperationException("Not implemented in ODE.");
    }

    @Override
    public boolean useSharedWorkingMemory(DWorld from_world) {
        return this.dWorldUseSharedWorkingMemory((DxWorld)from_world);
    }

    @Override
    public void cleanupWorkingMemory() {
        this.dWorldCleanupWorkingMemory();
    }

    @Override
    public boolean setStepMemoryReservationPolicy(DWorld.DWorldStepReserveInfo policyinfo) {
        return this.dWorldSetStepMemoryReservationPolicy(policyinfo);
    }

    @Override
    public boolean setStepMemoryManager(DWorld.DWorldStepMemoryFunctionsInfo memfuncs) {
        return this.dWorldSetStepMemoryManager(memfuncs);
    }

    public static interface dstepper_fn_t {
        public void run(DxWorldProcessMemArena var1, DxWorld var2, DxBody[] var3, int var4, int var5, DxJoint[] var6, int var7, int var8, double var9);
    }
}

