/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DVector3;
import org.ode4j.ode.DAABB;
import org.ode4j.ode.DTriMesh;
import org.ode4j.ode.OdeConfig;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxGimpact;
import org.ode4j.ode.internal.DxGimpactData;
import org.ode4j.ode.internal.DxSpace;
import org.ode4j.ode.internal.DxTriMeshData;
import org.ode4j.ode.internal.DxTriMeshDisabled;

public abstract class DxTriMesh
extends DxGeom
implements DTriMesh {
    DTriMesh.DTriCallback Callback;
    DTriMesh.DTriArrayCallback ArrayCallback;
    DTriMesh.DTriRayCallback RayCallback;
    DTriMesh.DTriTriMergeCallback TriMergeCallback;
    boolean doSphereTC;
    boolean doBoxTC;
    boolean doCapsuleTC;

    abstract void ClearTCCache();

    abstract boolean AABBTest(DAABB var1);

    @Override
    abstract void computeAABB();

    public DxTriMesh(DxSpace space) {
        super(space, true);
        this.type = 8;
    }

    public static DxTriMesh dCreateTriMesh(DxSpace space, DxTriMeshData Data, DTriMesh.DTriCallback Callback, DTriMesh.DTriArrayCallback ArrayCallback, DTriMesh.DTriRayCallback RayCallback) {
        DxTriMesh Geom;
        switch (OdeConfig.dTRIMESH_TYPE) {
            case DISABLED: {
                Geom = new DxTriMeshDisabled(space, Data);
                break;
            }
            case GIMPACT: {
                Geom = new DxGimpact(space, (DxGimpactData)Data);
                break;
            }
            default: {
                throw new IllegalArgumentException(OdeConfig.dTRIMESH_TYPE.name());
            }
        }
        Geom.Callback = Callback;
        Geom.ArrayCallback = ArrayCallback;
        Geom.RayCallback = RayCallback;
        return Geom;
    }

    public abstract int FetchTriangleCount();

    public abstract void FetchTransformedTriangle(int var1, DVector3[] var2);
}

