/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DSphere;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBox;
import org.ode4j.ode.internal.DxCollisionUtil;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxPlane;
import org.ode4j.ode.internal.DxSpace;

public class DxSphere
extends DxGeom
implements DSphere {
    private double _radius;

    DxSphere(DxSpace space, double radius) {
        super(space, true);
        Common.dAASSERT(radius >= 0.0);
        this.type = 0;
        this._radius = radius;
        this.updateZeroSizedFlag(radius == 0.0);
    }

    @Override
    void computeAABB() {
        this._aabb.set(this.final_posr().pos().get0() - this._radius, this.final_posr().pos().get0() + this._radius, this.final_posr().pos().get1() - this._radius, this.final_posr().pos().get1() + this._radius, this.final_posr().pos().get2() - this._radius, this.final_posr().pos().get2() + this._radius);
    }

    public static DxSphere dCreateSphere(DxSpace space, double radius) {
        return new DxSphere(space, radius);
    }

    public void dGeomSphereSetRadius(double radius) {
        Common.dAASSERT(radius >= 0.0);
        this._radius = radius;
        this.updateZeroSizedFlag(radius == 0.0);
        this.dGeomMoved();
    }

    public double dGeomSphereGetRadius() {
        return this._radius;
    }

    public double dGeomSpherePointDepth(double x, double y, double z) {
        this.recomputePosr();
        DVector3 pos = new DVector3(x, y, z);
        pos.sub(this.final_posr().pos());
        return this._radius - pos.length();
    }

    public double dGeomSpherePointDepth(DVector3C xyz) {
        this.recomputePosr();
        DVector3 pos = new DVector3();
        pos.eqDiff(xyz, this.final_posr().pos());
        return this._radius - pos.length();
    }

    @Override
    public void setRadius(double radius) {
        this.dGeomSphereSetRadius(radius);
    }

    @Override
    public double getRadius() {
        return this.dGeomSphereGetRadius();
    }

    @Override
    public double getPointDepth(DVector3C p) {
        return this.dGeomSpherePointDepth(p);
    }

    static class CollideSphereBox
    implements DColliderFn {
        CollideSphereBox() {
        }

        int dCollideSphereBox(DxSphere o1, DxBox o2, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip == 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            double[] l = new double[3];
            double[] t = new double[3];
            DVector3 p = new DVector3();
            DVector3 q = new DVector3();
            DVector3 r = new DVector3();
            boolean onborder = false;
            DxSphere sphere = o1;
            DxBox box = o2;
            DContactGeom contact = contacts.get(0);
            contact.g1 = o1;
            contact.g2 = o2;
            contact.side1 = -1;
            contact.side2 = -1;
            p.eqDiff(o1.final_posr().pos(), o2.final_posr().pos());
            l[0] = box.side.get0() * 0.5;
            t[0] = OdeMath.dCalcVectorDot3_14((DVector3C)p, o2.final_posr().R(), 0);
            if (t[0] < -l[0]) {
                t[0] = -l[0];
                onborder = true;
            }
            if (t[0] > l[0]) {
                t[0] = l[0];
                onborder = true;
            }
            l[1] = box.side.get1() * 0.5;
            t[1] = OdeMath.dCalcVectorDot3_14((DVector3C)p, o2.final_posr().R(), 1);
            if (t[1] < -l[1]) {
                t[1] = -l[1];
                onborder = true;
            }
            if (t[1] > l[1]) {
                t[1] = l[1];
                onborder = true;
            }
            t[2] = OdeMath.dCalcVectorDot3_14((DVector3C)p, o2.final_posr().R(), 2);
            l[2] = box.side.get2() * 0.5;
            if (t[2] < -l[2]) {
                t[2] = -l[2];
                onborder = true;
            }
            if (t[2] > l[2]) {
                t[2] = l[2];
                onborder = true;
            }
            if (!onborder) {
                double min_distance = l[0] - Common.dFabs(t[0]);
                int mini = 0;
                int i = 1;
                while (i < 3) {
                    double face_distance = l[i] - Common.dFabs(t[i]);
                    if (face_distance < min_distance) {
                        min_distance = face_distance;
                        mini = i;
                    }
                    ++i;
                }
                contacts.get((int)0).pos.set(o1.final_posr().pos());
                DVector3 tmp = new DVector3();
                tmp.set(mini, t[mini] > 0.0 ? 1.0 : -1.0);
                OdeMath.dMultiply0_331(contacts.get((int)0).normal, o2.final_posr().R(), (DVector3C)tmp);
                contacts.get((int)0).depth = min_distance + sphere._radius;
                return 1;
            }
            OdeMath.dMultiply0_331(q, o2.final_posr().R(), (DVector3C)new DVector3(t[0], t[1], t[2]));
            r.eqDiff(p, q);
            double depth = sphere._radius - Common.dSqrt(r.dot(r));
            if (depth < 0.0) {
                return 0;
            }
            contacts.get((int)0).pos.eqSum(q, o2.final_posr().pos());
            contacts.get((int)0).normal.set(r);
            OdeMath.dNormalize3(contacts.get((int)0).normal);
            contacts.get((int)0).depth = depth;
            return 1;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideSphereBox((DxSphere)o1, (DxBox)o2, flags, contacts, 1);
        }
    }

    static class CollideSpherePlane
    implements DColliderFn {
        CollideSpherePlane() {
        }

        int dCollideSpherePlane(DxSphere o1, DxPlane o2, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip == 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            DxSphere sphere = o1;
            DxPlane plane = o2;
            DContactGeom contact = contacts.get(0);
            contact.g1 = o1;
            contact.g2 = o2;
            contact.side1 = -1;
            contact.side2 = -1;
            double k = o1.final_posr().pos().dot(plane.getNormal());
            double depth = plane.getDepth() - k + sphere._radius;
            if (depth >= 0.0) {
                contact.normal.set(plane.getNormal());
                contact.pos.eqSum(o1.final_posr().pos(), contact.normal, -sphere._radius);
                contact.depth = depth;
                return 1;
            }
            return 0;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideSpherePlane((DxSphere)o1, (DxPlane)o2, flags, contacts, 1);
        }
    }

    static class CollideSphereSphere
    implements DColliderFn {
        CollideSphereSphere() {
        }

        int dCollideSphereSphere(DxSphere sphere1, DxSphere sphere2, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip == 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            DContactGeom contact = contacts.get(0);
            contact.g1 = sphere1;
            contact.g2 = sphere2;
            contact.side1 = -1;
            contact.side2 = -1;
            return DxCollisionUtil.dCollideSpheres(sphere1.final_posr().pos(), sphere1._radius, sphere2.final_posr().pos(), sphere2._radius, contacts);
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideSphereSphere((DxSphere)o1, (DxSphere)o2, flags, contacts, 1);
        }
    }
}

