/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import java.util.ArrayList;
import java.util.List;
import org.ode4j.ode.DAABB;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DSpace;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxGeom;

public abstract class DxSpace
extends DxGeom
implements DSpace {
    static final int dSPACE_TLS_KIND_INIT_VALUE = 0;
    private static final int dSPACE_TLS_KIND_MANUAL_VALUE = 0;
    protected int count = 0;
    protected DxGeom _first1 = null;
    protected List<DxGeom> _geoms = new ArrayList<DxGeom>();
    boolean cleanup = true;
    int sublevel = 0;
    int tls_kind = dSPACE_TLS_KIND_INIT_VALUE;
    int current_index = 0;
    DxGeom current_geom = null;
    int lock_count = 0;

    @Override
    public abstract void cleanGeoms();

    @Override
    public abstract void collide(Object var1, DGeom.DNearCallback var2);

    abstract void collide2(Object var1, DxGeom var2, DGeom.DNearCallback var3);

    public void dSpaceDestroy() {
        this.dGeomDestroy();
    }

    public void dSpaceSetCleanup(boolean mode) {
        this.setCleanup(mode);
    }

    boolean dSpaceGetCleanup() {
        return this.getCleanup();
    }

    public void dSpaceAdd(DxGeom g) {
        this.CHECK_NOT_LOCKED();
        this.add(g);
    }

    void dSpaceRemove(DxGeom g) {
        this.CHECK_NOT_LOCKED();
        this.remove(g);
    }

    boolean dSpaceQuery(DxGeom g) {
        return this.query(g);
    }

    void dSpaceClean() {
        this.cleanGeoms();
    }

    public int dSpaceGetNumGeoms() {
        return this.getNumGeoms();
    }

    public DxGeom dSpaceGetGeom(int i) {
        return (DxGeom)this.getGeom(i);
    }

    int dSpaceGetClass() {
        return this.type;
    }

    public void dSpaceCollide(Object data, DGeom.DNearCallback callback) {
        Common.dAASSERT(callback);
        this.collide(data, callback);
    }

    static void swap_callback(Object data, DxGeom g1, DxGeom g2) {
        DataCallback dc = (DataCallback)data;
        dc.callback.call(dc.data, g2, g1);
    }

    public static void dSpaceCollide2(DxGeom g1, DxGeom g2, Object data, DGeom.DNearCallback callback) {
        int l2;
        int l1;
        Common.dAASSERT(g1, g2, callback);
        DxSpace s1 = g1 instanceof DxSpace ? (DxSpace)g1 : null;
        DxSpace s2 = g2 instanceof DxSpace ? (DxSpace)g2 : null;
        if (s1 != null && s2 != null && (l1 = s1.getSublevel()) != (l2 = s2.getSublevel())) {
            if (l1 > l2) {
                s2 = null;
            } else {
                s1 = null;
            }
        }
        if (s1 != null) {
            if (s2 != null) {
                if (s1 == s2) {
                    s1.collide(data, callback);
                } else if (s1.count < s2.count) {
                    DataCallback dc = new DataCallback(data, callback);
                    for (DxGeom g : s1._geoms) {
                        s2.collide2(dc, g, new DGeom.DNearCallback(){

                            @Override
                            public void call(Object data, DGeom g1, DGeom g2) {
                                DxSpace.swap_callback(data, (DxGeom)g1, (DxGeom)g2);
                            }
                        });
                    }
                } else {
                    for (DxGeom g : s1._geoms) {
                        s1.collide2(data, g, callback);
                    }
                }
            } else {
                s1.collide2(data, g2, callback);
            }
        } else if (s2 != null) {
            DataCallback dc = new DataCallback(data, callback);
            s2.collide2(dc, g1, new DGeom.DNearCallback(){

                @Override
                public void call(Object data, DGeom g1, DGeom g2) {
                    DxSpace.swap_callback(data, (DxGeom)g1, (DxGeom)g2);
                }
            });
        } else {
            g1.recomputeAABB();
            g2.recomputeAABB();
            DxSpace.collideAABBs(g1, g2, data, callback);
        }
    }

    DxSpace(DxSpace _space) {
        super(_space, false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void DESTRUCTOR() {
        block2: {
            this.CHECK_NOT_LOCKED();
            if (!this.cleanup) ** GOTO lbl8
            while (!this._geoms.isEmpty()) {
                this._geoms.get(0).dGeomDestroy();
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                this.remove(this._geoms.get(0));
lbl8:
                // 2 sources

                ** while (!this._geoms.isEmpty())
            }
        }
        super.DESTRUCTOR();
    }

    @Override
    void computeAABB() {
        if (!this._geoms.isEmpty()) {
            DAABB aabb = new DAABB();
            aabb.set(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
            for (DxGeom g : this._geoms) {
                g.recomputeAABB();
                aabb.expand(g.getAABB());
            }
            this._aabb.set(aabb);
        } else {
            this._aabb.setZero();
        }
    }

    @Override
    public void setCleanup(boolean mode) {
        this.cleanup = mode;
    }

    @Override
    public boolean getCleanup() {
        return this.cleanup;
    }

    @Override
    public void setSublevel(int value) {
        this.sublevel = value;
    }

    @Override
    public int getSublevel() {
        return this.sublevel;
    }

    @Override
    public void setManualCleanup(int value) {
        this.tls_kind = value != 0 ? dSPACE_TLS_KIND_MANUAL_VALUE : dSPACE_TLS_KIND_INIT_VALUE;
    }

    @Override
    public int getManualCleanup() {
        return this.tls_kind == dSPACE_TLS_KIND_MANUAL_VALUE ? 1 : 0;
    }

    boolean query(DxGeom geom) {
        return geom.parent_space == this;
    }

    @Override
    public int getNumGeoms() {
        return this.count;
    }

    @Override
    public DGeom getGeom(int i) {
        DxGeom g;
        Common.dUASSERT(i >= 0 && i < this.count, "index out of range");
        this.current_geom = g = this._geoms.get(i);
        this.current_index = i;
        return g;
    }

    void add(DxGeom geom) {
        this.CHECK_NOT_LOCKED();
        Common.dAASSERT(geom);
        Common.dUASSERT(geom.parent_space == null && geom.getNext() == null, "geom is already in a space");
        geom.parent_space = this;
        geom.spaceAdd(this._first1, this, this._geoms);
        ++this.count;
        this.current_geom = null;
        geom.setFlagDirtyAndBad();
        this.dGeomMoved();
    }

    void remove(DxGeom geom) {
        this.CHECK_NOT_LOCKED();
        Common.dAASSERT(geom);
        Common.dUASSERT(geom.parent_space == this, "object is not in this space");
        geom.spaceRemove(this, this._geoms);
        --this.count;
        geom.setNextPrevNull();
        geom.parent_space = null;
        this.current_geom = null;
        this.dGeomMoved();
    }

    void dirty(DxGeom geom) {
        geom.spaceRemove(this, this._geoms);
        geom.spaceAdd(this._first1, this, this._geoms);
    }

    public void CHECK_NOT_LOCKED() {
        Common.dUASSERT(this.lock_count == 0, "invalid operation for locked space");
    }

    public static void CHECK_NOT_LOCKED(DxSpace s) {
        Common.dUASSERT(s == null || s.lock_count == 0, "invalid operation for locked space");
    }

    public void setFirst(DxGeom dxGeom) {
        this._first1 = dxGeom;
    }

    @Override
    public void add(DGeom x) {
        this.dSpaceAdd((DxGeom)x);
    }

    @Override
    public void remove(DGeom x) {
        this.dSpaceRemove((DxGeom)x);
    }

    @Override
    public boolean query(DGeom x) {
        return this.dSpaceQuery((DxGeom)x);
    }

    private static class DataCallback {
        Object data;
        DGeom.DNearCallback callback;

        public DataCallback(Object data, DGeom.DNearCallback callback) {
            this.data = data;
            this.callback = callback;
        }
    }
}

