/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.ode.DGeom;
import org.ode4j.ode.DSimpleSpace;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxSpace;

public class DxSimpleSpace
extends DxSpace
implements DSimpleSpace {
    public static DxSimpleSpace dSimpleSpaceCreate(DxSpace space) {
        return new DxSimpleSpace(space);
    }

    DxSimpleSpace(DxSpace space) {
        super(space);
        this.type = 10;
    }

    @Override
    public void cleanGeoms() {
        ++this.lock_count;
        for (DxGeom g : this._geoms) {
            if (!g.hasFlagDirty()) break;
            if (g instanceof DxSpace) {
                ((DxSpace)g).cleanGeoms();
            }
            g.recomputeAABB();
            g.unsetFlagDirtyAndBad();
        }
        --this.lock_count;
    }

    @Override
    public void collide(Object data, DGeom.DNearCallback callback) {
        Common.dAASSERT(callback);
        ++this.lock_count;
        this.cleanGeoms();
        int i = 0;
        while (i < this._geoms.size()) {
            DxGeom g1 = (DxGeom)this._geoms.get(i);
            if (this.GEOM_ENABLED(g1)) {
                int j = i + 1;
                while (j < this._geoms.size()) {
                    DxGeom g2 = (DxGeom)this._geoms.get(j);
                    if (this.GEOM_ENABLED(g2)) {
                        DxSimpleSpace.collideAABBs(g1, g2, data, callback);
                    }
                    ++j;
                }
            }
            ++i;
        }
        --this.lock_count;
    }

    @Override
    void collide2(Object data, DxGeom geom, DGeom.DNearCallback callback) {
        Common.dAASSERT(geom, callback);
        ++this.lock_count;
        this.cleanGeoms();
        geom.recomputeAABB();
        for (DxGeom g : this._geoms) {
            if (!this.GEOM_ENABLED(g)) continue;
            DxSimpleSpace.collideAABBs(g, geom, data, callback);
        }
        --this.lock_count;
    }
}

