/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.ode4j.ode.DAABB;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DSapSpace;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DArray;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxSpace;

public class DxSAPSpace
extends DxSpace
implements DSapSpace {
    private DArray<DxGeom> DirtyList = new DArray();
    private DArray<DxGeom> GeomList = new DArray();
    private ArrayList<DxGeom> TmpGeomList = new ArrayList();
    private DArray<DxGeom> TmpInfGeomList = new DArray();
    private int ax0id;
    private int ax1id;
    private int ax2id;
    private static final int GEOM_INVALID_IDX = -1;

    public static DxSAPSpace dSweepAndPruneSpaceCreate(DxSpace space, int axisorder) {
        return new DxSAPSpace(space, axisorder);
    }

    private void GEOM_SET_DIRTY_IDX(DxGeom g, int idx) {
        g._sapIdxDirty = idx;
    }

    private void GEOM_SET_GEOM_IDX(DxGeom g, int idx) {
        g._sapIdxGeom = idx;
    }

    private int GEOM_GET_DIRTY_IDX(DxGeom g) {
        return g._sapIdxDirty;
    }

    private int GEOM_GET_GEOM_IDX(DxGeom g) {
        return g._sapIdxGeom;
    }

    static void collideGeomsNoAABBs(DxGeom g1, DxGeom g2, Object data, DGeom.DNearCallback callback) {
        Common.dIASSERT(!g1.hasFlagAabbBad());
        Common.dIASSERT(!g2.hasFlagAabbBad());
        if (g1.body == g2.body && g1.body != null) {
            return;
        }
        if ((g1.category_bits & g2.collide_bits) == 0L && (g2.category_bits & g1.collide_bits) == 0L) {
            return;
        }
        DAABB bounds1 = g1._aabb;
        DAABB bounds2 = g2._aabb;
        if (!g1.AABBTest(g2, bounds2)) {
            return;
        }
        if (!g2.AABBTest(g1, bounds1)) {
            return;
        }
        callback.call(data, g1, g2);
    }

    private DxSAPSpace(DxSpace space, int axisorder) {
        super(space);
        this.type = 12;
        this._aabb.set(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.ax0id = axisorder & 3;
        this.ax1id = axisorder >> 2 & 3;
        this.ax2id = axisorder >> 4 & 3;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void DESTRUCTOR() {
        block4: {
            DxSAPSpace.CHECK_NOT_LOCKED(this);
            if (!this.cleanup) ** GOTO lbl11
            while (this.DirtyList.size() != 0) {
                this.DirtyList.get(0).dGeomDestroy();
            }
            while (this.GeomList.size() != 0) {
                this.GeomList.get(0).dGeomDestroy();
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                this.remove(this.DirtyList.get(0));
lbl11:
                // 2 sources

                ** while (this.DirtyList.size() != 0)
            }
lbl12:
            // 2 sources

            while (this.GeomList.size() != 0) {
                this.remove(this.GeomList.get(0));
            }
        }
        super.DESTRUCTOR();
    }

    @Override
    public DxGeom getGeom(int i) {
        Common.dUASSERT(i >= 0 && i < this.count, "index out of range");
        int dirtySize = this.DirtyList.size();
        if (i < dirtySize) {
            return this.DirtyList.get(i);
        }
        return this.GeomList.get(i - dirtySize);
    }

    @Override
    void add(DxGeom g) {
        DxSAPSpace.CHECK_NOT_LOCKED(this);
        Common.dAASSERT(g);
        Common.dUASSERT(g.parent_space == null && g.getNext() == null, "geom is already in a space");
        g.setFlagDirtyAndBad();
        this.GEOM_SET_DIRTY_IDX(g, this.DirtyList.size());
        this.GEOM_SET_GEOM_IDX(g, -1);
        this.DirtyList.push(g);
        g.parent_space = this;
        ++this.count;
        this.dGeomMoved();
    }

    @Override
    void remove(DxGeom g) {
        DxSAPSpace.CHECK_NOT_LOCKED(this);
        Common.dAASSERT(g);
        Common.dUASSERT(g.parent_space == this, "object is not in this space");
        int dirtyIdx = this.GEOM_GET_DIRTY_IDX(g);
        int geomIdx = this.GEOM_GET_GEOM_IDX(g);
        Common.dUASSERT(dirtyIdx == -1 && geomIdx >= 0 && geomIdx < this.GeomList.size() || geomIdx == -1 && dirtyIdx >= 0 && dirtyIdx < this.DirtyList.size(), "geom indices messed up");
        if (dirtyIdx != -1) {
            int dirtySize = this.DirtyList.size();
            DxGeom lastG = this.DirtyList.get(dirtySize - 1);
            this.DirtyList.set(dirtyIdx, lastG);
            this.GEOM_SET_DIRTY_IDX(lastG, dirtyIdx);
            this.GEOM_SET_DIRTY_IDX(g, -1);
            this.DirtyList.setSize(dirtySize - 1);
        } else {
            int geomSize = this.GeomList.size();
            DxGeom lastG = this.GeomList.get(geomSize - 1);
            this.GeomList.set(geomIdx, lastG);
            this.GEOM_SET_GEOM_IDX(lastG, geomIdx);
            this.GEOM_SET_GEOM_IDX(g, -1);
            this.GeomList.setSize(geomSize - 1);
        }
        --this.count;
        g.parent_space = null;
        this.dGeomMoved();
    }

    @Override
    void dirty(DxGeom g) {
        Common.dAASSERT(g);
        Common.dUASSERT(g.parent_space == this, "object is not in this space");
        int dirtyIdx = this.GEOM_GET_DIRTY_IDX(g);
        if (dirtyIdx != -1) {
            return;
        }
        int geomIdx = this.GEOM_GET_GEOM_IDX(g);
        Common.dUASSERT(geomIdx >= 0 && geomIdx < this.GeomList.size(), "geom indices messed up");
        int geomSize = this.GeomList.size();
        DxGeom lastG = this.GeomList.get(geomSize - 1);
        this.GeomList.set(geomIdx, lastG);
        this.GEOM_SET_GEOM_IDX(lastG, geomIdx);
        this.GeomList.remove(geomSize - 1);
        this.GEOM_SET_GEOM_IDX(g, -1);
        this.GEOM_SET_DIRTY_IDX(g, this.DirtyList.size());
        this.DirtyList.push(g);
    }

    @Override
    void computeAABB() {
    }

    @Override
    public void cleanGeoms() {
        int dirtySize = this.DirtyList.size();
        if (dirtySize == 0) {
            return;
        }
        ++this.lock_count;
        int geomSize = this.GeomList.size();
        this.GeomList.setSize(geomSize + dirtySize);
        int i = 0;
        while (i < dirtySize) {
            DxGeom g = this.DirtyList.get(i);
            if (g instanceof DxSpace) {
                ((DxSpace)g).cleanGeoms();
            }
            g.recomputeAABB();
            g.unsetFlagDirtyAndBad();
            this.GEOM_SET_DIRTY_IDX(g, -1);
            this.GEOM_SET_GEOM_IDX(g, geomSize + i);
            this.GeomList.set(geomSize + i, g);
            ++i;
        }
        this.DirtyList.setSize(0);
        --this.lock_count;
    }

    @Override
    public void collide(Object data, DGeom.DNearCallback callback) {
        Common.dAASSERT(callback);
        ++this.lock_count;
        this.cleanGeoms();
        int geom_count = this.GeomList.size();
        Common.dUASSERT(geom_count == this.count, "geom counts messed up");
        this.TmpGeomList.clear();
        this.TmpInfGeomList.setSize(0);
        int axis0max = this.ax0id;
        int i = 0;
        while (i < geom_count) {
            DxGeom g = this.GeomList.get(i);
            if (this.GEOM_ENABLED(g)) {
                double amax = g._aabb.getMax(axis0max);
                if (amax == Double.POSITIVE_INFINITY) {
                    this.TmpInfGeomList.push(g);
                } else {
                    this.TmpGeomList.add(g);
                }
            }
            ++i;
        }
        ArrayList<Pair> overlapBoxes = new ArrayList<Pair>();
        int tmp_geom_count = this.TmpGeomList.size();
        if (tmp_geom_count > 0) {
            this.BoxPruning(tmp_geom_count, this.TmpGeomList, overlapBoxes);
        }
        int overlapCount = overlapBoxes.size();
        int j = 0;
        while (j < overlapCount) {
            Pair pair = overlapBoxes.get(j);
            DxSAPSpace.collideGeomsNoAABBs(pair.g0, pair.g1, data, callback);
            ++j;
        }
        int infSize = this.TmpInfGeomList.size();
        int normSize = this.TmpGeomList.size();
        int m = 0;
        while (m < infSize) {
            DxGeom g2;
            DxGeom g1 = this.TmpInfGeomList.get(m);
            int n = m + 1;
            while (n < infSize) {
                g2 = this.TmpInfGeomList.get(n);
                DxSAPSpace.collideGeomsNoAABBs(g1, g2, data, callback);
                ++n;
            }
            n = 0;
            while (n < normSize) {
                g2 = this.TmpGeomList.get(n);
                DxSAPSpace.collideGeomsNoAABBs(g1, g2, data, callback);
                ++n;
            }
            ++m;
        }
        --this.lock_count;
    }

    @Override
    void collide2(Object data, DxGeom geom, DGeom.DNearCallback callback) {
        Common.dAASSERT(geom != null && callback != null);
        ++this.lock_count;
        this.cleanGeoms();
        geom.recomputeAABB();
        int geom_count = this.GeomList.size();
        int i = 0;
        while (i < geom_count) {
            DxGeom g = this.GeomList.get(i);
            if (this.GEOM_ENABLED(g)) {
                DxSAPSpace.collideAABBs(g, geom, data, callback);
            }
            ++i;
        }
        --this.lock_count;
    }

    void BoxPruning(int count, ArrayList<DxGeom> geoms, ArrayList<Pair> pairs) {
        ArrayList<DxGeom> buffer = new ArrayList<DxGeom>(geoms);
        Collections.sort(buffer, new GeomComparator());
        int i = 0;
        while (i < buffer.size()) {
            DxGeom g0 = buffer.get(i);
            DAABB aabb0 = g0._aabb;
            double idx0ax0max = aabb0.getMax(this.ax0id);
            int j = i + 1;
            while (j < buffer.size()) {
                DxGeom g1 = buffer.get(j);
                if (g1._aabb.getMin(this.ax0id) > idx0ax0max) break;
                if (aabb0.getMax(this.ax1id) >= g1._aabb.getMin(this.ax1id) && g1._aabb.getMax(this.ax1id) >= aabb0.getMin(this.ax1id) && aabb0.getMax(this.ax2id) >= g1._aabb.getMin(this.ax2id) && g1._aabb.getMax(this.ax2id) >= aabb0.getMin(this.ax2id)) {
                    pairs.add(new Pair(g0, g1));
                }
                ++j;
            }
            ++i;
        }
    }

    private class GeomComparator
    implements Comparator<DxGeom> {
        private GeomComparator() {
        }

        @Override
        public int compare(DxGeom arg0, DxGeom arg1) {
            double a0 = arg0._aabb.getMin(DxSAPSpace.this.ax0id);
            double a1 = arg1._aabb.getMin(DxSAPSpace.this.ax0id);
            return a1 > a0 ? -1 : (a1 < a0 ? 1 : 0);
        }
    }

    private static class Pair {
        DxGeom g0;
        DxGeom g1;

        Pair(DxGeom geom0, DxGeom geom1) {
            this.g0 = geom0;
            this.g1 = geom1;
        }
    }
}

