/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DRay;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBox;
import org.ode4j.ode.internal.DxCapsule;
import org.ode4j.ode.internal.DxCylinder;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxPlane;
import org.ode4j.ode.internal.DxSpace;
import org.ode4j.ode.internal.DxSphere;

public class DxRay
extends DxGeom
implements DRay {
    private final int RAY_FIRSTCONTACT = 65536;
    private final int RAY_BACKFACECULL = 131072;
    private final int RAY_CLOSEST_HIT = 262144;
    private double _length;

    DxRay(DxSpace space, double length) {
        super(space, true);
        this.type = 5;
        this._length = length;
    }

    @Override
    void computeAABB() {
        DVector3 e = new DVector3();
        e.eqSum(this.final_posr().R().viewCol(2), this._length, this.final_posr().pos(), 1.0);
        this._aabb.setMinMax(this.final_posr().pos(), e);
    }

    public static DxRay dCreateRay(DxSpace space, double length) {
        return new DxRay(space, length);
    }

    private void dGeomRaySetLength(double length) {
        this._length = length;
        this.dGeomMoved();
    }

    private void dGeomRaySet(double px, double py, double pz, double dx, double dy, double dz) {
        this.recomputePosr();
        DMatrix3C rot = this.final_posr().R();
        this._final_posr.pos.set(px, py, pz);
        DVector3 n = new DVector3(dx, dy, dz);
        n.normalize();
        rot.viewCol(2).set(n);
        this.dGeomMoved();
    }

    private void dGeomRaySet(DVector3C p, DVector3C d) {
        this.recomputePosr();
        DMatrix3C rot = this.final_posr().R();
        this._final_posr.pos.set(p);
        DVector3 n = new DVector3(d);
        n.normalize();
        rot.viewCol(2).set(n);
        this.dGeomMoved();
    }

    private void dGeomRayGet(DVector3 start, DVector3 dir) {
        this.recomputePosr();
        start.set(this.final_posr().pos());
        dir.set(this.final_posr().R().viewCol(2));
    }

    void dGeomRaySetParams(boolean FirstContact, boolean BackfaceCull) {
        if (FirstContact) {
            this.setFlagCustom(65536);
        } else {
            this.unsetFlagCustom(65536);
        }
        if (BackfaceCull) {
            this.setFlagCustom(131072);
        } else {
            this.unsetFlagCustom(131072);
        }
    }

    @Override
    public boolean getFirstContact() {
        return (this.getFlags() & 0x10000) != 0;
    }

    @Override
    public boolean getBackfaceCull() {
        return (this.getFlags() & 0x20000) != 0;
    }

    void dGeomRaySetClosestHit(boolean closestHit) {
        if (closestHit) {
            this.setFlagCustom(262144);
        } else {
            this.unsetFlagCustom(262144);
        }
    }

    boolean dGeomRayGetClosestHit() {
        return (this.getFlags() & 0x40000) != 0;
    }

    private static int ray_sphere_helper(DxRay ray, DVector3C sphere_pos, double radius, DContactGeomBuffer contacts, boolean mode) {
        double alpha;
        DVector3 q = new DVector3();
        q.eqDiff(ray.final_posr().pos(), sphere_pos);
        double B = OdeMath.dCalcVectorDot3_14((DVector3C)q, ray.final_posr().R(), 2);
        double C = q.dot(q) - radius * radius;
        double k = B * B - C;
        if (k < 0.0) {
            return 0;
        }
        k = Common.dSqrt(k);
        if (mode && C >= 0.0 ? (alpha = -B + k) < 0.0 : (alpha = -B - k) < 0.0 && (alpha = -B + k) < 0.0) {
            return 0;
        }
        if (alpha > ray._length) {
            return 0;
        }
        DContactGeom contact = contacts.get(0);
        contact.pos.eqSum(ray.final_posr().pos(), ray.final_posr().R().viewCol(2), alpha);
        double nsign = C < 0.0 || mode ? -1.0 : 1.0;
        contact.normal.eqDiff(contact.pos, sphere_pos).scale(nsign);
        contact.normal.normalize();
        contact.depth = alpha;
        return 1;
    }

    @Override
    public void setLength(double length) {
        this.dGeomRaySetLength(length);
    }

    @Override
    public double getLength() {
        return this._length;
    }

    @Override
    public void set(double px, double py, double pz, double dx, double dy, double dz) {
        this.dGeomRaySet(px, py, pz, dx, dy, dz);
    }

    @Override
    public void set(DVector3C p, DVector3C d) {
        this.dGeomRaySet(p, d);
    }

    @Override
    public void get(DVector3 start, DVector3 dir) {
        this.dGeomRayGet(start, dir);
    }

    @Override
    public void setParams(boolean firstContact, boolean backfaceCull) {
        this.dGeomRaySetParams(firstContact, backfaceCull);
    }

    @Override
    public void setClosestHit(boolean closestHit) {
        this.dGeomRaySetClosestHit(closestHit);
    }

    @Override
    public boolean getParamFirstContact() {
        return (this.getFlags() & 0x10000) != 0;
    }

    @Override
    public boolean getParamBackfaceCull() {
        return (this.getFlags() & 0x20000) != 0;
    }

    @Override
    public boolean getClosestHit() {
        return this.dGeomRayGetClosestHit();
    }

    @Override
    public DVector3C getDirection() {
        return this.final_posr().R().columnAsNewVector(2);
    }

    static class CollideRayBox
    implements DColliderFn {
        CollideRayBox() {
        }

        int dCollideRayBox(DxRay ray, DxBox box, int flags, DContactGeomBuffer contacts, int skip) {
            int n;
            double alpha;
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            DContactGeom contact = contacts.get(0);
            contact.g1 = ray;
            contact.g2 = box;
            contact.side1 = -1;
            contact.side2 = -1;
            DVector3 tmp = new DVector3();
            DVector3 s = new DVector3();
            DVector3 v = new DVector3();
            tmp.eqDiff(ray.final_posr().pos(), box.final_posr().pos());
            OdeMath.dMultiply1_331(s, box.final_posr().R(), tmp);
            tmp.set(ray.final_posr().R().viewCol(2));
            OdeMath.dMultiply1_331(v, box.final_posr().R(), tmp);
            DVector3 sign = new DVector3();
            int i = 0;
            while (i < 3) {
                if (v.get(i) < 0.0) {
                    s.scale(i, -1.0);
                    v.scale(i, -1.0);
                    sign.set(i, 1.0);
                } else {
                    sign.set(i, -1.0);
                }
                ++i;
            }
            double[] h = new double[]{0.5 * box.side.get0(), 0.5 * box.side.get1(), 0.5 * box.side.get2()};
            if (s.get0() < -h[0] && v.get0() <= 0.0 || s.get0() > h[0] || s.get1() < -h[1] && v.get1() <= 0.0 || s.get1() > h[1] || s.get2() < -h[2] && v.get2() <= 0.0 || s.get2() > h[2] || v.get0() == 0.0 && v.get1() == 0.0 && v.get2() == 0.0) {
                return 0;
            }
            double lo = Double.NEGATIVE_INFINITY;
            double hi = Double.POSITIVE_INFINITY;
            int nlo = 0;
            int nhi = 0;
            i = 0;
            while (i < 3) {
                if (v.get(i) != 0.0) {
                    double k = (-h[i] - s.get(i)) / v.get(i);
                    if (k > lo) {
                        lo = k;
                        nlo = i;
                    }
                    if ((k = (h[i] - s.get(i)) / v.get(i)) < hi) {
                        hi = k;
                        nhi = i;
                    }
                }
                ++i;
            }
            if (lo > hi) {
                return 0;
            }
            if (lo >= 0.0) {
                alpha = lo;
                n = nlo;
            } else {
                alpha = hi;
                n = nhi;
            }
            if (alpha < 0.0 || alpha > ray._length) {
                return 0;
            }
            contact.pos.eqSum(ray.final_posr().pos(), ray.final_posr().R().viewCol(2), alpha);
            contact.normal.set(box.final_posr().R().viewCol(n)).scale(sign.get(n));
            contact.depth = alpha;
            return 1;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideRayBox((DxRay)o1, (DxBox)o2, flags, contacts, 1);
        }
    }

    static class CollideRayCapsule
    implements DColliderFn {
        CollideRayCapsule() {
        }

        int dCollideRayCapsule(DxRay ray, DxCapsule ccyl, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            DContactGeom contact = contacts.get(0);
            contact.g1 = ray;
            contact.g2 = ccyl;
            contact.side1 = -1;
            contact.side2 = -1;
            double lz2 = ccyl.getLength() * 0.5;
            DVector3 cs = new DVector3();
            DVector3 q = new DVector3();
            DVector3 r = new DVector3();
            cs.eqDiff(ray.final_posr().pos(), ccyl.final_posr().pos());
            double k = OdeMath.dCalcVectorDot3_41(ccyl.final_posr().R(), 2, cs);
            q.eqSum(ccyl.final_posr().R().viewCol(2), k, (DVector3C)cs, -1.0);
            double C = OdeMath.dCalcVectorDot3(q, q) - ccyl.getRadius() * ccyl.getRadius();
            boolean inside_ccyl = false;
            if (C < 0.0) {
                if (k < -lz2) {
                    k = -lz2;
                } else if (k > lz2) {
                    k = lz2;
                }
                r.eqSum(ccyl.final_posr().R().viewCol(2), k, ccyl.final_posr().pos(), 1.0);
                if ((ray.final_posr().pos().get0() - r.get0()) * (ray.final_posr().pos().get0() - r.get0()) + (ray.final_posr().pos().get1() - r.get1()) * (ray.final_posr().pos().get1() - r.get1()) + (ray.final_posr().pos().get2() - r.get2()) * (ray.final_posr().pos().get2() - r.get2()) < ccyl.getRadius() * ccyl.getRadius()) {
                    inside_ccyl = true;
                }
            }
            if (!inside_ccyl && C < 0.0) {
                k = k < 0.0 ? -lz2 : lz2;
            } else {
                double uv = OdeMath.dCalcVectorDot3_44(ccyl.final_posr().R(), 2, ray.final_posr().R(), 2);
                r.eqSum(ccyl.final_posr().R().viewCol(2), uv, ray.final_posr().R().viewCol(2), -1.0);
                double A = OdeMath.dCalcVectorDot3(r, r);
                double B = 2.0 * OdeMath.dCalcVectorDot3(q, r);
                k = B * B - 4.0 * A * C;
                if (k < 0.0) {
                    if (!inside_ccyl) {
                        return 0;
                    }
                    k = uv < 0.0 ? -lz2 : lz2;
                } else {
                    double nsign;
                    double alpha = (-B - (k = Common.dSqrt(k))) * (A = Common.dRecip(2.0 * A));
                    if (alpha < 0.0 && (alpha = (-B + k) * A) < 0.0) {
                        return 0;
                    }
                    if (alpha > ray._length) {
                        return 0;
                    }
                    contact.pos.eqSum(ray.final_posr().R().viewCol(2), alpha, ray.final_posr().pos(), 1.0);
                    q.eqDiff(contact.pos, ccyl.final_posr().pos());
                    k = OdeMath.dCalcVectorDot3_14((DVector3C)q, ccyl.final_posr().R(), 2);
                    double d = nsign = inside_ccyl ? -1.0 : 1.0;
                    if (k >= -lz2 && k <= lz2) {
                        contact.normal.eqSum(ccyl.final_posr().R().viewCol(2), -k, ccyl.final_posr().pos(), -1.0);
                        contact.normal.add(contact.pos).scale(nsign);
                        contact.normal.normalize();
                        contact.depth = alpha;
                        return 1;
                    }
                    k = k < 0.0 ? -lz2 : lz2;
                }
            }
            q.eqSum(ccyl.final_posr().R().viewCol(2), k, ccyl.final_posr().pos(), 1.0);
            return DxRay.ray_sphere_helper(ray, q, ccyl.getRadius(), contacts, inside_ccyl);
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideRayCapsule((DxRay)o1, (DxCapsule)o2, flags, contacts, 1);
        }
    }

    static class CollideRayCylinder
    implements DColliderFn {
        CollideRayCylinder() {
        }

        int dCollideRayCylinder(DxRay ray, DxCylinder cyl, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            DContactGeom contact = contacts.get(0);
            contact.g1 = ray;
            contact.g2 = cyl;
            contact.side1 = -1;
            contact.side2 = -1;
            double half_length = cyl.getLength() * 0.5;
            DVector3 q = new DVector3();
            DVector3 r = new DVector3();
            r.eqDiff(ray.final_posr().pos(), cyl.final_posr().pos());
            double d = OdeMath.dCalcVectorDot3_41(cyl.final_posr().R(), 2, r);
            q.eqSum(cyl.final_posr().R().viewCol(2), d, (DVector3C)r, -1.0);
            double C = OdeMath.dCalcVectorDot3(q, q) - cyl.getRadius() * cyl.getRadius();
            double uv = OdeMath.dCalcVectorDot3_44(cyl.final_posr().R(), 2, ray.final_posr().R(), 2);
            r.eqSum(cyl.final_posr().R().viewCol(2), uv, ray.final_posr().R().viewCol(2), -1.0);
            double A = OdeMath.dCalcVectorDot3(r, r);
            double B = 2.0 * OdeMath.dCalcVectorDot3(q, r);
            double k = B * B - 4.0 * A * C;
            if (k < Common.dEpsilon && C <= 0.0) {
                double internal;
                double uvsign = uv < 0.0 ? -1.0 : 1.0;
                double d2 = internal = d >= -half_length && d <= half_length ? -1.0 : 1.0;
                if (uv > 0.0 && d + uvsign * ray._length < half_length * internal || uv < 0.0 && d + uvsign * ray._length > half_length * internal) {
                    return 0;
                }
                contact.depth = -uvsign * d - internal * half_length;
                contact.pos.eqSum(ray.final_posr().R().viewCol(2), contact.depth, ray.final_posr().pos(), 1.0);
                contact.normal.set(cyl.final_posr().R().viewCol(2)).scale(uvsign);
                return 1;
            }
            if (k > 0.0) {
                double alpha = (-B - (k = Common.dSqrt(k))) * (A = Common.dRecip(2.0 * A));
                if (alpha < 0.0) {
                    alpha = (-B + k) * A;
                }
                if (alpha >= 0.0 && alpha <= ray._length) {
                    contact.pos.eqSum(ray.final_posr().R().viewCol(2), alpha, ray.final_posr().pos(), 1.0);
                    q.eqDiff(contact.pos, cyl.final_posr().pos());
                    d = OdeMath.dCalcVectorDot3_14((DVector3C)q, cyl.final_posr().R(), 2);
                    if (d >= -half_length && d <= half_length) {
                        double nsign = C < 0.0 ? -1.0 : 1.0;
                        contact.normal.eqSum(cyl.final_posr().R().viewCol(2), -d, cyl.final_posr().pos(), -1.0);
                        contact.normal.add(contact.pos).scale(nsign);
                        contact.normal.normalize();
                        contact.depth = alpha;
                        return 1;
                    }
                }
            }
            return 0;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideRayCylinder((DxRay)o1, (DxCylinder)o2, flags, contacts, 1);
        }
    }

    static class CollideRayPlane
    implements DColliderFn {
        CollideRayPlane() {
        }

        int dCollideRayPlane(DxRay ray, DxPlane plane, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            double alpha = plane.getDepth() - plane.getNormal().dot(ray.final_posr().pos());
            double nsign = alpha > 0.0 ? -1.0 : 1.0;
            double k = plane.getNormal().dot(ray.final_posr().R().viewCol(2));
            if (k == 0.0) {
                return 0;
            }
            if ((alpha /= k) < 0.0 || alpha > ray._length) {
                return 0;
            }
            DContactGeom contact = contacts.get(0);
            contact.pos.eqSum(ray.final_posr().R().viewCol(2), alpha, ray.final_posr().pos(), 1.0);
            contact.normal.set(plane.getNormal());
            contact.normal.scale(nsign);
            contact.depth = alpha;
            contact.g1 = ray;
            contact.g2 = plane;
            contact.side1 = -1;
            contact.side2 = -1;
            return 1;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideRayPlane((DxRay)o1, (DxPlane)o2, flags, contacts, 1);
        }
    }

    static class CollideRaySphere
    implements DColliderFn {
        CollideRaySphere() {
        }

        int dCollideRaySphere(DxRay ray, DxSphere sphere, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            DContactGeom contact = contacts.get(0);
            contact.g1 = ray;
            contact.g2 = sphere;
            contact.side1 = -1;
            contact.side2 = -1;
            return DxRay.ray_sphere_helper(ray, sphere.final_posr().pos(), sphere.getRadius(), contacts, false);
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideRaySphere((DxRay)o1, (DxSphere)o2, flags, contacts, 1);
        }
    }
}

