/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cstring;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.AbstractStepper;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBody;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.Matrix;
import org.ode4j.ode.internal.Misc;
import org.ode4j.ode.internal.Objects_H;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.processmem.DxUtil;
import org.ode4j.ode.internal.processmem.DxWorldProcessIslandsInfo;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemArena;

public class DxQuickStep
extends AbstractStepper
implements DxWorld.dstepper_fn_t,
DxWorldProcessIslandsInfo.dmemestimate_fn_t {
    private static final boolean CHECK_VELOCITY_OBEYS_CONSTRAINT = false;
    public static final DxQuickStep INSTANCE = new DxQuickStep();
    private static final boolean TIMING = false;
    private static final boolean REORDER_CONSTRAINTS = false;
    private static final boolean RANDOMLY_REORDER_CONSTRAINTS = true;

    private static void Multiply1_12q1(DVector3 A1, DVector3 A2, double[] B, int ofsB, double[] C, int ofsC, int q) {
        if (q < 0) {
            throw new IllegalArgumentException();
        }
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double d = 0.0;
        double e = 0.0;
        double f = 0.0;
        int i = ofsC;
        int k = ofsB;
        while (i < q + ofsC) {
            double s = C[i];
            a += B[k] * s;
            b += B[1 + k] * s;
            c += B[2 + k] * s;
            d += B[3 + k] * s;
            e += B[4 + k] * s;
            f += B[5 + k] * s;
            ++i;
            k += 12;
        }
        A1.set(a, b, c);
        A2.set(d, e, f);
    }

    private static void compute_invM_JT(int m, double[] J, double[] iMJ, int[] jb, DxBody[] bodyP, int bodyOfs, double[] invI) {
        int iMJ_ofs = 0;
        int J_ofs = 0;
        int i = 0;
        while (i < m) {
            int b1 = jb[i * 2];
            int b2 = jb[i * 2 + 1];
            double k1 = bodyP[b1 + bodyOfs].invMass;
            int j = 0;
            while (j < 3) {
                iMJ[j + iMJ_ofs] = k1 * J[j + J_ofs];
                ++j;
            }
            OdeMath.dMultiply0_331(iMJ, iMJ_ofs + 3, invI, 12 * b1, J, J_ofs + 3);
            if (b2 != -1) {
                double k2 = bodyP[b2 + bodyOfs].invMass;
                j = 0;
                while (j < 3) {
                    iMJ[j + 6 + iMJ_ofs] = k2 * J[j + 6 + J_ofs];
                    ++j;
                }
                OdeMath.dMultiply0_331(iMJ, iMJ_ofs + 9, invI, 12 * b2, J, J_ofs + 9);
            }
            J_ofs += 12;
            iMJ_ofs += 12;
            ++i;
        }
    }

    private static void multiply_J(int m, double[] J, int[] jb, double[] in, double[] out) {
        int J_ofs = 0;
        int i = 0;
        while (i < m) {
            int b1 = jb[i * 2];
            int b2 = jb[i * 2 + 1];
            double sum = 0.0;
            int in_ofs = b1 * 6;
            int j = 0;
            while (j < 6) {
                sum += J[j + J_ofs] * in[j + in_ofs];
                ++j;
            }
            J_ofs += 6;
            if (b2 != -1) {
                in_ofs = b2 * 6;
                j = 0;
                while (j < 6) {
                    sum += J[j + J_ofs] * in[j + in_ofs];
                    ++j;
                }
            }
            J_ofs += 6;
            out[i] = sum;
            ++i;
        }
    }

    private static void SOR_LCP(DxWorldProcessMemArena memarena, int m, int nb, double[] J, int[] jb, DxBody[] bodyP, int bodyOfs, double[] invI, double[] lambda, double[] fc, double[] b, double[] lo, double[] hi, double[] cfm, int[] findex, Objects_H.dxQuickStepParameters qs) {
        Matrix.dSetZero(lambda, m);
        double[] iMJ = memarena.AllocateArrayDReal(m * 12);
        DxQuickStep.compute_invM_JT(m, J, iMJ, jb, bodyP, bodyOfs, invI);
        Matrix.dSetZero(fc, nb * 6);
        double[] Ad = memarena.AllocateArrayDReal(m);
        double sor_w = qs.w;
        int iMJ_ofs = 0;
        int J_ofs = 0;
        int i = 0;
        while (i < m) {
            double sum = 0.0;
            int j = 0;
            while (j < 6) {
                sum += iMJ[j + iMJ_ofs] * J[j + J_ofs];
                ++j;
            }
            if (jb[i * 2 + 1] != -1) {
                j = 6;
                while (j < 12) {
                    sum += iMJ[j + iMJ_ofs] * J[j + J_ofs];
                    ++j;
                }
            }
            Ad[i] = sor_w / (sum + cfm[i]);
            iMJ_ofs += 12;
            J_ofs += 12;
            ++i;
        }
        int J_ofs2 = 0;
        int i2 = 0;
        while (i2 < m) {
            double Ad_i = Ad[i2];
            int j = 0;
            while (j < 12) {
                int n = J_ofs2 + j;
                J[n] = J[n] * Ad_i;
                ++j;
            }
            int n = i2;
            b[n] = b[n] * Ad_i;
            Ad[i2] = Ad_i * cfm[i2];
            J_ofs2 += 12;
            ++i2;
        }
        IndexError[] order = new IndexError[m];
        int iii = 0;
        while (iii < m) {
            order[iii] = new IndexError();
            ++iii;
        }
        int orderhead = 0;
        int ordertail = m - 1;
        int i3 = 0;
        while (i3 < m) {
            if (findex[i3] == -1) {
                order[orderhead].index = i3;
                ++orderhead;
            } else {
                order[ordertail].index = i3;
                --ordertail;
            }
            ++i3;
        }
        Common.dIASSERT(orderhead - ordertail == 1);
        int num_iterations = qs.num_iterations;
        int iteration = 0;
        while (iteration < num_iterations) {
            if ((iteration & 7) == 0) {
                i3 = 1;
                while (i3 < m) {
                    int swapi = Misc.dRandInt(i3 + 1);
                    IndexError tmp = order[i3];
                    order[i3] = order[swapi];
                    order[swapi] = tmp;
                    ++i3;
                }
            }
            i3 = 0;
            while (i3 < m) {
                double lo_act;
                double hi_act;
                int index = order[i3].index;
                int NULL = -1;
                int b1 = jb[index * 2];
                int b2 = jb[index * 2 + 1];
                int fc_ofs1 = 0 + 6 * b1;
                int fc_ofs2 = b2 != -1 ? 0 + 6 * b2 : -1;
                double old_lambda = lambda[index];
                double delta = b[index] - old_lambda * Ad[index];
                int J_ofs3 = index * 12;
                delta -= fc[fc_ofs1] * J[J_ofs3] + fc[fc_ofs1 + 1] * J[J_ofs3 + 1] + fc[fc_ofs1 + 2] * J[J_ofs3 + 2] + fc[fc_ofs1 + 3] * J[J_ofs3 + 3] + fc[fc_ofs1 + 4] * J[J_ofs3 + 4] + fc[fc_ofs1 + 5] * J[J_ofs3 + 5];
                if (fc_ofs2 != -1) {
                    delta -= fc[fc_ofs2 + 0] * J[J_ofs3 + 6] + fc[fc_ofs2 + 1] * J[J_ofs3 + 7] + fc[fc_ofs2 + 2] * J[J_ofs3 + 8] + fc[fc_ofs2 + 3] * J[J_ofs3 + 9] + fc[fc_ofs2 + 4] * J[J_ofs3 + 10] + fc[fc_ofs2 + 5] * J[J_ofs3 + 11];
                }
                if (findex[index] != -1) {
                    hi_act = Common.dFabs(hi[index] * lambda[findex[index]]);
                    lo_act = -hi_act;
                } else {
                    hi_act = hi[index];
                    lo_act = lo[index];
                }
                double new_lambda = old_lambda + delta;
                if (new_lambda < lo_act) {
                    delta = lo_act - old_lambda;
                    lambda[index] = lo_act;
                } else if (new_lambda > hi_act) {
                    delta = hi_act - old_lambda;
                    lambda[index] = hi_act;
                } else {
                    lambda[index] = new_lambda;
                }
                int iMJ_ofs2 = 0 + index * 12;
                int n = fc_ofs1 + 0;
                fc[n] = fc[n] + delta * iMJ[iMJ_ofs2 + 0];
                int n2 = fc_ofs1 + 1;
                fc[n2] = fc[n2] + delta * iMJ[iMJ_ofs2 + 1];
                int n3 = fc_ofs1 + 2;
                fc[n3] = fc[n3] + delta * iMJ[iMJ_ofs2 + 2];
                int n4 = fc_ofs1 + 3;
                fc[n4] = fc[n4] + delta * iMJ[iMJ_ofs2 + 3];
                int n5 = fc_ofs1 + 4;
                fc[n5] = fc[n5] + delta * iMJ[iMJ_ofs2 + 4];
                int n6 = fc_ofs1 + 5;
                fc[n6] = fc[n6] + delta * iMJ[iMJ_ofs2 + 5];
                if (fc_ofs2 != -1) {
                    int n7 = fc_ofs2 + 0;
                    fc[n7] = fc[n7] + delta * iMJ[iMJ_ofs2 + 6];
                    int n8 = fc_ofs2 + 1;
                    fc[n8] = fc[n8] + delta * iMJ[iMJ_ofs2 + 7];
                    int n9 = fc_ofs2 + 2;
                    fc[n9] = fc[n9] + delta * iMJ[iMJ_ofs2 + 8];
                    int n10 = fc_ofs2 + 3;
                    fc[n10] = fc[n10] + delta * iMJ[iMJ_ofs2 + 9];
                    int n11 = fc_ofs2 + 4;
                    fc[n11] = fc[n11] + delta * iMJ[iMJ_ofs2 + 10];
                    int n12 = fc_ofs2 + 5;
                    fc[n12] = fc[n12] + delta * iMJ[iMJ_ofs2 + 11];
                }
                ++i3;
            }
            ++iteration;
        }
    }

    private static void dxQuickStepper(DxWorldProcessMemArena memarena, DxWorld world, DxBody[] bodyP, int bodyOfs, int nb, DxJoint[] _jointP, int _jointOfs, int _nj, double stepsize) {
        int i;
        double gravity_z;
        double gravity_y;
        DxBody b;
        double stepsize1 = Common.dRecip(stepsize);
        int i2 = 0;
        while (i2 < nb) {
            bodyP[i2 + bodyOfs].tag = i2;
            ++i2;
        }
        double[] invI = memarena.AllocateArrayDReal(nb * 3 * 4);
        int invIrowP = 0;
        int i3 = 0;
        while (i3 < nb) {
            DMatrix3 tmp = new DMatrix3();
            b = bodyP[i3 + bodyOfs];
            OdeMath.dMultiply2_333(tmp, b.invI, b.posr().R());
            OdeMath.dMultiply0_333(invI, invIrowP, b.posr().R(), tmp);
            if (b.isFlagsGyroscopic()) {
                DMatrix3 I = new DMatrix3();
                OdeMath.dMultiply2_333(tmp, b.mass._I, b.posr().R());
                OdeMath.dMultiply0_333(I, b.posr().R(), tmp);
                OdeMath.dMultiply0_331(tmp, (DMatrix3C)I, (DVector3C)b.avel);
                OdeMath.dSubtractVectorCross3(b.tacc, (DVector3C)b.avel, tmp);
            }
            invIrowP += 12;
            ++i3;
        }
        double gravity_x = world.gravity.get0();
        if (gravity_x != 0.0) {
            int i4 = 0;
            while (i4 < nb) {
                b = bodyP[i4 + bodyOfs];
                if ((b.flags & 8) == 0) {
                    b.facc.add(0, b.mass._mass * gravity_x);
                }
                ++i4;
            }
        }
        if ((gravity_y = world.gravity.get1()) != 0.0) {
            int i5 = 0;
            while (i5 < nb) {
                DxBody b2 = bodyP[i5 + bodyOfs];
                if ((b2.flags & 8) == 0) {
                    b2.facc.add(1, b2.mass._mass * gravity_y);
                }
                ++i5;
            }
        }
        if ((gravity_z = world.gravity.get2()) != 0.0) {
            i = 0;
            while (i < nb) {
                DxBody b3 = bodyP[i + bodyOfs];
                if ((b3.flags & 8) == 0) {
                    b3.facc.add(2, b3.mass._mass * gravity_z);
                }
                ++i;
            }
        }
        DxWorldProcessMemArena.dummy();
        Object[] jointiinfos = new DJointWithInfo1[_nj];
        int jicurrP = 0;
        DJointWithInfo1 jicurrO = new DJointWithInfo1();
        int i6 = 0;
        while (i6 < _nj) {
            DxJoint j = _jointP[i6 + _jointOfs];
            j.getInfo1(jicurrO.info);
            Common.dIASSERT(jicurrO.info.m >= 0 && jicurrO.info.m <= 6 && jicurrO.info.nub >= 0 && jicurrO.info.nub <= jicurrO.info.m);
            if (jicurrO.info.m > 0) {
                jicurrO.joint = j;
                jointiinfos[jicurrP] = jicurrO;
                ++jicurrP;
                jicurrO = new DJointWithInfo1();
            }
            ++i6;
        }
        int njXXX = jicurrP;
        memarena.ShrinkArrayDJointWithInfo1(jointiinfos, _nj, njXXX);
        int mfb = 0;
        int mcurr = 0;
        int mfbcurr = 0;
        i = 0;
        while (i < njXXX) {
            int jm = ((DJointWithInfo1)jointiinfos[i]).info.m;
            mcurr += jm;
            if (((DJointWithInfo1)jointiinfos[i]).joint.feedback != null) {
                mfbcurr += jm;
            }
            ++i;
        }
        int m = mcurr;
        mfb = mfbcurr;
        double[] J = null;
        int[] jb = null;
        if (m > 0) {
            int mlocal = m;
            int jelements = mlocal * 12;
            J = memarena.AllocateArrayDReal(jelements);
            Matrix.dSetZero(J);
            double[] cfm = memarena.AllocateArrayDReal(mlocal);
            Matrix.dSetValue(cfm, mlocal, world.global_cfm);
            double[] lo = memarena.AllocateArrayDReal(mlocal);
            Matrix.dSetValue(lo, mlocal, Double.NEGATIVE_INFINITY);
            double[] hi = memarena.AllocateArrayDReal(mlocal);
            Matrix.dSetValue(hi, mlocal, Double.POSITIVE_INFINITY);
            int[] findex = memarena.AllocateArrayInt(mlocal);
            int i7 = 0;
            while (i7 < mlocal) {
                findex[i7] = -1;
                ++i7;
            }
            int jbelements = mlocal * 2;
            jb = memarena.AllocateArrayInt(jbelements);
            double[] rhs = memarena.AllocateArrayDReal(mlocal);
            double[] Jcopy = memarena.AllocateArrayDReal(mfb * 12);
            DxUtil.BlockPointer cstate = memarena.BEGIN_STATE_SAVE();
            double[] c = memarena.AllocateArrayDReal(m);
            Matrix.dSetZero(c, m);
            DxJoint.Info2 Jinfo = new DxJoint.Info2();
            Jinfo.setRowskip(12);
            Jinfo.setArrays(J, c, cfm, lo, hi, findex);
            Jinfo.fps = stepsize1;
            Jinfo.erp = world.getERP();
            int JcopyrowP = 0;
            int ofsi = 0;
            int i8 = 0;
            while (i8 < njXXX) {
                int JrowP;
                Object jicurr = jointiinfos[i8];
                Jinfo.J1lp = JrowP = 0 + ofsi * 12;
                Jinfo.J1ap = JrowP + 3;
                Jinfo.J2lp = JrowP + 6;
                Jinfo.J2ap = JrowP + 9;
                Jinfo.setAllP(ofsi);
                DxJoint joint = ((DJointWithInfo1)jicurr).joint;
                joint.getInfo2(Jinfo);
                int infom = ((DJointWithInfo1)jicurr).info.m;
                if (joint.feedback != null) {
                    int rowels = infom * 12;
                    Cstring.memcpy(Jcopy, JcopyrowP, J, JrowP, rowels);
                    JcopyrowP += rowels;
                }
                int findex_ofsi = ofsi;
                int j = 0;
                while (j < infom) {
                    int fival = findex[findex_ofsi + j];
                    if (fival != -1) {
                        findex[findex_ofsi + j] = fival + ofsi;
                    }
                    ++j;
                }
                ofsi += infom;
                ++i8;
            }
            int jb_ofs = 0;
            int i9 = 0;
            while (i9 < njXXX) {
                DxJoint joint = ((DJointWithInfo1)jointiinfos[i9]).joint;
                int infom = ((DJointWithInfo1)jointiinfos[i9]).info.m;
                int b1 = joint.node[0].body != null ? joint.node[0].body.tag : -1;
                int b2 = joint.node[1].body != null ? joint.node[1].body.tag : -1;
                int j = 0;
                while (j < infom) {
                    jb[jb_ofs] = b1;
                    jb[jb_ofs + 1] = b2;
                    jb_ofs += 2;
                    ++j;
                }
                ++i9;
            }
            Common.dIASSERT(jb_ofs == 2 * m);
            DxUtil.BlockPointer tmp1state = memarena.BEGIN_STATE_SAVE();
            double[] tmp1 = memarena.AllocateArrayDReal(nb * 6);
            int tmp1currP = 0;
            int invIrowP2 = 0;
            int i10 = 0;
            while (i10 < nb) {
                DxBody b4 = bodyP[i10 + bodyOfs];
                double body_invMass = b4.invMass;
                int j = 0;
                while (j < 3) {
                    tmp1[tmp1currP + j] = b4.facc.get(j) * body_invMass + b4.lvel.get(j) * stepsize1;
                    ++j;
                }
                OdeMath.dMultiply0_331(tmp1, tmp1currP + 3, invI, invIrowP2, b4.tacc);
                int k = 0;
                while (k < 3) {
                    int n = tmp1currP + 3 + k;
                    tmp1[n] = tmp1[n] + b4.avel.get(k) * stepsize1;
                    ++k;
                }
                tmp1currP += 6;
                invIrowP2 += 12;
                ++i10;
            }
            DxQuickStep.multiply_J(m, J, jb, tmp1, rhs);
            memarena.END_STATE_SAVE(tmp1state);
            i = 0;
            while (i < m) {
                rhs[i] = c[i] * stepsize1 - rhs[i];
                ++i;
            }
            int j = 0;
            while (j < m) {
                int n = j++;
                cfm[n] = cfm[n] * stepsize1;
            }
            memarena.END_STATE_SAVE(cstate);
            double[] lambda = memarena.AllocateArrayDReal(m);
            double[] cforce = memarena.AllocateArrayDReal(nb * 6);
            DxUtil.BlockPointer lcpstate = memarena.BEGIN_STATE_SAVE();
            DxQuickStep.SOR_LCP(memarena, m, nb, J, jb, bodyP, bodyOfs, invI, lambda, cforce, rhs, lo, hi, cfm, findex, world.qs);
            memarena.END_STATE_SAVE(lcpstate);
            int cforcecurrP = 0;
            i8 = 0;
            while (i8 < nb) {
                DxBody b5 = bodyP[i8 + bodyOfs];
                int j2 = 0;
                while (j2 < 3) {
                    b5.lvel.add(j2, stepsize * cforce[cforcecurrP + j2]);
                    b5.avel.add(j2, stepsize * cforce[cforcecurrP + 3 + j2]);
                    ++j2;
                }
                cforcecurrP += 6;
                ++i8;
            }
            if (mfb > 0) {
                int lambdacurrP = 0;
                int JcopyrowP2 = 0;
                i = 0;
                while (i < njXXX) {
                    DxJoint joint = ((DJointWithInfo1)jointiinfos[i]).joint;
                    int infom = ((DJointWithInfo1)jointiinfos[i]).info.m;
                    if (joint.feedback != null) {
                        DJoint.DJointFeedback fb = joint.feedback;
                        DxQuickStep.Multiply1_12q1(fb.f1, fb.t1, Jcopy, JcopyrowP2, lambda, lambdacurrP, infom);
                        if (joint.node[1].body != null) {
                            DxQuickStep.Multiply1_12q1(fb.f2, fb.t2, Jcopy, JcopyrowP2 + 6, lambda, lambdacurrP, infom);
                        }
                        JcopyrowP2 += infom * 12;
                    }
                    lambdacurrP += infom;
                    ++i;
                }
            }
        }
        int invIrowP3 = 0;
        int i11 = 0;
        while (i11 < nb) {
            DxBody b6 = bodyP[i11 + bodyOfs];
            double body_invMass_mul_stepsize = stepsize * b6.invMass;
            int j = 0;
            while (j < 3) {
                b6.lvel.add(j, body_invMass_mul_stepsize * b6.facc.get(j));
                b6.tacc.scale(stepsize);
                ++j;
            }
            OdeMath.dMultiplyAdd0_331(b6.avel, invI, invIrowP3, b6.tacc);
            invIrowP3 += 12;
            ++i11;
        }
        i = 0;
        while (i < nb) {
            bodyP[i + bodyOfs].dxStepBody(stepsize);
            ++i;
        }
        i = 0;
        while (i < nb) {
            DxBody b7 = bodyP[i + bodyOfs];
            b7.facc.setZero();
            b7.tacc.setZero();
            ++i;
        }
    }

    @Override
    public int dxEstimateMemoryRequirements(DxBody[] body, int bodyOfs, int nb, DxJoint[] _joint, int jointOfs, int _nj) {
        return -1;
    }

    @Override
    public void run(DxWorldProcessMemArena memarena, DxWorld world, DxBody[] body, int bodyOfs, int nb, DxJoint[] joint, int jointOfs, int nj, double stepsize) {
        DxQuickStep.dxQuickStepper(memarena, world, body, bodyOfs, nb, joint, jointOfs, nj, stepsize);
    }

    static class DJointWithInfo1 {
        DxJoint joint;
        final DxJoint.Info1 info = new DxJoint.Info1();

        DJointWithInfo1() {
        }
    }

    private static class IndexError {
        int index;

        private IndexError() {
        }
    }
}

