/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cmath;
import org.cpp4j.java.ObjArray;
import org.cpp4j.java.RefInt;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DAABBC;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DQuadTreeSpace;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DArray;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxSpace;

public class DxQuadTreeSpace
extends DxSpace
implements DQuadTreeSpace {
    private static final int AXIS0 = 0;
    private static final int AXIS1 = 1;
    private static final boolean DRAWBLOCKS = false;
    private static final int SPLITAXIS = 2;
    private static final int SPLITS = 4;
    private Block[] Blocks;
    private DArray<DxGeom> DirtyList = new DArray();
    Block CurrentBlock;
    int[] CurrentChild;
    int CurrentLevel;
    DxGeom CurrentObject;
    int CurrentIndex;
    private DGeom.DNearCallback swap_callback = new DGeom.DNearCallback(){

        void swap_callback(DataCallback data, DGeom g1, DGeom g2) {
            data.callback.call(data.data, g2, g1);
        }

        @Override
        public void call(Object data, DGeom o1, DGeom o2) {
            this.swap_callback((DataCallback)data, o1, o2);
        }
    };

    DxQuadTreeSpace(DxSpace _space, DVector3C Center, DVector3C Extents, int Depth) {
        super(_space);
        this.type = 13;
        int BlockCount = 0;
        int i = 0;
        while (i <= Depth) {
            BlockCount += (int)Cmath.pow(4.0, (double)i);
            ++i;
        }
        this.Blocks = new Block[BlockCount];
        i = 0;
        while (i < this.Blocks.length) {
            this.Blocks[i] = new Block();
            ++i;
        }
        Block[] BlocksA = this.Blocks;
        RefInt BlocksP = new RefInt(1);
        double MinX = Center.get(0) - Extents.get(0);
        double MaxX = Common.dNextAfter(Center.get(0) + Extents.get(0), Double.POSITIVE_INFINITY);
        double MinZ = Center.get(1) - Extents.get(1);
        double MaxZ = Common.dNextAfter(Center.get(1) + Extents.get(1), Double.POSITIVE_INFINITY);
        this.Blocks[0].Create(MinX, MaxX, MinZ, MaxZ, null, Depth, BlocksA, BlocksP);
        this.CurrentBlock = null;
        this.CurrentChild = new int[Depth + 1];
        this.CurrentLevel = 0;
        this.CurrentObject = null;
        this.CurrentIndex = -1;
        this._aabb.set(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public void DESTRUCTOR() {
        int Depth = 0;
        Block Current = this.Blocks[0];
        while (Current != null && Current.mChildren != null) {
            ++Depth;
            Current = Current.mChildren.at(0);
        }
        int BlockCount = 0;
        int i = 0;
        while (i < Depth) {
            BlockCount += (int)Cmath.pow(4.0, (double)i);
            ++i;
        }
        super.DESTRUCTOR();
    }

    @Override
    public DxGeom getGeom(int Index) {
        Common.dUASSERT(Index >= 0 && Index < this.count, "index out of range");
        Common.dDebug(0, "dxQuadTreeSpace::getGeom() not yet implemented", new Object[0]);
        return null;
    }

    @Override
    void add(DxGeom g) {
        DxQuadTreeSpace.CHECK_NOT_LOCKED(this);
        Common.dAASSERT(g);
        Common.dUASSERT(g.parent_space == null && g.getNext() == null, "geom is already in a space");
        g.setFlagDirtyAndBad();
        this.DirtyList.push(g);
        g.parent_space = this;
        this.Blocks[0].GetBlock(g._aabb).AddObject(g);
        ++this.count;
        this.current_geom = null;
        this.dGeomMoved();
    }

    @Override
    void remove(DxGeom g) {
        DxQuadTreeSpace.CHECK_NOT_LOCKED(this);
        Common.dAASSERT(g);
        Common.dUASSERT(g.parent_space == this, "object is not in this space");
        g._qtIdx.DelObject(g);
        --this.count;
        int i = 0;
        while (i < this.DirtyList.size()) {
            if (this.DirtyList.get(i) == g) {
                this.DirtyList.remove(i);
                --i;
            }
            ++i;
        }
        g.parent_space = null;
        this.current_geom = null;
        this.dGeomMoved();
    }

    @Override
    void dirty(DxGeom g) {
        this.DirtyList.push(g);
    }

    @Override
    void computeAABB() {
    }

    @Override
    public void cleanGeoms() {
        ++this.lock_count;
        int i = 0;
        while (i < this.DirtyList.size()) {
            DxGeom g = this.DirtyList.get(i);
            if (g instanceof DxSpace) {
                ((DxSpace)g).cleanGeoms();
            }
            g.recomputeAABB();
            g.unsetFlagDirtyAndBad();
            g._qtIdx.Traverse(g);
            ++i;
        }
        this.DirtyList.setSize(0);
        --this.lock_count;
    }

    @Override
    public void collide(Object UserData, DGeom.DNearCallback Callback) {
        Common.dAASSERT(Callback);
        ++this.lock_count;
        this.cleanGeoms();
        this.Blocks[0].Collide(UserData, Callback);
        --this.lock_count;
    }

    @Override
    void collide2(Object UserData, DxGeom g2, DGeom.DNearCallback Callback) {
        Common.dAASSERT(g2, Callback);
        ++this.lock_count;
        this.cleanGeoms();
        g2.recomputeAABB();
        if (g2.parent_space == this) {
            Block CurrentBlock = g2._qtIdx;
            DataCallback dc = new DataCallback(UserData, Callback);
            CurrentBlock.Collide(g2, CurrentBlock.mFirst, dc, this.swap_callback);
            while ((CurrentBlock = CurrentBlock.mParent) != null) {
                CurrentBlock.CollideLocal(g2, UserData, Callback);
            }
        } else {
            DataCallback dc = new DataCallback(UserData, Callback);
            this.Blocks[0].Collide(g2, this.Blocks[0].mFirst, dc, this.swap_callback);
        }
        --this.lock_count;
    }

    public static DxQuadTreeSpace dQuadTreeSpaceCreate(DxSpace space, DVector3C Center, DVector3C Extents, int Depth) {
        return new DxQuadTreeSpace(space, Center, Extents, Depth);
    }

    class Block {
        double mMinX;
        double mMaxX;
        double mMinZ;
        double mMaxZ;
        DxGeom mFirst;
        int mGeomCount;
        Block mParent;
        ObjArray<Block> mChildren;

        Block() {
        }

        void DrawBlock(Block Block2) {
            throw new UnsupportedOperationException();
        }

        void Create(double MinX, double MaxX, double MinZ, double MaxZ, Block Parent, int Depth, Block[] BlocksA, RefInt BlocksP) {
            Common.dIASSERT(MinX <= MaxX);
            Common.dIASSERT(MinZ <= MaxZ);
            this.mGeomCount = 0;
            this.mFirst = null;
            this.mMinX = MinX;
            this.mMaxX = MaxX;
            this.mMinZ = MinZ;
            this.mMaxZ = MaxZ;
            this.mParent = Parent;
            if (Depth > 0) {
                this.mChildren = new ObjArray<Block>(DxQuadTreeSpace.this.Blocks, BlocksP.get());
                BlocksP.add(4);
                double ChildExtentX = (MaxX - MinX) / 2.0;
                double ChildExtentZ = (MaxZ - MinZ) / 2.0;
                int ChildDepth = Depth - 1;
                int Index = 0;
                double ChildRightX = MinX;
                int i = 0;
                while (i < 2) {
                    double ChildLeftX = ChildRightX;
                    ChildRightX = i != 1 ? ChildLeftX + ChildExtentX : MaxX;
                    double ChildRightZ = MinZ;
                    int j = 0;
                    while (j < 2) {
                        double ChildLeftZ = ChildRightZ;
                        ChildRightZ = j != 1 ? ChildLeftZ + ChildExtentZ : MaxZ;
                        this.mChildren.at(Index).Create(ChildLeftX, ChildRightX, ChildLeftZ, ChildRightZ, this, ChildDepth, BlocksA, BlocksP);
                        ++Index;
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.mChildren = null;
            }
        }

        void Collide(Object UserData, DGeom.DNearCallback Callback) {
            DxGeom g = this.mFirst;
            while (g != null) {
                if (DxQuadTreeSpace.this.GEOM_ENABLED(g)) {
                    this.Collide(g, g.getNext(), UserData, Callback);
                }
                g = g.getNext();
            }
            if (this.mChildren != null) {
                int i = 0;
                while (i < 4) {
                    Block CurrentChild = this.mChildren.at(i);
                    if (CurrentChild.mGeomCount > 1) {
                        CurrentChild.Collide(UserData, Callback);
                    }
                    ++i;
                }
            }
        }

        void Collide(DxGeom g1, DxGeom g2, Object UserData, DGeom.DNearCallback Callback) {
            while (g2 != null) {
                if (DxQuadTreeSpace.this.GEOM_ENABLED(g2)) {
                    DxQuadTreeSpace.collideAABBs(g1, g2, UserData, Callback);
                }
                g2 = g2.getNext();
            }
            if (this.mChildren != null) {
                int i = 0;
                while (i < 4) {
                    Block CurrentChild = this.mChildren.at(i);
                    if (!(CurrentChild.mGeomCount == 0 || CurrentChild.mGeomCount != 1 && (g1._aabb.getMin(0) >= CurrentChild.mMaxX || g1._aabb.getMax(0) < CurrentChild.mMinX || g1._aabb.getMin(1) >= CurrentChild.mMaxZ || g1._aabb.getMax(1) < CurrentChild.mMinZ))) {
                        CurrentChild.Collide(g1, CurrentChild.mFirst, UserData, Callback);
                    }
                    ++i;
                }
            }
        }

        void CollideLocal(DxGeom g2, Object userData, DGeom.DNearCallback callback) {
            DxGeom g1 = this.mFirst;
            while (g1 != null) {
                if (DxQuadTreeSpace.this.GEOM_ENABLED(g1)) {
                    DxQuadTreeSpace.collideAABBs(g1, g2, userData, callback);
                }
                g1 = g1.getNext();
            }
        }

        void AddObject(DxGeom aObject) {
            aObject._next = this.mFirst;
            this.mFirst = aObject;
            aObject._qtIdx = this;
            Block Block2 = this;
            do {
                ++Block2.mGeomCount;
            } while ((Block2 = Block2.mParent) != null);
        }

        void DelObject(DxGeom aObject) {
            DxGeom g = this.mFirst;
            DxGeom Last = null;
            while (g != null) {
                if (g == aObject) {
                    if (Last != null) {
                        Last._next = g._next;
                        break;
                    }
                    this.mFirst = g.getNext();
                    break;
                }
                Last = g;
                g = g.getNext();
            }
            aObject._qtIdx = null;
            Block Block2 = this;
            do {
                --Block2.mGeomCount;
            } while ((Block2 = Block2.mParent) != null);
        }

        void Traverse(DxGeom aObject) {
            Block NewBlock = this.GetBlock(aObject._aabb);
            if (NewBlock != this) {
                this.DelObject(aObject);
                NewBlock.AddObject(aObject);
            }
        }

        boolean Inside(DAABBC AABB) {
            return AABB.getMin(0) >= this.mMinX && AABB.getMax(0) < this.mMaxX && AABB.getMin(1) >= this.mMinZ && AABB.getMax(1) < this.mMaxZ;
        }

        Block GetBlock(DAABBC AABB) {
            if (this.Inside(AABB)) {
                return this.GetBlockChild(AABB);
            }
            if (this.mParent != null) {
                return this.mParent.GetBlock(AABB);
            }
            return this;
        }

        Block GetBlockChild(DAABBC AABB) {
            if (this.mChildren != null) {
                int i = 0;
                while (i < 4) {
                    Block CurrentChild = this.mChildren.at(i);
                    if (CurrentChild.Inside(AABB)) {
                        return CurrentChild.GetBlockChild(AABB);
                    }
                    ++i;
                }
            }
            return this;
        }
    }

    private static class DataCallback {
        Object data;
        DGeom.DNearCallback callback;

        public DataCallback(Object userData, DGeom.DNearCallback callback2) {
            this.data = userData;
            this.callback = callback2;
        }
    }
}

