/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.math.DVector4;
import org.ode4j.ode.DPlane;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxSpace;

public class DxPlane
extends DxGeom
implements DPlane {
    private DVector3 _pV = new DVector3();
    private double _pD = 0.0;

    private void make_sure_plane_normal_has_unit_length() {
        double l = this._pV.lengthSquared();
        if (l > 0.0) {
            l = Common.dRecipSqrt(l);
            this._pV.scale(l);
            this._pD *= l;
        } else {
            this._pV.set(1.0, 0.0, 0.0);
            this._pD = 0.0;
        }
    }

    DxPlane(DxSpace space, double a, double b, double c, double d) {
        super(space, false);
        this.type = 4;
        this._pV.set(a, b, c);
        this._pD = d;
        this.make_sure_plane_normal_has_unit_length();
    }

    @Override
    void computeAABB() {
        this._aabb.setToInfinity();
        if (this._pV.get1() == 0.0 && this._pV.get2() == 0.0) {
            this._aabb.setMin0(this._pV.get0() > 0.0 ? Double.NEGATIVE_INFINITY : -this._pD);
            this._aabb.setMax0(this._pV.get0() > 0.0 ? this._pD : Double.POSITIVE_INFINITY);
        } else if (this._pV.get0() == 0.0 && this._pV.get2() == 0.0) {
            this._aabb.setMin1(this._pV.get1() > 0.0 ? Double.NEGATIVE_INFINITY : -this._pD);
            this._aabb.setMax1(this._pV.get1() > 0.0 ? this._pD : Double.POSITIVE_INFINITY);
        } else if (this._pV.get0() == 0.0 && this._pV.get1() == 0.0) {
            this._aabb.setMin2(this._pV.get2() > 0.0 ? Double.NEGATIVE_INFINITY : -this._pD);
            this._aabb.setMax2(this._pV.get2() > 0.0 ? this._pD : Double.POSITIVE_INFINITY);
        }
    }

    public static DxPlane dCreatePlane(DxSpace space, double a, double b, double c, double d) {
        return new DxPlane(space, a, b, c, d);
    }

    public void dGeomPlaneSetParams(double a, double b, double c, double d) {
        this._pV.set(a, b, c);
        this._pD = d;
        this.make_sure_plane_normal_has_unit_length();
        this.dGeomMoved();
    }

    public void dGeomPlaneGetParams(DVector4 result) {
        result.set(this._pV.get0(), this._pV.get1(), this._pV.get2(), this._pD);
    }

    public double dGeomPlanePointDepth(double x, double y, double z) {
        return this._pD - this._pV.get0() * x - this._pV.get1() * y - this._pV.get2() * z;
    }

    @Override
    public double getPointDepth(DVector3C p) {
        return this._pD - this._pV.dot(p);
    }

    @Override
    public DVector3C getNormal() {
        return this._pV;
    }

    @Override
    public double getDepth() {
        return this._pD;
    }

    @Override
    public void setParams(double a, double b, double c, double d) {
        this.dGeomPlaneSetParams(a, b, c, d);
    }

    @Override
    public void setParams(DVector3C abc, double d) {
        this.dGeomPlaneSetParams(abc.get0(), abc.get1(), abc.get2(), d);
    }

    public void getParams(DVector4 result) {
        this.dGeomPlaneGetParams(result);
    }

    @Override
    public DVector3C getPosition() {
        throw new UnsupportedOperationException("ERROR: getPosition() is not supported for Planes.");
    }

    @Override
    public DMatrix3C getRotation() {
        throw new UnsupportedOperationException("ERROR: getRotation() is not supported for Planes.");
    }
}

