/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.FormattedStringBuilder;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DMass;
import org.ode4j.ode.DMassC;
import org.ode4j.ode.DTriMesh;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxTriMesh;
import org.ode4j.ode.internal.Matrix;

public class DxMass
implements DMass {
    double _mass;
    DVector3 _c = new DVector3();
    DMatrix3 _I = new DMatrix3();

    private double SQR(double x) {
        return x * x;
    }

    private double CUBE(double x) {
        return x * x * x;
    }

    public DxMass() {
        this.dMassSetZero();
    }

    public boolean dMassCheck() {
        if (this._mass <= 0.0) {
            Common.dDEBUGMSG("mass must be > 0 but is " + this._mass);
            return false;
        }
        if (!Matrix.dIsPositiveDefinite(this._I)) {
            Common.dDEBUGMSG("inertia must be positive definite");
            return false;
        }
        DMatrix3 I2 = new DMatrix3();
        DMatrix3 chat = new DMatrix3();
        OdeMath.dSetCrossMatrixPlus(chat, this._c);
        OdeMath.dMultiply0_333(I2, chat, chat);
        I2.scale(this._mass);
        I2.add(this._I);
        if (!Matrix.dIsPositiveDefinite(I2)) {
            Common.dDEBUGMSG("center of mass inconsistent with mass parameters");
            return false;
        }
        return true;
    }

    public void dMassSetZero() {
        this._mass = 0.0;
        this._c.setZero();
        this._I.setZero();
    }

    public void dMassSetParameters(double themass, double cgx, double cgy, double cgz, double I11, double I22, double I33, double I12, double I13, double I23) {
        this.dMassSetZero();
        this._mass = themass;
        this._c.set(cgx, cgy, cgz);
        this._I.set(I11, I12, I13, I12, I22, I23, I13, I23, I33);
        this.dMassCheck();
    }

    public void dMassSetSphere(double density, double radius) {
        this.dMassSetSphereTotal(4.1887902047863905 * radius * radius * radius * density, radius);
    }

    public void dMassSetSphereTotal(double total_mass, double radius) {
        this.dMassSetZero();
        this._mass = total_mass;
        double II = 0.4 * total_mass * radius * radius;
        this._I.set00(II);
        this._I.set11(II);
        this._I.set22(II);
        this.dMassCheck();
    }

    public void dMassSetCapsule(double density, int direction, double radius, double length) {
        Common.dUASSERT(direction >= 1 && direction <= 3, "bad direction number");
        this.dMassSetZero();
        double M1 = Math.PI * radius * radius * length * density;
        double M2 = 4.1887902047863905 * radius * radius * radius * density;
        this._mass = M1 + M2;
        double Ia = M1 * (0.25 * radius * radius + 0.08333333333333333 * length * length) + M2 * (0.4 * radius * radius + 0.375 * radius * length + 0.25 * length * length);
        double Ib = (M1 * 0.5 + M2 * 0.4) * radius * radius;
        this._I.set00(Ia);
        this._I.set11(Ia);
        this._I.set22(Ia);
        this._I.set(direction - 1, direction - 1, Ib);
        this.dMassCheck();
    }

    public void dMassSetCapsuleTotal(double total_mass, int direction, double radius, double length) {
        this.dMassSetCapsule(1.0, direction, radius, length);
        this.dMassAdjust(total_mass);
    }

    public void dMassSetCylinder(double density, int direction, double radius, double length) {
        this.dMassSetCylinderTotal(Math.PI * radius * radius * length * density, direction, radius, length);
    }

    public void dMassSetCylinderTotal(double total_mass, int direction, double radius, double length) {
        Common.dUASSERT(direction >= 1 && direction <= 3, "bad direction number");
        this.dMassSetZero();
        double r2 = radius * radius;
        this._mass = total_mass;
        double I = total_mass * (0.25 * r2 + 0.08333333333333333 * length * length);
        this._I.set00(I);
        this._I.set11(I);
        this._I.set22(I);
        this._I.set(direction - 1, direction - 1, total_mass * 0.5 * r2);
        this.dMassCheck();
    }

    public void dMassSetBox(double density, double lx, double ly, double lz) {
        this.dMassSetBoxTotal(lx * ly * lz * density, lx, ly, lz);
    }

    public void dMassSetBoxTotal(double total_mass, double lx, double ly, double lz) {
        this.dMassSetZero();
        this._mass = total_mass;
        this._I.set00(total_mass / 12.0 * (ly * ly + lz * lz));
        this._I.set11(total_mass / 12.0 * (lx * lx + lz * lz));
        this._I.set22(total_mass / 12.0 * (lx * lx + ly * ly));
        this.dMassCheck();
    }

    public void dMassSetTrimesh(double density, DTriMesh g) {
        Common.dUASSERT(g != null, "argument not a trimesh");
        this.dMassSetZero();
        DxTriMesh TriMesh = (DxTriMesh)g;
        int triangles = TriMesh.FetchTriangleCount();
        double T0 = 0.0;
        double[] T1 = new double[]{0.0, 0.0, 0.0};
        double[] T2 = new double[]{0.0, 0.0, 0.0};
        double[] TP = new double[]{0.0, 0.0, 0.0};
        int i = 0;
        while (i < triangles) {
            int C;
            DVector3[] v = new DVector3[]{new DVector3(), new DVector3(), new DVector3()};
            TriMesh.FetchTransformedTriangle(i, v);
            DVector3 n = new DVector3();
            DVector3 a = new DVector3();
            DVector3 b = new DVector3();
            a.eqDiff(v[1], v[0]);
            b.eqDiff(v[2], v[0]);
            OdeMath.dCalcVectorCross3(n, b, a);
            double nx = Math.abs(n.get0());
            double ny = Math.abs(n.get1());
            double nz = Math.abs(n.get2());
            if (nx > ny && nx > nz) {
                C = 0;
            } else {
                int n2 = C = ny > nz ? 1 : 2;
            }
            if (n.get(C) != 0.0) {
                int A = (C + 1) % 3;
                int B = (A + 1) % 3;
                double a0 = 0.0;
                double a1 = 0.0;
                double b0 = 0.0;
                double b1 = 0.0;
                double Pbbb = 0.0;
                double Pabb = 0.0;
                double Paab = 0.0;
                double Paaa = 0.0;
                double Pbb = 0.0;
                double Pab = 0.0;
                double Paa = 0.0;
                double Pb = 0.0;
                double Pa = 0.0;
                double P1 = 0.0;
                int j = 0;
                while (j < 3) {
                    switch (j) {
                        case 0: {
                            a0 = v[0].get(A);
                            b0 = v[0].get(B);
                            a1 = v[1].get(A);
                            b1 = v[1].get(B);
                            break;
                        }
                        case 1: {
                            a0 = v[1].get(A);
                            b0 = v[1].get(B);
                            a1 = v[2].get(A);
                            b1 = v[2].get(B);
                            break;
                        }
                        case 2: {
                            a0 = v[2].get(A);
                            b0 = v[2].get(B);
                            a1 = v[0].get(A);
                            b1 = v[0].get(B);
                        }
                    }
                    double da = a1 - a0;
                    double db = b1 - b0;
                    double a0_2 = a0 * a0;
                    double a0_3 = a0_2 * a0;
                    double a0_4 = a0_3 * a0;
                    double b0_2 = b0 * b0;
                    double b0_3 = b0_2 * b0;
                    double b0_4 = b0_3 * b0;
                    double a1_2 = a1 * a1;
                    double a1_3 = a1_2 * a1;
                    double b1_2 = b1 * b1;
                    double b1_3 = b1_2 * b1;
                    double C1 = a1 + a0;
                    double Ca = a1 * C1 + a0_2;
                    double Caa = a1 * Ca + a0_3;
                    double Caaa = a1 * Caa + a0_4;
                    double Cb = b1 * (b1 + b0) + b0_2;
                    double Cbb = b1 * Cb + b0_3;
                    double Cbbb = b1 * Cbb + b0_4;
                    double Cab = 3.0 * a1_2 + 2.0 * a1 * a0 + a0_2;
                    double Kab = a1_2 + 2.0 * a1 * a0 + 3.0 * a0_2;
                    double Caab = a0 * Cab + 4.0 * a1_3;
                    double Kaab = a1 * Kab + 4.0 * a0_3;
                    double Cabb = 4.0 * b1_3 + 3.0 * b1_2 * b0 + 2.0 * b1 * b0_2 + b0_3;
                    double Kabb = b1_3 + 2.0 * b1_2 * b0 + 3.0 * b1 * b0_2 + 4.0 * b0_3;
                    P1 += db * C1;
                    Pa += db * Ca;
                    Paa += db * Caa;
                    Paaa += db * Caaa;
                    Pb += da * Cb;
                    Pbb += da * Cbb;
                    Pbbb += da * Cbbb;
                    Pab += db * (b1 * Cab + b0 * Kab);
                    Paab += db * (b1 * Caab + b0 * Kaab);
                    Pabb += da * (a1 * Cabb + a0 * Kabb);
                    ++j;
                }
                P1 /= 2.0;
                Pa /= 6.0;
                Paa /= 12.0;
                Paaa /= 20.0;
                Pb /= -6.0;
                Pbb /= -12.0;
                Pbbb /= -20.0;
                Pab /= 24.0;
                Paab /= 60.0;
                Pabb /= -60.0;
                double w = -n.dot(v[0]);
                double k1 = 1.0 / n.get(C);
                double k2 = k1 * k1;
                double k3 = k2 * k1;
                double k4 = k3 * k1;
                double Fa = k1 * Pa;
                double Fb = k1 * Pb;
                double Fc = -k2 * (n.get(A) * Pa + n.get(B) * Pb + w * P1);
                double Faa = k1 * Paa;
                double Fbb = k1 * Pbb;
                double Fcc = k3 * (this.SQR(n.get(A)) * Paa + 2.0 * n.get(A) * n.get(B) * Pab + this.SQR(n.get(B)) * Pbb + w * (2.0 * (n.get(A) * Pa + n.get(B) * Pb) + w * P1));
                double Faaa = k1 * Paaa;
                double Fbbb = k1 * Pbbb;
                double Fccc = -k4 * (this.CUBE(n.get(A)) * Paaa + 3.0 * this.SQR(n.get(A)) * n.get(B) * Paab + 3.0 * n.get(A) * this.SQR(n.get(B)) * Pabb + this.CUBE(n.get(B)) * Pbbb + 3.0 * w * (this.SQR(n.get(A)) * Paa + 2.0 * n.get(A) * n.get(B) * Pab + this.SQR(n.get(B)) * Pbb) + w * w * (3.0 * (n.get(A) * Pa + n.get(B) * Pb) + w * P1));
                double Faab = k1 * Paab;
                double Fbbc = -k2 * (n.get(A) * Pabb + n.get(B) * Pbbb + w * Pbb);
                double Fcca = k3 * (this.SQR(n.get(A)) * Paaa + 2.0 * n.get(A) * n.get(B) * Paab + this.SQR(n.get(B)) * Pabb + w * (2.0 * (n.get(A) * Paa + n.get(B) * Pab) + w * Pa));
                T0 += n.get0() * (A == 0 ? Fa : (B == 0 ? Fb : Fc));
                int n3 = A;
                T1[n3] = T1[n3] + n.get(A) * Faa;
                int n4 = B;
                T1[n4] = T1[n4] + n.get(B) * Fbb;
                int n5 = C;
                T1[n5] = T1[n5] + n.get(C) * Fcc;
                int n6 = A;
                T2[n6] = T2[n6] + n.get(A) * Faaa;
                int n7 = B;
                T2[n7] = T2[n7] + n.get(B) * Fbbb;
                int n8 = C;
                T2[n8] = T2[n8] + n.get(C) * Fccc;
                int n9 = A;
                TP[n9] = TP[n9] + n.get(A) * Faab;
                int n10 = B;
                TP[n10] = TP[n10] + n.get(B) * Fbbc;
                int n11 = C;
                TP[n11] = TP[n11] + n.get(C) * Fcca;
            }
            ++i;
        }
        T1[0] = T1[0] / 2.0;
        T1[1] = T1[1] / 2.0;
        T1[2] = T1[2] / 2.0;
        T2[0] = T2[0] / 3.0;
        T2[1] = T2[1] / 3.0;
        T2[2] = T2[2] / 3.0;
        TP[0] = TP[0] / 2.0;
        TP[1] = TP[1] / 2.0;
        TP[2] = TP[2] / 2.0;
        this._mass = density * T0;
        this._I.set00(density * (T2[1] + T2[2]));
        this._I.set11(density * (T2[2] + T2[0]));
        this._I.set22(density * (T2[0] + T2[1]));
        this._I.set01(-density * TP[0]);
        this._I.set10(-density * TP[0]);
        this._I.set21(-density * TP[1]);
        this._I.set12(-density * TP[1]);
        this._I.set20(-density * TP[2]);
        this._I.set02(-density * TP[2]);
        DVector3 vT = new DVector3(T1[0] / T0, T1[1] / T0, T1[2] / T0);
        this.dMassTranslate(vT);
        this.dMassCheck();
    }

    public void dMassSetTrimeshTotal(double total_mass, DTriMesh g) {
        Common.dUASSERT(g != null, "argument not a trimesh");
        this.dMassSetTrimesh(1.0, g);
        this.dMassAdjust(total_mass);
    }

    public void dMassAdjust(double newmass) {
        double scale = newmass / this._mass;
        this._mass = newmass;
        this._I.scale(scale);
        this.dMassCheck();
    }

    public void dMassTranslate(DVector3C xyz) {
        DMatrix3 ahat = new DMatrix3();
        DMatrix3 chat = new DMatrix3();
        DMatrix3 t1 = new DMatrix3();
        DMatrix3 t2 = new DMatrix3();
        OdeMath.dSetCrossMatrixPlus(chat, this._c);
        DVector3 a = new DVector3(xyz);
        a.add(this._c);
        OdeMath.dSetCrossMatrixPlus(ahat, a);
        OdeMath.dMultiply0_333(t1, ahat, ahat);
        OdeMath.dMultiply0_333(t2, chat, chat);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this._I.add(i, j, this._mass * (t2.get(i, j) - t1.get(i, j)));
                ++j;
            }
            ++i;
        }
        this._I.set10(this._I.get01());
        this._I.set20(this._I.get02());
        this._I.set21(this._I.get12());
        this._c.add(xyz);
        this.dMassCheck();
    }

    public void dMassRotate(DMatrix3C aR) {
        DMatrix3 t1 = new DMatrix3();
        DVector3 t2 = new DVector3();
        OdeMath.dMultiply2_333(t1, this._I, aR);
        OdeMath.dMultiply0_333(this._I, aR, t1);
        this._I.set10(this._I.get01());
        this._I.set20(this._I.get02());
        this._I.set21(this._I.get12());
        OdeMath.dMultiply0_331(t2, aR, (DVector3C)this._c);
        this._c.set(t2);
        this.dMassCheck();
    }

    public void dMassAdd(DMassC b) {
        Common.dAASSERT(b);
        double denom = Common.dRecip(this._mass + b.getMass());
        this._c.eqSum(this._c, this._mass, b.getC(), b.getMass()).scale(denom);
        this._mass += b.getMass();
        this._I.add(b.getI());
    }

    void set(DMassC m) {
        this._mass = m.getMass();
        this._c = new DVector3(m.getC());
        this._I = new DMatrix3(m.getI());
    }

    public String toString() {
        FormattedStringBuilder b = new FormattedStringBuilder();
        b.appendln("Mass = " + this._mass);
        b.appendln("c = ", this._c.toString());
        b.appendln("I = ", this._I.toString());
        return b.toString();
    }

    @Override
    public void setZero() {
        this.dMassSetZero();
    }

    @Override
    public void setParameters(double themass, double cgx, double cgy, double cgz, double I11, double I22, double I33, double I12, double I13, double I23) {
        this.dMassSetParameters(themass, cgx, cgy, cgz, I11, I22, I33, I12, I13, I23);
    }

    @Override
    public void setSphere(double density, double radius) {
        this.dMassSetSphere(density, radius);
    }

    @Override
    public void setSphereTotal(double total, double radius) {
        this.dMassSetSphereTotal(total, radius);
    }

    @Override
    public void setCapsule(double density, int direction, double radius, double length) {
        this.dMassSetCapsule(density, direction, radius, length);
    }

    @Override
    public void setCapsuleTotal(double total, int direction, double radius, double length) {
        this.dMassSetCapsuleTotal(total, direction, radius, length);
    }

    @Override
    public void setCylinder(double density, int direction, double radius, double length) {
        this.dMassSetCylinder(density, direction, radius, length);
    }

    @Override
    public void setCylinderTotal(double total, int direction, double radius, double length) {
        this.dMassSetCylinderTotal(total, direction, radius, length);
    }

    @Override
    public void setBox(double density, double lx, double ly, double lz) {
        this.dMassSetBox(density, lx, ly, lz);
    }

    @Override
    public void setBoxTotal(double total, double lx, double ly, double lz) {
        this.dMassSetBoxTotal(total, lx, ly, lz);
    }

    @Override
    public void setTrimesh(double density, DTriMesh geom) {
        this.dMassSetTrimesh(density, geom);
    }

    @Override
    public void setTrimeshTotal(double total, DTriMesh geom) {
        this.dMassSetTrimeshTotal(total, geom);
    }

    @Override
    public void adjust(double newmass) {
        this.dMassAdjust(newmass);
    }

    @Override
    public void translate(double x, double y, double z) {
        this.dMassTranslate(new DVector3(x, y, z));
    }

    @Override
    public void translate(DVector3C xyz) {
        this.dMassTranslate(xyz);
    }

    @Override
    public void rotate(DMatrix3C R) {
        this.dMassRotate(R);
    }

    @Override
    public void add(DMassC b) {
        this.dMassAdd((DxMass)b);
    }

    @Override
    public DVector3C getC() {
        return this._c;
    }

    @Override
    public double getMass() {
        return this._mass;
    }

    @Override
    public void setMass(double d) {
        this._mass = d;
    }

    @Override
    public DMatrix3C getI() {
        return this._I;
    }

    @Override
    public void setC(DVector3C c) {
        this._c.set(c);
    }

    @Override
    public void setI(DMatrix3C I) {
        this._I.set(I);
    }

    @Override
    public boolean check() {
        return this.dMassCheck();
    }
}

