/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import java.util.Arrays;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DHeightfield;
import org.ode4j.ode.DHeightfieldData;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxHeightfield;

public class DxHeightfieldData
implements DHeightfieldData {
    double m_fWidth = 0.0;
    double m_fDepth = 0.0;
    double m_fSampleWidth = 0.0;
    double m_fSampleDepth = 0.0;
    double m_fSampleZXAspect = 0.0;
    double m_fInvSampleWidth = 0.0;
    double m_fInvSampleDepth = 0.0;
    double m_fHalfWidth = 0.0;
    double m_fHalfDepth = 0.0;
    double m_fMinHeight = 0.0;
    double m_fMaxHeight = 0.0;
    double m_fThickness = 0.0;
    double m_fScale = 0.0;
    double m_fOffset = 0.0;
    int m_nWidthSamples = 0;
    int m_nDepthSamples = 0;
    boolean m_bCopyHeightData = false;
    boolean m_bWrapMode = false;
    int m_nGetHeightMode = 0;
    Object m_pHeightData = null;
    Object m_pUserData = null;
    DContactGeomBuffer m_contacts = new DContactGeomBuffer(10);
    DHeightfield.DHeightfieldGetHeight m_pGetHeightCallback = null;

    DxHeightfieldData() {
    }

    void SetData(int nWidthSamples, int nDepthSamples, double fWidth, double fDepth, double fScale, double fOffset, double fThickness, boolean bWrapMode) {
        Common.dIASSERT(fWidth > 0.0);
        Common.dIASSERT(fDepth > 0.0);
        Common.dIASSERT(nWidthSamples > 0);
        Common.dIASSERT(nDepthSamples > 0);
        this.m_fWidth = fWidth;
        this.m_fDepth = fDepth;
        this.m_fHalfWidth = fWidth / 2.0;
        this.m_fHalfDepth = fDepth / 2.0;
        this.m_fScale = fScale;
        this.m_fOffset = fOffset;
        this.m_fThickness = fThickness;
        this.m_nWidthSamples = nWidthSamples;
        this.m_nDepthSamples = nDepthSamples;
        this.m_fSampleWidth = this.m_fWidth / ((double)this.m_nWidthSamples - 1.0);
        this.m_fSampleDepth = this.m_fDepth / ((double)this.m_nDepthSamples - 1.0);
        this.m_fSampleZXAspect = this.m_fSampleDepth / this.m_fSampleWidth;
        this.m_fInvSampleWidth = 1.0 / this.m_fSampleWidth;
        this.m_fInvSampleDepth = 1.0 / this.m_fSampleDepth;
        this.m_bWrapMode = bWrapMode;
    }

    void ComputeHeightBounds() {
        switch (this.m_nGetHeightMode) {
            case 0: {
                return;
            }
            case 1: {
                byte[] data_byte = (byte[])this.m_pHeightData;
                this.m_fMinHeight = Double.POSITIVE_INFINITY;
                this.m_fMaxHeight = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < this.m_nWidthSamples * this.m_nDepthSamples) {
                    double h = data_byte[i];
                    if (h < this.m_fMinHeight) {
                        this.m_fMinHeight = h;
                    }
                    if (h > this.m_fMaxHeight) {
                        this.m_fMaxHeight = h;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                short[] data_short = (short[])this.m_pHeightData;
                this.m_fMinHeight = Double.POSITIVE_INFINITY;
                this.m_fMaxHeight = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < this.m_nWidthSamples * this.m_nDepthSamples) {
                    double h = data_short[i];
                    if (h < this.m_fMinHeight) {
                        this.m_fMinHeight = h;
                    }
                    if (h > this.m_fMaxHeight) {
                        this.m_fMaxHeight = h;
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                float[] data_float = (float[])this.m_pHeightData;
                this.m_fMinHeight = Double.POSITIVE_INFINITY;
                this.m_fMaxHeight = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < this.m_nWidthSamples * this.m_nDepthSamples) {
                    double h = data_float[i];
                    if (h < this.m_fMinHeight) {
                        this.m_fMinHeight = h;
                    }
                    if (h > this.m_fMaxHeight) {
                        this.m_fMaxHeight = h;
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                double[] data_double = (double[])this.m_pHeightData;
                this.m_fMinHeight = Double.POSITIVE_INFINITY;
                this.m_fMaxHeight = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < this.m_nWidthSamples * this.m_nDepthSamples) {
                    double h = data_double[i];
                    if (h < this.m_fMinHeight) {
                        this.m_fMinHeight = h;
                    }
                    if (h > this.m_fMaxHeight) {
                        this.m_fMaxHeight = h;
                    }
                    ++i;
                }
                break;
            }
        }
        this.m_fMinHeight *= this.m_fScale;
        this.m_fMaxHeight *= this.m_fScale;
        this.m_fMinHeight += this.m_fOffset;
        this.m_fMaxHeight += this.m_fOffset;
        this.m_fMinHeight -= this.m_fThickness;
    }

    boolean IsOnHeightfield2(DxHeightfield.HeightFieldVertex CellCorner, DVector3C pos, boolean isABC) {
        if (isABC) {
            double MinX = CellCorner.vertex.get0();
            if (pos.get0() < MinX) {
                return false;
            }
            double MaxX = (double)(CellCorner.coords0 + 1) * this.m_fSampleWidth;
            if (pos.get0() >= MaxX) {
                return false;
            }
            double MinZ = CellCorner.vertex.get2();
            if (pos.get2() < MinZ) {
                return false;
            }
            double MaxZ = (double)(CellCorner.coords1 + 1) * this.m_fSampleDepth;
            if (pos.get2() >= MaxZ) {
                return false;
            }
            return MaxZ - pos.get2() > (pos.get0() - MinX) * this.m_fSampleZXAspect;
        }
        double MaxX = CellCorner.vertex.get0();
        if (pos.get0() >= MaxX) {
            return false;
        }
        double MinX = (double)(CellCorner.coords0 - 1) * this.m_fSampleWidth;
        if (pos.get0() < MinX) {
            return false;
        }
        double MaxZ = CellCorner.vertex.get2();
        if (pos.get2() >= MaxZ) {
            return false;
        }
        double MinZ = (double)(CellCorner.coords1 - 1) * this.m_fSampleDepth;
        if (pos.get2() < MinZ) {
            return false;
        }
        return MaxZ - pos.get2() <= (pos.get0() - MinX) * this.m_fSampleZXAspect;
    }

    double GetHeight(int x, int z) {
        double h = 0.0;
        if (!this.m_bWrapMode) {
            if (x < 0) {
                x = 0;
            }
            if (z < 0) {
                z = 0;
            }
            if (x > this.m_nWidthSamples - 1) {
                x = this.m_nWidthSamples - 1;
            }
            if (z > this.m_nDepthSamples - 1) {
                z = this.m_nDepthSamples - 1;
            }
        } else {
            z %= this.m_nDepthSamples - 1;
            if ((x %= this.m_nWidthSamples - 1) < 0) {
                x += this.m_nWidthSamples - 1;
            }
            if (z < 0) {
                z += this.m_nDepthSamples - 1;
            }
        }
        switch (this.m_nGetHeightMode) {
            case 0: {
                h = this.m_pGetHeightCallback.call(this.m_pUserData, x, z);
                break;
            }
            case 1: {
                byte[] data_byte = (byte[])this.m_pHeightData;
                h = data_byte[x + z * this.m_nWidthSamples];
                break;
            }
            case 2: {
                short[] data_short = (short[])this.m_pHeightData;
                h = data_short[x + z * this.m_nWidthSamples];
                break;
            }
            case 3: {
                float[] data_float = (float[])this.m_pHeightData;
                h = data_float[x + z * this.m_nWidthSamples];
                break;
            }
            case 4: {
                double[] data_double = (double[])this.m_pHeightData;
                h = data_double[x + z * this.m_nWidthSamples];
            }
        }
        return h * this.m_fScale + this.m_fOffset;
    }

    void DESTRUCTOR() {
    }

    public static DHeightfieldData dGeomHeightfieldDataCreate() {
        return new DxHeightfieldData();
    }

    public void dGeomHeightfieldDataBuildCallback(Object pUserData, DHeightfield.DHeightfieldGetHeight pCallback, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean bWrap) {
        Common.dIASSERT(pCallback != null);
        Common.dIASSERT(widthSamples >= 2);
        Common.dIASSERT(depthSamples >= 2);
        this.m_nGetHeightMode = 0;
        this.m_pUserData = pUserData;
        this.m_pGetHeightCallback = pCallback;
        this.SetData(widthSamples, depthSamples, width, depth, scale, offset, thickness, bWrap);
        this.m_fMinHeight = Double.NEGATIVE_INFINITY;
        this.m_fMaxHeight = Double.POSITIVE_INFINITY;
    }

    void dGeomHeightfieldDataBuildByte(byte[] pHeightData, boolean bCopyHeightData, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean bWrap) {
        Common.dIASSERT(pHeightData != null);
        Common.dIASSERT(widthSamples >= 2);
        Common.dIASSERT(depthSamples >= 2);
        this.SetData(widthSamples, depthSamples, width, depth, scale, offset, thickness, bWrap);
        this.m_nGetHeightMode = 1;
        this.m_bCopyHeightData = bCopyHeightData;
        this.m_pHeightData = !this.m_bCopyHeightData ? (Object)pHeightData : (Object)Arrays.copyOf(pHeightData, this.m_nWidthSamples * this.m_nDepthSamples);
        this.ComputeHeightBounds();
    }

    void dGeomHeightfieldDataBuildShort(short[] pHeightData, boolean bCopyHeightData, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean bWrap) {
        Common.dIASSERT(pHeightData != null);
        Common.dIASSERT(widthSamples >= 2);
        Common.dIASSERT(depthSamples >= 2);
        this.SetData(widthSamples, depthSamples, width, depth, scale, offset, thickness, bWrap);
        this.m_nGetHeightMode = 2;
        this.m_bCopyHeightData = bCopyHeightData;
        this.m_pHeightData = !this.m_bCopyHeightData ? (Object)pHeightData : (Object)Arrays.copyOf(pHeightData, this.m_nWidthSamples * this.m_nDepthSamples);
        this.ComputeHeightBounds();
    }

    void dGeomHeightfieldDataBuildSingle(float[] pHeightData, boolean bCopyHeightData, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean bWrap) {
        Common.dIASSERT(pHeightData != null);
        Common.dIASSERT(widthSamples >= 2);
        Common.dIASSERT(depthSamples >= 2);
        this.SetData(widthSamples, depthSamples, width, depth, scale, offset, thickness, bWrap);
        this.m_nGetHeightMode = 3;
        this.m_bCopyHeightData = bCopyHeightData;
        this.m_pHeightData = !this.m_bCopyHeightData ? (Object)pHeightData : (Object)Arrays.copyOf(pHeightData, this.m_nWidthSamples * this.m_nDepthSamples);
        this.ComputeHeightBounds();
    }

    void dGeomHeightfieldDataBuildDouble(double[] pHeightData, boolean bCopyHeightData, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean bWrap) {
        Common.dIASSERT(pHeightData != null);
        Common.dIASSERT(widthSamples >= 2);
        Common.dIASSERT(depthSamples >= 2);
        this.SetData(widthSamples, depthSamples, width, depth, scale, offset, thickness, bWrap);
        this.m_nGetHeightMode = 4;
        this.m_bCopyHeightData = bCopyHeightData;
        this.m_pHeightData = !this.m_bCopyHeightData ? (Object)pHeightData : (Object)Arrays.copyOf(pHeightData, this.m_nWidthSamples * this.m_nDepthSamples);
        this.ComputeHeightBounds();
    }

    public void dGeomHeightfieldDataSetBounds(double minHeight, double maxHeight) {
        this.m_fMinHeight = minHeight * this.m_fScale + this.m_fOffset - this.m_fThickness;
        this.m_fMaxHeight = maxHeight * this.m_fScale + this.m_fOffset;
    }

    public void dGeomHeightfieldDataDestroy() {
        this.DESTRUCTOR();
    }

    @Override
    public void destroy() {
        this.dGeomHeightfieldDataDestroy();
    }

    @Override
    public void setBounds(double minHeight, double maxHeight) {
        this.dGeomHeightfieldDataSetBounds(minHeight, maxHeight);
    }

    @Override
    public void buildCallback(Object userData, DHeightfield.DHeightfieldGetHeight callback, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean wrap) {
        this.dGeomHeightfieldDataBuildCallback(userData, callback, width, depth, widthSamples, depthSamples, scale, offset, thickness, wrap);
    }

    @Override
    public void buildByte(byte[] pHeightData, boolean bCopyHeightData, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean bWrap) {
        this.build(pHeightData, bCopyHeightData, width, depth, widthSamples, depthSamples, scale, offset, thickness, bWrap);
    }

    @Override
    public void build(byte[] pHeightData, boolean bCopyHeightData, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean bWrap) {
        this.dGeomHeightfieldDataBuildByte(pHeightData, bCopyHeightData, width, depth, widthSamples, depthSamples, scale, offset, thickness, bWrap);
    }

    @Override
    public void build(short[] pHeightData, boolean bCopyHeightData, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean bWrap) {
        this.dGeomHeightfieldDataBuildShort(pHeightData, bCopyHeightData, width, depth, widthSamples, depthSamples, scale, offset, thickness, bWrap);
    }

    @Override
    public void build(float[] pHeightData, boolean bCopyHeightData, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean bWrap) {
        this.dGeomHeightfieldDataBuildSingle(pHeightData, bCopyHeightData, width, depth, widthSamples, depthSamples, scale, offset, thickness, bWrap);
    }

    @Override
    public void build(double[] pHeightData, boolean bCopyHeightData, double width, double depth, int widthSamples, int depthSamples, double scale, double offset, double thickness, boolean bWrap) {
        this.dGeomHeightfieldDataBuildDouble(pHeightData, bCopyHeightData, width, depth, widthSamples, depthSamples, scale, offset, thickness, bWrap);
    }
}

