/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.ObjArray;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DAABB;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DHeightfield;
import org.ode4j.ode.DHeightfieldData;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.CollideBoxPlane;
import org.ode4j.ode.internal.CollideCylinderPlane;
import org.ode4j.ode.internal.CollideTrimeshPlane;
import org.ode4j.ode.internal.CollideTrimeshRay;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBox;
import org.ode4j.ode.internal.DxCapsule;
import org.ode4j.ode.internal.DxCollisionUtil;
import org.ode4j.ode.internal.DxConvex;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxGimpact;
import org.ode4j.ode.internal.DxHeightfieldData;
import org.ode4j.ode.internal.DxPlane;
import org.ode4j.ode.internal.DxRay;
import org.ode4j.ode.internal.DxSpace;
import org.ode4j.ode.internal.DxSphere;
import org.ode4j.ode.internal.DxTriMesh;

public class DxHeightfield
extends DxGeom
implements DHeightfield {
    static final int HEIGHTFIELDMAXCONTACTPERCELL = 10;
    private static final boolean DHEIGHTFIELD_CORNER_ORIGIN = false;
    private static final boolean NO_CONTACT_CULLING_BY_ISONHEIGHTFIELD2 = false;
    private DxHeightfieldData m_p_data;
    private static final int TEMP_PLANE_BUFFER_ELEMENT_COUNT_ALIGNMENT = 4;
    private static final int TEMP_HEIGHT_BUFFER_ELEMENT_COUNT_ALIGNMENT_X = 4;
    private static final int TEMP_HEIGHT_BUFFER_ELEMENT_COUNT_ALIGNMENT_Z = 4;
    private static final int TEMP_TRIANGLE_BUFFER_ELEMENT_COUNT_ALIGNMENT = 1;
    private ObjArray<HeightFieldPlane>[] tempPlaneBuffer = null;
    private HeightFieldPlane[] tempPlaneInstances = null;
    private int tempPlaneBufferSize = 0;
    private HeightFieldTriangle[] tempTriangleBuffer = null;
    private int tempTriangleBufferSize = 0;
    private ObjArray<HeightFieldVertex>[] tempHeightBuffer = null;
    private HeightFieldVertex[] tempHeightInstances = null;
    private int tempHeightBufferSizeX = 0;
    private int tempHeightBufferSizeZ = 0;

    private static final double dMIN(double A, double B) {
        return A > B ? B : A;
    }

    private static final double dMAX(double A, double B) {
        return A > B ? A : B;
    }

    private final double dMIN3(double A, double B, double C) {
        return A < B ? DxHeightfield.dMIN(A, C) : DxHeightfield.dMIN(B, C);
    }

    private final double dMAX3(double A, double B, double C) {
        return A > B ? DxHeightfield.dMAX(A, C) : DxHeightfield.dMAX(B, C);
    }

    private void dGeomRaySetNoNormalize(DxRay myRay, DVector3C MyPoint, DVector3C MyVector) {
        myRay._final_posr.pos.set(MyPoint);
        myRay._final_posr.R.set(0, 2, MyVector.get0());
        myRay._final_posr.R.set(1, 2, MyVector.get1());
        myRay._final_posr.R.set(2, 2, MyVector.get2());
        myRay.dGeomMoved();
    }

    private void dGeomPlaneSetNoNormalize(DxPlane MyPlane, DVector3 MyPlaneDefV, double MyPlaneDefD) {
        MyPlane.setParams(MyPlaneDefV, MyPlaneDefD);
        MyPlane.dGeomMoved();
    }

    private static int AlignBufferSize(int value, int alignment) {
        Common.dIASSERT((alignment & alignment - 1) == 0);
        return value + (alignment - 1) & ~(alignment - 1);
    }

    private DxHeightfield(DxSpace space, DxHeightfieldData data, boolean bPlaceable) {
        super(space, bPlaceable);
        this.type = 9;
        this.m_p_data = data;
    }

    @Override
    void computeAABB() {
        DxHeightfieldData d = this.m_p_data;
        if (!d.m_bWrapMode) {
            if (this.hasFlagPlaceable()) {
                double[] dx = new double[6];
                double[] dy = new double[6];
                double[] dz = new double[6];
                if (d.m_fMinHeight != Double.NEGATIVE_INFINITY) {
                    dy[0] = this.final_posr().R().get01() * d.m_fMinHeight;
                    dy[1] = this.final_posr().R().get11() * d.m_fMinHeight;
                    dy[2] = this.final_posr().R().get21() * d.m_fMinHeight;
                } else {
                    dy[0] = this.final_posr().R().get01() != 0.0 ? this.final_posr().R().get01() * Double.NEGATIVE_INFINITY : 0.0;
                    dy[1] = this.final_posr().R().get11() != 0.0 ? this.final_posr().R().get11() * Double.NEGATIVE_INFINITY : 0.0;
                    double d2 = dy[2] = this.final_posr().R().get21() != 0.0 ? this.final_posr().R().get21() * Double.NEGATIVE_INFINITY : 0.0;
                }
                if (d.m_fMaxHeight != Double.POSITIVE_INFINITY) {
                    dy[3] = this.final_posr().R().get01() * d.m_fMaxHeight;
                    dy[4] = this.final_posr().R().get11() * d.m_fMaxHeight;
                    dy[5] = this.final_posr().R().get21() * d.m_fMaxHeight;
                } else {
                    dy[3] = this.final_posr().R().get01() != 0.0 ? this.final_posr().R().get01() * Double.POSITIVE_INFINITY : 0.0;
                    dy[4] = this.final_posr().R().get11() != 0.0 ? this.final_posr().R().get11() * Double.POSITIVE_INFINITY : 0.0;
                    dy[5] = this.final_posr().R().get21() != 0.0 ? this.final_posr().R().get21() * Double.POSITIVE_INFINITY : 0.0;
                }
                dx[0] = this.final_posr().R().get00() * -d.m_fHalfWidth;
                dx[1] = this.final_posr().R().get10() * -d.m_fHalfWidth;
                dx[2] = this.final_posr().R().get20() * -d.m_fHalfWidth;
                dx[3] = this.final_posr().R().get00() * d.m_fHalfWidth;
                dx[4] = this.final_posr().R().get10() * d.m_fHalfWidth;
                dx[5] = this.final_posr().R().get20() * d.m_fHalfWidth;
                dz[0] = this.final_posr().R().get02() * -d.m_fHalfDepth;
                dz[1] = this.final_posr().R().get12() * -d.m_fHalfDepth;
                dz[2] = this.final_posr().R().get22() * -d.m_fHalfDepth;
                dz[3] = this.final_posr().R().get02() * d.m_fHalfDepth;
                dz[4] = this.final_posr().R().get12() * d.m_fHalfDepth;
                dz[5] = this.final_posr().R().get22() * d.m_fHalfDepth;
                this._aabb.setMin0(this.final_posr().pos().get0() + this.dMIN3(DxHeightfield.dMIN(dx[0], dx[3]), DxHeightfield.dMIN(dy[0], dy[3]), DxHeightfield.dMIN(dz[0], dz[3])));
                this._aabb.setMax0(this.final_posr().pos().get0() + this.dMAX3(DxHeightfield.dMAX(dx[0], dx[3]), DxHeightfield.dMAX(dy[0], dy[3]), DxHeightfield.dMAX(dz[0], dz[3])));
                this._aabb.setMin1(this.final_posr().pos().get1() + this.dMIN3(DxHeightfield.dMIN(dx[1], dx[4]), DxHeightfield.dMIN(dy[1], dy[4]), DxHeightfield.dMIN(dz[1], dz[4])));
                this._aabb.setMax1(this.final_posr().pos().get1() + this.dMAX3(DxHeightfield.dMAX(dx[1], dx[4]), DxHeightfield.dMAX(dy[1], dy[4]), DxHeightfield.dMAX(dz[1], dz[4])));
                this._aabb.setMin2(this.final_posr().pos().get2() + this.dMIN3(DxHeightfield.dMIN(dx[2], dx[5]), DxHeightfield.dMIN(dy[2], dy[5]), DxHeightfield.dMIN(dz[2], dz[5])));
                this._aabb.setMax2(this.final_posr().pos().get2() + this.dMAX3(DxHeightfield.dMAX(dx[2], dx[5]), DxHeightfield.dMAX(dy[2], dy[5]), DxHeightfield.dMAX(dz[2], dz[5])));
            } else {
                this._aabb.set(-d.m_fHalfWidth, d.m_fHalfWidth, d.m_fMinHeight, d.m_fMaxHeight, -d.m_fHalfDepth, d.m_fHalfDepth);
            }
        } else if (this.hasFlagPlaceable()) {
            this._aabb.set(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        } else {
            this._aabb.set(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, d.m_fMinHeight, d.m_fMaxHeight, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
    }

    @Override
    public void DESTRUCTOR() {
        this.resetTriangleBuffer();
        this.resetPlaneBuffer();
        this.resetHeightBuffer();
    }

    private void allocateTriangleBuffer(int numTri) {
        int alignedNumTri;
        this.tempTriangleBufferSize = alignedNumTri = DxHeightfield.AlignBufferSize(numTri, 1);
        this.tempTriangleBuffer = new HeightFieldTriangle[alignedNumTri];
        int i = 0;
        while (i < this.tempTriangleBuffer.length) {
            this.tempTriangleBuffer[i] = new HeightFieldTriangle();
            ++i;
        }
    }

    private void resetTriangleBuffer() {
        this.tempTriangleBuffer = null;
    }

    private void allocatePlaneBuffer(int numTri) {
        int alignedNumTri;
        this.tempPlaneBufferSize = alignedNumTri = DxHeightfield.AlignBufferSize(numTri, 4);
        this.tempPlaneBuffer = new ObjArray[alignedNumTri];
        this.tempPlaneInstances = new HeightFieldPlane[alignedNumTri];
        int indexTri = 0;
        while (indexTri != alignedNumTri) {
            this.tempPlaneInstances[indexTri] = new HeightFieldPlane();
            ++indexTri;
        }
        indexTri = 0;
        while (indexTri != alignedNumTri) {
            this.tempPlaneBuffer[indexTri] = new ObjArray<HeightFieldPlane>(this.tempPlaneInstances, indexTri);
            ++indexTri;
        }
    }

    private void resetPlaneBuffer() {
        this.tempPlaneInstances = null;
        this.tempPlaneBuffer = null;
    }

    private void allocateHeightBuffer(int numX, int numZ) {
        int alignedNumX = DxHeightfield.AlignBufferSize(numX, 4);
        int alignedNumZ = DxHeightfield.AlignBufferSize(numZ, 4);
        this.tempHeightBufferSizeX = alignedNumX;
        this.tempHeightBufferSizeZ = alignedNumZ;
        this.tempHeightBuffer = new ObjArray[alignedNumX];
        int numCells = alignedNumX * alignedNumZ;
        this.tempHeightInstances = new HeightFieldVertex[numCells];
        int i = 0;
        while (i < this.tempHeightInstances.length) {
            this.tempHeightInstances[i] = new HeightFieldVertex();
            ++i;
        }
        int indexX = 0;
        while (indexX != alignedNumX) {
            this.tempHeightBuffer[indexX] = new ObjArray<HeightFieldVertex>(this.tempHeightInstances, indexX * alignedNumZ);
            ++indexX;
        }
    }

    void resetHeightBuffer() {
        this.tempHeightInstances = null;
        this.tempHeightBuffer = null;
    }

    public static DxHeightfield dCreateHeightfield(DxSpace space, DxHeightfieldData data, boolean bPlaceable) {
        return new DxHeightfield(space, data, bPlaceable);
    }

    void dGeomHeightfieldSetHeightfieldData(DHeightfieldData d) {
        this._data = d;
    }

    DHeightfieldData dGeomHeightfieldGetHeightfieldData() {
        return this.m_p_data;
    }

    private boolean DescendingPlaneSort(HeightFieldPlane A, HeightFieldPlane B) {
        return A.maxAAAB - B.maxAAAB > Common.dEpsilon;
    }

    void sortPlanes(int numPlanes) {
        boolean has_swapped = true;
        do {
            has_swapped = false;
            int i = 0;
            while (i < numPlanes - 1) {
                if (this.DescendingPlaneSort(this.tempPlaneBuffer[i].at0(), this.tempPlaneBuffer[i + 1].at0())) {
                    ObjArray<HeightFieldPlane> tempPlane = this.tempPlaneBuffer[i];
                    this.tempPlaneBuffer[i] = this.tempPlaneBuffer[i + 1];
                    this.tempPlaneBuffer[i + 1] = tempPlane;
                    has_swapped = true;
                }
                ++i;
            }
        } while (has_swapped);
    }

    int dCollideHeightfieldZone(int minX, int maxX, int minZ, int maxZ, DxGeom o2, int numMaxContactsPossible, int flags, DContactGeomBuffer contacts, int skip) {
        boolean needFurtherPasses;
        DxPlane myplane;
        int z_local;
        DContactGeom pContact = null;
        int numX = maxX - minX + 1;
        int numZ = maxZ - minZ + 1;
        double minO2Height = o2._aabb.getMin1();
        double maxO2Height = o2._aabb.getMax1();
        double maxY = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double cfSampleWidth = this.m_p_data.m_fSampleWidth;
        double cfSampleDepth = this.m_p_data.m_fSampleDepth;
        if (this.tempHeightBufferSizeX < numX || this.tempHeightBufferSizeZ < numZ) {
            this.resetHeightBuffer();
            this.allocateHeightBuffer(numX, numZ);
        }
        int x = minX;
        int x_local = 0;
        while (x_local < numX) {
            double Xpos;
            double c_Xpos = Xpos = (double)x * cfSampleWidth;
            ObjArray<HeightFieldVertex> HeightFieldRow = this.tempHeightBuffer[x_local];
            int z = minZ;
            z_local = 0;
            while (z_local < numZ) {
                double Ypos = (double)z * cfSampleDepth;
                double h = this.m_p_data.GetHeight(x, z);
                HeightFieldRow.at((int)z_local).vertex.set(c_Xpos, h, Ypos);
                HeightFieldRow.at((int)z_local).coords0 = x;
                HeightFieldRow.at((int)z_local).coords1 = z++;
                maxY = DxHeightfield.dMAX(maxY, h);
                minY = DxHeightfield.dMIN(minY, h);
                ++z_local;
            }
            ++x;
            ++x_local;
        }
        if (minO2Height - maxY > -Common.dEpsilon) {
            return 0;
        }
        if (minY - maxO2Height > -Common.dEpsilon) {
            pContact = contacts.get(0);
            pContact.pos.set(o2.final_posr().pos().get0(), minY, o2.final_posr().pos().get2());
            pContact.normal.set(0.0, -1.0, 0.0);
            pContact.depth = minY - maxO2Height;
            pContact.side1 = -1;
            pContact.side2 = -1;
            return 1;
        }
        DColliderFn geomRayNCollider = null;
        DColliderFn geomNPlaneCollider = null;
        dGetDepthFn geomNDepthGetter = null;
        switch (o2.type) {
            case 5: {
                geomRayNCollider = null;
                geomNPlaneCollider = new DxRay.CollideRayPlane();
                geomNDepthGetter = null;
                break;
            }
            case 0: {
                geomRayNCollider = new DxRay.CollideRaySphere();
                geomNPlaneCollider = new DxSphere.CollideSpherePlane();
                geomNDepthGetter = new dGetDepthFn(){

                    @Override
                    public double get(DGeom g, double x, double y, double z) {
                        return ((DxSphere)g).dGeomSpherePointDepth(x, y, z);
                    }
                };
                break;
            }
            case 1: {
                geomRayNCollider = new DxRay.CollideRayBox();
                geomNPlaneCollider = new CollideBoxPlane();
                geomNDepthGetter = new dGetDepthFn(){

                    @Override
                    public double get(DGeom g, double x, double y, double z) {
                        return ((DxBox)g).dGeomBoxPointDepth(x, y, z);
                    }
                };
                break;
            }
            case 2: {
                geomRayNCollider = new DxRay.CollideRayCapsule();
                geomNPlaneCollider = new DxCapsule.CollideCapsulePlane();
                geomNDepthGetter = new dGetDepthFn(){

                    @Override
                    public double get(DGeom g, double x, double y, double z) {
                        return ((DxCapsule)g).dGeomCapsulePointDepth(x, y, z);
                    }
                };
                break;
            }
            case 3: {
                geomRayNCollider = new DxRay.CollideRayCylinder();
                geomNPlaneCollider = new CollideCylinderPlane();
                geomNDepthGetter = null;
                break;
            }
            case 6: {
                geomRayNCollider = new DxConvex.CollideRayConvex();
                geomNPlaneCollider = new DxConvex.CollideConvexPlane();
                geomNDepthGetter = null;
                break;
            }
            case 8: {
                geomRayNCollider = new CollideRayTrimesh();
                geomNPlaneCollider = new CollideTrimeshPlane();
                geomNDepthGetter = null;
                break;
            }
            default: {
                Common.dIASSERT(false);
            }
        }
        DxPlane sliding_plane = myplane = new DxPlane(null, 0.0, 0.0, 0.0, 0.0);
        DVector3 triplaneV = new DVector3();
        double triplaneD = 0.0;
        if (maxY - minY < Common.dEpsilon) {
            triplaneV.set(0.0, 1.0, 0.0);
            triplaneD = minY;
            this.dGeomPlaneSetNoNormalize(sliding_plane, triplaneV, triplaneD);
            if (skip != 1) {
                throw new IllegalArgumentException("SKIP=" + skip);
            }
            int numTerrainContacts = geomNPlaneCollider.dColliderFn(o2, sliding_plane, flags, contacts);
            Common.dIASSERT(numTerrainContacts <= numMaxContactsPossible);
            int i = 0;
            while (i < numTerrainContacts) {
                pContact = contacts.get(i * skip);
                pContact.normal.set(triplaneV).scale(-1.0);
                ++i;
            }
            return numTerrainContacts;
        }
        int numTerrainContacts = 0;
        DContactGeomBuffer PlaneContact = this.m_p_data.m_contacts;
        int numTriMax = (maxX - minX) * (maxZ - minZ) * 2;
        if (this.tempTriangleBufferSize < numTriMax) {
            this.resetTriangleBuffer();
            this.allocateTriangleBuffer(numTriMax);
        }
        boolean isContactNumPointsLimited = true;
        boolean bl = needFurtherPasses = o2.type == 8;
        if (o2.type != 5 && !needFurtherPasses) {
            double xratio = (o2._aabb.getMax0() - o2._aabb.getMin0()) * this.m_p_data.m_fInvSampleWidth;
            if (xratio > 1.5) {
                needFurtherPasses = true;
            } else {
                double zratio = (o2._aabb.getMax2() - o2._aabb.getMin2()) * this.m_p_data.m_fInvSampleDepth;
                if (zratio > 1.5) {
                    needFurtherPasses = true;
                }
            }
        }
        int numTri = 0;
        int maxX_local = maxX - minX;
        int maxZ_local = maxZ - minZ;
        x_local = 0;
        while (x_local < maxX_local) {
            ObjArray<HeightFieldVertex> HeightFieldRow = this.tempHeightBuffer[x_local];
            ObjArray<HeightFieldVertex> HeightFieldNextRow = this.tempHeightBuffer[x_local + 1];
            HeightFieldVertex C = HeightFieldRow.at(0);
            HeightFieldVertex D = HeightFieldNextRow.at(0);
            z_local = 0;
            while (z_local < maxZ_local) {
                HeightFieldVertex A = C;
                HeightFieldVertex B = D;
                C = HeightFieldRow.at(z_local + 1);
                D = HeightFieldNextRow.at(z_local + 1);
                double AHeight = A.vertex.get1();
                double BHeight = B.vertex.get1();
                double CHeight = C.vertex.get1();
                double DHeight = D.vertex.get1();
                boolean isACollide = AHeight > minO2Height;
                boolean isBCollide = BHeight > minO2Height;
                boolean isCCollide = CHeight > minO2Height;
                boolean isDCollide = DHeight > minO2Height;
                A.state = !isACollide;
                B.state = !isBCollide;
                C.state = !isCCollide;
                boolean bl2 = D.state = !isDCollide;
                if (isACollide || isBCollide || isCCollide) {
                    HeightFieldTriangle CurrTriUp = this.tempTriangleBuffer[numTri++];
                    CurrTriUp.state = false;
                    CurrTriUp.vertices[0] = A;
                    CurrTriUp.vertices[1] = B;
                    CurrTriUp.vertices[2] = C;
                    CurrTriUp.setMinMax();
                    CurrTriUp.isUp = true;
                }
                if (isBCollide || isCCollide || isDCollide) {
                    HeightFieldTriangle CurrTriDown = this.tempTriangleBuffer[numTri++];
                    CurrTriDown.state = false;
                    CurrTriDown.vertices[0] = D;
                    CurrTriDown.vertices[1] = B;
                    CurrTriDown.vertices[2] = C;
                    CurrTriDown.setMinMax();
                    CurrTriDown.isUp = false;
                }
                if (needFurtherPasses && (isBCollide || isCCollide) && AHeight > CHeight && AHeight > BHeight && DHeight > CHeight && DHeight > BHeight) {
                    B.state = true;
                    C.state = true;
                }
                ++z_local;
            }
            ++x_local;
        }
        Common.dIASSERT(numTri != 0);
        DVector3 Edge1 = new DVector3();
        DVector3 Edge2 = new DVector3();
        int k = 0;
        while (k < numTri) {
            HeightFieldTriangle itTriangle = this.tempTriangleBuffer[k];
            Edge1.eqDiff(itTriangle.vertices[2].vertex, itTriangle.vertices[0].vertex);
            Edge2.eqDiff(itTriangle.vertices[1].vertex, itTriangle.vertices[0].vertex);
            if (itTriangle.isUp) {
                DxCollisionUtil.dVector3Cross(Edge1, Edge2, triplaneV);
            } else {
                DxCollisionUtil.dVector3Cross(Edge2, Edge1, triplaneV);
            }
            double dinvlength = 1.0 / triplaneV.length();
            triplaneV.scale(dinvlength);
            triplaneD = triplaneV.dot(itTriangle.vertices[0].vertex);
            itTriangle.planeDefV.set(triplaneV);
            itTriangle.planeDefD = triplaneD;
            ++k;
        }
        if (this.tempPlaneBufferSize < numTri) {
            this.resetPlaneBuffer();
            this.allocatePlaneBuffer(numTri);
        }
        int numPlanes = 0;
        int k2 = 0;
        while (k2 < numTri) {
            HeightFieldTriangle tri_base = this.tempTriangleBuffer[k2];
            if (!tri_base.state) {
                HeightFieldPlane currPlane = this.tempPlaneBuffer[numPlanes].at0();
                currPlane.resetTriangleListSize(numTri - k2);
                currPlane.addTriangle(tri_base);
                currPlane.planeDefV.set(tri_base.planeDefV);
                currPlane.planeDefD = tri_base.planeDefD;
                double normx = tri_base.planeDefV.get0();
                double normy = tri_base.planeDefV.get1();
                double normz = tri_base.planeDefV.get2();
                double dist = tri_base.planeDefD;
                int m = k2 + 1;
                while (m < numTri) {
                    HeightFieldTriangle tri_test = this.tempTriangleBuffer[m];
                    if (!tri_test.state && Common.dFabs(normy - tri_test.planeDefV.get1()) < Common.dEpsilon && Common.dFabs(dist - tri_test.planeDefD) < Common.dEpsilon && Common.dFabs(normx - tri_test.planeDefV.get0()) < Common.dEpsilon && Common.dFabs(normz - tri_test.planeDefV.get2()) < Common.dEpsilon) {
                        currPlane.addTriangle(tri_test);
                        tri_test.state = true;
                    }
                    ++m;
                }
                tri_base.state = true;
                currPlane.setMinMax();
                ++numPlanes;
            }
            ++k2;
        }
        this.sortPlanes(numPlanes);
        int planeTestFlags = flags & 0xFFFF0000 | 0xA;
        int k3 = 0;
        while (k3 < numPlanes) {
            int b;
            HeightFieldPlane itPlane = this.tempPlaneBuffer[k3].at0();
            this.dGeomPlaneSetNoNormalize(sliding_plane, itPlane.planeDefV, itPlane.planeDefD);
            boolean didCollide = false;
            int numPlaneContacts = geomNPlaneCollider.dColliderFn(o2, sliding_plane, planeTestFlags, PlaneContact);
            int planeTriListSize = itPlane.trianglelistCurrentSize;
            int i = 0;
            while (i < numPlaneContacts) {
                DContactGeom planeCurrContact = PlaneContact.get(i);
                DVector3 pCPos = planeCurrContact.pos;
                int b2 = 0;
                while (planeTriListSize > b2) {
                    if (this.m_p_data.IsOnHeightfield2(itPlane.trianglelist[b2].vertices[0], pCPos, itPlane.trianglelist[b2].isUp)) {
                        pContact = contacts.get(numTerrainContacts * skip);
                        pContact.pos.set(pCPos);
                        pContact.normal.set(itPlane.planeDefV).scale(-1.0);
                        pContact.depth = planeCurrContact.depth;
                        pContact.side1 = planeCurrContact.side1;
                        pContact.side2 = planeCurrContact.side2;
                        if (++numTerrainContacts == numMaxContactsPossible) {
                            return numTerrainContacts;
                        }
                        didCollide = true;
                        break;
                    }
                    ++b2;
                }
                ++i;
            }
            if (didCollide) {
                b = 0;
                while (planeTriListSize > b) {
                    int i2 = 0;
                    while (i2 < 3) {
                        itPlane.trianglelist[b].vertices[i2].state = true;
                        ++i2;
                    }
                    ++b;
                }
            } else {
                b = 0;
                while (planeTriListSize > b) {
                    itPlane.trianglelist[b].state = false;
                    ++b;
                }
            }
            ++k3;
        }
        if (needFurtherPasses) {
            DxRay tempRay = new DxRay(null, 1.0);
            double depth = 0.0;
            int rayTestFlags = flags & 0xFFFF0000 | 1;
            k3 = 0;
            while (k3 < numTri) {
                HeightFieldTriangle itTriangle = this.tempTriangleBuffer[k3];
                if (!itTriangle.state) {
                    int i = 0;
                    while (i < 3) {
                        HeightFieldVertex vertex = itTriangle.vertices[i];
                        if (!vertex.state) {
                            boolean vertexCollided = false;
                            DVector3 triVertex = vertex.vertex;
                            if (geomNDepthGetter != null) {
                                depth = geomNDepthGetter.get(o2, triVertex.get0(), triVertex.get1(), triVertex.get2());
                                if (depth > Common.dEpsilon) {
                                    vertexCollided = true;
                                }
                            } else {
                                tempRay.setLength((minO2Height - triVertex.get1()) * 1000.0);
                                this.dGeomRaySetNoNormalize(tempRay, triVertex, itTriangle.planeDefV);
                                if (geomRayNCollider.dColliderFn(tempRay, o2, rayTestFlags, PlaneContact) != 0) {
                                    depth = PlaneContact.get((int)0).depth;
                                    vertexCollided = true;
                                }
                            }
                            if (vertexCollided) {
                                pContact = contacts.get(numTerrainContacts * skip);
                                pContact.pos.set(triVertex);
                                pContact.normal.set(itTriangle.planeDefV).scale(-1.0);
                                pContact.depth = depth;
                                pContact.side1 = -1;
                                pContact.side2 = -1;
                                if (++numTerrainContacts == numMaxContactsPossible) {
                                    return numTerrainContacts;
                                }
                                vertex.state = true;
                            }
                        }
                        ++i;
                    }
                }
                ++k3;
            }
        }
        return numTerrainContacts;
    }

    @Override
    public DHeightfieldData getHeightfieldData() {
        return this.dGeomHeightfieldGetHeightfieldData();
    }

    @Override
    public void setHeightfieldData(DHeightfieldData d) {
        this.dGeomHeightfieldSetHeightfieldData(d);
    }

    static class CollideHeightfield
    implements DColliderFn {
        CollideHeightfield() {
        }

        int dCollideHeightfield(DxHeightfield o1, DxGeom o2, int flags, DContactGeomBuffer contacts, int skip) {
            int numTerrainContacts;
            block14: {
                DContactGeom pContact;
                int i;
                Common.dIASSERT(skip >= 1);
                Common.dIASSERT((flags & 0xFFFF) >= 1);
                int numMaxTerrainContacts = flags & 0xFFFF;
                DxHeightfield terrain = o1;
                DVector3 posbak = new DVector3();
                DMatrix3 Rbak = new DMatrix3();
                DAABB aabbbak = new DAABB();
                int gflagsbak = 0;
                DVector3 pos0 = new DVector3();
                DVector3 pos1 = new DVector3();
                DMatrix3 R1 = new DMatrix3();
                numTerrainContacts = 0;
                int numTerrainOrigContacts = 0;
                boolean reComputeAABB = true;
                if (reComputeAABB) {
                    posbak.set(o2.final_posr().pos());
                    Rbak.set(o2.final_posr().R());
                    aabbbak.set(o2._aabb);
                    gflagsbak = o2.getFlags();
                }
                if (terrain.hasFlagPlaceable()) {
                    pos0.eqDiff(o2.final_posr().pos(), terrain.final_posr().pos());
                    OdeMath.dMultiply1_331(pos1, terrain.final_posr().R(), pos0);
                    OdeMath.dMultiply1_333(R1, terrain.final_posr().R(), o2.final_posr().R());
                    o2._final_posr.pos.set(pos1);
                    o2._final_posr.R.set(R1);
                }
                o2._final_posr.pos.add(0, ((DxHeightfield)terrain).m_p_data.m_fHalfWidth);
                o2._final_posr.pos.add(2, ((DxHeightfield)terrain).m_p_data.m_fHalfDepth);
                if (reComputeAABB) {
                    o2.computeAABB();
                }
                boolean wrapped = ((DxHeightfield)terrain).m_p_data.m_bWrapMode;
                boolean dCollideHeightfieldExit = false;
                if (!wrapped) {
                    if (o2._aabb.getMin0() > ((DxHeightfield)terrain).m_p_data.m_fWidth || o2._aabb.getMin2() > ((DxHeightfield)terrain).m_p_data.m_fDepth) {
                        dCollideHeightfieldExit = true;
                    }
                    if (o2._aabb.getMax0() < 0.0 || o2._aabb.getMax2() < 0.0) {
                        dCollideHeightfieldExit = true;
                    }
                }
                if (!dCollideHeightfieldExit) {
                    double fInvSampleWidth = ((DxHeightfield)terrain).m_p_data.m_fInvSampleWidth;
                    int nMinX = (int)Common.dFloor(Common.dNextAfter(o2._aabb.getMin0() * fInvSampleWidth, Double.NEGATIVE_INFINITY));
                    int nMaxX = (int)Common.dCeil(Common.dNextAfter(o2._aabb.getMax0() * fInvSampleWidth, Double.POSITIVE_INFINITY));
                    double fInvSampleDepth = ((DxHeightfield)terrain).m_p_data.m_fInvSampleDepth;
                    int nMinZ = (int)Common.dFloor(Common.dNextAfter(o2._aabb.getMin2() * fInvSampleDepth, Double.NEGATIVE_INFINITY));
                    int nMaxZ = (int)Common.dCeil(Common.dNextAfter(o2._aabb.getMax2() * fInvSampleDepth, Double.POSITIVE_INFINITY));
                    if (!wrapped) {
                        nMinX = (int)DxHeightfield.dMAX(nMinX, 0.0);
                        nMaxX = (int)DxHeightfield.dMIN(nMaxX, ((DxHeightfield)terrain).m_p_data.m_nWidthSamples - 1);
                        nMinZ = (int)DxHeightfield.dMAX(nMinZ, 0.0);
                        nMaxZ = (int)DxHeightfield.dMIN(nMaxZ, ((DxHeightfield)terrain).m_p_data.m_nDepthSamples - 1);
                        Common.dIASSERT(nMinX < nMaxX && nMinZ < nMaxZ);
                    }
                    numTerrainOrigContacts = numTerrainContacts;
                    Common.dIASSERT((numTerrainContacts += terrain.dCollideHeightfieldZone(nMinX, nMaxX, nMinZ, nMaxZ, o2, numMaxTerrainContacts - numTerrainContacts, flags, contacts.createView(numTerrainContacts * skip), skip)) <= numMaxTerrainContacts);
                    i = numTerrainOrigContacts;
                    while (i != numTerrainContacts) {
                        pContact = contacts.get(i * skip);
                        pContact.g1 = o1;
                        pContact.g2 = o2;
                        ++i;
                    }
                }
                if (!reComputeAABB) break block14;
                o2._final_posr.pos.set(posbak);
                o2._final_posr.R.set(Rbak);
                o2._aabb.set(aabbbak);
                o2.setFlags(gflagsbak);
                if (o2 instanceof DxGimpact) {
                    o2.computeAABB();
                }
                if (terrain.hasFlagPlaceable()) {
                    i = 0;
                    while (i < numTerrainContacts) {
                        pContact = contacts.get(i * skip);
                        pos0.set(pContact.pos);
                        pos0.add(0, -((DxHeightfield)terrain).m_p_data.m_fHalfWidth);
                        pos0.add(2, -((DxHeightfield)terrain).m_p_data.m_fHalfDepth);
                        OdeMath.dMultiply0_331(pContact.pos, terrain.final_posr().R(), (DVector3C)pos0);
                        pContact.pos.add(terrain.final_posr().pos());
                        pos0.set(pContact.normal);
                        OdeMath.dMultiply0_331(pContact.normal, terrain.final_posr().R(), (DVector3C)pos0);
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < numTerrainContacts) {
                        pContact = contacts.get(i * skip);
                        pContact.pos.add(0, -((DxHeightfield)terrain).m_p_data.m_fHalfWidth);
                        pContact.pos.add(2, -((DxHeightfield)terrain).m_p_data.m_fHalfDepth);
                        ++i;
                    }
                }
            }
            return numTerrainContacts;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideHeightfield((DxHeightfield)o1, (DxGeom)o2, flags, contacts, 1);
        }
    }

    private static class CollideRayTrimesh
    implements DColliderFn {
        CollideTrimeshRay collider = new CollideTrimeshRay();

        private CollideRayTrimesh() {
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.collider.dCollideRTL((DxTriMesh)o2, (DxRay)o1, flags, contacts, 1);
        }
    }

    private class HeightFieldPlane {
        HeightFieldTriangle[] trianglelist;
        int trianglelistReservedSize;
        int trianglelistCurrentSize;
        double maxAAAB;
        DVector3 planeDefV = new DVector3();
        double planeDefD;

        private HeightFieldPlane() {
        }

        void setMinMax() {
            int asize = this.trianglelistCurrentSize;
            if (asize > 0) {
                this.maxAAAB = this.trianglelist[0].maxAAAB;
                int k = 1;
                while (asize > k) {
                    if (this.trianglelist[k].maxAAAB > this.maxAAAB) {
                        this.maxAAAB = this.trianglelist[k].maxAAAB;
                    }
                    ++k;
                }
            }
        }

        public void resetTriangleListSize(int newSize) {
            if (this.trianglelistReservedSize < newSize) {
                this.trianglelistReservedSize = newSize;
                this.trianglelist = new HeightFieldTriangle[newSize];
            }
            this.trianglelistCurrentSize = 0;
        }

        public void addTriangle(HeightFieldTriangle tri) {
            Common.dIASSERT(this.trianglelistCurrentSize < this.trianglelistReservedSize);
            this.trianglelist[this.trianglelistCurrentSize++] = tri;
        }
    }

    private class HeightFieldTriangle {
        HeightFieldVertex[] vertices = new HeightFieldVertex[3];
        DVector3 planeDefV = new DVector3();
        double planeDefD;
        double maxAAAB;
        boolean isUp;
        boolean state;

        HeightFieldTriangle() {
        }

        void setMinMax() {
            this.maxAAAB = this.vertices[0].vertex.get1() > this.vertices[1].vertex.get1() ? this.vertices[0].vertex.get1() : this.vertices[1].vertex.get1();
            this.maxAAAB = this.vertices[2].vertex.get1() > this.maxAAAB ? this.vertices[2].vertex.get1() : this.maxAAAB;
        }
    }

    class HeightFieldVertex {
        DVector3 vertex = new DVector3();
        int coords0;
        int coords1;
        boolean state;

        HeightFieldVertex() {
        }
    }

    private static interface dGetDepthFn {
        public double get(DGeom var1, double var2, double var4, double var6);
    }
}

