/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cmath;
import org.cpp4j.java.RefInt;
import org.ode4j.ode.DAABB;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DHashSpace;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxSpace;

public class DxHashSpace
extends DxSpace
implements DHashSpace {
    private static final int MAXINT = Integer.MAX_VALUE;
    private static final int NUM_PRIMES = 31;
    private static final int[] prime = new int[]{1, 2, 3, 7, 13, 31, 61, 127, 251, 509, 1021, 2039, 4093, 8191, 16381, 32749, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD, 33554393, 0x3FFFFFB, 134217689, 0xFFFFFC7, 0x1FFFFFFD, 0x3FFFFFDD};
    private int global_minlevel;
    private int global_maxlevel;

    private static int findLevel(DAABB boundsV) {
        if (!boundsV.isValid()) {
            return Integer.MAX_VALUE;
        }
        double q = boundsV.len0();
        double q2 = boundsV.len1();
        if (q2 > q) {
            q = q2;
        }
        if ((q2 = boundsV.len2()) > q) {
            q = q2;
        }
        RefInt level = new RefInt();
        Cmath.frexp(q, level);
        return level.i;
    }

    private static int getVirtualAddress(int level, int x, int y, int z) {
        int r = level * 1000 + x * 100 + y * 10 + z;
        if (r >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("level: " + level + " x=" + x + " y=" + y + " z=" + z);
        }
        return Math.abs(r);
    }

    DxHashSpace(DxSpace _space) {
        super(_space);
        this.type = 11;
        this.global_minlevel = -3;
        this.global_maxlevel = 10;
    }

    @Override
    public void setLevels(int minlevel, int maxlevel) {
        Common.dAASSERT(minlevel <= maxlevel);
        this.global_minlevel = minlevel;
        this.global_maxlevel = maxlevel;
    }

    @Override
    public int getLevelMin() {
        return this.global_minlevel;
    }

    @Override
    public int getLevelMax() {
        return this.global_maxlevel;
    }

    @Override
    public void cleanGeoms() {
        ++this.lock_count;
        for (DxGeom g : this._geoms) {
            if (!g.hasFlagDirty()) break;
            if (g instanceof DxSpace) {
                ((DxSpace)g).cleanGeoms();
            }
            g.recomputeAABB();
            g.unsetFlagDirtyAndBad();
        }
        --this.lock_count;
    }

    @Override
    public void collide(Object data, DGeom.DNearCallback callback) {
        int i;
        Common.dAASSERT(this, callback);
        if (this.count < 2) {
            return;
        }
        ++this.lock_count;
        this.cleanGeoms();
        int n = 0;
        dxAABB first_aabb = null;
        dxAABB big_boxes = null;
        int maxlevel = this.global_minlevel - 1;
        for (DxGeom geom : this._geoms) {
            if (!this.GEOM_ENABLED(geom)) continue;
            dxAABB aabbP = new dxAABB();
            aabbP.geom = geom;
            int level = DxHashSpace.findLevel(geom._aabb);
            if (level < this.global_minlevel) {
                level = this.global_minlevel;
            }
            if (level <= this.global_maxlevel) {
                aabbP.next = first_aabb;
                first_aabb = aabbP;
                aabbP.level = level;
                if (level > maxlevel) {
                    maxlevel = level;
                }
                double cellsize = Cmath.ldexp(1.0, level);
                i = 0;
                while (i < 3) {
                    aabbP.dbounds[2 * i] = (int)Math.floor(geom._aabb.getMin(i) / cellsize);
                    aabbP.dbounds[2 * i + 1] = (int)Math.floor(geom._aabb.getMax(i) / cellsize);
                    ++i;
                }
                aabbP.index = n++;
                continue;
            }
            aabbP.next = big_boxes;
            big_boxes = aabbP;
        }
        int tested_rowsize = n + 7 >> 3;
        int[] tested = new int[n * tested_rowsize];
        i = 0;
        while (i < 31) {
            if (prime[i] >= 8 * n) break;
            ++i;
        }
        if (i >= 31) {
            i = 30;
        }
        int sz = prime[i];
        Node[] table = new Node[sz];
        dxAABB aabb = first_aabb;
        while (aabb != null) {
            int[] dbounds = aabb.dbounds;
            int xi = dbounds[0];
            while (xi <= dbounds[1]) {
                int yi = dbounds[2];
                while (yi <= dbounds[3]) {
                    int zi = dbounds[4];
                    while (zi <= dbounds[5]) {
                        int hi = DxHashSpace.getVirtualAddress(aabb.level, xi, yi, zi) % sz;
                        Node node = new Node();
                        node.x = xi;
                        node.y = yi;
                        node.z = zi++;
                        node.aabb = aabb;
                        node.next = table[hi];
                        table[hi] = node;
                    }
                    ++yi;
                }
                ++xi;
            }
            aabb = aabb.next;
        }
        int[] db = new int[6];
        aabb = first_aabb;
        while (aabb != null) {
            i = 0;
            while (i < 6) {
                db[i] = aabb.dbounds[i];
                ++i;
            }
            int level = aabb.level;
            while (level <= maxlevel) {
                int xi = db[0];
                while (xi <= db[1]) {
                    int yi = db[2];
                    while (yi <= db[3]) {
                        int zi = db[4];
                        while (zi <= db[5]) {
                            int hi = DxHashSpace.getVirtualAddress(level, xi, yi, zi) % sz;
                            Node node = table[hi];
                            while (node != null) {
                                if (node.aabb != aabb && node.aabb.level == level && node.x == xi && node.y == yi && node.z == zi) {
                                    int mask;
                                    if (aabb.index <= node.aabb.index) {
                                        i = aabb.index * tested_rowsize + (node.aabb.index >> 3);
                                        mask = 1 << (node.aabb.index & 7);
                                    } else {
                                        i = node.aabb.index * tested_rowsize + (aabb.index >> 3);
                                        mask = 1 << (aabb.index & 7);
                                    }
                                    Common.dIASSERT(i >= 0 && i < tested_rowsize * n);
                                    if ((tested[i] & mask) == 0) {
                                        DxHashSpace.collideAABBs(aabb.geom, node.aabb.geom, data, callback);
                                    }
                                    int n2 = i;
                                    tested[n2] = tested[n2] | mask;
                                }
                                node = node.next;
                            }
                            ++zi;
                        }
                        ++yi;
                    }
                    ++xi;
                }
                i = 0;
                while (i < 6) {
                    int n3 = i++;
                    db[n3] = db[n3] >> 1;
                }
                ++level;
            }
            aabb = aabb.next;
        }
        aabb = first_aabb;
        while (aabb != null) {
            dxAABB aabb2 = big_boxes;
            while (aabb2 != null) {
                DxHashSpace.collideAABBs(aabb.geom, aabb2.geom, data, callback);
                aabb2 = aabb2.next;
            }
            aabb = aabb.next;
        }
        aabb = big_boxes;
        while (aabb != null) {
            dxAABB aabb2 = aabb.next;
            while (aabb2 != null) {
                DxHashSpace.collideAABBs(aabb.geom, aabb2.geom, data, callback);
                aabb2 = aabb2.next;
            }
            aabb = aabb.next;
        }
        --this.lock_count;
    }

    @Override
    void collide2(Object data, DxGeom geom, DGeom.DNearCallback callback) {
        Common.dAASSERT(geom, callback);
        ++this.lock_count;
        this.cleanGeoms();
        geom.recomputeAABB();
        for (DxGeom g : this._geoms) {
            if (!this.GEOM_ENABLED(g)) continue;
            DxHashSpace.collideAABBs(g, geom, data, callback);
        }
        --this.lock_count;
    }

    public static DxHashSpace dHashSpaceCreate(DxSpace space) {
        return new DxHashSpace(space);
    }

    void dHashSpaceSetLevels(int minlevel, int maxlevel) {
        Common.dUASSERT(minlevel <= maxlevel, "must have minlevel <= maxlevel");
        this.setLevels(minlevel, maxlevel);
    }

    private static class Node {
        Node next;
        int x;
        int y;
        int z;
        dxAABB aabb;

        private Node() {
        }
    }

    private static class dxAABB {
        dxAABB next;
        int level;
        int[] dbounds = new int[6];
        DxGeom geom;
        int index;

        private dxAABB() {
        }
    }
}

