/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.RefDouble;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.math.DVector4;
import org.ode4j.math.DVector4C;
import org.ode4j.ode.DAABB;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxGimpact;
import org.ode4j.ode.internal.DxTriMesh;
import org.ode4j.ode.internal.gimpact.GimContact;
import org.ode4j.ode.internal.gimpact.GimDynArray;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimTriCollision;
import org.ode4j.ode.internal.gimpact.GimTrimesh;

public class DxGimpactCollision {
    private void gim_trimesh_get_triangle_verticesODE(GimTrimesh trimesh, int triangle_index, DVector3 v1, DVector3 v2, DVector3 v3) {
        GimGeometry.vec3f src1 = new GimGeometry.vec3f();
        GimGeometry.vec3f src2 = new GimGeometry.vec3f();
        GimGeometry.vec3f src3 = new GimGeometry.vec3f();
        trimesh.gim_trimesh_get_triangle_vertices(triangle_index, src1, src2, src3);
        v1.set(src1.f);
        v2.set(src2.f);
        v3.set(src3.f);
    }

    private static GimGeometry.vec3f DVector3Tovec3f(DVector3C v) {
        GimGeometry.vec3f vf = new GimGeometry.vec3f();
        vf.f[0] = (float)v.get0();
        vf.f[1] = (float)v.get1();
        vf.f[2] = (float)v.get2();
        return vf;
    }

    private static GimGeometry.vec4f DVector4Tovec4f(DVector4C v) {
        GimGeometry.vec4f vf = new GimGeometry.vec4f();
        vf.f[0] = (float)v.get0();
        vf.f[1] = (float)v.get1();
        vf.f[2] = (float)v.get2();
        vf.f[3] = (float)v.get3();
        return vf;
    }

    static void gim_trimesh_get_triangle_verticesODE(GimTrimesh mesh) {
        mesh.gim_trimesh_get_triangle_vertices(0, null, null, null);
    }

    static int gim_trimesh_ray_closest_collisionODE(GimTrimesh mesh, DVector3C origin, DVector3C dir, double tmax, GimTriCollision.GIM_TRIANGLE_RAY_CONTACT_DATA contact) {
        GimGeometry.vec3f dir_vec3f = DxGimpactCollision.DVector3Tovec3f(dir);
        GimGeometry.vec3f origin_vec3f = DxGimpactCollision.DVector3Tovec3f(origin);
        return mesh.gim_trimesh_ray_closest_collision(origin_vec3f, dir_vec3f, (float)tmax, contact);
    }

    static int gim_trimesh_ray_collisionODE(GimTrimesh mesh, DVector3C origin, DVector3C dir, double tmax, GimTriCollision.GIM_TRIANGLE_RAY_CONTACT_DATA contact) {
        GimGeometry.vec3f dir_vec3f = DxGimpactCollision.DVector3Tovec3f(dir);
        GimGeometry.vec3f origin_vec3f = DxGimpactCollision.DVector3Tovec3f(origin);
        return mesh.gim_trimesh_ray_collision(origin_vec3f, dir_vec3f, (float)tmax, contact);
    }

    static void gim_trimesh_sphere_collisionODE(GimTrimesh mesh, DVector3C Position, double Radius, GimDynArray<GimContact> contact) {
        GimGeometry.vec3f pos_vec3f = DxGimpactCollision.DVector3Tovec3f(Position);
        mesh.gim_trimesh_sphere_collision(pos_vec3f, (float)Radius, contact);
    }

    static void gim_trimesh_plane_collisionODE(GimTrimesh mesh, DVector4 plane, GimDynArray<GimGeometry.vec4f> contact) {
        GimGeometry.vec4f plane_vec4f = DxGimpactCollision.DVector4Tovec4f(plane);
        mesh.gim_trimesh_plane_collision(plane_vec4f, contact);
    }

    static void GIM_AABB_COPY(GimGeometry.aabb3f src, DAABB dst) {
        dst.set(src.minX, src.maxX, src.minY, src.maxY, src.minZ, src.maxZ);
    }

    static int FetchTriangleCount(DxGimpact TriMesh) {
        return TriMesh.m_collision_trimesh.gim_trimesh_get_triangle_count();
    }

    static void FetchTransformedTriangle(DxGimpact TriMesh, int Index, DVector3[] Out) {
        TriMesh.m_collision_trimesh.gim_trimesh_locks_work_data();
        GimGeometry.vec3f[] vOut = new GimGeometry.vec3f[]{new GimGeometry.vec3f(), new GimGeometry.vec3f(), new GimGeometry.vec3f()};
        TriMesh.m_collision_trimesh.gim_trimesh_get_triangle_vertices(Index, vOut[0], vOut[1], vOut[2]);
        Out[0].set(vOut[0].f);
        Out[1].set(vOut[1].f);
        Out[2].set(vOut[2].f);
        TriMesh.m_collision_trimesh.gim_trimesh_unlocks_work_data();
    }

    static void MakeMatrix(DVector3C Position, DMatrix3C Rotation2, GimGeometry.mat4f m) {
        m.f[0] = (float)Rotation2.get00();
        m.f[1] = (float)Rotation2.get01();
        m.f[2] = (float)Rotation2.get02();
        m.f[4] = (float)Rotation2.get10();
        m.f[5] = (float)Rotation2.get11();
        m.f[6] = (float)Rotation2.get12();
        m.f[8] = (float)Rotation2.get20();
        m.f[9] = (float)Rotation2.get21();
        m.f[10] = (float)Rotation2.get22();
        m.f[3] = (float)Position.get0();
        m.f[7] = (float)Position.get1();
        m.f[11] = (float)Position.get2();
    }

    static void MakeMatrix(DxGeom g, GimGeometry.mat4f Out) {
        DVector3C Position = g.dGeomGetPosition();
        DMatrix3C Rotation2 = g.dGeomGetRotation();
        DxGimpactCollision.MakeMatrix(Position, Rotation2, Out);
    }

    void Decompose(DMatrix3C Matrix2, DVector3 Right, DVector3 Up, DVector3 Direction) {
        Right.set(Matrix2.get00(), Matrix2.get10(), Matrix2.get20());
        Up.set(Matrix2.get01(), Matrix2.get11(), Matrix2.get21());
        Direction.set(Matrix2.get02(), Matrix2.get12(), Matrix2.get22());
    }

    void Decompose(DMatrix3C Matrix2, DVector3[] Vectors) {
        this.Decompose(Matrix2, Vectors[0], Vectors[1], Vectors[2]);
    }

    static void GetPointFromBarycentric(GimGeometry.vec3f[] dv, double u, double v, DVector3 Out) {
        double w = 1.0 - u - v;
        Out.set0((double)dv[0].f[0] * w + (double)dv[1].f[0] * u + (double)dv[2].f[0] * v);
        Out.set1((double)dv[0].f[1] * w + (double)dv[1].f[1] * u + (double)dv[2].f[1] * v);
        Out.set2((double)dv[0].f[2] * w + (double)dv[1].f[2] * u + (double)dv[2].f[2] * v);
    }

    boolean Callback(DxTriMesh TriMesh, DxGeom Object2, int TriIndex) {
        if (TriMesh.Callback != null) {
            return TriMesh.Callback.call(TriMesh, Object2, TriIndex) != 0;
        }
        return true;
    }

    void Vector3Subtract(DVector3C left, DVector3C right, DVector3 result) {
        result.eqDiff(left, right);
    }

    void Vector3Add(DVector3C left, DVector3C right, DVector3 result) {
        result.eqSum(left, right);
    }

    void Vector3Negate(DVector3C in, DVector3 out) {
        out.set(in).scale(-1.0);
    }

    void Vector3Copy(DVector3C in, DVector3 out) {
        out.set(in);
    }

    void Vector3Multiply(DVector3C in, double scalar, DVector3 out) {
        out.set(in).scale(scalar);
    }

    void TransformVector3(DVector3C in, DMatrix3C orientation, DVector3C position, DVector3 out) {
        OdeMath.dMultiply0_331(out, orientation, in);
        out.add(position);
    }

    boolean IntersectCapsuleTri(DVector3C segOrigin, DVector3C segEnd, double radius, DVector3C triOrigin, DVector3C triEdge0, DVector3C triEdge1, RefDouble dist, double[] t, double[] u, double[] v) {
        throw new UnsupportedOperationException();
    }
}

