/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import java.nio.channels.UnsupportedAddressTypeException;
import org.ode4j.math.DVector3;
import org.ode4j.ode.DAABB;
import org.ode4j.ode.DBox;
import org.ode4j.ode.DCapsule;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DSphere;
import org.ode4j.ode.DTriMesh;
import org.ode4j.ode.DTriMeshData;
import org.ode4j.ode.internal.DxGimpactCollision;
import org.ode4j.ode.internal.DxGimpactData;
import org.ode4j.ode.internal.DxSpace;
import org.ode4j.ode.internal.DxTriMesh;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimTrimesh;

public class DxGimpact
extends DxTriMesh {
    DxGimpactData _Data;
    GimTrimesh m_collision_trimesh;

    void dGeomTriMeshSetLastTransform(Object last_trans) {
        throw new UnsupportedAddressTypeException();
    }

    Object dGeomTriMeshGetLastTransform() {
        throw new UnsupportedAddressTypeException();
    }

    @Override
    public int FetchTriangleCount() {
        return DxGimpactCollision.FetchTriangleCount(this);
    }

    @Override
    public void FetchTransformedTriangle(int i, DVector3[] v) {
        DxGimpactCollision.FetchTransformedTriangle(this, i, v);
    }

    DxGimpact(DxSpace Space, DxGimpactData Data) {
        super(Space);
        this._Data = Data;
        this.type = 8;
        this.Callback = null;
        this.ArrayCallback = null;
        this.RayCallback = null;
        this.TriMergeCallback = null;
        this.dGeomTriMeshSetData(Data);
        this.doSphereTC = true;
        this.doBoxTC = true;
        this.doCapsuleTC = true;
    }

    @Override
    public void DESTRUCTOR() {
        this.m_collision_trimesh.gim_trimesh_destroy();
        super.DESTRUCTOR();
    }

    @Override
    void ClearTCCache() {
    }

    @Override
    boolean AABBTest(DAABB aabb) {
        return true;
    }

    @Override
    void computeAABB() {
        GimGeometry.mat4f transform = new GimGeometry.mat4f();
        GimGeometry.IDENTIFY_MATRIX_4X4(transform);
        DxGimpactCollision.MakeMatrix(this, transform);
        this.m_collision_trimesh.gim_trimesh_set_tranform(transform);
        this.m_collision_trimesh.gim_trimesh_update();
        DxGimpactCollision.GIM_AABB_COPY(this.m_collision_trimesh.getAabbSet().getGlobalBound(), this._aabb);
    }

    void dGeomTriMeshSetCallback(DTriMesh.DTriCallback Callback) {
        this.Callback = Callback;
    }

    DTriMesh.DTriCallback dGeomTriMeshGetCallback() {
        return this.Callback;
    }

    void dGeomTriMeshSetArrayCallback(DTriMesh.DTriArrayCallback ArrayCallback) {
        this.ArrayCallback = ArrayCallback;
    }

    DTriMesh.DTriArrayCallback dGeomTriMeshGetArrayCallback() {
        return this.ArrayCallback;
    }

    void dGeomTriMeshSetRayCallback(DTriMesh.DTriRayCallback Callback) {
        this.RayCallback = Callback;
    }

    DTriMesh.DTriRayCallback dGeomTriMeshGetRayCallback() {
        return this.RayCallback;
    }

    void dGeomTriMeshSetTriMergeCallback(DTriMesh.DTriTriMergeCallback Callback) {
        this.TriMergeCallback = Callback;
    }

    DTriMesh.DTriTriMergeCallback dGeomTriMeshGetTriMergeCallback() {
        return this.TriMergeCallback;
    }

    void dGeomTriMeshSetData(DTriMeshData Data) {
        this._Data = (DxGimpactData)Data;
        this.setFlagDirtyAndBad();
        if (this._Data.getDataRef() != null) {
            this.m_collision_trimesh = GimTrimesh.gim_trimesh_create_from_data(this._Data.getDataRef(), false, this._Data.getIndexRef(), false, true);
        }
    }

    DTriMeshData dGeomTriMeshGetData() {
        return this._Data;
    }

    void dGeomTriMeshEnableTC(Class<? extends DGeom> geomClass, boolean enable) {
        if (geomClass.equals(DSphere.class)) {
            this.doSphereTC = enable;
        } else if (geomClass.equals(DBox.class)) {
            this.doBoxTC = enable;
        } else if (geomClass.equals(DCapsule.class)) {
            this.doCapsuleTC = enable;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    boolean dGeomTriMeshIsTCEnabled(Class<? extends DGeom> geomClass) {
        if (geomClass.equals(DSphere.class)) {
            return this.doSphereTC;
        }
        if (geomClass.equals(DBox.class)) {
            return this.doBoxTC;
        }
        if (geomClass.equals(DCapsule.class)) {
            return this.doCapsuleTC;
        }
        throw new UnsupportedOperationException();
    }

    void dGeomTriMeshClearTCCache() {
        this.ClearTCCache();
    }

    DTriMeshData dGeomTriMeshGetTriMeshDataID() {
        return this._Data;
    }

    void dGeomTriMeshGetTriangle(int Index, DVector3 v0, DVector3 v1, DVector3 v2) {
        DVector3[] v = new DVector3[]{v0, v1, v2};
        this.FetchTransformedTriangle(Index, v);
    }

    void dGeomTriMeshGetPoint(int Index, double u, double v, DVector3 Out) {
        GimGeometry.vec3f[] dv = new GimGeometry.vec3f[]{new GimGeometry.vec3f(), new GimGeometry.vec3f(), new GimGeometry.vec3f()};
        this.m_collision_trimesh.gim_trimesh_locks_work_data();
        this.m_collision_trimesh.gim_trimesh_get_triangle_vertices(Index, dv[0], dv[1], dv[2]);
        DxGimpactCollision.GetPointFromBarycentric(dv, u, v, Out);
        this.m_collision_trimesh.gim_trimesh_unlocks_work_data();
    }

    int dGeomTriMeshGetTriangleCount() {
        return this.FetchTriangleCount();
    }

    @Override
    public void enableTC(Class<? extends DGeom> cls, boolean enable) {
        this.dGeomTriMeshEnableTC(cls, enable);
    }

    @Override
    public boolean isTCEnabled(Class<? extends DGeom> cls) {
        return this.dGeomTriMeshIsTCEnabled(cls);
    }

    @Override
    public void clearTCCache(DTriMesh g) {
        this.dGeomTriMeshClearTCCache();
    }

    @Override
    public DTriMesh.DTriTriMergeCallback getTriMergeCallback() {
        return this.dGeomTriMeshGetTriMergeCallback();
    }

    @Override
    public void setTriMergeCallback(DTriMesh.DTriTriMergeCallback Callback) {
        this.dGeomTriMeshSetTriMergeCallback(Callback);
    }
}

