/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DGeomTransform;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBody;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxSpace;
import org.ode4j.ode.internal.Objects_H;

public class DxGeomTransform
extends DxGeom
implements DGeomTransform {
    private DxGeom obj;
    private boolean cleanup;
    private boolean infomode;
    private Objects_H.DxPosR transform_posr;

    DxGeomTransform(DxSpace space) {
        super(space, true);
        this.type = 7;
        this.obj = null;
        this.cleanup = false;
        this.infomode = false;
        this.transform_posr = new Objects_H.DxPosR();
    }

    @Override
    public void DESTRUCTOR() {
        if (this.obj != null && this.cleanup) {
            this.obj.DESTRUCTOR();
        }
        super.DESTRUCTOR();
    }

    @Override
    void computeAABB() {
        if (this.obj == null) {
            this._aabb.setZero();
            return;
        }
        Objects_H.DxPosR posr_bak = this.obj._final_posr;
        this.computeFinalTx();
        this.obj._final_posr = this.transform_posr;
        this.obj.computeAABB();
        this._aabb.set(this.obj._aabb);
        this.obj._final_posr = posr_bak;
    }

    private void computeFinalTx() {
        OdeMath.dMultiply0_331(this.transform_posr.pos, this.final_posr().R(), this.obj.final_posr().pos());
        this.transform_posr.pos.add(this.final_posr().pos());
        OdeMath.dMultiply0_333(this.transform_posr.R, this.final_posr().R(), this.obj.final_posr().R());
    }

    public static DxGeomTransform dCreateGeomTransform(DxSpace space) {
        return new DxGeomTransform(space);
    }

    public void dGeomTransformSetGeom(DxGeom obj2) {
        if (this.obj != null && this.cleanup) {
            this.obj.DESTRUCTOR();
        }
        this.obj = obj2;
    }

    public DxGeom dGeomTransformGetGeom() {
        return this.obj;
    }

    public void dGeomTransformSetCleanup(boolean mode) {
        this.cleanup = mode;
    }

    public boolean dGeomTransformGetCleanup() {
        return this.cleanup;
    }

    public void dGeomTransformSetInfo(boolean mode) {
        this.infomode = mode;
    }

    public boolean dGeomTransformGetInfo() {
        return this.infomode;
    }

    @Override
    public void setGeom(DGeom geom) {
        this.dGeomTransformSetGeom((DxGeom)geom);
    }

    @Override
    public DGeom getGeom() {
        return this.dGeomTransformGetGeom();
    }

    @Override
    public void setCleanup(boolean mode) {
        this.dGeomTransformSetCleanup(mode);
    }

    @Override
    public boolean getCleanup() {
        return this.dGeomTransformGetCleanup();
    }

    @Override
    public void setInfo(boolean mode) {
        this.dGeomTransformSetInfo(mode);
    }

    @Override
    public boolean getInfo() {
        return this.dGeomTransformGetInfo();
    }

    static class CollideTransform
    implements DColliderFn {
        CollideTransform() {
        }

        public int dCollideTransform(DxGeom o1, DxGeom o2, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip == 1);
            DxGeomTransform tr = (DxGeomTransform)o1;
            if (tr.obj == null) {
                return 0;
            }
            Common.dUASSERT(((DxGeomTransform)tr).obj.parent_space == null, "GeomTransform encapsulated object must not be in a space");
            Common.dUASSERT(((DxGeomTransform)tr).obj.body == null, "GeomTransform encapsulated object must not be attached to a body");
            Objects_H.DxPosR posr_bak = ((DxGeomTransform)tr).obj._final_posr;
            DxBody bodybak = ((DxGeomTransform)tr).obj.body;
            if (tr.hasFlagAabbBad()) {
                tr.computeFinalTx();
            }
            ((DxGeomTransform)tr).obj._final_posr = tr.transform_posr;
            ((DxGeomTransform)tr).obj.body = o1.body;
            int n = DxGeomTransform.dCollide(tr.obj, o2, flags, contacts, skip);
            if (tr.infomode) {
                int i = 0;
                while (i < n) {
                    DContactGeom c = contacts.get(skip * i);
                    c.g1 = o1;
                    ++i;
                }
            }
            ((DxGeomTransform)tr).obj._final_posr = posr_bak;
            ((DxGeomTransform)tr).obj.body = bodybak;
            return n;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideTransform((DxGeom)o1, (DxGeom)o2, flags, contacts, 1);
        }
    }
}

