/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import java.util.List;
import org.cpp4j.java.Ref;
import org.cpp4j.java.RefInt;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DQuaternionC;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DAABB;
import org.ode4j.ode.DAABBC;
import org.ode4j.ode.DBody;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DRotation;
import org.ode4j.ode.DSpace;
import org.ode4j.ode.OdeConfig;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.CollideBoxBox;
import org.ode4j.ode.internal.CollideBoxPlane;
import org.ode4j.ode.internal.CollideCylinderBox;
import org.ode4j.ode.internal.CollideCylinderPlane;
import org.ode4j.ode.internal.CollideCylinderSphere;
import org.ode4j.ode.internal.CollideCylinderTrimesh;
import org.ode4j.ode.internal.CollideSpaceGeom;
import org.ode4j.ode.internal.CollideTrimeshBox;
import org.ode4j.ode.internal.CollideTrimeshCCylinder;
import org.ode4j.ode.internal.CollideTrimeshPlane;
import org.ode4j.ode.internal.CollideTrimeshRay;
import org.ode4j.ode.internal.CollideTrimeshSphere;
import org.ode4j.ode.internal.CollideTrimeshTrimesh;
import org.ode4j.ode.internal.CollisionLibccd;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DBase;
import org.ode4j.ode.internal.DxBody;
import org.ode4j.ode.internal.DxCapsule;
import org.ode4j.ode.internal.DxConvex;
import org.ode4j.ode.internal.DxGeomTransform;
import org.ode4j.ode.internal.DxHeightfield;
import org.ode4j.ode.internal.DxQuadTreeSpace;
import org.ode4j.ode.internal.DxRay;
import org.ode4j.ode.internal.DxSpace;
import org.ode4j.ode.internal.DxSphere;
import org.ode4j.ode.internal.Objects_H;
import org.ode4j.ode.internal.Rotation;

public abstract class DxGeom
extends DBase
implements DGeom {
    public static final int NUMC_MASK = 65535;
    protected static final int GEOM_DIRTY = 1;
    protected static final int GEOM_POSR_BAD = 2;
    protected static final int GEOM_AABB_BAD = 4;
    protected static final int GEOM_PLACEABLE = 8;
    protected static final int GEOM_ENABLED = 16;
    protected static final int GEOM_ZERO_SIZED = 32;
    protected static final int GEOM_ENABLE_TEST_MASK = 48;
    protected static final int GEOM_ENABLE_TEST_VALUE = 16;
    public int type = -1;
    private int _gflags = 21;
    Object _data;
    DxBody body;
    DxGeom body_next;
    Objects_H.DxPosR _final_posr;
    private Objects_H.DxPosR offset_posr;
    DxGeom _next = null;
    private DxGeom _prev = null;
    DxSpace parent_space;
    int _sapIdxDirty;
    int _sapIdxGeom;
    DxQuadTreeSpace.Block _qtIdx;
    DAABB _aabb = new DAABB();
    long category_bits;
    long collide_bits;
    private static final DVector3C OFFSET_POSITION_ZERO = new DVector3(0.0, 0.0, 0.0);
    private static final DMatrix3C OFFSET_ROTATION_ZERO = new DMatrix3(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    private static final dColliderEntry[][] colliders = new dColliderEntry[18][18];
    private static boolean colliders_initialized = false;
    private static final boolean LIBCCD;
    private static final boolean dLIBCCD_BOX_CYL;
    private static final boolean dLIBCCD_CYL_CYL;
    private static final boolean dLIBCCD_CAP_CYL;
    private static final boolean dLIBCCD_CONVEX_BOX;
    private static final boolean dLIBCCD_CONVEX_CAP;
    private static final boolean dLIBCCD_CONVEX_CYL;
    private static final boolean dLIBCCD_CONVEX_SPHERE;
    private static final boolean dLIBCCD_CONVEX_CONVEX;

    static {
        dLIBCCD_BOX_CYL = LIBCCD = OdeConfig.isLibCCDEndabled();
        dLIBCCD_CYL_CYL = LIBCCD;
        dLIBCCD_CAP_CYL = LIBCCD;
        dLIBCCD_CONVEX_BOX = LIBCCD;
        dLIBCCD_CONVEX_CAP = LIBCCD;
        dLIBCCD_CONVEX_CYL = LIBCCD;
        dLIBCCD_CONVEX_SPHERE = LIBCCD;
        dLIBCCD_CONVEX_CONVEX = LIBCCD;
    }

    void updateZeroSizedFlag(boolean is_zero_sized) {
        this._gflags = is_zero_sized ? this._gflags | 0x20 : this._gflags & 0xFFFFFFDF;
    }

    void recomputePosr() {
        if ((this._gflags & 2) != 0) {
            this.computePosr();
            this._gflags &= 0xFFFFFFFD;
        }
    }

    abstract void computeAABB();

    void computeOBB(DMatrix3C R) {
        throw new UnsupportedOperationException();
    }

    void recomputeAABB() {
        if ((this._gflags & 4) != 0) {
            this.recomputePosr();
            this.computeAABB();
            this._gflags &= 0xFFFFFFFB;
        }
    }

    final void setFlagDirtyAndBad() {
        this._gflags |= 5;
    }

    final void unsetFlagDirtyAndBad() {
        this._gflags &= 0xFFFFFFFA;
    }

    final boolean hasFlagDirty() {
        return (this._gflags & 1) != 0;
    }

    final boolean hasFlagAabbBad() {
        return (this._gflags & 4) != 0;
    }

    final boolean hasFlagPlaceable() {
        return (this._gflags & 8) != 0;
    }

    final int getFlags() {
        return this._gflags;
    }

    final void setFlags(int flags) {
        this._gflags = flags;
    }

    final void setFlagCustom(int customFlag) {
        this._gflags |= customFlag;
    }

    final void unsetFlagCustom(int customFlag) {
        this._gflags &= ~customFlag;
    }

    void spaceAdd(DxGeom next, DxSpace parent, List<DxGeom> geoms) {
        this._next = next;
        if (this._next != null) {
            this._next._prev = this;
        }
        this._prev = null;
        parent.setFirst(this);
        geoms.add(0, this);
    }

    void spaceRemove(DxSpace parent, List<DxGeom> geoms) {
        if (this._next != null) {
            this._next._prev = this._prev;
        }
        parent.setFirst(this._next);
        geoms.remove(this);
    }

    final DxGeom getNext() {
        return this._next;
    }

    private void bodyAdd(DxBody b) {
        this.body = b;
        this.body_next = b.geom;
        b.geom = this;
    }

    protected DxGeom(DxSpace space, boolean isPlaceable) {
        if (isPlaceable) {
            this._gflags |= 8;
        }
        this._data = null;
        this.body = null;
        this.body_next = null;
        if (isPlaceable) {
            this._final_posr = this.dAllocPosr();
            this._final_posr.pos.setZero();
            this._final_posr.R.setIdentity();
        } else {
            this._final_posr = null;
        }
        this.offset_posr = null;
        this._next = null;
        this._prev = null;
        this.parent_space = null;
        this._aabb.setZero();
        this.category_bits = -1L;
        this.collide_bits = -1L;
        if (space != null) {
            space.dSpaceAdd(this);
        }
    }

    @Override
    public void DESTRUCTOR() {
        if (this.parent_space != null) {
            this.parent_space.dSpaceRemove(this);
        }
        if ((this._gflags & 8) != 0 && (this.body == null || this.body != null && this.offset_posr != null)) {
            this.dFreePosr(this._final_posr);
        }
        if (this.offset_posr != null) {
            this.dFreePosr(this.offset_posr);
        }
        this.bodyRemove();
    }

    int getParentSpaceTLSKind() {
        return this.parent_space != null ? this.parent_space.tls_kind : DxSpace.dSPACE_TLS_KIND_INIT_VALUE;
    }

    boolean AABBTest(DxGeom o, DAABBC aabb) {
        return true;
    }

    private void bodyRemove() {
        if (this.body != null) {
            DxGeom g = this.body.geom;
            while (g != null) {
                if (g == this) {
                    this.body.geom = g.body_next;
                    break;
                }
                this.body.geom = g.body_next;
                g = g.body_next;
            }
            this.body = null;
            this.body_next = null;
        }
    }

    private void matrixInvert(DMatrix3C inMat, DMatrix3 outMat) {
        outMat.set(inMat);
        double x = outMat.get10();
        outMat.set10(outMat.get01());
        outMat.set01(x);
        x = outMat.get02();
        outMat.set02(outMat.get20());
        outMat.set20(x);
        x = outMat.get21();
        outMat.set21(outMat.get12());
        outMat.set12(x);
    }

    void getBodyPosr(Objects_H.DxPosR offset_posr, Objects_H.DxPosR final_posr, Objects_H.DxPosR body_posr) {
        DMatrix3 inv_offset = new DMatrix3();
        this.matrixInvert(offset_posr.R, inv_offset);
        OdeMath.dMultiply0_333(body_posr.R, final_posr.R, inv_offset);
        DVector3 world_offset = new DVector3();
        OdeMath.dMultiply0_331(world_offset, (DMatrix3C)body_posr.R, offset_posr.pos());
        body_posr.pos.eqDiff(final_posr.pos(), world_offset);
    }

    void getWorldOffsetPosr(Objects_H.DxPosRC body_posr, Objects_H.DxPosRC world_posr, Objects_H.DxPosR offset_posr) {
        DMatrix3 inv_body = new DMatrix3();
        this.matrixInvert(body_posr.R(), inv_body);
        OdeMath.dMultiply0_333(offset_posr.R, inv_body, world_posr.R());
        DVector3 world_offset = new DVector3();
        world_offset.eqDiff(world_posr.pos(), body_posr.pos());
        OdeMath.dMultiply0_331(offset_posr.pos, (DMatrix3C)inv_body, (DVector3C)world_offset);
    }

    void computePosr() {
        OdeMath.dMultiply0_331(this._final_posr.pos, this.body.posr().R(), this.offset_posr.pos());
        this._final_posr.pos.add(this.body.posr().pos());
        OdeMath.dMultiply0_333(this._final_posr.R, this.body.posr().R(), this.offset_posr.R);
    }

    boolean checkControlValueSizeValidity(Ref<?> dataValue, RefInt dataSize, int iRequiresSize) {
        if (dataSize.get() == iRequiresSize && dataValue.get() != null) {
            return true;
        }
        dataSize.set(iRequiresSize);
        return iRequiresSize == 0;
    }

    boolean controlGeometry(DGeom.CONTROL_CLASS controlClass, DGeom.CONTROL_CODE controlCode, DGeom.DataValue dataValue, RefInt dataSize) {
        throw new IllegalArgumentException("Control class/code is not supported for current geom");
    }

    DxGeom dGeomGetBodyNext() {
        return this.body_next;
    }

    public void dGeomDestroy() {
        this.DESTRUCTOR();
    }

    public void dGeomSetData(Object data) {
        this._data = data;
    }

    public Object dGeomGetData() {
        return this._data;
    }

    public void dGeomSetBody(DxBody b) {
        Common.dUASSERT(b == null || (this._gflags & 8) == 0, "geom must be placeable");
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        if (b != null) {
            if (this.body == null) {
                this.dFreePosr(this._final_posr);
            }
            if (this.body != b) {
                if (this.offset_posr != null) {
                    this.dFreePosr(this.offset_posr);
                    this.offset_posr = null;
                }
                this._final_posr = b._posr;
                this.bodyRemove();
                this.bodyAdd(b);
            }
            this.dGeomMoved();
        } else if (this.body != null) {
            if (this.offset_posr != null) {
                this.recomputePosr();
                this.dFreePosr(this.offset_posr);
                this.offset_posr = null;
            } else {
                this._final_posr = new Objects_H.DxPosR();
                this._final_posr.pos.set(this.body.posr().pos());
                this._final_posr.R.set(this.body.posr().R());
            }
            this.bodyRemove();
        }
    }

    private DxBody dGeomGetBody() {
        return this.body;
    }

    private void dGeomSetPosition(DVector3C xyz) {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        if (this.offset_posr != null) {
            DVector3 world_offset = new DVector3();
            OdeMath.dMultiply0_331(world_offset, this.body.posr().R(), this.offset_posr.pos());
            world_offset.eqDiff(xyz, world_offset);
            this.body.dBodySetPosition(world_offset);
        } else if (this.body != null) {
            this.body.dBodySetPosition(xyz);
        } else {
            this._final_posr.pos.set(xyz);
            this.dGeomMoved();
        }
    }

    private void dGeomSetRotation(DMatrix3C R) {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        if (this.offset_posr != null) {
            this.recomputePosr();
            Objects_H.DxPosR new_final_posr = new Objects_H.DxPosR();
            Objects_H.DxPosR new_body_posr = new Objects_H.DxPosR();
            new_final_posr.pos.set(this._final_posr.pos());
            new_final_posr.R.set(R);
            this.getBodyPosr(this.offset_posr, new_final_posr, new_body_posr);
            this.body.dBodySetRotation(new_body_posr.R);
            this.body.dBodySetPosition(new_body_posr.pos());
        } else if (this.body != null) {
            this.body.dBodySetRotation(R);
        } else {
            this._final_posr.R.set(R);
            this.dGeomMoved();
        }
    }

    private void dGeomSetQuaternion(DQuaternionC quat) {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        if (this.offset_posr != null) {
            this.recomputePosr();
            Objects_H.DxPosR new_final_posr = new Objects_H.DxPosR();
            Objects_H.DxPosR new_body_posr = new Objects_H.DxPosR();
            DRotation.dRfromQ(new_final_posr.R, quat);
            new_final_posr.pos.set(this._final_posr.pos());
            this.getBodyPosr(this.offset_posr, new_final_posr, new_body_posr);
            this.body.dBodySetRotation(new_body_posr.R);
            this.body.dBodySetPosition(new_body_posr.pos());
        }
        if (this.body != null) {
            this.body.dBodySetQuaternion(quat);
        } else {
            DRotation.dRfromQ(this._final_posr.R, quat);
            this.dGeomMoved();
        }
    }

    DVector3C dGeomGetPosition() {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        this.recomputePosr();
        return this._final_posr.pos();
    }

    private void dGeomCopyPosition(DVector3 pos) {
        pos.set(this.dGeomGetPosition());
    }

    DMatrix3C dGeomGetRotation() {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        this.recomputePosr();
        return this._final_posr.R;
    }

    private void dGeomCopyRotation(DMatrix3 R) {
        R.set(this.dGeomGetRotation());
    }

    public void dGeomGetQuaternion(DQuaternion quat) {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        if (this.body != null && this.offset_posr == null) {
            quat.set(this.body.dBodyGetQuaternion());
        } else {
            this.recomputePosr();
            Rotation.dQfromR(quat, this._final_posr.R);
        }
    }

    @Override
    public DQuaternionC getQuaternion() {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        if (this.body != null && this.offset_posr == null) {
            return this.body.dBodyGetQuaternion();
        }
        this.recomputePosr();
        DQuaternion quat = new DQuaternion();
        Rotation.dQfromR(quat, this._final_posr.R);
        return quat;
    }

    public void dGeomGetAABB(DAABB aabb) {
        this.recomputeAABB();
        aabb.set(this._aabb);
    }

    @Override
    public DAABBC getAABB() {
        this.recomputeAABB();
        return this._aabb;
    }

    private DxSpace dGeomGetSpace() {
        return this.parent_space;
    }

    private int dGeomGetClass() {
        return this.type;
    }

    private void dGeomSetCategoryBits(long bits) {
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        this.category_bits = bits;
    }

    private void dGeomSetCollideBits(long bits) {
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        this.collide_bits = bits;
    }

    private long dGeomGetCategoryBits() {
        return this.category_bits;
    }

    private long dGeomGetCollideBits() {
        return this.collide_bits;
    }

    private void dGeomEnable() {
        this._gflags |= 0x10;
    }

    private void dGeomDisable() {
        this._gflags &= 0xFFFFFFEF;
    }

    private boolean dGeomIsEnabled() {
        return (this._gflags & 0x10) != 0;
    }

    void dGeomGetRelPointPos(double px, double py, double pz, DVector3 result) {
        if ((this._gflags & 8) == 0) {
            result.set(px, py, pz);
            return;
        }
        this.recomputePosr();
        DVector3 p = new DVector3();
        DVector3 prel = new DVector3(px, py, pz);
        OdeMath.dMultiply0_331(p, (DMatrix3C)this._final_posr.R, (DVector3C)prel);
        result.eqSum(p, this._final_posr.pos());
    }

    void dGeomGetPosRelPoint(double px, double py, double pz, DVector3 result) {
        if ((this._gflags & 8) == 0) {
            result.set(px, py, pz);
            return;
        }
        this.recomputePosr();
        DVector3 prel = new DVector3(px, py, pz);
        prel.sub(this._final_posr.pos());
        OdeMath.dMultiply1_331(result, this._final_posr.R, prel);
    }

    void dGeomVectorToWorld(double px, double py, double pz, DVector3 result) {
        if ((this._gflags & 8) == 0) {
            result.set(px, py, pz);
            return;
        }
        this.recomputePosr();
        DVector3 p = new DVector3(px, py, pz);
        OdeMath.dMultiply0_331(result, (DMatrix3C)this._final_posr.R, (DVector3C)p);
    }

    void dGeomVectorFromWorld(double px, double py, double pz, DVector3 result) {
        if ((this._gflags & 8) == 0) {
            result.set(px, py, pz);
            return;
        }
        this.recomputePosr();
        DVector3 p = new DVector3(px, py, pz);
        OdeMath.dMultiply1_331(result, this._final_posr.R, p);
    }

    boolean dGeomLowLevelControl(DGeom.CONTROL_CLASS controlClass, DGeom.CONTROL_CODE controlCode, DGeom.DataValue dataValue, RefInt dataSize) {
        Common.dAASSERT(dataSize);
        if (dataSize == null) {
            return false;
        }
        boolean result = this.controlGeometry(controlClass, controlCode, dataValue, dataSize);
        return result;
    }

    static void dFinitUserClasses() {
    }

    private void dGeomCreateOffset() {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        Common.dUASSERT(this.body, "geom must be on a body");
        if (this.offset_posr != null) {
            return;
        }
        Common.dIASSERT(this._final_posr == this.body._posr);
        this._final_posr = this.dAllocPosr();
        this.offset_posr = this.dAllocPosr();
        this.offset_posr.pos.setZero();
        this.offset_posr.R.setIdentity();
        this._gflags |= 2;
    }

    public void dGeomSetOffsetPosition(double x, double y, double z) {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        Common.dUASSERT(this.body, "geom must be on a body");
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        if (this.offset_posr == null) {
            this.dGeomCreateOffset();
        }
        this.offset_posr.pos.set(x, y, z);
        this.dGeomMoved();
    }

    public void dGeomSetOffsetRotation(DMatrix3C R) {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        Common.dUASSERT(this.body, "geom must be on a body");
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        if (this.offset_posr == null) {
            this.dGeomCreateOffset();
        }
        this.offset_posr.R.set(R);
        this.dGeomMoved();
    }

    void dGeomSetOffsetQuaternion(DQuaternionC quat) {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        Common.dUASSERT(this.body, "geom must be on a body");
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        if (this.offset_posr == null) {
            this.dGeomCreateOffset();
        }
        DRotation.dRfromQ(this.offset_posr.R, quat);
        this.dGeomMoved();
    }

    void dGeomSetOffsetWorldPosition(double x, double y, double z) {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        Common.dUASSERT(this.body, "geom must be on a body");
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        if (this.offset_posr == null) {
            this.dGeomCreateOffset();
        }
        this.body.dBodyGetPosRelPoint(new DVector3(x, y, z), this.offset_posr.pos);
        this.dGeomMoved();
    }

    void dGeomSetOffsetWorldRotation(DMatrix3C R) {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        Common.dUASSERT(this.body, "geom must be on a body");
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        if (this.offset_posr == null) {
            this.dGeomCreateOffset();
        }
        this.recomputePosr();
        Objects_H.DxPosR new_final_posr = new Objects_H.DxPosR();
        new_final_posr.pos.set(this._final_posr.pos());
        new_final_posr.R.set(R);
        this.getWorldOffsetPosr(this.body.posr(), new_final_posr, this.offset_posr);
        this.dGeomMoved();
    }

    void dGeomSetOffsetWorldQuaternion(DQuaternionC quat) {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        Common.dUASSERT(this.body, "geom must be on a body");
        DxSpace.CHECK_NOT_LOCKED(this.parent_space);
        if (this.offset_posr == null) {
            this.dGeomCreateOffset();
        }
        this.recomputePosr();
        Objects_H.DxPosR new_final_posr = new Objects_H.DxPosR();
        new_final_posr.pos.set(this._final_posr.pos());
        DRotation.dRfromQ(new_final_posr.R, quat);
        this.getWorldOffsetPosr(this.body.posr(), new_final_posr, this.offset_posr);
        this.dGeomMoved();
    }

    void dGeomClearOffset() {
        Common.dUASSERT(this._gflags & 8, "geom must be placeable");
        if (this.offset_posr != null) {
            this.dFreePosr(this.offset_posr);
            this.offset_posr = null;
            this.dFreePosr(this._final_posr);
            this._final_posr = this.body._posr;
            this._gflags &= 0xFFFFFFFD;
            this.dGeomMoved();
        }
    }

    boolean dGeomIsOffset() {
        return this.offset_posr != null;
    }

    private DVector3C dGeomGetOffsetPosition() {
        if (this.offset_posr != null) {
            return this.offset_posr.pos();
        }
        return OFFSET_POSITION_ZERO;
    }

    private void dGeomCopyOffsetPosition(DVector3 pos) {
        pos.set(this.dGeomGetOffsetPosition());
    }

    private DMatrix3C dGeomGetOffsetRotation() {
        if (this.offset_posr != null) {
            return this.offset_posr.R;
        }
        return OFFSET_ROTATION_ZERO;
    }

    private void dGeomCopyOffsetRotation(DMatrix3 R) {
        R.set(this.dGeomGetOffsetRotation());
    }

    void dGeomGetOffsetQuaternion(DQuaternion result) {
        if (this.offset_posr != null) {
            Rotation.dQfromR(result, this.offset_posr.R);
        } else {
            result.set(1.0, 0.0, 0.0, 0.0);
        }
    }

    private Objects_H.DxPosR dAllocPosr() {
        return new Objects_H.DxPosR();
    }

    private void dFreePosr(Objects_H.DxPosR oldPosR) {
    }

    void dGeomMoved() {
        if (this.offset_posr != null) {
            this._gflags |= 2;
        }
        DxSpace parent = this.parent_space;
        DxGeom geom = this;
        while (parent != null && (geom._gflags & 1) == 0) {
            parent.CHECK_NOT_LOCKED();
            geom._gflags |= 5;
            parent.dirty(geom);
            geom = parent;
            parent = parent.parent_space;
        }
        while (geom != null) {
            geom._gflags |= 5;
            DxSpace.CHECK_NOT_LOCKED(geom.parent_space);
            geom = geom.parent_space;
        }
    }

    protected boolean GEOM_ENABLED(DxGeom g) {
        return (g._gflags & 0x30) == 16;
    }

    private static void setCollider(int i, int j, DColliderFn fn) {
        if (colliders[i][j] == null) {
            DxGeom.colliders[i][j] = new dColliderEntry();
        }
        if (colliders[j][i] == null) {
            DxGeom.colliders[j][i] = new dColliderEntry();
        }
        if (DxGeom.colliders[i][j].fn == null) {
            DxGeom.colliders[i][j].fn = fn;
            DxGeom.colliders[i][j].reverse = false;
        }
        if (DxGeom.colliders[j][i].fn == null) {
            DxGeom.colliders[j][i].fn = fn;
            DxGeom.colliders[j][i].reverse = true;
        }
    }

    private static void setAllColliders(int i, DColliderFn fn) {
        int j = 0;
        while (j < 18) {
            DxGeom.setCollider(i, j, fn);
            ++j;
        }
    }

    public static void dInitColliders() {
        int j;
        Common.dIASSERT(!colliders_initialized);
        colliders_initialized = true;
        int i = 0;
        while (i < colliders.length) {
            DxGeom.colliders[i] = new dColliderEntry[18];
            j = 0;
            while (j < colliders[i].length) {
                DxGeom.colliders[i][j] = new dColliderEntry();
                ++j;
            }
            ++i;
        }
        i = 10;
        while (i <= 13) {
            j = 0;
            while (j < 18) {
                DxGeom.setCollider(i, j, new CollideSpaceGeom());
                ++j;
            }
            ++i;
        }
        DxGeom.setCollider(0, 0, new DxSphere.CollideSphereSphere());
        DxGeom.setCollider(0, 1, new DxSphere.CollideSphereBox());
        DxGeom.setCollider(0, 4, new DxSphere.CollideSpherePlane());
        DxGeom.setCollider(1, 1, new CollideBoxBox());
        DxGeom.setCollider(1, 4, new CollideBoxPlane());
        DxGeom.setCollider(2, 0, new DxCapsule.CollideCapsuleSphere());
        DxGeom.setCollider(2, 1, new DxCapsule.CollideCapsuleBox());
        DxGeom.setCollider(2, 2, new DxCapsule.CollideCapsuleCapsule());
        DxGeom.setCollider(2, 4, new DxCapsule.CollideCapsulePlane());
        DxGeom.setCollider(5, 0, new DxRay.CollideRaySphere());
        DxGeom.setCollider(5, 1, new DxRay.CollideRayBox());
        DxGeom.setCollider(5, 2, new DxRay.CollideRayCapsule());
        DxGeom.setCollider(5, 4, new DxRay.CollideRayPlane());
        DxGeom.setCollider(5, 3, new DxRay.CollideRayCylinder());
        DxGeom.setCollider(8, 0, new CollideTrimeshSphere());
        DxGeom.setCollider(8, 1, new CollideTrimeshBox());
        DxGeom.setCollider(8, 5, new CollideTrimeshRay());
        DxGeom.setCollider(8, 8, new CollideTrimeshTrimesh());
        DxGeom.setCollider(8, 2, new CollideTrimeshCCylinder());
        DxGeom.setCollider(8, 4, new CollideTrimeshPlane());
        DxGeom.setCollider(3, 8, new CollideCylinderTrimesh());
        if (dLIBCCD_BOX_CYL) {
            DxGeom.setCollider(1, 3, new CollisionLibccd.CollideBoxCylinderCCD());
        } else {
            DxGeom.setCollider(3, 1, new CollideCylinderBox());
        }
        DxGeom.setCollider(3, 0, new CollideCylinderSphere());
        DxGeom.setCollider(3, 4, new CollideCylinderPlane());
        if (dLIBCCD_CYL_CYL) {
            DxGeom.setCollider(3, 3, new CollisionLibccd.CollideCylinderCylinder());
        }
        if (dLIBCCD_CAP_CYL) {
            DxGeom.setCollider(2, 3, new CollisionLibccd.CollideCapsuleCylinder());
        }
        if (dLIBCCD_CONVEX_BOX) {
            DxGeom.setCollider(6, 1, new CollisionLibccd.CollideConvexBoxCCD());
        } else {
            DxGeom.setCollider(6, 1, new DxConvex.CollideConvexBox());
        }
        if (dLIBCCD_CONVEX_CAP) {
            DxGeom.setCollider(6, 2, new CollisionLibccd.CollideConvexCapsuleCCD());
        } else {
            DxGeom.setCollider(6, 2, new DxConvex.CollideConvexCapsule());
        }
        if (dLIBCCD_CONVEX_CYL) {
            DxGeom.setCollider(6, 3, new CollisionLibccd.CollideConvexCylinderCCD());
        }
        if (dLIBCCD_CONVEX_SPHERE) {
            DxGeom.setCollider(6, 0, new CollisionLibccd.CollideConvexSphereCCD());
        } else {
            DxGeom.setCollider(0, 6, new DxConvex.CollideSphereConvex());
        }
        if (dLIBCCD_CONVEX_CONVEX) {
            DxGeom.setCollider(6, 6, new CollisionLibccd.CollideConvexConvexCCD());
        } else {
            DxGeom.setCollider(6, 6, new DxConvex.CollideConvexConvex());
        }
        DxGeom.setCollider(6, 4, new DxConvex.CollideConvexPlane());
        DxGeom.setCollider(5, 6, new DxConvex.CollideRayConvex());
        DxGeom.setCollider(9, 5, new DxHeightfield.CollideHeightfield());
        DxGeom.setCollider(9, 0, new DxHeightfield.CollideHeightfield());
        DxGeom.setCollider(9, 1, new DxHeightfield.CollideHeightfield());
        DxGeom.setCollider(9, 2, new DxHeightfield.CollideHeightfield());
        DxGeom.setCollider(9, 3, new DxHeightfield.CollideHeightfield());
        DxGeom.setCollider(9, 6, new DxHeightfield.CollideHeightfield());
        DxGeom.setCollider(9, 8, new DxHeightfield.CollideHeightfield());
        DxGeom.setAllColliders(7, new DxGeomTransform.CollideTransform());
    }

    static void dFinitColliders() {
        colliders_initialized = false;
    }

    public static void dSetColliderOverride(int i, int j, DColliderFn fn) {
        Common.dIASSERT(colliders_initialized);
        Common.dAASSERT(i < 18);
        Common.dAASSERT(j < 18);
        DxGeom.colliders[i][j].fn = fn;
        DxGeom.colliders[i][j].reverse = false;
        DxGeom.colliders[j][i].fn = fn;
        DxGeom.colliders[j][i].reverse = true;
    }

    public static int dCollide(DxGeom o1, DxGeom o2, int flags, DContactGeomBuffer contacts, int skip) {
        Common.dAASSERT(o1, o2, contacts);
        Common.dUASSERT(colliders_initialized, "Please call ODE initialization (dInitODE() or similar) before using the library");
        Common.dUASSERT(o1.type >= 0 && o1.type < 18, "bad o1 class number");
        Common.dUASSERT(o2.type >= 0 && o2.type < 18, "bad o2 class number");
        Common.dUASSERT((flags & 0xFFFF) > 0, "no contacts requested");
        if ((flags & 0xFFFF) == 0) {
            return 0;
        }
        if (o1 == o2) {
            return 0;
        }
        if (o1.body == o2.body && o1.body != null) {
            return 0;
        }
        o1.recomputePosr();
        o2.recomputePosr();
        dColliderEntry ce = colliders[o1.type][o2.type];
        int count = 0;
        if (ce.fn != null) {
            if (ce.reverse) {
                count = ce.fn.dColliderFn(o2, o1, flags, contacts);
                int i = 0;
                while (i < count) {
                    DContactGeom c = contacts.get(i);
                    c.normal.scale(-1.0);
                    DGeom tmp = c.g1;
                    c.g1 = c.g2;
                    c.g2 = tmp;
                    int tmpint = c.side1;
                    c.side1 = c.side2;
                    c.side2 = tmpint;
                    ++i;
                }
            } else {
                count = ce.fn.dColliderFn(o1, o2, flags, contacts);
            }
        }
        return count;
    }

    static void collideAABBs(DxGeom g1, DxGeom g2, Object data, DGeom.DNearCallback callback) {
        Common.dIASSERT((g1._gflags & 4) == 0);
        Common.dIASSERT((g2._gflags & 4) == 0);
        if (g1.body == g2.body && g1.body != null) {
            return;
        }
        if ((g1.category_bits & g2.collide_bits) == 0L && (g2.category_bits & g1.collide_bits) == 0L) {
            return;
        }
        DAABB bounds1 = g1._aabb;
        DAABB bounds2 = g2._aabb;
        if (bounds1.isDisjoint(bounds2)) {
            return;
        }
        if (!g1.AABBTest(g2, bounds2)) {
            return;
        }
        if (!g2.AABBTest(g1, bounds1)) {
            return;
        }
        callback.call(data, g1, g2);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " body=" + this.body;
    }

    void setNextPrevNull() {
        this._next = null;
        this._prev = null;
    }

    Objects_H.DxPosRC final_posr() {
        return this._final_posr;
    }

    Objects_H.DxPosRC offset_posr() {
        return this.offset_posr;
    }

    @Override
    public void destroy() {
        this.dGeomDestroy();
    }

    @Override
    public int getClassID() {
        return this.dGeomGetClass();
    }

    @Override
    public DSpace getSpace() {
        return this.dGeomGetSpace();
    }

    @Override
    public void setData(Object data) {
        this.dGeomSetData(data);
    }

    @Override
    public Object getData() {
        return this.dGeomGetData();
    }

    @Override
    public void setBody(DBody b) {
        this.dGeomSetBody((DxBody)b);
    }

    @Override
    public DBody getBody() {
        return this.dGeomGetBody();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.dGeomSetPosition(new DVector3(x, y, z));
    }

    @Override
    public void setPosition(DVector3C xyz) {
        this.dGeomSetPosition(xyz);
    }

    @Override
    public DVector3C getPosition() {
        return this.dGeomGetPosition();
    }

    @Override
    public void setRotation(DMatrix3C R) {
        this.dGeomSetRotation(R);
    }

    @Override
    public DMatrix3C getRotation() {
        return this.dGeomGetRotation();
    }

    @Override
    public void setQuaternion(DQuaternionC quat) {
        this.dGeomSetQuaternion(quat);
    }

    @Override
    public void setCategoryBits(long bits) {
        this.dGeomSetCategoryBits(bits);
    }

    @Override
    public void setCollideBits(long bits) {
        this.dGeomSetCollideBits(bits);
    }

    @Override
    public long getCategoryBits() {
        return this.dGeomGetCategoryBits();
    }

    @Override
    public long getCollideBits() {
        return this.dGeomGetCollideBits();
    }

    @Override
    public void enable() {
        this.dGeomEnable();
    }

    @Override
    public void disable() {
        this.dGeomDisable();
    }

    @Override
    public boolean isEnabled() {
        return this.dGeomIsEnabled();
    }

    @Override
    public void collide2(DGeom g, Object data, DGeom.DNearCallback callback) {
        DxSpace.dSpaceCollide2(this, (DxGeom)g, data, callback);
    }

    @Override
    public void setOffsetPosition(double x, double y, double z) {
        this.dGeomSetOffsetPosition(x, y, z);
    }

    @Override
    public void setOffsetRotation(DMatrix3C R) {
        this.dGeomSetOffsetRotation(R);
    }

    @Override
    public void clearOffset() {
        this.dGeomClearOffset();
    }

    @Override
    public DVector3C getOffsetPosition() {
        return this.dGeomGetOffsetPosition();
    }

    @Override
    public void getOffsetQuaternion(DQuaternion result) {
        this.dGeomGetOffsetQuaternion(result);
    }

    @Override
    public DMatrix3C getOffsetRotation() {
        return this.dGeomGetOffsetRotation();
    }

    @Override
    public boolean isOffset() {
        return this.dGeomIsOffset();
    }

    @Override
    public void setOffsetQuaternion(DQuaternionC q) {
        this.dGeomSetOffsetQuaternion(q);
    }

    @Override
    public void setOffsetWorldPosition(double x, double y, double z) {
        this.dGeomSetOffsetWorldPosition(x, y, z);
    }

    @Override
    public void setOffsetWorldQuaternion(DQuaternionC q) {
        this.dGeomSetOffsetWorldQuaternion(q);
    }

    @Override
    public void setOffsetWorldRotation(DMatrix3C R) {
        this.dGeomSetOffsetRotation(R);
    }

    @Override
    public void copyOffsetPosition(DVector3 pos) {
        this.dGeomCopyOffsetPosition(pos);
    }

    @Override
    public void copyOffsetRotation(DMatrix3 R) {
        this.dGeomCopyOffsetRotation(R);
    }

    @Override
    public void copyPosition(DVector3 pos) {
        this.dGeomCopyPosition(pos);
    }

    @Override
    public void copyRotation(DMatrix3 R) {
        this.dGeomCopyRotation(R);
    }

    @Override
    public boolean lowLevelControl(DGeom.CONTROL_CLASS controlClass, DGeom.CONTROL_CODE controlCode, DGeom.DataValue dataValue, RefInt dataSize) {
        return this.dGeomLowLevelControl(controlClass, controlCode, dataValue, dataSize);
    }

    @Override
    public void getRelPointPos(double px, double py, double pz, DVector3 result) {
        this.dGeomGetRelPointPos(px, py, pz, result);
    }

    @Override
    public void getPosRelPoint(double px, double py, double pz, DVector3 result) {
        this.dGeomGetPosRelPoint(px, py, pz, result);
    }

    @Override
    public void vectorToWorld(double px, double py, double pz, DVector3 result) {
        this.dGeomVectorToWorld(px, py, pz, result);
    }

    @Override
    public void vectorFromWorld(double px, double py, double pz, DVector3 result) {
        this.dGeomVectorFromWorld(px, py, pz, result);
    }

    private static class dColliderEntry {
        DColliderFn fn;
        boolean reverse;

        private dColliderEntry() {
        }
    }

    static enum dxContactMergeOptions {
        DONT_MERGE_CONTACTS,
        MERGE_CONTACT_NORMALS,
        MERGE_CONTACTS_FULLY;

    }
}

