/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DCylinder;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxSpace;

public class DxCylinder
extends DxGeom
implements DCylinder {
    private double _radius;
    private double _lz;

    DxCylinder(DxSpace space, double __radius, double __length) {
        super(space, true);
        Common.dAASSERT(__radius >= 0.0 && __length >= 0.0);
        this.type = 3;
        this._radius = __radius;
        this._lz = __length;
        this.updateZeroSizedFlag(this._radius == 0.0 || __length == 0.0);
    }

    @Override
    void computeAABB() {
        DMatrix3C R = this.final_posr().R();
        DVector3C pos = this.final_posr().pos();
        double xrange = Common.dFabs(R.get00() * this._radius) + Common.dFabs(R.get01() * this._radius) + 0.5 * Common.dFabs(R.get02() * this._lz);
        double yrange = Common.dFabs(R.get10() * this._radius) + Common.dFabs(R.get11() * this._radius) + 0.5 * Common.dFabs(R.get12() * this._lz);
        double zrange = Common.dFabs(R.get20() * this._radius) + Common.dFabs(R.get21() * this._radius) + 0.5 * Common.dFabs(R.get22() * this._lz);
        this._aabb.setMinMax(xrange, yrange, zrange);
        this._aabb.shiftPos(pos);
    }

    public static DxCylinder dCreateCylinder(DxSpace space, double radius, double length) {
        return new DxCylinder(space, radius, length);
    }

    void dGeomCylinderSetParams(double radius, double length) {
        Common.dAASSERT(radius >= 0.0 && length >= 0.0);
        this._radius = radius;
        this._lz = length;
        this.updateZeroSizedFlag(radius == 0.0 || length == 0.0);
        this.dGeomMoved();
    }

    @Override
    public double getRadius() {
        return this._radius;
    }

    @Override
    public double getLength() {
        return this._lz;
    }

    @Override
    public void setParams(double radius, double length) {
        this.dGeomCylinderSetParams(radius, length);
    }
}

