/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cmath;
import org.cpp4j.Cstdio;
import org.cpp4j.java.RefDouble;
import org.cpp4j.java.RefInt;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DConvex;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBox;
import org.ode4j.ode.internal.DxCapsule;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxPlane;
import org.ode4j.ode.internal.DxRay;
import org.ode4j.ode.internal.DxSpace;
import org.ode4j.ode.internal.DxSphere;

public class DxConvex
extends DxGeom
implements DConvex {
    private DVector3[] planesV;
    private double[] planesD;
    private double[] points;
    private int[] polygons;
    private int planecount;
    private int pointcount;
    private int edgecount;
    private Edge[] edges;

    private int SupportIndex(DVector3 dir) {
        DVector3 rdir = new DVector3();
        int index = 0;
        OdeMath.dMultiply1_331(rdir, this.final_posr().R(), dir);
        double max = OdeMath.dCalcVectorDot3(this.points, 0, rdir);
        int i = 1;
        while (i < this.pointcount) {
            double tmp = OdeMath.dCalcVectorDot3(this.points, i * 3, rdir);
            if (tmp > max) {
                index = i;
                max = tmp;
            }
            ++i;
        }
        return index;
    }

    private static final double dMIN(double a, double b) {
        return a > b ? b : a;
    }

    private static final double dMAX(double a, double b) {
        return a > b ? a : b;
    }

    private static final int dMIN(int a, int b) {
        return a > b ? b : a;
    }

    private static final int dMAX(int a, int b) {
        return a > b ? a : b;
    }

    DxConvex(DxSpace space, double[] _planes, int _planecount, double[] _points, int _pointcount, int[] _polygons) {
        super(space, true);
        Common.dAASSERT(_planes != null);
        Common.dAASSERT(_points != null);
        Common.dAASSERT(_polygons != null);
        this.type = 6;
        this.planesV = new DVector3[_planecount];
        this.planesD = new double[_planecount];
        int i = 0;
        while (i < _planecount) {
            this.planesV[i] = new DVector3(_planes[i * 4], _planes[i * 4 + 1], _planes[i * 4 + 2]);
            this.planesD[i] = _planes[i * 4 + 3];
            ++i;
        }
        this.planecount = _planecount;
        this.points = _points;
        this.pointcount = _pointcount;
        this.polygons = _polygons;
        this.edges = null;
        this.FillEdges();
        int points_in_polyPos = 0;
        int indexPos = 1;
        int i2 = 0;
        while (i2 < this.planecount) {
            Common.dAASSERT(this.polygons[points_in_polyPos] > 2);
            int index03 = this.polygons[indexPos] * 3;
            int index13 = this.polygons[indexPos + 1] * 3;
            int index23 = this.polygons[indexPos + 2] * 3;
            if (this.points[index03 + 0] * this.points[index13 + 1] * this.points[index23 + 2] + this.points[index03 + 1] * this.points[index13 + 2] * this.points[index23 + 0] + this.points[index03 + 2] * this.points[index13 + 0] * this.points[index23 + 1] - this.points[index03 + 2] * this.points[index13 + 1] * this.points[index23 + 0] - this.points[index03 + 1] * this.points[index13 + 0] * this.points[index23 + 2] - this.points[index03 + 0] * this.points[index13 + 2] * this.points[index23 + 1] < 0.0) {
                Cstdio.fprintf(Cstdio.stdout, "WARNING: Polygon %d is not defined counterclockwise\n", i2);
            }
            points_in_polyPos += this.polygons[points_in_polyPos] + 1;
            indexPos = points_in_polyPos + 1;
            if (this.planesD[i2] < 0.0) {
                Cstdio.fprintf(Cstdio.stdout, "WARNING: Plane %d does not contain the origin\n", i2);
            }
            ++i2;
        }
    }

    @Override
    void computeAABB() {
        DVector3 point = new DVector3();
        OdeMath.dMultiply0_331(point, this.final_posr().R(), this.points, 0);
        this._aabb.setMin(this.final_posr().pos());
        this._aabb.setMax(this.final_posr().pos());
        this._aabb.shiftPos(point);
        int i = 3;
        while (i < this.pointcount * 3) {
            OdeMath.dMultiply0_331(point, this.final_posr().R(), this.points, i);
            DVector3 tmp = new DVector3();
            tmp.eqSum(point, this.final_posr().pos());
            this._aabb.expand(tmp);
            i += 3;
        }
    }

    void FillEdges() {
        int points_in_polyPos = 0;
        int indexPos = 1;
        if (this.edges != null) {
            this.edges = null;
        }
        this.edgecount = 0;
        Edge e = new Edge();
        int i = 0;
        while (i < this.planecount) {
            int j = 0;
            while (j < this.polygons[points_in_polyPos]) {
                e.first = DxConvex.dMIN(this.polygons[indexPos + j], this.polygons[indexPos + (j + 1) % this.polygons[points_in_polyPos]]);
                e.second = DxConvex.dMAX(this.polygons[indexPos + j], this.polygons[indexPos + (j + 1) % this.polygons[points_in_polyPos]]);
                boolean isinset = false;
                int k = 0;
                while (k < this.edgecount) {
                    if (this.edges[k].first == e.first && this.edges[k].second == e.second) {
                        isinset = true;
                        break;
                    }
                    ++k;
                }
                if (!isinset) {
                    Edge[] tmp = new Edge[this.edgecount + 1];
                    if (this.edgecount != 0) {
                        int ii = 0;
                        while (ii < this.edges.length) {
                            tmp[ii] = this.edges[ii];
                            ++ii;
                        }
                    }
                    tmp[this.edgecount] = new Edge();
                    tmp[this.edgecount].first = e.first;
                    tmp[this.edgecount].second = e.second;
                    this.edges = tmp;
                    ++this.edgecount;
                }
                ++j;
            }
            points_in_polyPos += this.polygons[points_in_polyPos] + 1;
            indexPos = points_in_polyPos + 1;
            ++i;
        }
    }

    public static DConvex dCreateConvex(DxSpace space, double[] planes, int planecount, double[] points, int pointcount, int[] polygons) {
        return new DxConvex(space, planes, planecount, points, pointcount, polygons);
    }

    void dGeomSetConvex(double[] planes, int planecount, double[] points, int pointcount, int[] polygons) {
        this.planesV = new DVector3[planecount];
        this.planesD = new double[planecount];
        int i = 0;
        while (i < planecount) {
            this.planesV[i] = new DVector3(planes[i * 4], planes[i * 4 + 1], planes[i * 4 + 2]);
            this.planesD[i] = planes[i * 4 + 3];
            ++i;
        }
        this.planecount = planecount;
        this.points = points;
        this.pointcount = pointcount;
        this.polygons = polygons;
    }

    private static boolean IntersectSegmentPlane(DVector3 a, DVector3 b, DVector3 pV, double pD, RefDouble t, DVector3 q) {
        DVector3 ab = new DVector3();
        ab.eqDiff(b, a);
        t.set((pD - OdeMath.dCalcVectorDot3(pV, a)) / OdeMath.dCalcVectorDot3(pV, ab));
        if (t.get() >= 0.0 && t.get() <= 1.0) {
            q.eqSum((DVector3C)a, ab, t.get());
            return true;
        }
        return false;
    }

    private boolean ClosestPointInRay(DVector3 Origin1, DVector3 Direction1, DVector3 Origin2, DVector3 Direction2, RefDouble t) {
        DVector3 w = new DVector3();
        w.eqDiff(Origin1, Origin2);
        double a = OdeMath.dCalcVectorDot3(Direction1, Direction1);
        double b = OdeMath.dCalcVectorDot3(Direction1, Direction2);
        double c = OdeMath.dCalcVectorDot3(Direction2, Direction2);
        double d = OdeMath.dCalcVectorDot3(Direction1, w);
        double e = OdeMath.dCalcVectorDot3(Direction2, w);
        double denominator = a * c - b * b;
        if (denominator == 0.0) {
            return false;
        }
        t.set((a * e - b * d) / denominator);
        return true;
    }

    private static double Clamp(double n, double min, double max) {
        if (n < min) {
            return min;
        }
        if (n > max) {
            return max;
        }
        return n;
    }

    private static double ClosestPointBetweenSegments(DVector3 p1, DVector3 q1, DVector3 p2, DVector3 q2, DVector3 c1, DVector3 c2) {
        double t;
        double s;
        DVector3 d1 = q1.reSub(p1);
        DVector3 d2 = q2.reSub(p2);
        DVector3 r = p1.reSub(p2);
        double a = d1.lengthSquared();
        double e = d2.lengthSquared();
        double f = d2.dot(r);
        if (a <= Common.dEpsilon && e <= Common.dEpsilon) {
            double t2 = 0.0;
            double s2 = 0.0;
            c1.set(p1);
            c2.set(p2);
            return c1.reSub(c2).lengthSquared();
        }
        if (a <= Common.dEpsilon) {
            s = 0.0;
            t = f / e;
            t = DxConvex.Clamp(t, 0.0, 1.0);
        } else {
            double c = OdeMath.dCalcVectorDot3(d1, r);
            if (e <= Common.dEpsilon) {
                t = 0.0;
                s = DxConvex.Clamp(-c / a, 0.0, 1.0);
            } else {
                double b;
                double denom = a * e - (b = OdeMath.dCalcVectorDot3(d1, d2)) * b;
                s = denom != 0.0 ? DxConvex.Clamp((b * f - c * e) / denom, 0.0, 1.0) : 0.0;
                double tnom = b * s + f;
                if (tnom < 0.0) {
                    t = 0.0;
                    s = DxConvex.Clamp(-c / a, 0.0, 1.0);
                } else if (tnom > e) {
                    t = 1.0;
                    s = DxConvex.Clamp((b - c) / a, 0.0, 1.0);
                } else {
                    t = tnom / e;
                }
            }
        }
        c1.eqSum((DVector3C)p1, d1, s);
        c2.eqSum((DVector3C)p2, d2, t);
        return (c1.get0() - c2.get0()) * (c1.get0() - c2.get0()) + (c1.get1() - c2.get1()) * (c1.get1() - c2.get1()) + (c1.get2() - c2.get2()) * (c1.get2() - c2.get2());
    }

    private boolean IntersectPlanes(DVector3 p1, double p13, DVector3 p2, double p23, DVector3 p, DVector3 d) {
        OdeMath.dCalcVectorCross3(d, p1, p2);
        double denom = d.dot(d);
        if (denom < Common.dEpsilon) {
            return false;
        }
        DVector3 n = new DVector3();
        n.eqSum(p2, p13, (DVector3C)p1, -p23);
        OdeMath.dCalcVectorCross3(p, n, d);
        p.scale(1.0 / denom);
        return true;
    }

    private static final boolean IsPointInPolygon(DVector3C p, int[] polygonA, int polyPos, DxConvex convex, DVector3 out) {
        int pointcount = polygonA[0 + polyPos];
        DVector3 a = new DVector3();
        DVector3 b = new DVector3();
        DVector3 c = new DVector3();
        DVector3 ab = new DVector3();
        DVector3 ac = new DVector3();
        DVector3 ap = new DVector3();
        DVector3 bp = new DVector3();
        ++polyPos;
        int i = 0;
        while (i < pointcount) {
            OdeMath.dMultiply0_331(a, convex.final_posr().R(), convex.points, polygonA[i + polyPos] * 3);
            a.eqSum(convex.final_posr().pos(), a);
            OdeMath.dMultiply0_331(b, convex.final_posr().R(), convex.points, polygonA[(polyPos + i + 1) % pointcount] * 3);
            b.eqSum(convex.final_posr().pos(), b);
            OdeMath.dMultiply0_331(c, convex.final_posr().R(), convex.points, polygonA[(polyPos + i + 2) % pointcount] * 3);
            c.eqSum(convex.final_posr().pos(), c);
            ab.eqDiff(b, a);
            ac.eqDiff(c, a);
            ap.eqDiff(p, a);
            double d1 = OdeMath.dCalcVectorDot3(ab, ap);
            double d2 = OdeMath.dCalcVectorDot3(ac, ap);
            if (d1 <= 0.0 && d2 <= 0.0) {
                out.set(a);
                return false;
            }
            bp.eqDiff(p, b);
            double d3 = OdeMath.dCalcVectorDot3(ab, bp);
            double d4 = OdeMath.dCalcVectorDot3(ac, bp);
            if (d3 >= 0.0 && d4 <= d3) {
                out.set(b);
                return false;
            }
            double vc = d1 * d4 - d3 * d2;
            if (vc < 0.0 && d1 > 0.0 && d3 < 0.0) {
                double v = d1 / (d1 - d3);
                out.eqSum((DVector3C)a, ab, v);
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void ComputeInterval(DxConvex cvx, DVector3 axis, double axisD, RefDouble min, RefDouble max) {
        DVector3 point = new DVector3();
        OdeMath.dMultiply0_331(point, cvx.final_posr().R(), cvx.points, 0);
        point.add(cvx.final_posr().pos());
        min.set(OdeMath.dCalcVectorDot3(point, axis) - axisD);
        max.set(min.get());
        int i = 1;
        while (i < cvx.pointcount) {
            OdeMath.dMultiply0_331(point, cvx.final_posr().R(), cvx.points, i * 3);
            point.add(cvx.final_posr().pos());
            double value = OdeMath.dCalcVectorDot3(point, axis) - axisD;
            if (value < min.get()) {
                min.set(value);
            } else if (value > max.get()) {
                max.set(value);
            }
            ++i;
        }
    }

    boolean CheckEdgeIntersection(DxConvex cvx1, DxConvex cvx2, int flags, RefInt curc, DContactGeomBuffer contacts, int skip) {
        int maxc = flags & 0xFFFF;
        Common.dIASSERT(maxc != 0);
        DVector3 e1 = new DVector3();
        DVector3 e2 = new DVector3();
        DVector3 q = new DVector3();
        DVector3 planeV = new DVector3();
        DVector3 depthplaneV = new DVector3();
        RefDouble t = new RefDouble();
        int i = 0;
        while (i < cvx1.edgecount) {
            OdeMath.dMultiply0_331(e1, cvx1.final_posr().R(), cvx1.points, cvx1.edges[i].first * 3);
            e1.add(cvx1.final_posr().pos());
            OdeMath.dMultiply0_331(e2, cvx1.final_posr().R(), cvx1.points, cvx1.edges[i].second * 3);
            e2.add(cvx1.final_posr().pos());
            int[] pPolyV = cvx2.polygons;
            int pPolyPos = 0;
            int j = 0;
            while (j < cvx2.planecount) {
                OdeMath.dMultiply0_331(planeV, cvx2.final_posr().R(), (DVector3C)cvx2.planesV[i]);
                OdeMath.dNormalize3(planeV);
                double planeD = cvx2.planesD[j] + planeV.dot(cvx2.final_posr().pos());
                DContactGeom target = contacts.getSafe(flags, curc.get());
                target.g1 = cvx1;
                target.g2 = cvx2;
                if (DxConvex.IntersectSegmentPlane(e1, e2, planeV, planeD, t, target.pos) && DxConvex.IsPointInPolygon(target.pos, pPolyV, pPolyPos, cvx2, q)) {
                    target.depth = Double.POSITIVE_INFINITY;
                    int k = 0;
                    while (k < cvx2.planecount) {
                        if (k != j) {
                            OdeMath.dMultiply0_331(depthplaneV, cvx2.final_posr().R(), (DVector3C)cvx2.planesV[k]);
                            OdeMath.dNormalize3(depthplaneV);
                            double depthplaneD = cvx2.planesD[k] + planeV.dot(cvx2.final_posr().pos());
                            double depth = depthplaneV.dot(target.pos) - depthplaneD;
                            if (Cmath.fabs(depth) < Cmath.fabs(target.depth) && (depth < -Common.dEpsilon || depth > Common.dEpsilon)) {
                                target.depth = depth;
                                target.normal.set(depthplaneV);
                            }
                        }
                        ++k;
                    }
                    curc.inc();
                    if (curc.get() == maxc) {
                        return true;
                    }
                }
                pPolyPos += pPolyV[pPolyPos] + 1;
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static boolean CheckSATConvexFaces(DxConvex cvx1, DxConvex cvx2, ConvexConvexSATOutput ccso) {
        RefDouble min1 = new RefDouble();
        RefDouble max1 = new RefDouble();
        RefDouble min2 = new RefDouble();
        RefDouble max2 = new RefDouble();
        DVector3 planeV = new DVector3();
        int i = 0;
        while (i < cvx1.planecount) {
            OdeMath.dMultiply0_331(planeV, cvx1.final_posr().R(), (DVector3C)cvx1.planesV[i]);
            OdeMath.dNormalize3(planeV);
            double planeD = cvx1.planesD[i] + planeV.dot(cvx1.final_posr().pos());
            DxConvex.ComputeInterval(cvx1, planeV, planeD, min1, max1);
            DxConvex.ComputeInterval(cvx2, planeV, planeD, min2, max2);
            if (max2.get() < min1.get() || max1.get() < min2.get()) {
                return false;
            }
            double min = DxConvex.dMAX(min1.get(), min2.get());
            double max = DxConvex.dMIN(max1.get(), max2.get());
            double depth = max - min;
            if (max2.get() * min2.get() <= 0.0 && Common.dFabs(depth) < Common.dFabs(ccso.min_depth)) {
                ccso.min_depth = -depth;
                ccso.depth_type = 1;
            }
            ++i;
        }
        return true;
    }

    private static boolean CheckSATConvexEdges(DxConvex cvx1, DxConvex cvx2, ConvexConvexSATOutput ccso) {
        RefDouble min1 = new RefDouble();
        RefDouble max1 = new RefDouble();
        RefDouble min2 = new RefDouble();
        RefDouble max2 = new RefDouble();
        DVector3 planeV = new DVector3();
        DVector3 e1 = new DVector3();
        DVector3 e2 = new DVector3();
        DVector3 e1a = new DVector3();
        DVector3 e1b = new DVector3();
        DVector3 e2a = new DVector3();
        DVector3 e2b = new DVector3();
        DVector3 dist = new DVector3(ccso.dist);
        int s1 = cvx1.SupportIndex(dist);
        dist.scale(-1.0);
        int s2 = cvx2.SupportIndex(dist);
        int i = 0;
        while (i < cvx1.edgecount) {
            if (cvx1.edges[i].first == s1 || cvx1.edges[i].second == s1) {
                OdeMath.dMultiply0_331(e1a, cvx1.final_posr().R(), cvx1.points, cvx1.edges[i].first * 3);
                OdeMath.dMultiply0_331(e1b, cvx1.final_posr().R(), cvx1.points, cvx1.edges[i].second * 3);
                e1.eqDiff(e1b, e1a);
                int j = 0;
                while (j < cvx2.edgecount) {
                    if (cvx2.edges[j].first == s2 || cvx2.edges[j].second == s2) {
                        OdeMath.dMultiply0_331(e2a, cvx2.final_posr().R(), cvx2.points, cvx2.edges[j].first * 3);
                        OdeMath.dMultiply0_331(e2b, cvx2.final_posr().R(), cvx2.points, cvx2.edges[j].second * 3);
                        e2.eqDiff(e2b, e2a);
                        OdeMath.dCalcVectorCross3(planeV, e1, e2);
                        if (!(planeV.dot(planeV) < Common.dEpsilon)) {
                            OdeMath.dNormalize3(planeV);
                            double planeD = 0.0;
                            DxConvex.ComputeInterval(cvx1, planeV, planeD, min1, max1);
                            DxConvex.ComputeInterval(cvx2, planeV, planeD, min2, max2);
                            if (max2.get() < min1.get() || max1.get() < min2.get()) {
                                return false;
                            }
                            double min = DxConvex.dMAX(min1.get(), min2.get());
                            double max = DxConvex.dMIN(max1.get(), max2.get());
                            double depth = max - min;
                            if (Common.dFabs(depth) + Common.dEpsilon < Common.dFabs(ccso.min_depth)) {
                                ccso.min_depth = depth;
                                ccso.depth_type = 2;
                                ccso.e1a.set(e1a);
                                ccso.e1b.set(e1b);
                                ccso.e1a.add(cvx1.final_posr().pos());
                                ccso.e1b.add(cvx1.final_posr().pos());
                                ccso.e2a.set(e2a);
                                ccso.e2b.set(e2b);
                                ccso.e2a.add(cvx2.final_posr().pos());
                                ccso.e2b.add(cvx2.final_posr().pos());
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private static int GetSupportSide(DVector3 dir, DxConvex cvx) {
        DVector3 dics = new DVector3();
        DVector3 tmp = new DVector3();
        int side = 0;
        tmp.set(dir);
        OdeMath.dNormalize3(tmp);
        OdeMath.dMultiply1_331(dics, cvx.final_posr().R(), tmp);
        double SavedDot = dics.dot(cvx.planesV[0]);
        int i = 1;
        while (i < cvx.planecount) {
            double Dot = OdeMath.dCalcVectorDot3(dics, cvx.planesV[i]);
            if (Dot > SavedDot) {
                SavedDot = Dot;
                side = i;
            }
            ++i;
        }
        return side;
    }

    private static int TestConvexIntersection(DxConvex cvx1, DxConvex cvx2, int flags, DContactGeomBuffer contactBuf, int skip) {
        ConvexConvexSATOutput ccso = new ConvexConvexSATOutput();
        ccso.min_depth = Double.POSITIVE_INFINITY;
        ccso.depth_type = 0;
        ccso.dist.eqDiff(cvx2.final_posr().pos(), cvx1.final_posr().pos());
        int maxc = flags & 0xFFFF;
        Common.dIASSERT(maxc != 0);
        DVector3 i1 = new DVector3();
        DVector3 i2 = new DVector3();
        DVector3 r1 = new DVector3();
        DVector3 r2 = new DVector3();
        int contacts = 0;
        if (!DxConvex.CheckSATConvexFaces(cvx1, cvx2, ccso)) {
            return 0;
        }
        if (!DxConvex.CheckSATConvexFaces(cvx2, cvx1, ccso)) {
            return 0;
        }
        if (!DxConvex.CheckSATConvexEdges(cvx1, cvx2, ccso)) {
            return 0;
        }
        if (ccso.depth_type == 1) {
            double d;
            boolean out;
            boolean outside;
            DVector3 planeV = new DVector3();
            DVector3 rplaneV = new DVector3();
            DVector3 iplaneV = new DVector3();
            DVector3 tmp = new DVector3();
            DVector3 p = new DVector3();
            RefDouble t = new RefDouble();
            DVector3 dist = new DVector3(ccso.dist);
            int reference_side = DxConvex.GetSupportSide(dist, cvx1);
            dist.scale(-1.0);
            int incident_side = DxConvex.GetSupportSide(dist, cvx2);
            int pReferencePolyPos = 0;
            int pIncidentPolyPos = 0;
            int[] refPolys = cvx1.polygons;
            int[] incPolys = cvx2.polygons;
            OdeMath.dMultiply0_331(rplaneV, cvx1.final_posr().R(), (DVector3C)cvx1.planesV[reference_side]);
            OdeMath.dNormalize3(rplaneV);
            double rplaneD = cvx1.planesD[reference_side] + rplaneV.dot(cvx1.final_posr().pos());
            rplaneV.scale(-1.0);
            rplaneD = -rplaneD;
            int i = 0;
            while (i < incident_side) {
                pIncidentPolyPos += incPolys[pIncidentPolyPos] + 1;
                ++i;
            }
            int pIncidentPointsPos = pIncidentPolyPos + 1;
            OdeMath.dMultiply0_331(i2, cvx2.final_posr().R(), cvx2.points, incPolys[pIncidentPointsPos] * 3);
            i2.add(cvx2.final_posr().pos());
            r2.set(i2);
            r2.sub(cvx1.final_posr().pos());
            tmp.set(r2);
            OdeMath.dMultiply1_331(r2, cvx1.final_posr().R(), tmp);
            i = 0;
            while (i < cvx2.polygons[pIncidentPolyPos]) {
                i1.set(i2);
                r1.set(r2);
                OdeMath.dMultiply0_331(i2, cvx2.final_posr().R(), cvx2.points, incPolys[pIncidentPointsPos + (i + 1) % incPolys[pIncidentPolyPos]] * 3);
                i2.add(cvx2.final_posr().pos());
                r2.set(i1);
                r2.sub(cvx1.final_posr().pos());
                tmp.set(r2);
                OdeMath.dMultiply1_331(r2, cvx1.final_posr().R(), tmp);
                outside = false;
                int j = 0;
                while (j < cvx1.planecount) {
                    planeV.set(cvx1.planesV[j]);
                    double planeD = cvx1.planesD[j];
                    double d1 = r1.dot(planeV) - planeD;
                    double d2 = r2.dot(planeV) - planeD;
                    if (d1 * d2 < 0.0) {
                        DxConvex.IntersectSegmentPlane(r1, r2, planeV, planeD, t, p);
                        out = false;
                        int k = 0;
                        while (k < cvx1.planecount) {
                            d = p.dot(cvx1.planesV[k]) - cvx1.planesD[k];
                            if (d > 0.0) {
                                out = true;
                                break;
                            }
                            ++k;
                        }
                        if (!out) {
                            OdeMath.dMultiply0_331(tmp, cvx1.final_posr().R(), (DVector3C)p);
                            p.eqSum(tmp, cvx1.final_posr().pos());
                            d = p.dot(rplaneV) - rplaneD;
                            if (d > 0.0) {
                                DContactGeom contact = contactBuf.getSafe(flags, contacts);
                                contact.pos.set(p);
                                contact.normal.set(rplaneV);
                                contact.g1 = cvx1;
                                contact.g2 = cvx2;
                                contact.depth = d;
                                if (++contacts == maxc) {
                                    return contacts;
                                }
                            }
                        }
                    }
                    if (d1 > 0.0) {
                        outside = true;
                    }
                    ++j;
                }
                if (!outside && (d = i1.dot(rplaneV) - rplaneD) > 0.0) {
                    DContactGeom contact = contactBuf.getSafe(flags, contacts);
                    contact.pos.set(i1);
                    contact.normal.set(rplaneV);
                    contact.g1 = cvx1;
                    contact.g2 = cvx2;
                    contact.depth = d;
                    if (++contacts == maxc) {
                        return contacts;
                    }
                }
                ++i;
            }
            OdeMath.dMultiply0_331(iplaneV, cvx2.final_posr().R(), (DVector3C)cvx2.planesV[incident_side]);
            OdeMath.dNormalize3(iplaneV);
            double iplaneD = cvx2.planesD[incident_side] + iplaneV.dot(cvx2.final_posr().pos());
            i = 0;
            while (i < reference_side) {
                pReferencePolyPos += refPolys[pReferencePolyPos] + 1;
                ++i;
            }
            int pReferencePointsPos = pReferencePolyPos + 1;
            i = 0;
            while (i < refPolys[pReferencePolyPos]) {
                OdeMath.dMultiply0_331(i1, cvx1.final_posr().R(), cvx1.points, refPolys[pReferencePointsPos + i] * 3);
                i1.add(cvx1.final_posr().pos());
                t.set(-(i1.dot(iplaneV) - iplaneD));
                i1.eqSum((DVector3C)i1, iplaneV, t.get());
                r1.set(i1);
                r1.sub(cvx2.final_posr().pos());
                tmp.set(r1);
                OdeMath.dMultiply1_331(r1, cvx2.final_posr().R(), tmp);
                out = false;
                int j = 0;
                while (j < cvx2.planecount) {
                    d = r1.dot(cvx2.planesV[j]) - cvx2.planesD[j];
                    if (d >= 0.0) {
                        out = true;
                        break;
                    }
                    ++j;
                }
                if (!out) {
                    outside = false;
                    j = 0;
                    while (j < contacts) {
                        if (contactBuf.getSafe((int)flags, (int)j).pos.isEq(i1)) {
                            outside = true;
                        }
                        ++j;
                    }
                    if (!outside && (d = i1.dot(rplaneV) - rplaneD) > 0.0) {
                        DContactGeom contact = contactBuf.getSafe(flags, contacts);
                        contact.pos.set(i1);
                        contact.normal.set(rplaneV);
                        contact.g1 = cvx1;
                        contact.g2 = cvx2;
                        contact.depth = d;
                        if (++contacts == maxc) {
                            return contacts;
                        }
                    }
                }
                ++i;
            }
        } else if (ccso.depth_type == 2) {
            DVector3 c1 = new DVector3();
            DVector3 c2 = new DVector3();
            DContactGeom contact = contactBuf.getSafe(flags, contacts);
            contact.depth = Common.dSqrt(DxConvex.ClosestPointBetweenSegments(ccso.e1a, ccso.e1b, ccso.e2a, ccso.e2b, c1, c2));
            contact.g1 = cvx1;
            contact.g2 = cvx2;
            contact.pos.set(c1);
            contact.normal.eqDiff(c2, c1);
            contact.normal.normalize();
            ++contacts;
        }
        return contacts;
    }

    @Override
    public void setConvex(double[] planes, int planeCount, double[] points, int pointCount, int[] polygons) {
        this.dGeomSetConvex(planes, planeCount, points, pointCount, polygons);
    }

    public double[] getPoints() {
        return this.points;
    }

    public int getPointcount() {
        return this.pointcount;
    }

    static class CollideConvexBox
    implements DColliderFn {
        CollideConvexBox() {
        }

        int dCollideConvexBox(DxConvex Convex, DxBox box, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            return 0;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideConvexBox((DxConvex)o1, (DxBox)o2, flags, contacts, 1);
        }
    }

    static class CollideConvexCapsule
    implements DColliderFn {
        CollideConvexCapsule() {
        }

        int dCollideConvexCapsule(DxConvex Convex, DxCapsule Capsule, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            return 0;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideConvexCapsule((DxConvex)o1, (DxCapsule)o2, flags, contacts, 1);
        }
    }

    public static class CollideConvexConvex
    implements DColliderFn {
        int dCollideConvexConvex(DxConvex Convex1, DxConvex Convex2, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            return DxConvex.TestConvexIntersection(Convex1, Convex2, flags, contacts, skip);
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideConvexConvex((DxConvex)o1, (DxConvex)o2, flags, contacts, 1);
        }
    }

    static class CollideConvexPlane
    implements DColliderFn {
        CollideConvexPlane() {
        }

        int dCollideConvexPlane(DxConvex Convex, DxPlane Plane, int flags, DContactGeomBuffer contactBuf, int skip) {
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            int contacts = 0;
            int maxc = flags & 0xFFFF;
            DVector3 v2 = new DVector3();
            int LTEQ_ZERO = 0x10000000;
            int GTEQ_ZERO = 0x20000000;
            int BOTH_SIGNS = 0x30000000;
            int totalsign = 0;
            int i = 0;
            while (i < Convex.pointcount) {
                OdeMath.dMultiply0_331(v2, Convex.final_posr().R(), Convex.points, i * 3);
                v2.add(Convex.final_posr().pos());
                int distance2sign = 0x20000000;
                double distance2 = Plane.getNormal().dot(v2) - Plane.getDepth();
                if (distance2 <= 0.0) {
                    int n = distance2sign = distance2 != 0.0 ? 0x10000000 : 0x30000000;
                    if (contacts != maxc) {
                        DContactGeom target = contactBuf.getSafe(flags, contacts);
                        target.normal.set(Plane.getNormal());
                        target.pos.set(v2);
                        target.depth = -distance2;
                        target.g1 = Convex;
                        target.g2 = Plane;
                        target.side1 = -1;
                        target.side2 = -1;
                        ++contacts;
                    }
                }
                if ((contacts ^ maxc | (totalsign |= distance2sign)) == 0x30000000) break;
                ++i;
            }
            if (totalsign == 0x30000000) {
                return contacts;
            }
            return 0;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideConvexPlane((DxConvex)o1, (DxPlane)o2, flags, contacts, 1);
        }
    }

    static class CollideRayConvex
    implements DColliderFn {
        CollideRayConvex() {
        }

        int dCollideRayConvex(DxRay ray, DxConvex convex, int flags, DContactGeomBuffer contacts, int skip) {
            double alpha;
            int planePos;
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            DContactGeom contact = contacts.get(0);
            contact.g1 = ray;
            contact.g2 = convex;
            contact.side1 = -1;
            contact.side2 = -1;
            boolean flag = false;
            int i = 0;
            while (i < convex.planecount) {
                planePos = i++;
                alpha = OdeMath.dCalcVectorDot3(convex.planesV[planePos], ray.final_posr().pos()) - convex.planesD[planePos];
                if (!(alpha >= 0.0)) continue;
                flag = true;
                break;
            }
            double nsign = flag ? 1.0 : -1.0;
            contact.depth = Double.POSITIVE_INFINITY;
            i = 0;
            while (i < convex.planecount) {
                planePos = i;
                alpha = nsign * (OdeMath.dCalcVectorDot3(convex.planesV[planePos], ray.final_posr().pos()) - convex.planesD[planePos]);
                double beta = convex.planesV[planePos].dot(ray.final_posr().R().viewCol(2)) * nsign;
                if (beta < -Common.dEpsilon && alpha >= 0.0 && alpha <= ray.getLength() && alpha < contact.depth) {
                    contact.pos.eqSum(ray.final_posr().pos(), 0.0, (DVector3C)ray.final_posr().R().columnAsNewVector(2), alpha);
                    flag = false;
                    int j = 0;
                    while (j < convex.planecount) {
                        if (i != j) {
                            int planePosJ = j;
                            beta = OdeMath.dCalcVectorDot3(convex.planesV[planePosJ], contact.pos) - convex.planesD[planePos];
                            if (beta > Common.dEpsilon) {
                                flag = true;
                                break;
                            }
                        }
                        ++j;
                    }
                    if (!flag) {
                        contact.normal.set(convex.planesV[planePos]).scale(nsign);
                        contact.depth = alpha;
                        if ((flags & Integer.MIN_VALUE) != 0 && contact.depth <= ray.getLength()) break;
                    }
                }
                ++i;
            }
            return contact.depth <= ray.getLength() ? 1 : 0;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideRayConvex((DxRay)o1, (DxConvex)o2, flags, contacts, 1);
        }
    }

    static class CollideSphereConvex
    implements DColliderFn {
        CollideSphereConvex() {
        }

        int dCollideSphereConvex(DxSphere sphere, DxConvex convex, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip >= 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            double closestdist = Double.POSITIVE_INFINITY;
            DVector3 planeV = new DVector3();
            DVector3 offsetpos = new DVector3();
            DVector3 out = new DVector3();
            DVector3 temp = new DVector3();
            int[] pPolyV = convex.polygons;
            int pPolyPos = 0;
            int closestplane = -1;
            boolean sphereinside = true;
            DContactGeom contact = contacts.get(0);
            offsetpos.eqDiff(sphere.final_posr().pos(), convex.final_posr().pos());
            int i = 0;
            while (i < convex.planecount) {
                OdeMath.dMultiply0_331(planeV, convex.final_posr().R(), (DVector3C)convex.planesV[i]);
                double planeD = convex.planesD[i];
                double dist = planeV.dot(offsetpos) - planeD;
                if (dist > 0.0) {
                    if (dist < sphere.getRadius()) {
                        if (DxConvex.IsPointInPolygon(sphere.final_posr().pos(), pPolyV, pPolyPos, convex, out)) {
                            contact.normal.set(planeV);
                            contact.pos.eqSum(sphere.final_posr().pos(), contact.normal, -sphere.getRadius());
                            contact.depth = sphere.getRadius() - dist;
                            contact.g1 = sphere;
                            contact.g2 = convex;
                            contact.side1 = -1;
                            contact.side2 = -1;
                            return 1;
                        }
                        temp.eqDiff(sphere.final_posr().pos(), out);
                        dist = temp.lengthSquared();
                        if (dist < sphere.getRadius() * sphere.getRadius()) {
                            dist = Common.dSqrt(dist);
                            contact.normal.set(temp).scale(1.0 / dist);
                            contact.pos.eqSum(sphere.final_posr().pos(), contact.normal, -sphere.getRadius());
                            contact.depth = sphere.getRadius() - dist;
                            contact.g1 = sphere;
                            contact.g2 = convex;
                            contact.side1 = -1;
                            contact.side2 = -1;
                            return 1;
                        }
                    }
                    sphereinside = false;
                }
                if (sphereinside && closestdist > Common.dFabs(dist)) {
                    closestdist = Common.dFabs(dist);
                    closestplane = i;
                }
                pPolyPos += pPolyV[pPolyPos] + 1;
                ++i;
            }
            if (sphereinside) {
                OdeMath.dMultiply0_331(contact.normal, convex.final_posr().R(), (DVector3C)convex.planesV[closestplane]);
                contact.pos.set(sphere.final_posr().pos());
                contact.depth = closestdist + sphere.getRadius();
                contact.g1 = sphere;
                contact.g2 = convex;
                contact.side1 = -1;
                contact.side2 = -1;
                return 1;
            }
            return 0;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideSphereConvex((DxSphere)o1, (DxConvex)o2, flags, contacts, 1);
        }
    }

    private static class ConvexConvexSATOutput {
        double min_depth;
        int depth_type;
        DVector3 dist = new DVector3();
        DVector3 e1a = new DVector3();
        DVector3 e1b = new DVector3();
        DVector3 e2a = new DVector3();
        DVector3 e2b = new DVector3();

        private ConvexConvexSATOutput() {
        }
    }

    private static class Edge {
        int first;
        int second;

        private Edge() {
        }
    }
}

