/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cmath;
import org.cpp4j.java.RefDouble;
import org.cpp4j.java.RefInt;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.math.DVector4;
import org.ode4j.ode.DAABB;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxGeom;

public class DxCollisionUtil {
    final DContactGeom[] SAFECONTACT(int Flags, DContactGeom[] Contacts, int Index, int Stride) {
        Common.dIASSERT(Index >= 0 && Index < (Flags & 0xFFFF));
        throw new UnsupportedOperationException();
    }

    static void dVector3Subtract(DVector3C a, DVector3C b, DVector3 c) {
        c.eqDiff(a, b);
    }

    void dVector3Scale(DVector3 a, double nScale) {
        a.scale(nScale);
    }

    void dVector3Add(DVector3 a, DVector3 b, DVector3 c) {
        c.eqSum(a, b);
    }

    static void dVector3Copy(DVector3C a, DVector3 c) {
        c.set(a);
    }

    static void dVector3Cross(DVector3C a, DVector3C b, DVector3 c) {
        OdeMath.dCalcVectorCross3(c, a, b);
    }

    double dVector3Length(DVector3 a) {
        return a.length();
    }

    double dVector3Dot(DVector3C a, DVector3C b) {
        return a.dot(b);
    }

    static void dVector3Inv(DVector3 a) {
        a.scale(-1.0);
    }

    double dVector3LengthSquare(DVector3 a) {
        return a.lengthSquared();
    }

    static void dMat3GetCol(DMatrix3 m, int col, DVector3 v) {
        if (col == 0) {
            v.set(m.get00(), m.get10(), m.get20());
        } else if (col == 1) {
            v.set(m.get01(), m.get11(), m.get21());
        } else if (col == 2) {
            v.set(m.get02(), m.get12(), m.get22());
        } else {
            throw new IllegalArgumentException("col=" + col);
        }
    }

    void dVector3CrossMat3Col(DMatrix3C m, int col, DVector3C v, DVector3 r) {
        if (col == 0) {
            r.set0(v.get1() * m.get20() - v.get2() * m.get10());
            r.set1(v.get2() * m.get00() - v.get0() * m.get20());
            r.set2(v.get0() * m.get10() - v.get1() * m.get00());
        } else if (col == 1) {
            r.set0(v.get1() * m.get21() - v.get2() * m.get11());
            r.set1(v.get2() * m.get01() - v.get0() * m.get21());
            r.set2(v.get0() * m.get11() - v.get1() * m.get01());
        } else if (col == 2) {
            r.set0(v.get1() * m.get22() - v.get2() * m.get12());
            r.set1(v.get2() * m.get02() - v.get0() * m.get22());
            r.set2(v.get0() * m.get12() - v.get1() * m.get02());
        } else {
            throw new IllegalArgumentException("col=" + col);
        }
    }

    void dMat3ColCrossVector3(DMatrix3 m, int col, DVector3 v, DVector3 r) {
        if (col == 0) {
            r.set0(v.get2() * m.get10() - v.get1() * m.get20());
            r.set1(v.get0() * m.get20() - v.get2() * m.get00());
            r.set2(v.get1() * m.get00() - v.get0() * m.get10());
        } else if (col == 1) {
            r.set0(v.get2() * m.get11() - v.get1() * m.get21());
            r.set1(v.get0() * m.get21() - v.get2() * m.get01());
            r.set2(v.get1() * m.get01() - v.get0() * m.get11());
        } else if (col == 2) {
            r.set0(v.get2() * m.get12() - v.get1() * m.get22());
            r.set1(v.get0() * m.get22() - v.get2() * m.get02());
            r.set2(v.get1() * m.get02() - v.get0() * m.get12());
        } else {
            throw new IllegalArgumentException("col=" + col);
        }
    }

    void dMultiplyMat3Vec3(DMatrix3 m, DVector3 v, DVector3 r) {
        OdeMath.dMultiply0_331(r, (DMatrix3C)m, (DVector3C)v);
    }

    static double dPointPlaneDistance(DVector3 point, DVector4 plane) {
        return plane.get0() * point.get0() + plane.get1() * point.get1() + plane.get2() * point.get2() + plane.get3();
    }

    static void dConstructPlane(DVector3 normal, double distance, DVector4 plane) {
        plane.set(normal.get0(), normal.get1(), normal.get2(), distance);
    }

    static void dMatrix3Copy(DMatrix3C source, DMatrix3 dest) {
        dest.set(source);
    }

    double dMatrix3Det(DMatrix3 mat) {
        double det = mat.get00() * (mat.get11() * mat.get22() - mat.get21() * mat.get12()) - mat.get01() * (mat.get10() * mat.get22() - mat.get20() * mat.get12()) + mat.get02() * (mat.get10() * mat.get21() - mat.get20() * mat.get11());
        return det;
    }

    void dMatrix3Inv(DMatrix3 ma, DMatrix3 dst) {
        double det = this.dMatrix3Det(ma);
        if (Common.dFabs(det) < 5.0E-4) {
            dst.setIdentity();
            return;
        }
        dst.set00(ma.get11() * ma.get22() - ma.get12() * ma.get21() / det);
        dst.set01(-(ma.get01() * ma.get22() - ma.get21() * ma.get02()) / det);
        dst.set02(ma.get01() * ma.get12() - ma.get11() * ma.get02() / det);
        dst.set10(-(ma.get10() * ma.get22() - ma.get12() * ma.get20()) / det);
        dst.set11(ma.get00() * ma.get22() - ma.get20() * ma.get02() / det);
        dst.set12(-(ma.get00() * ma.get12() - ma.get10() * ma.get02()) / det);
        dst.set20(ma.get10() * ma.get21() - ma.get20() * ma.get11() / det);
        dst.set21(-(ma.get00() * ma.get21() - ma.get20() * ma.get01()) / det);
        dst.set22(ma.get00() * ma.get11() - ma.get01() * ma.get10() / det);
    }

    static void dQuatTransform(DQuaternion quat, DVector3 source, DVector3 dest) {
        double x0 = source.get0() * quat.get0() + source.get2() * quat.get2() - source.get1() * quat.get3();
        double x1 = source.get1() * quat.get0() + source.get0() * quat.get3() - source.get2() * quat.get1();
        double x2 = source.get2() * quat.get0() + source.get1() * quat.get1() - source.get0() * quat.get2();
        double x3 = source.get0() * quat.get1() + source.get1() * quat.get2() + source.get2() * quat.get3();
        dest.set0(quat.get0() * x0 + quat.get1() * x3 + quat.get2() * x2 - quat.get3() * x1);
        dest.set1(quat.get0() * x1 + quat.get2() * x3 + quat.get3() * x0 - quat.get1() * x2);
        dest.set2(quat.get0() * x2 + quat.get3() * x3 + quat.get1() * x1 - quat.get2() * x0);
    }

    void dQuatInvTransform(DQuaternion quat, DVector3 source, DVector3 dest) {
        double norm = quat.get0() * quat.get0() + quat.get1() * quat.get1() + quat.get2() * quat.get2() + quat.get3() * quat.get3();
        if (norm > 0.0) {
            DQuaternion invQuat = new DQuaternion();
            invQuat.set0(quat.get0() / norm);
            invQuat.set1(-quat.get1() / norm);
            invQuat.set2(-quat.get2() / norm);
            invQuat.set3(-quat.get3() / norm);
            DxCollisionUtil.dQuatTransform(invQuat, source, dest);
        } else {
            DxCollisionUtil.dVector3Copy(source, dest);
        }
    }

    void dGetEulerAngleFromRot(DMatrix3 mRot, RefDouble rX, RefDouble rY, RefDouble rZ) {
        rY.set(Cmath.asin(mRot.get02()));
        if (rY.get() < 1.5707963267948966) {
            if (rY.get() > -1.5707963267948966) {
                rX.set(Cmath.atan2(-mRot.get12(), mRot.get22()));
                rZ.set(Cmath.atan2(-mRot.get01(), mRot.get00()));
            } else {
                rX.set(-Cmath.atan2(mRot.get10(), mRot.get11()));
                rZ.set(0.0);
            }
        } else {
            rX.set(Cmath.atan2(mRot.get10(), mRot.get11()));
            rZ.set(0.0);
        }
    }

    static void dQuatInv(DQuaternion source, DQuaternion dest) {
        double norm = source.get0() * source.get0() + source.get1() * source.get1() + source.get2() * source.get2() + source.get3() * source.get3();
        if (norm > 0.0) {
            dest.set0(source.get0() / norm);
            dest.set1(-source.get1() / norm);
            dest.set2(-source.get2() / norm);
            dest.set3(-source.get3() / norm);
        } else {
            dest.set(1.0, 0.0, 0.0, 0.0);
        }
    }

    static int dCollideSpheres(DVector3C p1, double r1, DVector3C p2, double r2, DContactGeomBuffer cb) {
        DContactGeom c = cb.get();
        double d = p1.distance(p2);
        if (d > r1 + r2) {
            return 0;
        }
        if (d <= 0.0) {
            c.pos.set(p1);
            c.normal.set(1.0, 0.0, 0.0);
            c.depth = r1 + r2;
        } else {
            double d1 = Common.dRecip(d);
            c.normal.set0((p1.get0() - p2.get0()) * d1);
            c.normal.set1((p1.get1() - p2.get1()) * d1);
            c.normal.set2((p1.get2() - p2.get2()) * d1);
            double k = 0.5 * (r2 - r1 - d);
            c.pos.eqSum(p1, c.normal, k);
            c.depth = r1 + r2 - d;
        }
        return 1;
    }

    static void dLineClosestApproach(DVector3 pa, DVector3 ua, DVector3 pb, DVector3 ub, RefDouble alpha, RefDouble beta) {
        DVector3 p = new DVector3();
        p.eqDiff(pb, pa);
        double uaub = OdeMath.dCalcVectorDot3(ua, ub);
        double q1 = OdeMath.dCalcVectorDot3(ua, p);
        double q2 = -OdeMath.dCalcVectorDot3(ub, p);
        double d = 1.0 - uaub * uaub;
        if (d <= 1.0E-4) {
            alpha.set(0.0);
            beta.set(0.0);
        } else {
            d = Common.dRecip(d);
            alpha.set((q1 + uaub * q2) * d);
            beta.set((uaub * q1 + q2) * d);
        }
    }

    private static void SET2(DVector3 a, DVector3 b) {
        a.set(b);
    }

    private static void SET3_SUB(DVector3 a, DVector3 b, DVector3 c) {
        DxCollisionUtil.SET3_SUB(a, 1.0, b, 1.0, c);
    }

    private static void SET3_SUB(DVector3 a, double f1, DVector3 b, double f2, DVector3 c) {
        a.set0(b.get0() * f1 - c.get0() * f2);
        a.set1(b.get1() * f1 - c.get1() * f2);
        a.set2(b.get2() * f1 - c.get2() * f2);
    }

    private static void SET3_ADD(DVector3 a, double f1, DVector3 b, double f2, DVector3 c) {
        a.set0(b.get0() * f1 + c.get0() * f2);
        a.set1(b.get1() * f1 + c.get1() * f2);
        a.set2(b.get2() * f1 + c.get2() * f2);
    }

    static void dClosestLineSegmentPoints(DVector3 a1, DVector3 a2, DVector3 b1, DVector3 b2, DVector3 cp1, DVector3 cp2) {
        double det;
        double k;
        DVector3 a1a2 = new DVector3();
        DVector3 b1b2 = new DVector3();
        DVector3 a1b1 = new DVector3();
        DVector3 a1b2 = new DVector3();
        DVector3 a2b1 = new DVector3();
        DVector3 a2b2 = new DVector3();
        DVector3 n = new DVector3();
        DxCollisionUtil.SET3_SUB(a1a2, a2, a1);
        DxCollisionUtil.SET3_SUB(b1b2, b2, b1);
        DxCollisionUtil.SET3_SUB(a1b1, b1, a1);
        double da1 = OdeMath.dCalcVectorDot3(a1a2, a1b1);
        double db1 = OdeMath.dCalcVectorDot3(b1b2, a1b1);
        if (da1 <= 0.0 && db1 >= 0.0) {
            DxCollisionUtil.SET2(cp1, a1);
            DxCollisionUtil.SET2(cp2, b1);
            return;
        }
        DxCollisionUtil.SET3_SUB(a1b2, b2, a1);
        double da2 = OdeMath.dCalcVectorDot3(a1a2, a1b2);
        double db2 = OdeMath.dCalcVectorDot3(b1b2, a1b2);
        if (da2 <= 0.0 && db2 <= 0.0) {
            DxCollisionUtil.SET2(cp1, a1);
            DxCollisionUtil.SET2(cp2, b2);
            return;
        }
        DxCollisionUtil.SET3_SUB(a2b1, b1, a2);
        double da3 = OdeMath.dCalcVectorDot3(a1a2, a2b1);
        double db3 = OdeMath.dCalcVectorDot3(b1b2, a2b1);
        if (da3 >= 0.0 && db3 >= 0.0) {
            DxCollisionUtil.SET2(cp1, a2);
            DxCollisionUtil.SET2(cp2, b1);
            return;
        }
        DxCollisionUtil.SET3_SUB(a2b2, b2, a2);
        double da4 = OdeMath.dCalcVectorDot3(a1a2, a2b2);
        double db4 = OdeMath.dCalcVectorDot3(b1b2, a2b2);
        if (da4 >= 0.0 && db4 <= 0.0) {
            DxCollisionUtil.SET2(cp1, a2);
            DxCollisionUtil.SET2(cp2, b2);
            return;
        }
        double la = OdeMath.dCalcVectorDot3(a1a2, a1a2);
        if (da1 >= 0.0 && da3 <= 0.0) {
            k = da1 / la;
            DxCollisionUtil.SET3_SUB(n, 1.0, a1b1, k, a1a2);
            if (OdeMath.dCalcVectorDot3(b1b2, n) >= 0.0) {
                DxCollisionUtil.SET3_ADD(cp1, 1.0, a1, k, a1a2);
                DxCollisionUtil.SET2(cp2, b1);
                return;
            }
        }
        if (da2 >= 0.0 && da4 <= 0.0) {
            k = da2 / la;
            DxCollisionUtil.SET3_SUB(n, 1.0, a1b2, k, a1a2);
            if (OdeMath.dCalcVectorDot3(b1b2, n) <= 0.0) {
                DxCollisionUtil.SET3_ADD(cp1, 1.0, a1, k, a1a2);
                DxCollisionUtil.SET2(cp2, b2);
                return;
            }
        }
        double lb = OdeMath.dCalcVectorDot3(b1b2, b1b2);
        if (db1 <= 0.0 && db2 >= 0.0) {
            k = -db1 / lb;
            DxCollisionUtil.SET3_SUB(n, -1.0, a1b1, k, b1b2);
            if (OdeMath.dCalcVectorDot3(a1a2, n) >= 0.0) {
                DxCollisionUtil.SET2(cp1, a1);
                DxCollisionUtil.SET3_ADD(cp2, 1.0, b1, k, b1b2);
                return;
            }
        }
        if (db3 <= 0.0 && db4 >= 0.0) {
            k = -db3 / lb;
            DxCollisionUtil.SET3_SUB(n, -1.0, a2b1, k, b1b2);
            if (OdeMath.dCalcVectorDot3(a1a2, n) <= 0.0) {
                DxCollisionUtil.SET2(cp1, a2);
                DxCollisionUtil.SET3_ADD(cp2, 1.0, b1, k, b1b2);
                return;
            }
        }
        if ((det = la * lb - (k = OdeMath.dCalcVectorDot3(a1a2, b1b2)) * k) <= 0.0) {
            DxCollisionUtil.SET2(cp1, a1);
            DxCollisionUtil.SET2(cp2, b1);
            return;
        }
        det = Common.dRecip(det);
        double alpha = (lb * da1 - k * db1) * det;
        double beta = (k * da1 - la * db1) * det;
        DxCollisionUtil.SET3_ADD(cp1, 1.0, a1, alpha, a1a2);
        DxCollisionUtil.SET3_ADD(cp2, 1.0, b1, beta, b1b2);
    }

    static void dClosestLineBoxPoints(DVector3C p1, DVector3C p2, DVector3C c, DMatrix3C R, DVector3C side, DVector3 lret, DVector3 bret) {
        DVector3 tmp = new DVector3();
        DVector3 s = new DVector3();
        DVector3 v = new DVector3();
        tmp.eqDiff(p1, c);
        OdeMath.dMultiply1_331(s, R, tmp);
        tmp.eqDiff(p2, p1);
        OdeMath.dMultiply1_331(v, R, tmp);
        DVector3 sign = new DVector3();
        int i = 0;
        while (i < 3) {
            if (v.get(i) < 0.0) {
                s.set(i, -s.get(i));
                v.set(i, -v.get(i));
                sign.set(i, -1.0);
            } else {
                sign.set(i, 1.0);
            }
            ++i;
        }
        DVector3 v2 = new DVector3();
        v2.set0(v.get0() * v.get0());
        v2.set1(v.get1() * v.get1());
        v2.set2(v.get2() * v.get2());
        DVector3 h = new DVector3();
        h.set(side).scale(0.5);
        int[] region = new int[3];
        double[] tanchor = new double[3];
        double tanchor_eps = 1.0E-307;
        i = 0;
        while (i < 3) {
            if (v.get(i) > 1.0E-307) {
                if (s.get(i) < -h.get(i)) {
                    region[i] = -1;
                    tanchor[i] = (-h.get(i) - s.get(i)) / v.get(i);
                } else {
                    region[i] = s.get(i) > h.get(i) ? 1 : 0;
                    tanchor[i] = (h.get(i) - s.get(i)) / v.get(i);
                }
            } else {
                region[i] = 0;
                tanchor[i] = 2.0;
            }
            ++i;
        }
        double t = 0.0;
        double dd2dt = 0.0;
        i = 0;
        while (i < 3) {
            dd2dt -= (region[i] != 0 ? v2.get(i) : 0.0) * tanchor[i];
            ++i;
        }
        if (dd2dt >= 0.0) {
            DxCollisionUtil.answer(t, tmp, sign, p1, s, R, lret, h, c, v, bret);
            return;
        }
        do {
            double next_t = 1.0;
            i = 0;
            while (i < 3) {
                if (tanchor[i] > t && tanchor[i] < 1.0 && tanchor[i] < next_t) {
                    next_t = tanchor[i];
                }
                ++i;
            }
            double next_dd2dt = 0.0;
            i = 0;
            while (i < 3) {
                next_dd2dt += (region[i] != 0 ? v2.get(i) : 0.0) * (next_t - tanchor[i]);
                ++i;
            }
            if (next_dd2dt >= 0.0) {
                double m = (next_dd2dt - dd2dt) / (next_t - t);
                DxCollisionUtil.answer(t -= dd2dt / m, tmp, sign, p1, s, R, lret, h, c, v, bret);
                return;
            }
            i = 0;
            while (i < 3) {
                if (tanchor[i] == next_t) {
                    tanchor[i] = (h.get(i) - s.get(i)) / v.get(i);
                    int n = i;
                    region[n] = region[n] + 1;
                }
                ++i;
            }
            t = next_t;
            dd2dt = next_dd2dt;
        } while (t < 1.0);
        t = 1.0;
        DxCollisionUtil.answer(t, tmp, sign, p1, s, R, lret, h, c, v, bret);
    }

    private static void answer(double t, DVector3 tmp, DVector3C sign, DVector3C p1, DVector3 s, DMatrix3C R, DVector3 lret, DVector3C h, DVector3C c, DVector3C v, DVector3 bret) {
        lret.eqSum(p1, tmp, t);
        int i = 0;
        while (i < 3) {
            tmp.set(i, sign.get(i) * (s.get(i) + t * v.get(i)));
            if (tmp.get(i) < -h.get(i)) {
                tmp.set(i, -h.get(i));
            } else if (tmp.get(i) > h.get(i)) {
                tmp.set(i, h.get(i));
            }
            ++i;
        }
        OdeMath.dMultiply0_331(s, R, (DVector3C)tmp);
        bret.eqSum(s, c);
    }

    public static boolean dBoxTouchesBox(DVector3 p1, DMatrix3 R1, DVector3 side1, DVector3 p2, DMatrix3 R2, DVector3 side2) {
        DVector3 p = new DVector3();
        DVector3 pp = new DVector3();
        p.eqDiff(p2, p1);
        OdeMath.dMultiply1_331(pp, R1, p);
        double A1 = side1.get0() * 0.5;
        double A2 = side1.get1() * 0.5;
        double A3 = side1.get2() * 0.5;
        double B1 = side2.get0() * 0.5;
        double B2 = side2.get1() * 0.5;
        double B3 = side2.get2() * 0.5;
        double R11 = OdeMath.dCalcVectorDot3_44(R1, 0, R2, 0);
        double R12 = OdeMath.dCalcVectorDot3_44(R1, 0, R2, 1);
        double R13 = OdeMath.dCalcVectorDot3_44(R1, 0, R2, 2);
        double Q11 = Common.dFabs(R11);
        double Q12 = Common.dFabs(R12);
        double Q13 = Common.dFabs(R13);
        if (Common.dFabs(pp.get0()) > A1 + B1 * Q11 + B2 * Q12 + B3 * Q13) {
            return false;
        }
        double R21 = OdeMath.dCalcVectorDot3_44(R1, 1, R2, 0);
        double R22 = OdeMath.dCalcVectorDot3_44(R1, 1, R2, 1);
        double R23 = OdeMath.dCalcVectorDot3_44(R1, 1, R2, 2);
        double Q21 = Common.dFabs(R21);
        double Q22 = Common.dFabs(R22);
        double Q23 = Common.dFabs(R23);
        if (Common.dFabs(pp.get1()) > A2 + B1 * Q21 + B2 * Q22 + B3 * Q23) {
            return false;
        }
        double R31 = OdeMath.dCalcVectorDot3_44(R1, 2, R2, 0);
        double R32 = OdeMath.dCalcVectorDot3_44(R1, 2, R2, 1);
        double R33 = OdeMath.dCalcVectorDot3_44(R1, 2, R2, 2);
        double Q31 = Common.dFabs(R31);
        double Q32 = Common.dFabs(R32);
        double Q33 = Common.dFabs(R33);
        if (Common.dFabs(pp.get2()) > A3 + B1 * Q31 + B2 * Q32 + B3 * Q33) {
            return false;
        }
        if (Common.dFabs(OdeMath.dCalcVectorDot3_41(R2, 0, p)) > A1 * Q11 + A2 * Q21 + A3 * Q31 + B1) {
            return false;
        }
        if (Common.dFabs(OdeMath.dCalcVectorDot3_41(R2, 1, p)) > A1 * Q12 + A2 * Q22 + A3 * Q32 + B2) {
            return false;
        }
        if (Common.dFabs(OdeMath.dCalcVectorDot3_41(R2, 2, p)) > A1 * Q13 + A2 * Q23 + A3 * Q33 + B3) {
            return false;
        }
        if (Common.dFabs(pp.get2() * R21 - pp.get1() * R31) > A2 * Q31 + A3 * Q21 + B2 * Q13 + B3 * Q12) {
            return false;
        }
        if (Common.dFabs(pp.get2() * R22 - pp.get1() * R32) > A2 * Q32 + A3 * Q22 + B1 * Q13 + B3 * Q11) {
            return false;
        }
        if (Common.dFabs(pp.get2() * R23 - pp.get1() * R33) > A2 * Q33 + A3 * Q23 + B1 * Q12 + B2 * Q11) {
            return false;
        }
        if (Common.dFabs(pp.get0() * R31 - pp.get2() * R11) > A1 * Q31 + A3 * Q11 + B2 * Q23 + B3 * Q22) {
            return false;
        }
        if (Common.dFabs(pp.get0() * R32 - pp.get2() * R12) > A1 * Q32 + A3 * Q12 + B1 * Q23 + B3 * Q21) {
            return false;
        }
        if (Common.dFabs(pp.get0() * R33 - pp.get2() * R13) > A1 * Q33 + A3 * Q13 + B1 * Q22 + B2 * Q21) {
            return false;
        }
        if (Common.dFabs(pp.get1() * R11 - pp.get0() * R21) > A1 * Q21 + A2 * Q11 + B2 * Q33 + B3 * Q32) {
            return false;
        }
        if (Common.dFabs(pp.get1() * R12 - pp.get0() * R22) > A1 * Q22 + A2 * Q12 + B1 * Q33 + B3 * Q31) {
            return false;
        }
        return !(Common.dFabs(pp.get1() * R13 - pp.get0() * R23) > A1 * Q23 + A2 * Q13 + B1 * Q32 + B2 * Q31);
    }

    void dInfiniteAABB(DxGeom geom, DAABB aabb) {
        aabb.set(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    static boolean dClipEdgeToPlane(DVector3 vEpnt0, DVector3 vEpnt1, DVector4 plPlane) {
        double fDistance0 = DxCollisionUtil.dPointPlaneDistance(vEpnt0, plPlane);
        double fDistance1 = DxCollisionUtil.dPointPlaneDistance(vEpnt1, plPlane);
        if (fDistance0 < 0.0 && fDistance1 < 0.0) {
            return false;
        }
        if (fDistance0 > 0.0 && fDistance1 > 0.0) {
            return true;
        }
        if (fDistance0 > 0.0 && fDistance1 < 0.0 || fDistance0 < 0.0 && fDistance1 > 0.0) {
            double a0 = vEpnt0.get0() - (vEpnt0.get0() - vEpnt1.get0()) * fDistance0 / (fDistance0 - fDistance1);
            double a1 = vEpnt0.get1() - (vEpnt0.get1() - vEpnt1.get1()) * fDistance0 / (fDistance0 - fDistance1);
            double a2 = vEpnt0.get2() - (vEpnt0.get2() - vEpnt1.get2()) * fDistance0 / (fDistance0 - fDistance1);
            if (fDistance0 < 0.0) {
                vEpnt0.set(a0, a1, a2);
            } else {
                vEpnt1.set(a0, a1, a2);
            }
            return true;
        }
        return true;
    }

    static int dClipPolyToPlane(DVector3[] avArrayIn, int ctIn, DVector3[] avArrayOut, DVector4 plPlane) {
        int ctOut = 0;
        int i0 = ctIn - 1;
        int i1 = 0;
        while (i1 < ctIn) {
            double fDistance0 = DxCollisionUtil.dPointPlaneDistance(avArrayIn[i0], plPlane);
            double fDistance1 = DxCollisionUtil.dPointPlaneDistance(avArrayIn[i1], plPlane);
            if (fDistance0 >= 0.0) {
                avArrayOut[ctOut].set(avArrayIn[i0]);
                ++ctOut;
            }
            if (fDistance0 > 0.0 && fDistance1 < 0.0 || fDistance0 < 0.0 && fDistance1 > 0.0) {
                DVector3 vIntersectionPoint = new DVector3();
                vIntersectionPoint.set0(avArrayIn[i0].get0() - (avArrayIn[i0].get0() - avArrayIn[i1].get0()) * fDistance0 / (fDistance0 - fDistance1));
                vIntersectionPoint.set1(avArrayIn[i0].get1() - (avArrayIn[i0].get1() - avArrayIn[i1].get1()) * fDistance0 / (fDistance0 - fDistance1));
                vIntersectionPoint.set2(avArrayIn[i0].get2() - (avArrayIn[i0].get2() - avArrayIn[i1].get2()) * fDistance0 / (fDistance0 - fDistance1));
                avArrayOut[ctOut].set(vIntersectionPoint);
                ++ctOut;
            }
            i0 = i1++;
        }
        return ctOut;
    }

    void dClipPolyToCircle(DVector3[] avArrayIn, int ctIn, DVector3[] avArrayOut, RefInt ctOut, DVector4 plPlane, double fRadius) {
        ctOut.set(0);
        int i0 = ctIn - 1;
        int i1 = 0;
        while (i1 < ctIn) {
            double fDistance0 = DxCollisionUtil.dPointPlaneDistance(avArrayIn[i0], plPlane);
            double fDistance1 = DxCollisionUtil.dPointPlaneDistance(avArrayIn[i1], plPlane);
            if (fDistance0 >= 0.0 && this.dVector3LengthSquare(avArrayIn[i0]) <= fRadius * fRadius) {
                avArrayOut[ctOut.get()].set(avArrayIn[i0]);
                ctOut.inc();
            }
            if (fDistance0 > 0.0 && fDistance1 < 0.0 || fDistance0 < 0.0 && fDistance1 > 0.0) {
                DVector3 vIntersectionPoint = new DVector3();
                vIntersectionPoint.set0(avArrayIn[i0].get0() - (avArrayIn[i0].get0() - avArrayIn[i1].get0()) * fDistance0 / (fDistance0 - fDistance1));
                vIntersectionPoint.set1(avArrayIn[i0].get1() - (avArrayIn[i0].get1() - avArrayIn[i1].get1()) * fDistance0 / (fDistance0 - fDistance1));
                vIntersectionPoint.set2(avArrayIn[i0].get2() - (avArrayIn[i0].get2() - avArrayIn[i1].get2()) * fDistance0 / (fDistance0 - fDistance1));
                if (this.dVector3LengthSquare(avArrayIn[i0]) <= fRadius * fRadius) {
                    avArrayOut[ctOut.get()].set(vIntersectionPoint);
                    ctOut.inc();
                }
            }
            i0 = i1++;
        }
    }
}

