/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DCapsule;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBox;
import org.ode4j.ode.internal.DxCollisionUtil;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxPlane;
import org.ode4j.ode.internal.DxSpace;
import org.ode4j.ode.internal.DxSphere;

public class DxCapsule
extends DxGeom
implements DCapsule {
    private double _radius;
    private double _lz;

    public DxCapsule(DxSpace space, double __radius, double __length) {
        super(space, true);
        Common.dAASSERT(__radius >= 0.0 && __length >= 0.0);
        this.type = 2;
        this._radius = __radius;
        this._lz = __length;
        this.updateZeroSizedFlag(__radius == 0.0);
    }

    @Override
    public void computeAABB() {
        DMatrix3C R = this.final_posr().R();
        DVector3C pos = this.final_posr().pos();
        double xrange = Common.dFabs(R.get02() * this._lz) * 0.5 + this._radius;
        double yrange = Common.dFabs(R.get12() * this._lz) * 0.5 + this._radius;
        double zrange = Common.dFabs(R.get22() * this._lz) * 0.5 + this._radius;
        this._aabb.setMinMax(xrange, yrange, zrange);
        this._aabb.shiftPos(pos);
    }

    public static DxCapsule dCreateCapsule(DxSpace space, double radius, double length) {
        return new DxCapsule(space, radius, length);
    }

    public void dGeomCapsuleSetParams(double radius, double length) {
        this._radius = radius;
        this._lz = length;
        this.updateZeroSizedFlag(this._radius == 0.0);
        this.dGeomMoved();
    }

    public double dGeomCapsulePointDepth(double x, double y, double z) {
        this.recomputePosr();
        DMatrix3C R = this.final_posr().R();
        DVector3C pos = this.final_posr().pos();
        DVector3 a = new DVector3(x, y, z);
        a.sub(pos);
        double beta = OdeMath.dCalcVectorDot3_14((DVector3C)a, R, 2);
        double lz2 = this._lz * 0.5;
        if (beta < -lz2) {
            beta = -lz2;
        } else if (beta > lz2) {
            beta = lz2;
        }
        a.eqSum(this.final_posr().pos(), R.columnAsNewVector(2), beta);
        return this._radius - Common.dSqrt((x - a.get0()) * (x - a.get0()) + (y - a.get1()) * (y - a.get1()) + (z - a.get2()) * (z - a.get2()));
    }

    private static int dCollideSpheresZeroDist(DVector3 p1, double r1, DVector3 p2, double r2, DVector3 normal, DContactGeom c) {
        c.normal.set(normal);
        c.depth = r1 + r2;
        double k = 0.5 * (r2 - r1);
        c.pos.eqSum((DVector3C)p1, c.normal, k);
        return 1;
    }

    @Override
    public void setParams(double radius, double length) {
        this.dGeomCapsuleSetParams(radius, length);
    }

    @Override
    public double getRadius() {
        return this._radius;
    }

    @Override
    public double getLength() {
        return this._lz;
    }

    @Override
    public double getPointDepth(DVector3C p) {
        return this.dGeomCapsulePointDepth(p.get0(), p.get1(), p.get2());
    }

    static class CollideCapsuleBox
    implements DColliderFn {
        CollideCapsuleBox() {
        }

        int dCollideCapsuleBox(DxCapsule o1, DxBox o2, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip == 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            DxCapsule cyl = o1;
            DxBox box = o2;
            contacts.get((int)0).g1 = o1;
            contacts.get((int)0).g2 = o2;
            contacts.get((int)0).side1 = -1;
            contacts.get((int)0).side2 = -1;
            DVector3 p1 = new DVector3();
            DVector3 p2 = new DVector3();
            double clen = cyl._lz * 0.5;
            p1.eqSum(o1.final_posr().pos(), o1.final_posr().R().columnAsNewVector(2), clen);
            p2.eqSum(o1.final_posr().pos(), o1.final_posr().R().columnAsNewVector(2), -clen);
            double radius = cyl._radius;
            DVector3C c = o2.final_posr().pos();
            DMatrix3C R = o2.final_posr().R();
            DVector3 side = box.side;
            DVector3 pl = new DVector3();
            DVector3 pb = new DVector3();
            DxCollisionUtil.dClosestLineBoxPoints(p1, p2, c, R, side, pl, pb);
            double mindist = 1.0E-18;
            if (OdeMath.dCalcPointsDistance3(pl, pb) < mindist) {
                DVector3 normal = new DVector3();
                normal.eqDiff(pb, c);
                OdeMath.dSafeNormalize3(normal);
                return DxCapsule.dCollideSpheresZeroDist(pl, radius, pb, 0.0, normal, contacts.get());
            }
            return DxCollisionUtil.dCollideSpheres(pl, radius, pb, 0.0, contacts);
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideCapsuleBox((DxCapsule)o1, (DxBox)o2, flags, contacts, 1);
        }
    }

    static class CollideCapsuleCapsule
    implements DColliderFn {
        CollideCapsuleCapsule() {
        }

        int dCollideCapsuleCapsule(DxCapsule cyl1, DxCapsule cyl2, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip == 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            double tolerance = 1.0E-5;
            contacts.get((int)0).g1 = cyl1;
            contacts.get((int)0).g2 = cyl2;
            contacts.get((int)0).side1 = -1;
            contacts.get((int)0).side2 = -1;
            double lz1 = cyl1._lz * 0.5;
            double lz2 = cyl2._lz * 0.5;
            DVector3C pos1 = cyl1.final_posr().pos();
            DVector3C pos2 = cyl2.final_posr().pos();
            DVector3 axis1 = cyl1.final_posr().R().columnAsNewVector(2);
            DVector3 axis2 = cyl2.final_posr().R().columnAsNewVector(2);
            DVector3 sphere1 = new DVector3();
            DVector3 sphere2 = new DVector3();
            double a1a2 = OdeMath.dCalcVectorDot3(axis1, axis2);
            double det = 1.0 - a1a2 * a1a2;
            if (det < 1.0E-5) {
                double hi;
                if (a1a2 < 0.0) {
                    axis2.scale(-1.0);
                }
                DVector3 q = new DVector3();
                q.set(pos1).sub(pos2);
                double k = OdeMath.dCalcVectorDot3(axis1, q);
                double a1lo = -lz1;
                double a1hi = lz1;
                double a2lo = -lz2 - k;
                double a2hi = lz2 - k;
                double lo = a1lo > a2lo ? a1lo : a2lo;
                double d = hi = a1hi < a2hi ? a1hi : a2hi;
                if (lo <= hi) {
                    int num_contacts = flags & 0xFFFF;
                    if (num_contacts >= 2 && lo < hi) {
                        sphere1.set(axis1).scale(lo).add(pos1);
                        sphere2.set(axis2).scale(lo + k).add(pos2);
                        int n1 = DxCollisionUtil.dCollideSpheres(sphere1, cyl1._radius, sphere2, cyl2._radius, contacts);
                        if (n1 != 0) {
                            sphere1.set(axis1).scale(hi).add(pos1);
                            sphere2.set(axis2).scale(hi + k).add(pos2);
                            DContactGeomBuffer c2 = contacts.createView(skip);
                            int n2 = DxCollisionUtil.dCollideSpheres(sphere1, cyl1._radius, sphere2, cyl2._radius, c2);
                            if (n2 != 0) {
                                c2.get().g1 = cyl1;
                                c2.get().g2 = cyl2;
                                c2.get().side1 = -1;
                                c2.get().side2 = -1;
                                return 2;
                            }
                        }
                    }
                    double alpha1 = (lo + hi) * 0.5;
                    double alpha2 = alpha1 + k;
                    sphere1.set(axis1).scale(alpha1).add(pos1);
                    sphere2.set(axis2).scale(alpha2).add(pos2);
                    return DxCollisionUtil.dCollideSpheres(sphere1, cyl1._radius, sphere2, cyl2._radius, contacts);
                }
            }
            DVector3 a1 = new DVector3();
            DVector3 a2 = new DVector3();
            DVector3 b1 = new DVector3();
            DVector3 b2 = new DVector3();
            a1.set(axis1).scale(lz1).add(cyl1.final_posr().pos());
            a2.set(axis1).scale(-lz1).add(cyl1.final_posr().pos());
            b1.set(axis2).scale(lz2).add(cyl2.final_posr().pos());
            b2.set(axis2).scale(-lz2).add(cyl2.final_posr().pos());
            DxCollisionUtil.dClosestLineSegmentPoints(a1, a2, b1, b2, sphere1, sphere2);
            return DxCollisionUtil.dCollideSpheres(sphere1, cyl1._radius, sphere2, cyl2._radius, contacts);
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideCapsuleCapsule((DxCapsule)o1, (DxCapsule)o2, flags, contacts, 1);
        }
    }

    static class CollideCapsulePlane
    implements DColliderFn {
        CollideCapsulePlane() {
        }

        int dCollideCapsulePlane(DxCapsule o1, DxPlane o2, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip == 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            DxCapsule ccyl = o1;
            DxPlane plane = o2;
            DVector3C planePos = plane.getNormal();
            double sign = planePos.dot(o1.final_posr().R().viewCol(2)) > 0.0 ? -1.0 : 1.0;
            DVector3 p = o1.final_posr().R().columnAsNewVector(2);
            p.scale(ccyl._lz * 0.5 * sign).add(o1.final_posr().pos());
            double k = p.dot(planePos);
            double depth = plane.getDepth() - k + ccyl._radius;
            if (depth < 0.0) {
                return 0;
            }
            DContactGeom contact = contacts.get(0);
            contact.normal.set(planePos);
            contact.pos.set(contact.normal).scale(-ccyl._radius).add(p);
            contact.depth = depth;
            int ncontacts = 1;
            if ((flags & 0xFFFF) >= 2) {
                p = o1.final_posr().R().columnAsNewVector(2);
                p.scale(-ccyl._lz * 0.5 * sign).add(o1.final_posr().pos());
                k = p.dot(planePos);
                depth = plane.getDepth() - k + ccyl._radius;
                if (depth >= 0.0) {
                    DContactGeom c2 = contacts.get(skip);
                    c2.normal.set(planePos);
                    c2.pos.eqSum((DVector3C)p, planePos, -ccyl._radius);
                    c2.depth = depth;
                    ncontacts = 2;
                }
            }
            int i = 0;
            while (i < ncontacts) {
                DContactGeom currContact = contacts.get(i * skip);
                currContact.g1 = o1;
                currContact.g2 = o2;
                currContact.side1 = -1;
                currContact.side2 = -1;
                ++i;
            }
            return ncontacts;
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideCapsulePlane((DxCapsule)o1, (DxPlane)o2, flags, contacts, 1);
        }
    }

    static class CollideCapsuleSphere
    implements DColliderFn {
        CollideCapsuleSphere() {
        }

        int dCollideCapsuleSphere(DxCapsule o1, DxSphere o2, int flags, DContactGeomBuffer contacts, int skip) {
            Common.dIASSERT(skip == 1);
            Common.dIASSERT((flags & 0xFFFF) >= 1);
            DxCapsule ccyl = o1;
            DxSphere sphere = o2;
            contacts.get((int)0).g1 = o1;
            contacts.get((int)0).g2 = o2;
            contacts.get((int)0).side1 = -1;
            contacts.get((int)0).side2 = -1;
            double alpha = o1.final_posr().R().get02() * (o2.final_posr().pos().get0() - o1.final_posr().pos().get0()) + o1.final_posr().R().get12() * (o2.final_posr().pos().get1() - o1.final_posr().pos().get1()) + o1.final_posr().R().get22() * (o2.final_posr().pos().get2() - o1.final_posr().pos().get2());
            double lz2 = ccyl._lz * 0.5;
            if (alpha > lz2) {
                alpha = lz2;
            }
            if (alpha < -lz2) {
                alpha = -lz2;
            }
            DVector3 p = new DVector3();
            p.eqSum(o1.final_posr().pos(), o1.final_posr().R().columnAsNewVector(2), alpha);
            return DxCollisionUtil.dCollideSpheres(p, ccyl._radius, o2.final_posr().pos(), sphere.getRadius(), contacts);
        }

        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            return this.dCollideCapsuleSphere((DxCapsule)o1, (DxSphere)o2, flags, contacts, 1);
        }
    }
}

