/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cstring;
import org.cpp4j.java.RefDouble;
import org.cpp4j.java.RefInt;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DBox;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxCollisionUtil;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxSpace;

public class DxBox
extends DxGeom
implements DBox {
    DVector3 side = new DVector3();

    DxBox(DxSpace space, double lx, double ly, double lz) {
        super(space, true);
        Common.dAASSERT(lx >= 0.0 && ly >= 0.0 && lz >= 0.0);
        this.type = 1;
        this.side.set(lx, ly, lz);
        this.updateZeroSizedFlag(lx == 0.0 || ly == 0.0 || lz == 0.0);
    }

    @Override
    void computeAABB() {
        DMatrix3C R = this.final_posr().R();
        DVector3C pos = this.final_posr().pos();
        double xrange = 0.5 * (Common.dFabs(R.get00() * this.side.get0()) + Common.dFabs(R.get01() * this.side.get1()) + Common.dFabs(R.get02() * this.side.get2()));
        double yrange = 0.5 * (Common.dFabs(R.get10() * this.side.get0()) + Common.dFabs(R.get11() * this.side.get1()) + Common.dFabs(R.get12() * this.side.get2()));
        double zrange = 0.5 * (Common.dFabs(R.get20() * this.side.get0()) + Common.dFabs(R.get21() * this.side.get1()) + Common.dFabs(R.get22() * this.side.get2()));
        this._aabb.set(pos.get0() - xrange, pos.get0() + xrange, pos.get1() - yrange, pos.get1() + yrange, pos.get2() - zrange, pos.get2() + zrange);
    }

    public static DxBox dCreateBox(DxSpace space, double lx, double ly, double lz) {
        return new DxBox(space, lx, ly, lz);
    }

    public void dGeomBoxSetLengths(DVector3C l) {
        Common.dAASSERT(l.get0() >= 0.0 && l.get1() >= 0.0 && l.get2() >= 0.0);
        this.side.set(l);
        this.updateZeroSizedFlag(l.get0() == 0.0 || l.get1() == 0.0 || l.get2() == 0.0);
        this.dGeomMoved();
    }

    public void dGeomBoxGetLengths(DVector3 result) {
        result.set(this.side);
    }

    public double dGeomBoxPointDepth(double x, double y, double z) {
        this.recomputePosr();
        DVector3 p = new DVector3();
        DVector3 q = new DVector3();
        p.set(x, y, z).sub(this.final_posr().pos());
        OdeMath.dMultiply1_331(q, this.final_posr().R(), p);
        double[] dist = new double[6];
        boolean inside = true;
        int i = 0;
        while (i < 3) {
            double sideX = this.side.get(i) * 0.5;
            dist[i] = sideX - q.get(i);
            dist[i + 3] = sideX + q.get(i);
            if (dist[i] < 0.0 || dist[i + 3] < 0.0) {
                inside = false;
            }
            ++i;
        }
        if (inside) {
            double smallest_dist = -1.0;
            i = 0;
            while (i < 6) {
                if (dist[i] < smallest_dist) {
                    smallest_dist = dist[i];
                }
                ++i;
            }
            return smallest_dist;
        }
        double largest_dist = 0.0;
        i = 0;
        while (i < 6) {
            if (dist[i] > largest_dist) {
                largest_dist = dist[i];
            }
            ++i;
        }
        return -largest_dist;
    }

    static int intersectRectQuad(double[] h, double[] p, double[] ret) {
        int nq = 4;
        int nr = 0;
        double[] buffer = new double[16];
        double[] r = ret;
        double[] q = p;
        int pos_q = 0;
        int pos_r = 0;
        int dir = 0;
        while (dir <= 1) {
            int sign = -1;
            while (sign <= 1) {
                int pos_pq = pos_q;
                int pos_pr = pos_r;
                nr = 0;
                int i = nq;
                while (i > 0) {
                    int next_q;
                    if ((double)sign * q[pos_pq + dir] < h[dir]) {
                        r[pos_pr] = q[pos_pq];
                        r[pos_pr + 1] = q[pos_pq + 1];
                        pos_pr += 2;
                        if ((++nr & 8) != 0) {
                            q = r;
                            pos_q = pos_r;
                            if (q != ret) {
                                Cstring.memcpy(ret, 0, q, pos_q, nr * 2);
                            }
                            return nr;
                        }
                    }
                    if ((double)sign * q[pos_pq + dir] < h[dir] ^ (double)sign * q[(next_q = i > 1 ? pos_pq + 2 : 0) + dir] < h[dir]) {
                        r[pos_pr + 1 - dir] = q[pos_pq + 1 - dir] + (q[next_q + 1 - dir] - q[pos_pq + 1 - dir]) / (q[next_q + dir] - q[pos_pq + dir]) * ((double)sign * h[dir] - q[pos_pq + dir]);
                        r[pos_pr + dir] = (double)sign * h[dir];
                        pos_pr += 2;
                        if ((++nr & 8) != 0) {
                            q = r;
                            pos_q = pos_r;
                            if (q != ret) {
                                Cstring.memcpy(ret, 0, q, pos_q, nr * 2);
                            }
                            return nr;
                        }
                    }
                    pos_pq += 2;
                    --i;
                }
                q = r;
                pos_q = pos_r;
                r = q == ret ? buffer : ret;
                pos_r = 0;
                nq = nr;
                sign += 2;
            }
            ++dir;
        }
        if (q != ret) {
            Cstring.memcpy(ret, 0, q, pos_q, nr * 2);
        }
        return nr;
    }

    static void cullPoints(int n, double[] p, int m, int i0, int[] iretA) {
        int i;
        double a;
        double cy;
        double cx;
        int iretP = 0;
        if (n == 1) {
            cx = p[0];
            cy = p[1];
        } else if (n == 2) {
            cx = 0.5 * (p[0] + p[2]);
            cy = 0.5 * (p[1] + p[3]);
        } else {
            double q;
            a = 0.0;
            cx = 0.0;
            cy = 0.0;
            i = 0;
            while (i < n - 1) {
                q = p[i * 2] * p[i * 2 + 3] - p[i * 2 + 2] * p[i * 2 + 1];
                a += q;
                cx += q * (p[i * 2] + p[i * 2 + 2]);
                cy += q * (p[i * 2 + 1] + p[i * 2 + 3]);
                ++i;
            }
            q = p[n * 2 - 2] * p[1] - p[0] * p[n * 2 - 1];
            a = Common.dRecip(3.0 * (a + q));
            cx = a * (cx + q * (p[n * 2 - 2] + p[0]));
            cy = a * (cy + q * (p[n * 2 - 1] + p[1]));
        }
        double[] A = new double[8];
        i = 0;
        while (i < n) {
            A[i] = Common.dAtan2(p[i * 2 + 1] - cy, p[i * 2] - cx);
            ++i;
        }
        int[] avail = new int[8];
        i = 0;
        while (i < n) {
            avail[i] = 1;
            ++i;
        }
        avail[i0] = 0;
        iretA[iretP] = i0;
        ++iretP;
        int j = 1;
        while (j < m) {
            a = (double)j * (Math.PI * 2 / (double)m) + A[i0];
            if (a > Math.PI) {
                a -= Math.PI * 2;
            }
            double maxdiff = 1.0E9;
            iretA[iretP] = i0;
            i = 0;
            while (i < n) {
                if (avail[i] != 0) {
                    double diff = Common.dFabs(A[i] - a);
                    if (diff > Math.PI) {
                        diff = Math.PI * 2 - diff;
                    }
                    if (diff < maxdiff) {
                        maxdiff = diff;
                        iretA[iretP] = i;
                    }
                }
                ++i;
            }
            Common.dIASSERT(iretA[iretP] != i0);
            avail[iretA[iretP]] = 0;
            ++iretP;
            ++j;
        }
    }

    private static boolean TST1(double expr1, double expr2, DMatrix3C norm_A, int norm_O, int cc, TstClass tst1) {
        double expr1_val = expr1;
        double s2 = Common.dFabs(expr1_val) - expr2;
        if (s2 > 0.0) {
            return false;
        }
        if (s2 > tst1._s) {
            tst1._s = s2;
            tst1._normalR_M = norm_A;
            tst1._normalR_col = norm_O;
            tst1._invert_normal = expr1_val < 0.0;
            tst1._code = cc;
            if ((tst1._flags & Integer.MIN_VALUE) != 0) {
                tst1._break = true;
                return true;
            }
        }
        return true;
    }

    private static boolean TST2(double expr1, double expr2, double n1, double n2, double n3, int cc, TstClass tst2) {
        double expr1_val = expr1;
        double s2 = Common.dFabs(expr1_val) - expr2;
        if (s2 > 0.0) {
            return false;
        }
        double l = Common.dSqrt(n1 * n1 + n2 * n2 + n3 * n3);
        if (l > 0.0 && (s2 /= l) * tst2._fudge_factor > tst2._s) {
            tst2._s = s2;
            tst2._normalR_M = null;
            tst2._normalR_col = 0;
            tst2._normalC.set(n1 / l, n2 / l, n3 / l);
            tst2._invert_normal = expr1_val < 0.0;
            tst2._code = cc;
            if ((tst2._flags & Integer.MIN_VALUE) != 0) {
                tst2._break = true;
                return true;
            }
        }
        return true;
    }

    public static int dBoxBox(DVector3C p1, DMatrix3C R1, DVector3C side1, DVector3C p2, DMatrix3C R2, DVector3C side2, DVector3 normal, RefDouble depth, RefInt return_code, int flags, DContactGeomBuffer contacts, int skip) {
        int code2;
        int code1;
        int i;
        int a2;
        int lanr;
        int a1;
        DVector3 Sb;
        DVector3 Sa;
        DVector3C pb;
        DVector3C pa;
        DMatrix3C Rb;
        DMatrix3C Ra;
        DVector3 p = new DVector3();
        DVector3 pp = new DVector3();
        DVector3 A = new DVector3();
        DVector3 B = new DVector3();
        p.eqDiff(p2, p1);
        OdeMath.dMultiply1_331(pp, R1, p);
        A.set(side1).scale(0.5);
        B.set(side2).scale(0.5);
        double R11 = OdeMath.dCalcVectorDot3_44(R1, 0, R2, 0);
        double R12 = OdeMath.dCalcVectorDot3_44(R1, 0, R2, 1);
        double R13 = OdeMath.dCalcVectorDot3_44(R1, 0, R2, 2);
        double R21 = OdeMath.dCalcVectorDot3_44(R1, 1, R2, 0);
        double R22 = OdeMath.dCalcVectorDot3_44(R1, 1, R2, 1);
        double R23 = OdeMath.dCalcVectorDot3_44(R1, 1, R2, 2);
        double R31 = OdeMath.dCalcVectorDot3_44(R1, 2, R2, 0);
        double R32 = OdeMath.dCalcVectorDot3_44(R1, 2, R2, 1);
        double R33 = OdeMath.dCalcVectorDot3_44(R1, 2, R2, 2);
        double Q11 = Common.dFabs(R11);
        double Q12 = Common.dFabs(R12);
        double Q13 = Common.dFabs(R13);
        double Q21 = Common.dFabs(R21);
        double Q22 = Common.dFabs(R22);
        double Q23 = Common.dFabs(R23);
        double Q31 = Common.dFabs(R31);
        double Q32 = Common.dFabs(R32);
        double Q33 = Common.dFabs(R33);
        TstClass tst = new TstClass(flags, 1.05);
        tst._s = Double.NEGATIVE_INFINITY;
        tst._invert_normal = false;
        tst._code = 0;
        if (!DxBox.TST1(pp.get0(), A.get0() + B.get0() * Q11 + B.get1() * Q12 + B.get2() * Q13, R1, 0, 1, tst)) {
            return 0;
        }
        if (!tst._break) {
            if (!DxBox.TST1(pp.get1(), A.get1() + B.get0() * Q21 + B.get1() * Q22 + B.get2() * Q23, R1, 1, 2, tst)) {
                return 0;
            }
            if (!tst._break) {
                if (!DxBox.TST1(pp.get2(), A.get2() + B.get0() * Q31 + B.get1() * Q32 + B.get2() * Q33, R1, 2, 3, tst)) {
                    return 0;
                }
                if (!tst._break) {
                    if (!DxBox.TST1(OdeMath.dCalcVectorDot3_41(R2, 0, p), A.get0() * Q11 + A.get1() * Q21 + A.get2() * Q31 + B.get0(), R2, 0, 4, tst)) {
                        return 0;
                    }
                    if (!tst._break) {
                        if (!DxBox.TST1(OdeMath.dCalcVectorDot3_41(R2, 1, p), A.get0() * Q12 + A.get1() * Q22 + A.get2() * Q32 + B.get1(), R2, 1, 5, tst)) {
                            return 0;
                        }
                        if (!tst._break) {
                            if (!DxBox.TST1(OdeMath.dCalcVectorDot3_41(R2, 2, p), A.get0() * Q13 + A.get1() * Q23 + A.get2() * Q33 + B.get2(), R2, 2, 6, tst)) {
                                return 0;
                            }
                            if (!tst._break) {
                                if (!DxBox.TST2(pp.get2() * R21 - pp.get1() * R31, A.get1() * Q31 + A.get2() * Q21 + B.get1() * Q13 + B.get2() * Q12, 0.0, -R31, R21, 7, tst)) {
                                    return 0;
                                }
                                if (!tst._break) {
                                    if (!DxBox.TST2(pp.get2() * R22 - pp.get1() * R32, A.get1() * Q32 + A.get2() * Q22 + B.get0() * Q13 + B.get2() * Q11, 0.0, -R32, R22, 8, tst)) {
                                        return 0;
                                    }
                                    if (!tst._break) {
                                        if (!DxBox.TST2(pp.get2() * R23 - pp.get1() * R33, A.get1() * Q33 + A.get2() * Q23 + B.get0() * Q12 + B.get1() * Q11, 0.0, -R33, R23, 9, tst)) {
                                            return 0;
                                        }
                                        if (!tst._break) {
                                            if (!DxBox.TST2(pp.get0() * R31 - pp.get2() * R11, A.get0() * Q31 + A.get2() * Q11 + B.get1() * Q23 + B.get2() * Q22, R31, 0.0, -R11, 10, tst)) {
                                                return 0;
                                            }
                                            if (!tst._break) {
                                                if (!DxBox.TST2(pp.get0() * R32 - pp.get2() * R12, A.get0() * Q32 + A.get2() * Q12 + B.get0() * Q23 + B.get2() * Q21, R32, 0.0, -R12, 11, tst)) {
                                                    return 0;
                                                }
                                                if (!tst._break) {
                                                    if (!DxBox.TST2(pp.get0() * R33 - pp.get2() * R13, A.get0() * Q33 + A.get2() * Q13 + B.get0() * Q22 + B.get1() * Q21, R33, 0.0, -R13, 12, tst)) {
                                                        return 0;
                                                    }
                                                    if (!tst._break) {
                                                        if (!DxBox.TST2(pp.get1() * R11 - pp.get0() * R21, A.get0() * Q21 + A.get1() * Q11 + B.get1() * Q33 + B.get2() * Q32, -R21, R11, 0.0, 13, tst)) {
                                                            return 0;
                                                        }
                                                        if (!tst._break) {
                                                            if (!DxBox.TST2(pp.get1() * R12 - pp.get0() * R22, A.get0() * Q22 + A.get1() * Q12 + B.get0() * Q33 + B.get2() * Q31, -R22, R12, 0.0, 14, tst)) {
                                                                return 0;
                                                            }
                                                            if (!tst._break) {
                                                                if (!DxBox.TST2(pp.get1() * R13 - pp.get0() * R23, A.get0() * Q23 + A.get1() * Q13 + B.get0() * Q32 + B.get1() * Q31, -R23, R13, 0.0, 15, tst)) {
                                                                    return 0;
                                                                }
                                                                if (tst._break) {
                                                                    // empty if block
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (tst._code == 0) {
            return 0;
        }
        if (tst._normalR_M != null) {
            normal.set(tst._normalR_M.viewCol(tst._normalR_col));
        } else {
            OdeMath.dMultiply0_331(normal, R1, (DVector3C)tst._normalC);
        }
        if (tst._invert_normal) {
            normal.scale(-1.0);
        }
        depth.set(-tst._s);
        if (tst._code > 6) {
            int i2;
            double sign;
            DVector3 pa2 = new DVector3(p1);
            int j = 0;
            while (j < 3) {
                sign = OdeMath.dCalcVectorDot3_14((DVector3C)normal, R1, j) > 0.0 ? 1.0 : -1.0;
                i2 = 0;
                while (i2 < 3) {
                    pa2.add(i2, sign * A.get(j) * R1.get(i2, j));
                    ++i2;
                }
                ++j;
            }
            DVector3 pb2 = new DVector3(p2);
            j = 0;
            while (j < 3) {
                sign = OdeMath.dCalcVectorDot3_14((DVector3C)normal, R2, j) > 0.0 ? -1.0 : 1.0;
                i2 = 0;
                while (i2 < 3) {
                    pb2.add(i2, sign * B.get(j) * R2.get(i2, j));
                    ++i2;
                }
                ++j;
            }
            RefDouble alpha = new RefDouble(0.0);
            RefDouble beta = new RefDouble(0.0);
            DVector3 ua = new DVector3();
            DVector3 ub = new DVector3();
            i2 = 0;
            while (i2 < 3) {
                ua.set(i2, R1.get(i2, (tst._code - 7) / 3));
                ++i2;
            }
            i2 = 0;
            while (i2 < 3) {
                ub.set(i2, R2.get(i2, (tst._code - 7) % 3));
                ++i2;
            }
            DxCollisionUtil.dLineClosestApproach(pa2, ua, pb2, ub, alpha, beta);
            pa2.eqSum((DVector3C)pa2, ua, alpha.get());
            pb2.eqSum((DVector3C)pb2, ub, beta.get());
            contacts.get((int)0).pos.eqSum(pa2, pb2).scale(0.5);
            contacts.get((int)0).depth = depth.get();
            return_code.set(tst._code);
            return 1;
        }
        if (tst._code <= 3) {
            Ra = R1;
            Rb = R2;
            pa = p1;
            pb = p2;
            Sa = A;
            Sb = B;
        } else {
            Ra = R2;
            Rb = R1;
            pa = p2;
            pb = p1;
            Sa = B;
            Sb = A;
        }
        DVector3 normal2 = new DVector3();
        DVector3 nr = new DVector3();
        DVector3 anr = new DVector3();
        if (tst._code <= 3) {
            normal2.set(normal);
        } else {
            normal2.set(normal).scale(-1.0);
        }
        OdeMath.dMultiply1_331(nr, Rb, normal2);
        anr.set(nr).eqAbs();
        if (anr.get1() > anr.get0()) {
            if (anr.get1() > anr.get2()) {
                a1 = 0;
                lanr = 1;
                a2 = 2;
            } else {
                a1 = 0;
                a2 = 1;
                lanr = 2;
            }
        } else if (anr.get0() > anr.get2()) {
            lanr = 0;
            a1 = 1;
            a2 = 2;
        } else {
            a1 = 0;
            a2 = 1;
            lanr = 2;
        }
        DVector3 center = new DVector3();
        if (nr.get(lanr) < 0.0) {
            i = 0;
            while (i < 3) {
                center.set(i, pb.get(i) - pa.get(i) + Sb.get(lanr) * Rb.get(i, lanr));
                ++i;
            }
        } else {
            i = 0;
            while (i < 3) {
                center.set(i, pb.get(i) - pa.get(i) - Sb.get(lanr) * Rb.get(i, lanr));
                ++i;
            }
        }
        int codeN = tst._code <= 3 ? tst._code - 1 : tst._code - 4;
        if (codeN == 0) {
            code1 = 1;
            code2 = 2;
        } else if (codeN == 1) {
            code1 = 0;
            code2 = 2;
        } else {
            code1 = 0;
            code2 = 1;
        }
        double[] quad = new double[8];
        double c1 = OdeMath.dCalcVectorDot3_14((DVector3C)center, Ra, code1);
        double c2 = OdeMath.dCalcVectorDot3_14((DVector3C)center, Ra, code2);
        double m11 = OdeMath.dCalcVectorDot3_44(Ra, code1, Rb, a1);
        double m12 = OdeMath.dCalcVectorDot3_44(Ra, code1, Rb, a2);
        double m21 = OdeMath.dCalcVectorDot3_44(Ra, code2, Rb, a1);
        double m22 = OdeMath.dCalcVectorDot3_44(Ra, code2, Rb, a2);
        double k1 = m11 * Sb.get(a1);
        double k2 = m21 * Sb.get(a1);
        double k3 = m12 * Sb.get(a2);
        double k4 = m22 * Sb.get(a2);
        quad[0] = c1 - k1 - k3;
        quad[1] = c2 - k2 - k4;
        quad[2] = c1 - k1 + k3;
        quad[3] = c2 - k2 + k4;
        quad[4] = c1 + k1 + k3;
        quad[5] = c2 + k2 + k4;
        quad[6] = c1 + k1 - k3;
        quad[7] = c2 + k2 - k4;
        double[] rect = new double[]{Sa.get(code1), Sa.get(code2)};
        double[] ret = new double[16];
        int n = DxBox.intersectRectQuad(rect, quad, ret);
        if (n < 1) {
            return 0;
        }
        double[] point = new double[24];
        double[] dep = new double[8];
        double det1 = Common.dRecip(m11 * m22 - m12 * m21);
        m11 *= det1;
        m12 *= det1;
        m21 *= det1;
        m22 *= det1;
        int cnum = 0;
        int j = 0;
        while (j < n) {
            double k12 = m22 * (ret[j * 2] - c1) - m12 * (ret[j * 2 + 1] - c2);
            double k22 = -m21 * (ret[j * 2] - c1) + m11 * (ret[j * 2 + 1] - c2);
            i = 0;
            while (i < 3) {
                point[cnum * 3 + i] = center.get(i) + k12 * Rb.get(i, a1) + k22 * Rb.get(i, a2);
                ++i;
            }
            dep[cnum] = Sa.get(codeN) - OdeMath.dCalcVectorDot3(normal2, point, cnum * 3);
            if (dep[cnum] >= 0.0) {
                ret[cnum * 2] = ret[j * 2];
                ret[cnum * 2 + 1] = ret[j * 2 + 1];
                if ((++cnum | Integer.MIN_VALUE) == (flags & 0x8000FFFF)) break;
            }
            ++j;
        }
        if (cnum < 1) {
            return 0;
        }
        int maxc = flags & 0xFFFF;
        if (maxc > cnum) {
            maxc = cnum;
        }
        if (maxc < 1) {
            maxc = 1;
        }
        if (cnum <= maxc) {
            j = 0;
            while (j < cnum) {
                DContactGeom con = contacts.get(skip * j);
                i = 0;
                while (i < 3) {
                    con.pos.set(i, point[j * 3 + i] + pa.get(i));
                    ++i;
                }
                con.depth = dep[j];
                ++j;
            }
        } else {
            Common.dIASSERT((flags & Integer.MIN_VALUE) == 0);
            int i1 = 0;
            double maxdepth = dep[0];
            i = 1;
            while (i < cnum) {
                if (dep[i] > maxdepth) {
                    maxdepth = dep[i];
                    i1 = i;
                }
                ++i;
            }
            int[] iret = new int[8];
            DxBox.cullPoints(cnum, ret, maxc, i1, iret);
            j = 0;
            while (j < maxc) {
                DContactGeom con = contacts.get(skip * j);
                i = 0;
                while (i < 3) {
                    con.pos.set(i, point[iret[j] * 3 + i] + pa.get(i));
                    ++i;
                }
                con.depth = dep[iret[j]];
                ++j;
            }
            cnum = maxc;
        }
        return_code.set(tst._code);
        return cnum;
    }

    @Override
    public void setLengths(double lx, double ly, double lz) {
        this.dGeomBoxSetLengths(new DVector3(lx, ly, lz));
    }

    @Override
    public void getLengths(DVector3 result) {
        this.dGeomBoxGetLengths(result);
    }

    @Override
    public void setLengths(DVector3C sides) {
        this.dGeomBoxSetLengths(sides);
    }

    @Override
    public DVector3C getLengths() {
        return this.side;
    }

    @Override
    public double getPointDepth(DVector3C p) {
        return this.dGeomBoxPointDepth(p.get0(), p.get1(), p.get2());
    }

    private static class TstClass {
        int _code;
        DMatrix3C _normalR_M;
        int _normalR_col;
        DVector3 _normalC = new DVector3();
        double _s;
        double _fudge_factor;
        final int _flags;
        boolean _invert_normal;
        boolean _break = false;

        TstClass(int flags, double fudge_factor) {
            this._flags = flags;
            this._fudge_factor = fudge_factor;
        }
    }
}

