/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.Ref;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DQuaternionC;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DBody;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.DMass;
import org.ode4j.ode.DMassC;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DObject;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxMass;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.Matrix;
import org.ode4j.ode.internal.Objects_H;
import org.ode4j.ode.internal.Rotation;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointNode;
import org.ode4j.ode.internal.joints.OdeJointsFactoryImpl;

public class DxBody
extends DObject
implements DBody,
Cloneable {
    private static final int dxBodyFlagFiniteRotation = 1;
    private static final int dxBodyFlagFiniteRotationAxis = 2;
    static final int dxBodyDisabled = 4;
    static final int dxBodyNoGravity = 8;
    static final int dxBodyAutoDisable = 16;
    static final int dxBodyLinearDamping = 32;
    static final int dxBodyAngularDamping = 64;
    static final int dxBodyMaxAngularSpeed = 128;
    private static final int dxBodyGyroscopic = 256;
    public final Ref<DxJointNode> firstjoint = new Ref();
    int flags;
    public DxGeom geom;
    DxMass mass;
    DMatrix3 invI;
    public double invMass;
    public Objects_H.DxPosR _posr;
    public DQuaternion _q;
    public DVector3 lvel;
    public DVector3 avel;
    DVector3 facc;
    DVector3 tacc;
    DVector3 finite_rot_axis;
    Objects_H.dxAutoDisable adis;
    double adis_timeleft;
    int adis_stepsleft;
    DVector3[] average_lvel_buffer;
    DVector3[] average_avel_buffer;
    int average_counter;
    int average_ready;
    DBody.BodyMoveCallBack moved_callback;
    private Objects_H.dxDampingParameters dampingp;
    double max_angular_speed;

    protected DxBody(DxWorld w) {
        super(w);
    }

    DxWorld dBodyGetWorld() {
        return this.world;
    }

    public static DxBody dBodyCreate(DxWorld w) {
        Common.dAASSERT(w);
        DxBody b = new DxBody(w);
        b.firstjoint.set(null);
        b.flags = 0;
        b.geom = null;
        b.average_lvel_buffer = null;
        b.average_avel_buffer = null;
        b.mass = new DxMass();
        b.mass.dMassSetParameters(1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0);
        b.invI = new DMatrix3();
        b.invI.set00(1.0);
        b.invI.set11(1.0);
        b.invI.set22(1.0);
        b.invMass = 1.0;
        b._posr = new Objects_H.DxPosR();
        b._q = new DQuaternion();
        b._q.set(0, 1.0);
        b._posr.R.setIdentity();
        b.lvel = new DVector3();
        b.avel = new DVector3();
        b.facc = new DVector3();
        b.tacc = new DVector3();
        b.finite_rot_axis = new DVector3();
        DxBody.addObjectToList(b, w.firstbody);
        ++w.nb;
        b.average_lvel_buffer = null;
        b.average_avel_buffer = null;
        b.dBodySetAutoDisableDefaults();
        b.adis_stepsleft = b.adis.idle_steps;
        b.adis_timeleft = b.adis.idle_time;
        b.average_counter = 0;
        b.average_ready = 0;
        b.dBodySetAutoDisableAverageSamplesCount(b.adis.average_samples);
        b.moved_callback = null;
        b.dBodySetDampingDefaults();
        b.flags |= w.body_flags & 0x80;
        b.max_angular_speed = w.max_angular_speed;
        b.flags |= 0x100;
        return b;
    }

    public void dBodyDestroy() {
        DxGeom next_geom = null;
        DxGeom geom2 = this.geom;
        while (geom2 != null) {
            next_geom = geom2.dGeomGetBodyNext();
            geom2.dGeomSetBody(null);
            geom2 = next_geom;
        }
        DxJointNode n = this.firstjoint.get();
        while (n != null) {
            n.joint.node[n == n.joint.node[0] ? 1 : 0].body = null;
            DxJointNode next = n.next;
            n.next = null;
            n.joint.removeJointReferencesFromAttachedBodies();
            n = next;
        }
        this.removeObjectFromList();
        --this.world.nb;
        this.DESTRUCTOR();
    }

    public void dBodySetData(Object data) {
        this.userdata = data;
    }

    public Object dBodyGetData() {
        return this.userdata;
    }

    public void dBodySetPosition(double x, double y, double z) {
        this._posr.pos.set(x, y, z);
        DxGeom geom2 = this.geom;
        while (geom2 != null) {
            geom2.dGeomMoved();
            geom2 = geom2.dGeomGetBodyNext();
        }
    }

    public void dBodySetPosition(DVector3C xyz) {
        this._posr.pos.set(xyz);
        DxGeom geom2 = this.geom;
        while (geom2 != null) {
            geom2.dGeomMoved();
            geom2 = geom2.dGeomGetBodyNext();
        }
    }

    public void dBodySetRotation(DMatrix3C R) {
        this._posr.R.set(R);
        OdeMath.dOrthogonalizeR(this._posr.R);
        Rotation.dQfromR(this._q, R);
        OdeMath.dNormalize4(this._q);
        DxGeom geom2 = this.geom;
        while (geom2 != null) {
            geom2.dGeomMoved();
            geom2 = geom2.dGeomGetBodyNext();
        }
    }

    public void dBodySetQuaternion(DQuaternionC q) {
        this._q.set(q);
        OdeMath.dNormalize4(this._q);
        Rotation.dRfromQ(this._posr.R, this._q);
        DxGeom geom2 = this.geom;
        while (geom2 != null) {
            geom2.dGeomMoved();
            geom2 = geom2.dGeomGetBodyNext();
        }
    }

    public void dBodySetLinearVel(double x, double y, double z) {
        this.lvel.set(x, y, z);
    }

    public void dBodySetLinearVel(DVector3C xyz) {
        this.lvel.set(xyz);
    }

    public void dBodySetAngularVel(double x, double y, double z) {
        this.avel.set(x, y, z);
    }

    public void dBodySetAngularVel(DVector3C xyz) {
        this.avel.set(xyz);
    }

    public DVector3C dBodyGetPosition() {
        return this._posr.pos();
    }

    void dBodyCopyPosition(DxBody b, DVector3 pos) {
        pos.set(b._posr.pos());
    }

    public DMatrix3C dBodyGetRotation() {
        return this._posr.R();
    }

    void dBodyCopyRotation(DxBody b, DMatrix3 R) {
        R.set(b._posr.R());
    }

    public DQuaternionC dBodyGetQuaternion() {
        return this._q;
    }

    void dBodyCopyQuaternion(DxBody b, DQuaternion quat) {
        quat.set(b._q);
    }

    public DVector3C dBodyGetLinearVel() {
        return this.lvel;
    }

    public DVector3C dBodyGetAngularVel() {
        return this.avel;
    }

    public void dBodySetMass(DMassC mass2) {
        Common.dIASSERT(mass2.check());
        DVector3C mass2c = mass2.getC();
        Common.dUASSERT(Math.abs(mass2c.get0()) <= 2.220446049250313E-16 && Math.abs(mass2c.get1()) <= 2.220446049250313E-16 && Math.abs(mass2c.get2()) <= 2.220446049250313E-16, "The centre of mass must be at the origin.");
        this.mass.set(mass2);
        if (!Matrix.dInvertPDMatrix(this.mass._I, this.invI)) {
            Common.dDEBUGMSG("inertia must be positive definite!");
            this.invI.setIdentity();
        }
        this.invMass = Common.dRecip(this.mass._mass);
    }

    public void dBodyGetMass(DxMass mass2) {
        mass2.set(this.mass);
    }

    public void dBodyAddForce(double fx, double fy, double fz) {
        this.facc.add(fx, fy, fz);
    }

    public void dBodyAddForce(DVector3C f) {
        this.facc.add(f);
    }

    public void dBodyAddTorque(double fx, double fy, double fz) {
        this.tacc.add(fx, fy, fz);
    }

    public void dBodyAddTorque(DVector3C f) {
        this.tacc.add(f);
    }

    void dBodyAddRelForce(DVector3C f) {
        DVector3 t2 = new DVector3();
        OdeMath.dMultiply0_331(t2, (DMatrix3C)this._posr.R, f);
        this.facc.add(t2);
    }

    public void dBodyAddRelTorque(DVector3C f) {
        DVector3 t2 = new DVector3();
        OdeMath.dMultiply0_331(t2, (DMatrix3C)this._posr.R, f);
        this.tacc.add(t2);
    }

    void dBodyAddForceAtPos(DVector3C f, DVector3C p) {
        this.facc.add(f);
        DVector3 q = p.reSub(this._posr.pos());
        OdeMath.dAddVectorCross3(this.tacc, q, f);
    }

    void dBodyAddForceAtRelPos(DVector3C f, DVector3C prel) {
        DVector3 p = new DVector3();
        OdeMath.dMultiply0_331(p, (DMatrix3C)this._posr.R, prel);
        this.facc.add(f);
        OdeMath.dAddVectorCross3(this.tacc, p, f);
    }

    void dBodyAddRelForceAtPos(DVector3C frel, DVector3C p) {
        DVector3 f = new DVector3();
        OdeMath.dMultiply0_331(f, (DMatrix3C)this._posr.R, frel);
        this.facc.add(f);
        DVector3 q = p.reSub(this._posr.pos());
        OdeMath.dAddVectorCross3(this.tacc, q, f);
    }

    void dBodyAddRelForceAtRelPos(DVector3C fRel, DVector3C pRel) {
        DVector3 f = new DVector3();
        DVector3 p = new DVector3();
        OdeMath.dMultiply0_331(f, (DMatrix3C)this._posr.R, fRel);
        OdeMath.dMultiply0_331(p, (DMatrix3C)this._posr.R, pRel);
        this.facc.add(f);
        OdeMath.dAddVectorCross3(this.tacc, p, f);
    }

    DVector3C dBodyGetForce() {
        return this.facc;
    }

    DVector3C dBodyGetTorque() {
        return this.tacc;
    }

    void dBodySetForce(double x, double y, double z) {
        this.facc.set(x, y, z);
    }

    void dBodySetForce(DVector3C xyz) {
        this.facc.set(xyz);
    }

    void dBodySetTorque(double x, double y, double z) {
        this.tacc.set(x, y, z);
    }

    void dBodySetTorque(DVector3C t) {
        this.tacc.set(t);
    }

    void dBodyGetRelPointPos(DVector3C prel, DVector3 result) {
        OdeMath.dMultiply0_331(result, (DMatrix3C)this._posr.R, prel);
        result.add(this._posr.pos());
    }

    public void dBodyGetRelPointVel(DVector3C prel, DVector3 result) {
        DVector3 p = new DVector3();
        OdeMath.dMultiply0_331(p, (DMatrix3C)this._posr.R, prel);
        result.set(this.lvel);
        OdeMath.dAddVectorCross3(result, this.avel, p);
    }

    void dBodyGetPointVel(DVector3C prel, DVector3 result) {
        DVector3 p = new DVector3(prel).sub(this._posr.pos());
        result.set(this.lvel);
        OdeMath.dAddVectorCross3(result, this.avel, p);
    }

    void dBodyGetPosRelPoint(DVector3C p, DVector3 result) {
        DVector3 prel = p.reSub(this._posr.pos());
        OdeMath.dMultiply1_331(result, this._posr.R, prel);
    }

    void dBodyVectorToWorld(DVector3C p, DVector3 result) {
        OdeMath.dMultiply0_331(result, (DMatrix3C)this._posr.R, p);
    }

    void dBodyVectorFromWorld(DVector3C p, DVector3 result) {
        OdeMath.dMultiply1_331(result, this._posr.R, p);
    }

    void dBodySetFiniteRotationMode(boolean mode) {
        this.flags &= 0xFFFFFFFC;
        if (mode) {
            this.flags |= 1;
            if (this.finite_rot_axis.get0() != 0.0 || this.finite_rot_axis.get1() != 0.0 || this.finite_rot_axis.get2() != 0.0) {
                this.flags |= 2;
            }
        }
    }

    void dBodySetFiniteRotationAxis(DVector3C xyz) {
        this.finite_rot_axis.set(xyz);
        if (xyz.get0() != 0.0 || xyz.get1() != 0.0 || xyz.get2() != 0.0) {
            OdeMath.dNormalize3(this.finite_rot_axis);
            this.flags |= 2;
        } else {
            this.flags &= 0xFFFFFFFD;
        }
    }

    boolean dBodyGetFiniteRotationMode() {
        return (this.flags & 1) != 0;
    }

    void dBodyGetFiniteRotationAxis(DVector3 result) {
        result.set(this.finite_rot_axis);
    }

    int dBodyGetNumJoints() {
        int count = 0;
        DxJointNode n = this.firstjoint.get();
        while (n != null) {
            n = n.next;
            ++count;
        }
        return count;
    }

    DxJoint dBodyGetJoint(int index) {
        int i = 0;
        DxJointNode n = this.firstjoint.get();
        while (n != null) {
            if (i == index) {
                return n.joint;
            }
            n = n.next;
            ++i;
        }
        return null;
    }

    void dBodySetDynamic() {
        this.dBodySetMass(this.mass);
    }

    void dBodySetKinematic() {
        this.invI.setZero();
        this.invMass = 0.0;
    }

    boolean dBodyIsKinematic() {
        return this.invMass == 0.0;
    }

    public void dBodyEnable() {
        this.flags &= 0xFFFFFFFB;
        this.adis_stepsleft = this.adis.idle_steps;
        this.adis_timeleft = this.adis.idle_time;
    }

    public void dBodyEnable_noAdis() {
        this.flags &= 0xFFFFFFFB;
    }

    public void dBodyDisable() {
        this.flags |= 4;
    }

    public boolean dBodyIsEnabled() {
        return (this.flags & 4) == 0;
    }

    void dBodySetGravityMode(boolean mode) {
        this.flags = mode ? (this.flags &= 0xFFFFFFF7) : (this.flags |= 8);
    }

    boolean dBodyGetGravityMode() {
        return (this.flags & 8) == 0;
    }

    double dBodyGetAutoDisableLinearThreshold() {
        return Common.dSqrt(this.adis.linear_average_threshold);
    }

    void dBodySetAutoDisableLinearThreshold(double linear_average_threshold) {
        this.adis.linear_average_threshold = linear_average_threshold * linear_average_threshold;
    }

    double dBodyGetAutoDisableAngularThreshold() {
        return Common.dSqrt(this.adis.angular_average_threshold);
    }

    void dBodySetAutoDisableAngularThreshold(double angular_average_threshold) {
        this.adis.angular_average_threshold = angular_average_threshold * angular_average_threshold;
    }

    int dBodyGetAutoDisableAverageSamplesCount() {
        return this.adis.average_samples;
    }

    void dBodySetAutoDisableAverageSamplesCount(int average_samples_count) {
        this.adis.average_samples = average_samples_count;
        if (this.average_lvel_buffer != null) {
            this.average_lvel_buffer = null;
        }
        if (this.average_avel_buffer != null) {
            this.average_avel_buffer = null;
        }
        if (this.adis.average_samples > 0) {
            this.average_lvel_buffer = new DVector3[this.adis.average_samples];
            int i = 0;
            while (i < this.average_lvel_buffer.length) {
                this.average_lvel_buffer[i] = new DVector3();
                ++i;
            }
            this.average_avel_buffer = new DVector3[this.adis.average_samples];
            i = 0;
            while (i < this.average_avel_buffer.length) {
                this.average_avel_buffer[i] = new DVector3();
                ++i;
            }
        } else {
            this.average_lvel_buffer = null;
            this.average_avel_buffer = null;
        }
        this.average_counter = 0;
        this.average_ready = 0;
    }

    int dBodyGetAutoDisableSteps() {
        return this.adis.idle_steps;
    }

    void dBodySetAutoDisableSteps(int steps) {
        this.adis.idle_steps = steps;
    }

    double dBodyGetAutoDisableTime() {
        return this.adis.idle_time;
    }

    void dBodySetAutoDisableTime(double time) {
        this.adis.idle_time = time;
    }

    boolean dBodyGetAutoDisableFlag() {
        return (this.flags & 0x10) != 0;
    }

    void dBodySetAutoDisableFlag(boolean do_auto_disable) {
        if (!do_auto_disable) {
            this.flags &= 0xFFFFFFEF;
            this.flags &= 0xFFFFFFFB;
            this.adis.idle_steps = this.world.getAutoDisableSteps();
            this.adis.idle_time = this.world.getAutoDisableTime();
            this.dBodySetAutoDisableAverageSamplesCount(this.world.getAutoDisableAverageSamplesCount());
        } else {
            this.flags |= 0x10;
        }
    }

    void dBodySetAutoDisableDefaults() {
        DxWorld w = this.world;
        this.adis = w.adis.clone();
        this.dBodySetAutoDisableFlag((w.body_flags & 0x10) != 0);
    }

    double dBodyGetLinearDamping() {
        return this.dampingp.linear_scale;
    }

    void dBodySetLinearDamping(double scale) {
        this.flags = scale != 0.0 ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
        this.dampingp.linear_scale = scale;
    }

    double dBodyGetAngularDamping() {
        return this.dampingp.angular_scale;
    }

    void dBodySetAngularDamping(double scale) {
        this.flags = scale != 0.0 ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
        this.dampingp.angular_scale = scale;
    }

    void dBodySetDamping(double linear_scale, double angular_scale) {
        this.dBodySetLinearDamping(linear_scale);
        this.dBodySetAngularDamping(angular_scale);
    }

    double dBodyGetLinearDampingThreshold() {
        return Common.dSqrt(this.dampingp.linear_threshold);
    }

    void dBodySetLinearDampingThreshold(double threshold) {
        this.dampingp.linear_threshold = threshold * threshold;
    }

    double dBodyGetAngularDampingThreshold() {
        return Common.dSqrt(this.dampingp.angular_threshold);
    }

    void dBodySetAngularDampingThreshold(double threshold) {
        this.dampingp.angular_threshold = threshold * threshold;
    }

    void dBodySetDampingDefaults() {
        DxWorld w = this.world;
        this.dampingp = w.dampingp.clone();
        int mask = 96;
        this.flags &= 0xFFFFFF9F;
        this.flags |= w.body_flags & 0x60;
    }

    double dBodyGetMaxAngularSpeed() {
        return this.max_angular_speed;
    }

    void dBodySetMaxAngularSpeed(double max_speed) {
        this.flags = max_speed < Double.MAX_VALUE ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
        this.max_angular_speed = max_speed;
    }

    public void dBodySetMovedCallback(DBody.BodyMoveCallBack callback) {
        this.moved_callback = callback;
    }

    DxGeom dBodyGetFirstGeom() {
        return this.geom;
    }

    DxGeom dBodyGetNextGeom(DxGeom geom) {
        return geom.dGeomGetBodyNext();
    }

    boolean dBodyGetGyroscopicMode() {
        return (this.flags & 0x100) != 0;
    }

    void dBodySetGyroscopicMode(boolean enabled) {
        this.flags = enabled ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    private static double sinc(double x) {
        if (Common.dFabs(x) < 1.0E-4) {
            return 1.0 - x * x * 0.16666666666666666;
        }
        return Common.dSin(x) / x;
    }

    void dxStepBody(double h) {
        double k;
        if ((this.flags & 0x80) != 0) {
            double max_ang_speed = this.max_angular_speed;
            double aspeed = OdeMath.dCalcVectorDot3(this.avel, this.avel);
            if (aspeed > max_ang_speed * max_ang_speed) {
                double coef = max_ang_speed / Common.dSqrt(aspeed);
                this.avel.scale(coef);
            }
        }
        this._posr.pos.eqSum(this._posr.pos(), this.lvel, h);
        if ((this.flags & 1) != 0) {
            DVector3 irv = new DVector3();
            DQuaternion q = new DQuaternion();
            if ((this.flags & 2) != 0) {
                DVector3 frv = new DVector3();
                double k2 = OdeMath.dCalcVectorDot3(this.finite_rot_axis, this.avel);
                frv.set(this.finite_rot_axis).scale(k2);
                irv.eqDiff(this.avel, frv);
                double theta = k2 * (h *= 0.5);
                double s = DxBody.sinc(theta) * h;
                q.set(Common.dCos(theta), frv.get0() * s, frv.get1() * s, frv.get2() * s);
            } else {
                double wlen = this.avel.length();
                double theta = wlen * (h *= 0.5);
                double s = DxBody.sinc(theta) * h;
                q.set(Common.dCos(theta), this.avel.get0() * s, this.avel.get1() * s, this.avel.get2() * s);
            }
            DQuaternion q2 = new DQuaternion();
            Rotation.dQMultiply0(q2, q, this._q);
            this._q.set(q2);
            if ((this.flags & 2) != 0) {
                DQuaternion dq = new DQuaternion();
                Rotation.dDQfromW(dq, irv, this._q);
                this._q.sum(this._q, dq, h);
            }
        } else {
            DQuaternion dq = new DQuaternion();
            Rotation.dDQfromW(dq, this.avel, this._q);
            this._q.sum(this._q, dq, h);
        }
        OdeMath.dNormalize4(this._q);
        Rotation.dRfromQ(this._posr.R, this._q);
        DxGeom geom2 = this.geom;
        while (geom2 != null) {
            geom2.dGeomMoved();
            geom2 = geom2.dGeomGetBodyNext();
        }
        if (this.moved_callback != null) {
            this.moved_callback.run(this);
        }
        if ((this.flags & 0x20) != 0) {
            double lin_threshold = this.dampingp.linear_threshold;
            double lin_speed = OdeMath.dCalcVectorDot3(this.lvel, this.lvel);
            if (lin_speed > lin_threshold) {
                k = 1.0 - this.dampingp.linear_scale;
                this.lvel.scale(k);
            }
        }
        if ((this.flags & 0x40) != 0) {
            double ang_threshold = this.dampingp.angular_threshold;
            double ang_speed = OdeMath.dCalcVectorDot3(this.avel, this.avel);
            if (ang_speed > ang_threshold) {
                k = 1.0 - this.dampingp.angular_scale;
                this.avel.scale(k);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public Objects_H.DxPosRC posr() {
        return this._posr;
    }

    @Override
    public void DESTRUCTOR() {
        super.DESTRUCTOR();
    }

    @Override
    public void setData(Object data) {
        this.dBodySetData(data);
    }

    @Override
    public Object getData() {
        return this.dBodyGetData();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.dBodySetPosition(x, y, z);
    }

    @Override
    public void setPosition(DVector3C p) {
        this.dBodySetPosition(p);
    }

    @Override
    public void setRotation(DMatrix3C R) {
        this.dBodySetRotation(R);
    }

    @Override
    public void setQuaternion(DQuaternionC q) {
        this.dBodySetQuaternion(q);
    }

    @Override
    public void setLinearVel(double x, double y, double z) {
        this.dBodySetLinearVel(x, y, z);
    }

    @Override
    public void setLinearVel(DVector3C v) {
        this.dBodySetLinearVel(v);
    }

    @Override
    public void setAngularVel(double x, double y, double z) {
        this.dBodySetAngularVel(x, y, z);
    }

    @Override
    public void setAngularVel(DVector3C v) {
        this.dBodySetAngularVel(v);
    }

    @Override
    public DVector3C getPosition() {
        return this.dBodyGetPosition();
    }

    @Override
    public DMatrix3C getRotation() {
        return this.dBodyGetRotation();
    }

    @Override
    public DQuaternionC getQuaternion() {
        return this.dBodyGetQuaternion();
    }

    @Override
    public DVector3C getLinearVel() {
        return this.dBodyGetLinearVel();
    }

    @Override
    public DVector3C getAngularVel() {
        return this.dBodyGetAngularVel();
    }

    @Override
    public void setMass(DMassC mass) {
        this.dBodySetMass((DxMass)mass);
    }

    @Override
    public DMass getMass() {
        DxMass mass = new DxMass();
        this.dBodyGetMass(mass);
        return mass;
    }

    @Override
    public void addForce(double fx, double fy, double fz) {
        this.dBodyAddForce(fx, fy, fz);
    }

    @Override
    public void addForce(DVector3C f) {
        this.dBodyAddForce(f);
    }

    @Override
    public void addTorque(double fx, double fy, double fz) {
        this.dBodyAddTorque(fx, fy, fz);
    }

    @Override
    public void addTorque(DVector3C t) {
        this.dBodyAddTorque(t);
    }

    @Override
    public void addRelForce(double fx, double fy, double fz) {
        this.dBodyAddRelForce(new DVector3(fx, fy, fz));
    }

    @Override
    public void addRelForce(DVector3C f) {
        this.dBodyAddRelForce(f);
    }

    @Override
    public void addRelTorque(double fx, double fy, double fz) {
        this.dBodyAddRelTorque(new DVector3(fx, fy, fz));
    }

    @Override
    public void addRelTorque(DVector3C t) {
        this.dBodyAddRelTorque(t);
    }

    @Override
    public void addForceAtPos(double fx, double fy, double fz, double px, double py, double pz) {
        this.dBodyAddForceAtPos(new DVector3(fx, fy, fz), new DVector3(px, py, pz));
    }

    @Override
    public void addForceAtPos(DVector3C f, DVector3C p) {
        this.dBodyAddForceAtPos(f, p);
    }

    @Override
    public void addForceAtRelPos(double fx, double fy, double fz, double px, double py, double pz) {
        this.dBodyAddForceAtRelPos(new DVector3(fx, fy, fz), new DVector3(px, py, pz));
    }

    @Override
    public void addForceAtRelPos(DVector3C f, DVector3C p) {
        this.dBodyAddForceAtRelPos(f, p);
    }

    @Override
    public void addRelForceAtPos(double fx, double fy, double fz, double px, double py, double pz) {
        this.dBodyAddRelForceAtPos(new DVector3(fx, fy, fz), new DVector3(px, py, pz));
    }

    @Override
    public void addRelForceAtPos(DVector3C f, DVector3C p) {
        this.dBodyAddRelForceAtPos(f, p);
    }

    @Override
    public void addRelForceAtRelPos(double fx, double fy, double fz, double px, double py, double pz) {
        this.dBodyAddRelForceAtRelPos(new DVector3(fx, fy, fz), new DVector3(px, py, pz));
    }

    @Override
    public void addRelForceAtRelPos(DVector3C f, DVector3C p) {
        this.dBodyAddRelForceAtRelPos(f, p);
    }

    @Override
    public DVector3C getForce() {
        return this.dBodyGetForce();
    }

    @Override
    public DVector3C getTorque() {
        return this.dBodyGetTorque();
    }

    @Override
    public void setForce(double x, double y, double z) {
        this.dBodySetForce(x, y, z);
    }

    @Override
    public void setForce(DVector3C f) {
        this.dBodySetForce(f);
    }

    @Override
    public void setTorque(double x, double y, double z) {
        this.dBodySetTorque(x, y, z);
    }

    @Override
    public void setTorque(DVector3C t) {
        this.dBodySetTorque(t);
    }

    @Override
    public void setDynamic() {
        this.dBodySetDynamic();
    }

    @Override
    public void setKinematic() {
        this.dBodySetKinematic();
    }

    @Override
    public boolean isKinematic() {
        return this.dBodyIsKinematic();
    }

    @Override
    public void enable() {
        this.dBodyEnable();
    }

    @Override
    public void disable() {
        this.dBodyDisable();
    }

    @Override
    public boolean isEnabled() {
        return this.dBodyIsEnabled();
    }

    public boolean isFlagsGyroscopic() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public void getRelPointPos(double px, double py, double pz, DVector3 result) {
        this.dBodyGetRelPointPos(new DVector3(px, py, pz), result);
    }

    @Override
    public void getRelPointPos(DVector3C p, DVector3 result) {
        this.dBodyGetRelPointPos(p, result);
    }

    @Override
    public void getRelPointVel(double px, double py, double pz, DVector3 result) {
        this.dBodyGetRelPointVel(new DVector3(px, py, pz), result);
    }

    @Override
    public void getRelPointVel(DVector3C p, DVector3 result) {
        this.dBodyGetRelPointVel(p, result);
    }

    @Override
    public void getPointVel(double px, double py, double pz, DVector3 result) {
        this.dBodyGetPointVel(new DVector3(px, py, pz), result);
    }

    @Override
    public void getPointVel(DVector3C p, DVector3 result) {
        this.dBodyGetPointVel(p, result);
    }

    @Override
    public void getPosRelPoint(double px, double py, double pz, DVector3 result) {
        this.dBodyGetPosRelPoint(new DVector3(px, py, pz), result);
    }

    @Override
    public void getPosRelPoint(DVector3C p, DVector3 result) {
        this.dBodyGetPosRelPoint(p, result);
    }

    @Override
    public void vectorToWorld(double px, double py, double pz, DVector3 result) {
        this.dBodyVectorToWorld(new DVector3(px, py, pz), result);
    }

    @Override
    public void vectorToWorld(DVector3C p, DVector3 result) {
        this.dBodyVectorToWorld(p, result);
    }

    @Override
    public void vectorFromWorld(double px, double py, double pz, DVector3 result) {
        this.dBodyVectorFromWorld(new DVector3(px, py, pz), result);
    }

    @Override
    public void vectorFromWorld(DVector3C p, DVector3 result) {
        this.dBodyVectorFromWorld(p, result);
    }

    @Override
    public void setFiniteRotationMode(boolean mode) {
        this.dBodySetFiniteRotationMode(mode);
    }

    @Override
    public void setFiniteRotationAxis(double x, double y, double z) {
        this.dBodySetFiniteRotationAxis(new DVector3(x, y, z));
    }

    @Override
    public void setFiniteRotationAxis(DVector3C a) {
        this.dBodySetFiniteRotationAxis(a);
    }

    @Override
    public boolean getFiniteRotationMode() {
        return this.dBodyGetFiniteRotationMode();
    }

    @Override
    public void getFiniteRotationAxis(DVector3 result) {
        this.dBodyGetFiniteRotationAxis(result);
    }

    @Override
    public int getNumJoints() {
        return this.dBodyGetNumJoints();
    }

    @Override
    public DJoint getJoint(int index) {
        return this.dBodyGetJoint(index);
    }

    @Override
    public void setGravityMode(boolean mode) {
        this.dBodySetGravityMode(mode);
    }

    @Override
    public boolean getGravityMode() {
        return this.dBodyGetGravityMode();
    }

    @Override
    public void setGyroscopicMode(boolean mode) {
        this.dBodySetGyroscopicMode(mode);
    }

    @Override
    public boolean getGyroscopicMode() {
        return this.dBodyGetGyroscopicMode();
    }

    @Override
    public boolean isConnectedTo(DBody body) {
        return OdeJointsFactoryImpl.areConnected(this, body);
    }

    @Override
    public void setAutoDisableLinearThreshold(double threshold) {
        this.dBodySetAutoDisableLinearThreshold(threshold);
    }

    @Override
    public double getAutoDisableLinearThreshold() {
        return this.dBodyGetAutoDisableLinearThreshold();
    }

    @Override
    public void setAutoDisableAngularThreshold(double threshold) {
        this.dBodySetAutoDisableAngularThreshold(threshold);
    }

    @Override
    public double getAutoDisableAngularThreshold() {
        return this.dBodyGetAutoDisableAngularThreshold();
    }

    @Override
    public void setAutoDisableSteps(int steps) {
        this.dBodySetAutoDisableSteps(steps);
    }

    @Override
    public int getAutoDisableSteps() {
        return this.dBodyGetAutoDisableSteps();
    }

    @Override
    public void setAutoDisableTime(double time) {
        this.dBodySetAutoDisableTime(time);
    }

    @Override
    public double getAutoDisableTime() {
        return this.dBodyGetAutoDisableTime();
    }

    @Override
    public void setAutoDisableFlag(boolean do_auto_disable) {
        this.dBodySetAutoDisableFlag(do_auto_disable);
    }

    @Override
    public boolean getAutoDisableFlag() {
        return this.dBodyGetAutoDisableFlag();
    }

    @Override
    public double getLinearDamping() {
        return this.dBodyGetLinearDamping();
    }

    @Override
    public void setLinearDamping(double scale) {
        this.dBodySetLinearDamping(scale);
    }

    @Override
    public double getAngularDamping() {
        return this.dBodyGetAngularDamping();
    }

    @Override
    public void setAngularDamping(double scale) {
        this.dBodySetAngularDamping(scale);
    }

    @Override
    public void setDamping(double linear_scale, double angular_scale) {
        this.dBodySetDamping(linear_scale, angular_scale);
    }

    @Override
    public double getLinearDampingThreshold() {
        return this.dBodyGetLinearDampingThreshold();
    }

    @Override
    public void setLinearDampingThreshold(double threshold) {
        this.dBodySetLinearDampingThreshold(threshold);
    }

    @Override
    public double getAngularDampingThreshold() {
        return this.dBodyGetAngularDampingThreshold();
    }

    @Override
    public void setAngularDampingThreshold(double threshold) {
        this.dBodySetAngularDampingThreshold(threshold);
    }

    @Override
    public void setDampingDefaults() {
        this.dBodySetDampingDefaults();
    }

    @Override
    public double getMaxAngularSpeed() {
        return this.dBodyGetMaxAngularSpeed();
    }

    @Override
    public void setMaxAngularSpeed(double max_speed) {
        this.dBodySetMaxAngularSpeed(max_speed);
    }

    @Override
    public void destroy() {
        this.dBodyDestroy();
    }

    @Override
    public int getAutoDisableAverageSamplesCount() {
        return this.dBodyGetAutoDisableAverageSamplesCount();
    }

    @Override
    public void setAutoDisableAverageSamplesCount(int average_samples_count) {
        this.dBodySetAutoDisableAverageSamplesCount(average_samples_count);
    }

    @Override
    public void setAutoDisableDefaults() {
        this.dBodySetAutoDisableDefaults();
    }

    @Override
    public DGeom getFirstGeom() {
        return this.dBodyGetFirstGeom();
    }

    @Override
    public DGeom getNextGeom(DGeom geom) {
        return this.dBodyGetNextGeom((DxGeom)geom);
    }

    @Override
    public void setMovedCallback(DBody.BodyMoveCallBack callback) {
        this.dBodySetMovedCallback(callback);
    }
}

