/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.Cstdio;
import org.cpp4j.Cstring;
import org.ode4j.ode.DStopwatch;
import org.ode4j.ode.OdeConfig;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.ErrorHandler;
import org.ode4j.ode.internal.FastDot;
import org.ode4j.ode.internal.Matrix;
import org.ode4j.ode.internal.Misc;
import org.ode4j.ode.internal.Timer;
import org.ode4j.ode.internal.processmem.DxUtil;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemArena;

public class DLCP {
    private static final boolean dLCP_FAST = true;
    protected static final boolean ROWPTRS = false;
    protected static final boolean NUB_OPTIMIZATIONS = true;
    protected static final boolean DEBUG_LCP = false;
    private final int m_n;
    private final int m_nskip;
    private int m_nub;
    private int m_nC;
    private int m_nN;
    private double[] m_A;
    private double[] m_x;
    private double[] m_b;
    private double[] m_w;
    private double[] m_lo;
    private double[] m_hi;
    private double[] m_L;
    private double[] m_d;
    private double[] m_Dell;
    private double[] m_ell;
    private double[] m_tmp;
    private boolean[] m_state;
    private int[] m_findex;
    private int[] m_p;
    private int[] m_C;

    private final int AROWp(int i) {
        return i * this.m_nskip;
    }

    protected final double AROW(int i, int j) {
        return this.m_A[i * this.m_nskip + j];
    }

    private void pN_plusequals_ANi(double[] p, int i) {
        this.pN_plusequals_ANi(p, i, 1);
    }

    void solve1(double[] a, int i, int dir) {
        this.solve1(a, i, dir, false);
    }

    void solve1(double[] a, int i) {
        this.solve1(a, i, 1, false);
    }

    private int getNub() {
        return this.m_nub;
    }

    private void transfer_i_to_N(int i) {
        ++this.m_nN;
    }

    static int estimate_transfer_i_from_C_to_N_mem_req(int nC, int nskip) {
        return Matrix.dEstimateLDLTRemoveTmpbufSize(nC, nskip);
    }

    private int numC() {
        return this.m_nC;
    }

    private int numN() {
        return this.m_nN;
    }

    private int indexC(int i) {
        return i;
    }

    private int indexN(int i) {
        return i + this.m_nC;
    }

    private double Aii(int i) {
        return this.AROW(i, i);
    }

    private double AiC_times_qC(int i, double[] q) {
        return FastDot.dDot(this.m_A, this.AROWp(i), q, 0, this.m_nC);
    }

    private double AiN_times_qN(int i, double[] q) {
        return FastDot.dDot(this.m_A, this.AROWp(i) + this.m_nC, q, this.m_nC, this.m_nN);
    }

    DLCP(int _n, int _nskip, int _nub, double[] _Adata, double[] _x, double[] _b, double[] _w, double[] _lo, double[] _hi, double[] _L, double[] _d, double[] _Dell, double[] _ell, double[] _tmp, boolean[] _state, int[] _findex, int[] _p, int[] _C, double[][] Arows) {
        this.m_n = _n;
        this.m_nskip = _nskip;
        this.m_nub = _nub;
        this.m_A = _Adata;
        this.m_x = _x;
        this.m_b = _b;
        this.m_w = _w;
        this.m_lo = _lo;
        this.m_hi = _hi;
        this.m_L = _L;
        this.m_d = _d;
        this.m_Dell = _Dell;
        this.m_ell = _ell;
        this.m_tmp = _tmp;
        this.m_state = _state;
        this.m_findex = _findex;
        this.m_p = _p;
        this.m_C = _C;
        Matrix.dSetZero(this.m_x, this.m_n);
        int[] p = this.m_p;
        int n = this.m_n;
        int k = 0;
        while (k < n) {
            p[k] = k;
            ++k;
        }
        int[] findex = this.m_findex;
        double[] lo = this.m_lo;
        double[] hi = this.m_hi;
        int n2 = this.m_n;
        int k2 = this.m_nub;
        while (k2 < n2) {
            if ((findex == null || findex[k2] < 0) && lo[k2] == Double.NEGATIVE_INFINITY && hi[k2] == Double.POSITIVE_INFINITY) {
                DLCP.swapProblem(this.m_A, this.m_x, this.m_b, this.m_w, lo, hi, this.m_p, this.m_state, findex, n2, this.m_nub, k2, this.m_nskip, false);
                ++this.m_nub;
            }
            ++k2;
        }
        if (this.m_nub > 0) {
            int nub = this.m_nub;
            int Lrow = 0;
            int nskip = this.m_nskip;
            int j = 0;
            while (j < nub) {
                Cstring.memcpy(this.m_L, Lrow, this.m_A, this.AROWp(j), j + 1);
                Lrow += nskip;
                ++j;
            }
            Matrix.dFactorLDLT(this.m_L, this.m_d, nub, this.m_nskip);
            Cstring.memcpy(this.m_x, this.m_b, nub);
            Matrix.dSolveLDLT(this.m_L, this.m_d, this.m_x, nub, this.m_nskip);
            Matrix.dSetZero(this.m_w, nub);
            int[] C = this.m_C;
            k = 0;
            while (k < nub) {
                C[k] = k;
                ++k;
            }
            this.m_nC = nub;
        }
        if (this.m_findex != null) {
            int nub = this.m_nub;
            int[] findex2 = this.m_findex;
            int num_at_end = 0;
            int k3 = this.m_n - 1;
            while (k3 >= nub) {
                if (findex2[k3] >= 0) {
                    DLCP.swapProblem(this.m_A, this.m_x, this.m_b, this.m_w, this.m_lo, this.m_hi, this.m_p, this.m_state, findex2, this.m_n, k3, this.m_n - 1 - num_at_end, this.m_nskip, true);
                    ++num_at_end;
                }
                --k3;
            }
        }
    }

    void transfer_i_to_C(int i) {
        int nC;
        if (this.m_nC > 0) {
            nC = this.m_nC;
            int Ltgt_p = nC * this.m_nskip;
            double[] ell = this.m_ell;
            int j = 0;
            while (j < nC) {
                this.m_L[Ltgt_p + j] = ell[j];
                ++j;
            }
            nC = this.m_nC;
            this.m_d[nC] = Common.dRecip(this.AROW(i, i) - FastDot.dDot(this.m_ell, this.m_Dell, nC));
        } else {
            this.m_d[0] = Common.dRecip(this.AROW(i, i));
        }
        DLCP.swapProblem(this.m_A, this.m_x, this.m_b, this.m_w, this.m_lo, this.m_hi, this.m_p, this.m_state, this.m_findex, this.m_n, this.m_nC, i, this.m_nskip, true);
        this.m_C[nC] = nC = this.m_nC;
        this.m_nC = nC + 1;
    }

    void transfer_i_from_N_to_C(int i) {
        int nC;
        if (this.m_nC > 0) {
            int aPos = this.AROWp(i);
            double[] Dell = this.m_Dell;
            int[] C = this.m_C;
            int nub = this.m_nub;
            int j = 0;
            while (j < nub) {
                Dell[j] = this.m_A[aPos + j];
                ++j;
            }
            int nC2 = this.m_nC;
            while (j < nC2) {
                Dell[j] = this.m_A[aPos + C[j]];
                ++j;
            }
            Matrix.dSolveL1(this.m_L, this.m_Dell, this.m_nC, this.m_nskip);
            nC = this.m_nC;
            int Ltgt = nC * this.m_nskip;
            double[] ell = this.m_ell;
            double[] Dell2 = this.m_Dell;
            double[] d = this.m_d;
            int j2 = 0;
            while (j2 < nC) {
                this.m_L[Ltgt + j2] = ell[j2] = Dell2[j2] * d[j2];
                ++j2;
            }
            nC = this.m_nC;
            this.m_d[nC] = Common.dRecip(this.AROW(i, i) - FastDot.dDot(this.m_ell, this.m_Dell, nC));
        } else {
            this.m_d[0] = Common.dRecip(this.AROW(i, i));
        }
        DLCP.swapProblem(this.m_A, this.m_x, this.m_b, this.m_w, this.m_lo, this.m_hi, this.m_p, this.m_state, this.m_findex, this.m_n, this.m_nC, i, this.m_nskip, true);
        this.m_C[nC] = nC = this.m_nC;
        --this.m_nN;
        this.m_nC = nC + 1;
    }

    void transfer_i_from_C_to_N(int i, DxUtil.BlockPointer tmpbuf) {
        int[] C = this.m_C;
        int last_idx = -1;
        int nC = this.m_nC;
        int j = 0;
        while (j < nC) {
            if (C[j] == nC - 1) {
                last_idx = j;
            }
            if (C[j] == i) {
                int k;
                Matrix.dLDLTRemove(this.m_A, C, this.m_L, this.m_d, this.m_n, nC, j, this.m_nskip, tmpbuf);
                if (last_idx == -1) {
                    k = j + 1;
                    while (k < nC) {
                        if (C[k] == nC - 1) break;
                        ++k;
                    }
                    Common.dIASSERT(k < nC);
                } else {
                    k = last_idx;
                }
                C[k] = C[j];
                if (j >= nC - 1) break;
                Cstring.memmove(C, j, C, j + 1, nC - j - 1);
                break;
            }
            ++j;
        }
        Common.dIASSERT(j < nC);
        DLCP.swapProblem(this.m_A, this.m_x, this.m_b, this.m_w, this.m_lo, this.m_hi, this.m_p, this.m_state, this.m_findex, this.m_n, i, nC - 1, this.m_nskip, true);
        ++this.m_nN;
        this.m_nC = nC - 1;
    }

    void pN_equals_ANC_times_qC(double[] p, double[] q) {
        int nC;
        int ptgt_p = nC = this.m_nC;
        int nN = this.m_nN;
        int i = 0;
        while (i < nN) {
            p[ptgt_p + i] = FastDot.dDot(this.m_A, this.AROWp(i + nC), q, 0, nC);
            ++i;
        }
    }

    void pN_plusequals_ANi(double[] p, int ii, int sign) {
        int nC = this.m_nC;
        int aPos = this.AROWp(ii) + nC;
        int ptgt_p = nC;
        if (sign > 0) {
            int nN = this.m_nN;
            int j = 0;
            while (j < nN) {
                int n = ptgt_p + j;
                p[n] = p[n] + this.m_A[aPos + j];
                ++j;
            }
        } else {
            int nN = this.m_nN;
            int j = 0;
            while (j < nN) {
                int n = ptgt_p + j;
                p[n] = p[n] - this.m_A[aPos + j];
                ++j;
            }
        }
    }

    void pC_plusequals_s_times_qC(double[] p, double s, double[] q) {
        int nC = this.m_nC;
        int i = 0;
        while (i < nC) {
            int n = i;
            p[n] = p[n] + s * q[i];
            ++i;
        }
    }

    void pN_plusequals_s_times_qN(double[] p, double s, double[] q) {
        int nC;
        int ptgt_p = nC = this.m_nC;
        int qsrc_p = nC;
        int nN = this.m_nN;
        int i = 0;
        while (i < nN) {
            int n = ptgt_p + i;
            p[n] = p[n] + s * q[qsrc_p + i];
            ++i;
        }
    }

    void solve1(double[] a, int i, int dir, boolean only_transfer) {
        block9: {
            int j;
            if (this.m_nC > 0) {
                double[] Dell = this.m_Dell;
                int[] C = this.m_C;
                int aPos = this.AROWp(i);
                int nub = this.m_nub;
                j = 0;
                while (j < nub) {
                    Dell[j] = this.m_A[aPos + j];
                    ++j;
                }
                int nC = this.m_nC;
                while (j < nC) {
                    Dell[j] = this.m_A[aPos + C[j]];
                    ++j;
                }
            }
            Matrix.dSolveL1(this.m_L, this.m_Dell, this.m_nC, this.m_nskip);
            double[] ell = this.m_ell;
            double[] Dell = this.m_Dell;
            double[] d = this.m_d;
            int nC = this.m_nC;
            j = 0;
            while (j < nC) {
                ell[j] = Dell[j] * d[j];
                ++j;
            }
            if (only_transfer) break block9;
            double[] tmp = this.m_tmp;
            double[] ell2 = this.m_ell;
            int nC2 = this.m_nC;
            int j2 = 0;
            while (j2 < nC2) {
                tmp[j2] = ell2[j2];
                ++j2;
            }
            Matrix.dSolveL1T(this.m_L, tmp, this.m_nC, this.m_nskip);
            if (dir > 0) {
                int[] C = this.m_C;
                nC = this.m_nC;
                j = 0;
                while (j < nC) {
                    a[C[j]] = -tmp[j];
                    ++j;
                }
            } else {
                int[] C = this.m_C;
                nC = this.m_nC;
                j = 0;
                while (j < nC) {
                    a[C[j]] = tmp[j];
                    ++j;
                }
            }
        }
    }

    void unpermute() {
        Cstring.memcpy(this.m_tmp, this.m_x, this.m_n);
        double[] x = this.m_x;
        double[] tmp = this.m_tmp;
        int[] p = this.m_p;
        int n = this.m_n;
        int j = 0;
        while (j < n) {
            x[p[j]] = tmp[j];
            ++j;
        }
        Cstring.memcpy(this.m_tmp, this.m_w, this.m_n);
        double[] w = this.m_w;
        tmp = this.m_tmp;
        p = this.m_p;
        n = this.m_n;
        j = 0;
        while (j < n) {
            w[p[j]] = tmp[j];
            ++j;
        }
    }

    static void dSolveLCP(DxWorldProcessMemArena memarena, int n, double[] A, double[] x, double[] b, double[] outer_w, int nub, double[] lo, double[] hi, int[] findex) {
        Common.dAASSERT(n > 0 && nub >= 0 && nub <= n);
        Common.dAASSERT(A, x, b, lo, hi);
        int k = 0;
        while (k < n) {
            Common.dIASSERT(lo[k] <= 0.0 && hi[k] >= 0.0);
            ++k;
        }
        if (nub >= n) {
            double[] d = memarena.AllocateArrayDReal(n);
            Matrix.dSetZero(d);
            int nskip = Common.dPAD(n);
            Matrix.dFactorLDLT(A, d, n, nskip);
            Matrix.dSolveLDLT(A, d, b, n, nskip);
            Cstring.memcpy(x, b, n);
            return;
        }
        int nskip = Common.dPAD(n);
        double[] L = memarena.AllocateArrayDReal(n * nskip);
        double[] d = memarena.AllocateArrayDReal(n);
        double[] w = outer_w != null ? outer_w : memarena.AllocateArrayDReal(n);
        double[] delta_x = memarena.AllocateArrayDReal(n);
        double[] delta_w = memarena.AllocateArrayDReal(n);
        double[] Dell = memarena.AllocateArrayDReal(n);
        double[] ell = memarena.AllocateArrayDReal(n);
        double[][] Arows = null;
        int[] p = memarena.AllocateArrayInt(n);
        int[] C = memarena.AllocateArrayInt(n);
        boolean[] state = memarena.AllocateArrayBool(n);
        DLCP lcp = new DLCP(n, nskip, nub, A, x, b, w, lo, hi, L, d, Dell, ell, delta_w, state, findex, p, C, Arows);
        int adj_nub = lcp.getNub();
        boolean hit_first_friction_index = false;
        int i = adj_nub;
        while (i < n) {
            boolean s_error = false;
            if (!hit_first_friction_index && findex != null && findex[i] >= 0) {
                int j = 0;
                while (j < n) {
                    delta_w[p[j]] = x[j];
                    ++j;
                }
                int k2 = i;
                while (k2 < n) {
                    double wfk = delta_w[findex[k2]];
                    if (wfk == 0.0) {
                        hi[k2] = 0.0;
                        lo[k2] = 0.0;
                    } else {
                        hi[k2] = Common.dFabs(hi[k2] * wfk);
                        lo[k2] = -hi[k2];
                    }
                    ++k2;
                }
                hit_first_friction_index = true;
            }
            w[i] = lcp.AiC_times_qC(i, x) + lcp.AiN_times_qN(i, x) - b[i];
            if (lo[i] == 0.0 && w[i] >= 0.0) {
                lcp.transfer_i_to_N(i);
                state[i] = false;
            } else if (hi[i] == 0.0 && w[i] <= 0.0) {
                lcp.transfer_i_to_N(i);
                state[i] = true;
            } else if (w[i] == 0.0) {
                lcp.solve1(delta_x, i, 0, true);
                lcp.transfer_i_to_C(i);
            } else {
                int cmd;
                do {
                    double s2;
                    double s22;
                    double dirf;
                    int dir;
                    if (w[i] <= 0.0) {
                        dir = 1;
                        dirf = 1.0;
                    } else {
                        dir = -1;
                        dirf = -1.0;
                    }
                    lcp.solve1(delta_x, i, dir);
                    lcp.pN_equals_ANC_times_qC(delta_w, delta_x);
                    lcp.pN_plusequals_ANi(delta_w, i, dir);
                    delta_w[i] = lcp.AiC_times_qC(i, delta_x) + lcp.Aii(i) * dirf;
                    cmd = 1;
                    int si = 0;
                    double s = -w[i] / delta_w[i];
                    if (dir > 0) {
                        double s23;
                        if (hi[i] < Double.POSITIVE_INFINITY && (s23 = (hi[i] - x[i]) * dirf) < s) {
                            s = s23;
                            cmd = 3;
                        }
                    } else if (lo[i] > Double.NEGATIVE_INFINITY && (s22 = (lo[i] - x[i]) * dirf) < s) {
                        s = s22;
                        cmd = 2;
                    }
                    int numN = lcp.numN();
                    int k3 = 0;
                    while (k3 < numN) {
                        int indexN_k = lcp.indexN(k3);
                        if ((!state[indexN_k] ? delta_w[indexN_k] < 0.0 : delta_w[indexN_k] > 0.0) && (lo[indexN_k] != 0.0 || hi[indexN_k] != 0.0) && (s2 = -w[indexN_k] / delta_w[indexN_k]) < s) {
                            s = s2;
                            cmd = 4;
                            si = indexN_k;
                        }
                        ++k3;
                    }
                    int numC = lcp.numC();
                    k3 = adj_nub;
                    while (k3 < numC) {
                        int indexC_k = lcp.indexC(k3);
                        if (delta_x[indexC_k] < 0.0 && lo[indexC_k] > Double.NEGATIVE_INFINITY && (s2 = (lo[indexC_k] - x[indexC_k]) / delta_x[indexC_k]) < s) {
                            s = s2;
                            cmd = 5;
                            si = indexC_k;
                        }
                        if (delta_x[indexC_k] > 0.0 && hi[indexC_k] < Double.POSITIVE_INFINITY && (s2 = (hi[indexC_k] - x[indexC_k]) / delta_x[indexC_k]) < s) {
                            s = s2;
                            cmd = 6;
                            si = indexC_k;
                        }
                        ++k3;
                    }
                    if (s <= 0.0) {
                        ErrorHandler.dMessage(3, "LCP internal error, s <= 0 (s=%.4e)", s);
                        if (i < n) {
                            int ii = i;
                            while (ii < n) {
                                x[ii] = 0.0;
                                ++ii;
                            }
                            ii = i;
                            while (ii < n) {
                                w[ii] = 0.0;
                                ++ii;
                            }
                        }
                        s_error = true;
                        break;
                    }
                    lcp.pC_plusequals_s_times_qC(x, s, delta_x);
                    int n2 = i;
                    x[n2] = x[n2] + s * dirf;
                    lcp.pN_plusequals_s_times_qN(w, s, delta_w);
                    int n3 = i;
                    w[n3] = w[n3] + s * delta_w[i];
                    switch (cmd) {
                        case 1: {
                            w[i] = 0.0;
                            lcp.transfer_i_to_C(i);
                            break;
                        }
                        case 2: {
                            x[i] = lo[i];
                            state[i] = false;
                            lcp.transfer_i_to_N(i);
                            break;
                        }
                        case 3: {
                            x[i] = hi[i];
                            state[i] = true;
                            lcp.transfer_i_to_N(i);
                            break;
                        }
                        case 4: {
                            w[si] = 0.0;
                            lcp.transfer_i_from_N_to_C(si);
                            break;
                        }
                        case 5: {
                            x[si] = lo[si];
                            state[si] = false;
                            DxUtil.BlockPointer tmpbuf = memarena.PeekBufferRemainder();
                            lcp.transfer_i_from_C_to_N(si, tmpbuf);
                            break;
                        }
                        case 6: {
                            x[si] = hi[si];
                            state[si] = true;
                            DxUtil.BlockPointer tmpbuf = memarena.PeekBufferRemainder();
                            lcp.transfer_i_from_C_to_N(si, tmpbuf);
                        }
                    }
                } while (cmd > 3);
            }
            if (s_error) break;
            ++i;
        }
        lcp.unpermute();
    }

    private int sizeof(Class<?> cls) {
        return -1;
    }

    static int dEstimateSolveLCPMemoryReq(int n, boolean outer_w_avail) {
        return -1;
    }

    static int EstimateTestSolveLCPMemoryReq(int n) {
        return -1;
    }

    public static int dTestSolveLCP() {
        int n = 100;
        int memreq = DLCP.EstimateTestSolveLCPMemoryReq(100);
        DxWorldProcessMemArena arena = DxWorldProcessMemArena.allocateTemporary(memreq, null, null);
        if (arena == null) {
            return 0;
        }
        int nskip = Common.dPAD(100);
        double tol = OdeConfig.isDoublePrecision() ? 1.0E-9 : (double)1.0E-4f;
        System.out.println("dTestSolveLCP()");
        double[] A = arena.AllocateArrayDReal(100 * nskip);
        double[] x = arena.AllocateArrayDReal(100);
        double[] b = arena.AllocateArrayDReal(100);
        double[] w = arena.AllocateArrayDReal(100);
        double[] lo = arena.AllocateArrayDReal(100);
        double[] hi = arena.AllocateArrayDReal(100);
        double[] A2 = arena.AllocateArrayDReal(100 * nskip);
        double[] b2 = arena.AllocateArrayDReal(100);
        double[] lo2 = arena.AllocateArrayDReal(100);
        double[] hi2 = arena.AllocateArrayDReal(100);
        double[] tmp1 = arena.AllocateArrayDReal(100);
        double[] tmp2 = arena.AllocateArrayDReal(100);
        double total_time = 0.0;
        int count = 0;
        while (count < 1000) {
            DxUtil.BlockPointer saveInner = arena.BEGIN_STATE_SAVE();
            Misc.dMakeRandomMatrix(A2, 100, 100, 1.0);
            Matrix.dMultiply2(A, A2, A2, 100, 100, 100);
            Misc.dMakeRandomMatrix(x, 100, 1, 1.0);
            Matrix.dMultiply0(b, A, x, 100, 100, 1);
            int i = 0;
            while (i < 100) {
                int n2 = i++;
                b[n2] = b[n2] + (Misc.dRandReal() * 0.2 - 0.1);
            }
            int nub = 50;
            i = 0;
            while (i < nub) {
                lo[i] = Double.NEGATIVE_INFINITY;
                ++i;
            }
            i = 0;
            while (i < nub) {
                hi[i] = Double.POSITIVE_INFINITY;
                ++i;
            }
            i = nub;
            while (i < 100) {
                lo[i] = -Misc.dRandReal() - 0.01;
                ++i;
            }
            i = nub;
            while (i < 100) {
                hi[i] = Misc.dRandReal() + 0.01;
                ++i;
            }
            Cstring.memcpy(A2, A, 100 * nskip);
            Misc.dClearUpperTriangle(A2, 100);
            Cstring.memcpy(b2, b, 100);
            Cstring.memcpy(lo2, lo, 100);
            Cstring.memcpy(hi2, hi, 100);
            Matrix.dSetZero(x);
            Matrix.dSetZero(w);
            DStopwatch sw = new DStopwatch();
            Timer.dStopwatchReset(sw);
            Timer.dStopwatchStart(sw);
            DLCP.dSolveLCP(arena, 100, A2, x, b2, w, nub, lo2, hi2, null);
            Timer.dStopwatchStop(sw);
            double time = Timer.dStopwatchTime(sw);
            double average = (total_time += time) / ((double)count + 1.0) * 1000.0;
            Matrix.dMultiply0(tmp1, A, x, 100, 100, 1);
            i = 0;
            while (i < 100) {
                tmp2[i] = b[i] + w[i];
                ++i;
            }
            double diff = Misc.dMaxDifference(tmp1, tmp2, 100, 1);
            if (diff > tol) {
                ErrorHandler.dDebug(0, "A*x = b+w, maximum difference = %.6e", diff);
            }
            int n1 = 0;
            int n2 = 0;
            int n3 = 0;
            i = 0;
            while (i < 100) {
                double xi = x[i];
                double wi = w[i];
                if (xi == lo[i] && wi >= 0.0) {
                    ++n1;
                } else if (xi == hi[i] && wi <= 0.0) {
                    ++n2;
                } else if (xi >= lo[i] && xi <= hi[i] && wi == 0.0) {
                    ++n3;
                } else {
                    ErrorHandler.dDebug(0, "FAILED: i=%d x=%.4e w=%.4e lo=%.4e hi=%.4e", i, x[i], w[i], lo[i], hi[i]);
                }
                ++i;
            }
            Cstdio.printf("passed: NL=%3d NH=%3d C=%3d   ", n1, n2, n3);
            Cstdio.printf("time=%10.3f ms  avg=%10.4f\n", time * 1000.0, average);
            arena.END_STATE_SAVE(saveInner);
            ++count;
        }
        DxWorldProcessMemArena.freeTemporary(arena);
        return 1;
    }

    private static void swapRowsAndCols(double[] A, int n, int i1, int i2, int nskip, boolean do_fast_row_swaps) {
        Common.dAASSERT(n > 0 && i1 >= 0 && i2 >= 0 && i1 < n && i2 < n && nskip >= n && i1 < i2);
        int A_i1p = i1 * nskip;
        int A_i2p = i2 * nskip;
        int k = 0;
        while (k < i1) {
            double tmp = A[A_i1p + k];
            A[A_i1p + k] = A[A_i2p + k];
            A[A_i2p + k] = tmp;
            ++k;
        }
        int A_ip = A_i1p + nskip;
        int i = i1 + 1;
        while (i < i2) {
            double tmp = A[A_i2p + i];
            A[A_i2p + i] = A[A_ip + i1];
            A[A_ip + i1] = tmp;
            A_ip += nskip;
            ++i;
        }
        double tmp = A[A_i1p + i1];
        A[A_i1p + i1] = A[A_i2p + i2];
        A[A_i2p + i2] = tmp;
        int A_jp = A_i2p + nskip;
        int j = i2 + 1;
        while (j < n) {
            double tmp2 = A[A_jp + i1];
            A[A_jp + i1] = A[A_jp + i2];
            A[A_jp + i2] = tmp2;
            A_jp += nskip;
            ++j;
        }
    }

    protected static void swapProblem(double[] A, double[] x, double[] b, double[] w, double[] lo, double[] hi, int[] p, boolean[] state, int[] findex, int n, int i1, int i2, int nskip, boolean do_fast_row_swaps) {
        Common.dIASSERT(n > 0 && i1 >= 0 && i2 >= 0 && i1 < n && i2 < n && nskip >= n && i1 <= i2);
        if (i1 == i2) {
            return;
        }
        DLCP.swapRowsAndCols(A, n, i1, i2, nskip, do_fast_row_swaps);
        double tmpr = x[i1];
        x[i1] = x[i2];
        x[i2] = tmpr;
        tmpr = b[i1];
        b[i1] = b[i2];
        b[i2] = tmpr;
        tmpr = w[i1];
        w[i1] = w[i2];
        w[i2] = tmpr;
        tmpr = lo[i1];
        lo[i1] = lo[i2];
        lo[i2] = tmpr;
        tmpr = hi[i1];
        hi[i1] = hi[i2];
        hi[i2] = tmpr;
        int tmpi = p[i1];
        p[i1] = p[i2];
        p[i2] = tmpi;
        boolean tmpb = state[i1];
        state[i1] = state[i2];
        state[i2] = tmpb;
        if (findex != null) {
            tmpi = findex[i1];
            findex[i1] = findex[i2];
            findex[i2] = tmpi;
        }
    }

    protected void checkFactorization(double[] A, double[] _L, double[] _d, int nC, int[] C, int nskip) {
    }

    protected static void checkPermutations(int i, int n, int nC, int nN, int[] p, int[] C) {
    }
}

