/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.RefDouble;
import org.ode4j.math.DQuaternionC;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.internal.DxBox;
import org.ode4j.ode.internal.DxCapsule;
import org.ode4j.ode.internal.DxConvex;
import org.ode4j.ode.internal.DxCylinder;
import org.ode4j.ode.internal.DxSphere;
import org.ode4j.ode.internal.libccd.CCD;
import org.ode4j.ode.internal.libccd.CCDMPR;
import org.ode4j.ode.internal.libccd.CCDQuat;
import org.ode4j.ode.internal.libccd.CCDVec3;

public class CollisionLibccd {
    private static final CCD.ccd_support_fn ccdSupportBox = new CCD.ccd_support_fn(){

        @Override
        public void run(Object obj, CCDVec3.ccd_vec3_t _dir, CCDVec3.ccd_vec3_t v) {
            ccd_box_t o = (ccd_box_t)obj;
            CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
            CCDVec3.ccdVec3Copy(dir, _dir);
            CCDQuat.ccdQuatRotVec(dir, o.rot_inv);
            CCDVec3.ccdVec3Set(v, (double)CCDVec3.ccdSign(CCDVec3.ccdVec3X(dir)) * o.dim[0], (double)CCDVec3.ccdSign(CCDVec3.ccdVec3Y(dir)) * o.dim[1], (double)CCDVec3.ccdSign(CCDVec3.ccdVec3Z(dir)) * o.dim[2]);
            CCDQuat.ccdQuatRotVec(v, o.rot);
            CCDVec3.ccdVec3Add(v, o.pos);
        }
    };
    private static final CCD.ccd_support_fn ccdSupportCap = new CCD.ccd_support_fn(){

        @Override
        public void run(Object obj, CCDVec3.ccd_vec3_t _dir, CCDVec3.ccd_vec3_t v) {
            ccd_cap_t o = (ccd_cap_t)obj;
            CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
            CCDVec3.ccd_vec3_t pos1 = new CCDVec3.ccd_vec3_t();
            CCDVec3.ccd_vec3_t pos2 = new CCDVec3.ccd_vec3_t();
            CCDVec3.ccdVec3Copy(dir, _dir);
            CCDQuat.ccdQuatRotVec(dir, o.rot_inv);
            CCDVec3.ccdVec3Set(pos1, 0.0, 0.0, o.height);
            CCDVec3.ccdVec3Set(pos2, 0.0, 0.0, -o.height);
            CCDVec3.ccdVec3Copy(v, dir);
            CCDVec3.ccdVec3Scale(v, o.radius);
            CCDVec3.ccdVec3Add(pos1, v);
            CCDVec3.ccdVec3Add(pos2, v);
            if (CCDVec3.ccdVec3Dot(dir, pos1) > CCDVec3.ccdVec3Dot(dir, pos2)) {
                CCDVec3.ccdVec3Copy(v, pos1);
            } else {
                CCDVec3.ccdVec3Copy(v, pos2);
            }
            CCDQuat.ccdQuatRotVec(v, o.rot);
            CCDVec3.ccdVec3Add(v, o.pos);
        }
    };
    private static final CCD.ccd_support_fn ccdSupportCyl = new CCD.ccd_support_fn(){

        @Override
        public void run(Object obj, CCDVec3.ccd_vec3_t _dir, CCDVec3.ccd_vec3_t v) {
            ccd_cyl_t cyl = (ccd_cyl_t)obj;
            CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
            CCDVec3.ccdVec3Copy(dir, _dir);
            CCDQuat.ccdQuatRotVec(dir, cyl.rot_inv);
            double zdist = dir.get0() * dir.get0() + dir.get1() * dir.get1();
            zdist = Math.sqrt(zdist);
            if (CCDVec3.ccdIsZero(zdist)) {
                CCDVec3.ccdVec3Set(v, 0.0, 0.0, (double)CCDVec3.ccdSign(CCDVec3.ccdVec3Z(dir)) * cyl.height);
            } else {
                double rad = cyl.radius / zdist;
                CCDVec3.ccdVec3Set(v, rad * CCDVec3.ccdVec3X(dir), rad * CCDVec3.ccdVec3Y(dir), (double)CCDVec3.ccdSign(CCDVec3.ccdVec3Z(dir)) * cyl.height);
            }
            CCDQuat.ccdQuatRotVec(v, cyl.rot);
            CCDVec3.ccdVec3Add(v, cyl.pos);
        }
    };
    private static final CCD.ccd_support_fn ccdSupportSphere = new CCD.ccd_support_fn(){

        @Override
        public void run(Object obj, CCDVec3.ccd_vec3_t _dir, CCDVec3.ccd_vec3_t v) {
            ccd_sphere_t s = (ccd_sphere_t)obj;
            CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
            CCDVec3.ccdVec3Copy(dir, _dir);
            CCDQuat.ccdQuatRotVec(dir, s.rot_inv);
            CCDVec3.ccdVec3Copy(v, dir);
            CCDVec3.ccdVec3Scale(v, s.radius);
            CCDVec3.ccdVec3Scale(v, 1.0 / CCDVec3.CCD_SQRT(CCDVec3.ccdVec3Len2(dir)));
            CCDQuat.ccdQuatRotVec(v, s.rot);
            CCDVec3.ccdVec3Add(v, s.pos);
        }
    };
    private static final CCD.ccd_support_fn ccdSupportConvex = new CCD.ccd_support_fn(){

        @Override
        public void run(Object obj, CCDVec3.ccd_vec3_t _dir, CCDVec3.ccd_vec3_t v) {
            ccd_convex_t c = (ccd_convex_t)obj;
            CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
            CCDVec3.ccd_vec3_t p = new CCDVec3.ccd_vec3_t();
            CCDVec3.ccdVec3Copy(dir, _dir);
            CCDQuat.ccdQuatRotVec(dir, c.rot_inv);
            double maxdot = -1.7976931348623157E308;
            double[] curp = c.convex.getPoints();
            int curpI = 0;
            int i = 0;
            while (i < c.convex.getPointcount()) {
                CCDVec3.ccdVec3Set(p, curp[curpI + 0], curp[curpI + 1], curp[curpI + 2]);
                double dot = CCDVec3.ccdVec3Dot(dir, p);
                if (dot > maxdot) {
                    CCDVec3.ccdVec3Copy(v, p);
                    maxdot = dot;
                }
                ++i;
                curpI += 3;
            }
            CCDQuat.ccdQuatRotVec(v, c.rot);
            CCDVec3.ccdVec3Add(v, c.pos);
        }
    };
    private static CCD.ccd_center_fn ccdCenter = new CCD.ccd_center_fn(){

        @Override
        public void run(Object obj1, CCDVec3.ccd_vec3_t c) {
            ccd_obj_t o = (ccd_obj_t)obj1;
            CCDVec3.ccdVec3Copy(c, o.pos);
        }
    };

    static void ccdGeomToObj(DGeom g, ccd_obj_t o) {
        DVector3C ode_pos = g.getPosition();
        DQuaternionC ode_rot = g.getQuaternion();
        CCDVec3.ccdVec3Set(o.pos, ode_pos);
        CCDQuat.ccdQuatSet(o.rot, ode_rot.get1(), ode_rot.get2(), ode_rot.get3(), ode_rot.get0());
        CCDQuat.ccdQuatInvert2(o.rot_inv, o.rot);
    }

    static void ccdGeomToBox(DxBox g, ccd_box_t box) {
        DVector3 dim = new DVector3();
        CollisionLibccd.ccdGeomToObj(g, box);
        g.getLengths(dim);
        box.dim[0] = dim.get0() / 2.0;
        box.dim[1] = dim.get1() / 2.0;
        box.dim[2] = dim.get2() / 2.0;
    }

    static void ccdGeomToCap(DxCapsule g, ccd_cap_t cap) {
        CollisionLibccd.ccdGeomToObj(g, cap);
        cap.radius = g.getRadius();
        cap.height = g.getLength() / 2.0;
    }

    static void ccdGeomToCyl(DxCylinder g, ccd_cyl_t cyl) {
        CollisionLibccd.ccdGeomToObj(g, cyl);
        cyl.radius = g.getRadius();
        cyl.height = g.getLength() / 2.0;
    }

    static void ccdGeomToSphere(DxSphere g, ccd_sphere_t s) {
        CollisionLibccd.ccdGeomToObj(g, s);
        s.radius = g.getRadius();
    }

    static void ccdGeomToConvex(DxConvex g, ccd_convex_t c) {
        CollisionLibccd.ccdGeomToObj(g, c);
        c.convex = g;
    }

    static int ccdCollide(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts, ccd_obj_t obj1, CCD.ccd_support_fn supp1, CCD.ccd_center_fn cen1, ccd_obj_t obj2, CCD.ccd_support_fn supp2, CCD.ccd_center_fn cen2) {
        CCD.ccd_t ccd = new CCD.ccd_t();
        RefDouble depth = new RefDouble();
        CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t pos = new CCDVec3.ccd_vec3_t();
        int max_contacts = flags & 0xFFFF;
        if (max_contacts < 1) {
            return 0;
        }
        CCD.CCD_INIT(ccd);
        ccd.support1 = supp1;
        ccd.support2 = supp2;
        ccd.center1 = cen1;
        ccd.center2 = cen2;
        ccd.max_iterations = 500L;
        ccd.mpr_tolerance = 1.0E-6;
        if ((flags & Integer.MIN_VALUE) != 0) {
            if (CCDMPR.ccdMPRIntersect(obj1, obj2, ccd) != 0) {
                return 1;
            }
            return 0;
        }
        int res = CCDMPR.ccdMPRPenetration(obj1, obj2, ccd, depth, dir, pos);
        if (res == 0) {
            DContactGeom contact = contacts.get();
            contact.g1 = o1;
            contact.g2 = o2;
            contact.side2 = -1;
            contact.side1 = -1;
            contact.depth = depth.get();
            contact.pos.set(CCDVec3.ccdVec3X(pos), CCDVec3.ccdVec3Y(pos), CCDVec3.ccdVec3Z(pos));
            CCDVec3.ccdVec3Scale(dir, -1.0);
            contact.normal.set(CCDVec3.ccdVec3X(dir), CCDVec3.ccdVec3Y(dir), CCDVec3.ccdVec3Z(dir));
            return 1;
        }
        return 0;
    }

    public static class CollideBoxCylinderCCD
    implements DColliderFn {
        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            ccd_cyl_t cyl = new ccd_cyl_t();
            ccd_box_t box = new ccd_box_t();
            CollisionLibccd.ccdGeomToBox((DxBox)o1, box);
            CollisionLibccd.ccdGeomToCyl((DxCylinder)o2, cyl);
            return CollisionLibccd.ccdCollide(o1, o2, flags, contacts, box, ccdSupportBox, ccdCenter, cyl, ccdSupportCyl, ccdCenter);
        }
    }

    public static class CollideCapsuleCylinder
    implements DColliderFn {
        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            ccd_cap_t cap = new ccd_cap_t();
            ccd_cyl_t cyl = new ccd_cyl_t();
            CollisionLibccd.ccdGeomToCap((DxCapsule)o1, cap);
            CollisionLibccd.ccdGeomToCyl((DxCylinder)o2, cyl);
            return CollisionLibccd.ccdCollide(o1, o2, flags, contacts, cap, ccdSupportCap, ccdCenter, cyl, ccdSupportCyl, ccdCenter);
        }
    }

    public static class CollideConvexBoxCCD
    implements DColliderFn {
        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            ccd_box_t box = new ccd_box_t();
            ccd_convex_t conv = new ccd_convex_t();
            CollisionLibccd.ccdGeomToConvex((DxConvex)o1, conv);
            CollisionLibccd.ccdGeomToBox((DxBox)o2, box);
            return CollisionLibccd.ccdCollide(o1, o2, flags, contacts, conv, ccdSupportConvex, ccdCenter, box, ccdSupportBox, ccdCenter);
        }
    }

    public static class CollideConvexCapsuleCCD
    implements DColliderFn {
        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            ccd_cap_t cap = new ccd_cap_t();
            ccd_convex_t conv = new ccd_convex_t();
            CollisionLibccd.ccdGeomToConvex((DxConvex)o1, conv);
            CollisionLibccd.ccdGeomToCap((DxCapsule)o2, cap);
            return CollisionLibccd.ccdCollide(o1, o2, flags, contacts, conv, ccdSupportConvex, ccdCenter, cap, ccdSupportCap, ccdCenter);
        }
    }

    public static class CollideConvexConvexCCD
    implements DColliderFn {
        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            ccd_convex_t c1 = new ccd_convex_t();
            ccd_convex_t c2 = new ccd_convex_t();
            CollisionLibccd.ccdGeomToConvex((DxConvex)o1, c1);
            CollisionLibccd.ccdGeomToConvex((DxConvex)o2, c2);
            return CollisionLibccd.ccdCollide(o1, o2, flags, contacts, c1, ccdSupportConvex, ccdCenter, c2, ccdSupportConvex, ccdCenter);
        }
    }

    public static class CollideConvexCylinderCCD
    implements DColliderFn {
        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            ccd_cyl_t cyl = new ccd_cyl_t();
            ccd_convex_t conv = new ccd_convex_t();
            CollisionLibccd.ccdGeomToConvex((DxConvex)o1, conv);
            CollisionLibccd.ccdGeomToCyl((DxCylinder)o2, cyl);
            return CollisionLibccd.ccdCollide(o1, o2, flags, contacts, conv, ccdSupportConvex, ccdCenter, cyl, ccdSupportCyl, ccdCenter);
        }
    }

    public static class CollideConvexSphereCCD
    implements DColliderFn {
        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            ccd_sphere_t sphere = new ccd_sphere_t();
            ccd_convex_t conv = new ccd_convex_t();
            CollisionLibccd.ccdGeomToConvex((DxConvex)o1, conv);
            CollisionLibccd.ccdGeomToSphere((DxSphere)o2, sphere);
            return CollisionLibccd.ccdCollide(o1, o2, flags, contacts, conv, ccdSupportConvex, ccdCenter, sphere, ccdSupportSphere, ccdCenter);
        }
    }

    public static class CollideCylinderCylinder
    implements DColliderFn {
        @Override
        public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
            ccd_cyl_t cyl1 = new ccd_cyl_t();
            ccd_cyl_t cyl2 = new ccd_cyl_t();
            CollisionLibccd.ccdGeomToCyl((DxCylinder)o1, cyl1);
            CollisionLibccd.ccdGeomToCyl((DxCylinder)o2, cyl2);
            return CollisionLibccd.ccdCollide(o1, o2, flags, contacts, cyl1, ccdSupportCyl, ccdCenter, cyl2, ccdSupportCyl, ccdCenter);
        }
    }

    private static class ccd_box_t
    extends ccd_obj_t {
        double[] dim = new double[3];

        private ccd_box_t() {
        }
    }

    private static class ccd_cap_t
    extends ccd_obj_t {
        double radius;
        double height;

        private ccd_cap_t() {
        }
    }

    private static class ccd_convex_t
    extends ccd_obj_t {
        DxConvex convex;

        private ccd_convex_t() {
        }
    }

    private static class ccd_cyl_t
    extends ccd_obj_t {
        double radius;
        double height;

        private ccd_cyl_t() {
        }
    }

    private static class ccd_obj_t {
        final CCDVec3.ccd_vec3_t pos = new CCDVec3.ccd_vec3_t();
        final CCDQuat.ccd_quat_t rot = new CCDQuat.ccd_quat_t();
        final CCDQuat.ccd_quat_t rot_inv = new CCDQuat.ccd_quat_t();

        private ccd_obj_t() {
        }
    }

    private static class ccd_sphere_t
    extends ccd_obj_t {
        double radius;

        private ccd_sphere_t() {
        }
    }
}

