/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.ObjArray;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxGimpact;
import org.ode4j.ode.internal.DxGimpactCollision;
import org.ode4j.ode.internal.DxSphere;
import org.ode4j.ode.internal.gimpact.GimContact;
import org.ode4j.ode.internal.gimpact.GimDynArray;

public class CollideTrimeshSphere
implements DColliderFn {
    int dCollideSTL(DxGimpact g1, DxSphere SphereGeom, int Flags, DContactGeomBuffer Contacts, int Stride) {
        int maxcontacts;
        Common.dIASSERT(Stride == 1);
        Common.dIASSERT((Flags & 0xFFFF) >= 1);
        DxGimpact TriMesh = g1;
        DVector3C Position = SphereGeom.getPosition();
        double Radius = SphereGeom.getRadius();
        GimDynArray<GimContact> trimeshcontacts = GimContact.GIM_CREATE_CONTACT_LIST();
        g1.recomputeAABB();
        SphereGeom.recomputeAABB();
        DxGimpactCollision.gim_trimesh_sphere_collisionODE(TriMesh.m_collision_trimesh, Position, Radius, trimeshcontacts);
        if (trimeshcontacts.size() == 0) {
            trimeshcontacts.GIM_DYNARRAY_DESTROY();
            return 0;
        }
        ObjArray<GimContact> ptrimeshcontacts = trimeshcontacts.GIM_DYNARRAY_POINTER_V();
        int contactcount = trimeshcontacts.size();
        if (contactcount > (maxcontacts = Flags & 0xFFFF)) {
            contactcount = maxcontacts;
        }
        int i = 0;
        while (i < contactcount) {
            DContactGeom pcontact = Contacts.getSafe(Flags, i);
            pcontact.pos.set(ptrimeshcontacts.at0().getPoint().f);
            pcontact.normal.set(ptrimeshcontacts.at0().getNormal().f);
            pcontact.depth = ptrimeshcontacts.at0().getDepth();
            pcontact.g1 = g1;
            pcontact.g2 = SphereGeom;
            pcontact.side1 = ptrimeshcontacts.at0().getFeature1();
            pcontact.side2 = -1;
            ptrimeshcontacts.inc();
            ++i;
        }
        trimeshcontacts.GIM_DYNARRAY_DESTROY();
        return contactcount;
    }

    @Override
    public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
        return this.dCollideSTL((DxGimpact)o1, (DxSphere)o2, flags, contacts, 1);
    }
}

