/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DVector3;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxGimpact;
import org.ode4j.ode.internal.DxGimpactCollision;
import org.ode4j.ode.internal.DxRay;
import org.ode4j.ode.internal.DxTriMesh;
import org.ode4j.ode.internal.gimpact.GimTriCollision;

public class CollideTrimeshRay
implements DColliderFn {
    int dCollideRTL(DxTriMesh g1, DxRay RayGeom, int Flags, DContactGeomBuffer Contacts, int Stride) {
        Common.dIASSERT(Stride == 1);
        Common.dIASSERT((Flags & 0xFFFF) >= 1);
        DxGimpact TriMesh = (DxGimpact)g1;
        double Length = RayGeom.getLength();
        boolean FirstContact = RayGeom.getFirstContact();
        boolean BackfaceCull = RayGeom.getBackfaceCull();
        boolean ClosestHit = RayGeom.getClosestHit();
        DVector3 Origin = new DVector3();
        DVector3 Direction = new DVector3();
        RayGeom.get(Origin, Direction);
        int intersect = 0;
        GimTriCollision.GIM_TRIANGLE_RAY_CONTACT_DATA contact_data = new GimTriCollision.GIM_TRIANGLE_RAY_CONTACT_DATA();
        intersect = ClosestHit ? DxGimpactCollision.gim_trimesh_ray_closest_collisionODE(TriMesh.m_collision_trimesh, Origin, Direction, Length, contact_data) : DxGimpactCollision.gim_trimesh_ray_collisionODE(TriMesh.m_collision_trimesh, Origin, Direction, Length, contact_data);
        if (intersect == 0) {
            return 0;
        }
        if (TriMesh.RayCallback == null || TriMesh.RayCallback.call(TriMesh, RayGeom, contact_data.getFaceID(), contact_data.getU(), contact_data.getV()) != 0) {
            DContactGeom Contact = Contacts.get();
            Contact.pos.set(contact_data.getPoint().f);
            Contact.normal.set(contact_data.getNormal().f);
            Contact.depth = contact_data.getTParam();
            Contact.g1 = TriMesh;
            Contact.g2 = RayGeom;
            Contact.side1 = contact_data.getFaceID();
            Contact.side2 = -1;
            return 1;
        }
        return 0;
    }

    @Override
    public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
        return this.dCollideRTL((DxTriMesh)o1, (DxRay)o2, flags, contacts, 1);
    }
}

