/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.ObjArray;
import org.ode4j.math.DVector4;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxGimpact;
import org.ode4j.ode.internal.DxGimpactCollision;
import org.ode4j.ode.internal.DxPlane;
import org.ode4j.ode.internal.gimpact.GimDynArray;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimTrimesh;

public class CollideTrimeshPlane
implements DColliderFn {
    int dCollideTrimeshPlane(DxGimpact o1, DxPlane o2, int flags, DContactGeomBuffer contacts, int skip) {
        int contactmax;
        Common.dIASSERT(skip == 1);
        Common.dIASSERT((flags & 0xFFFF) >= 1);
        DxGimpact trimesh = o1;
        DVector4 plane = new DVector4();
        o2.getParams(plane);
        o1.recomputeAABB();
        o2.recomputeAABB();
        GimDynArray<GimGeometry.vec4f> collision_result = GimTrimesh.GIM_CREATE_TRIMESHPLANE_CONTACTS();
        DxGimpactCollision.gim_trimesh_plane_collisionODE(trimesh.m_collision_trimesh, plane, collision_result);
        if (collision_result.size() == 0) {
            collision_result.GIM_DYNARRAY_DESTROY();
            return 0;
        }
        int contactcount = collision_result.size();
        if (contactcount > (contactmax = flags & 0xFFFF)) {
            contactcount = contactmax;
        }
        ObjArray<GimGeometry.vec4f> planecontact_results = collision_result.GIM_DYNARRAY_POINTER_V();
        int i = 0;
        while (i < contactcount) {
            DContactGeom pcontact = contacts.getSafe(flags, i);
            pcontact.pos.set(planecontact_results.at((int)i).f);
            pcontact.normal.set(plane.get0(), plane.get1(), plane.get2());
            pcontact.depth = planecontact_results.at((int)i).f[3];
            pcontact.g1 = o1;
            pcontact.g2 = o2;
            pcontact.side1 = -1;
            pcontact.side2 = -1;
            ++i;
        }
        collision_result.GIM_DYNARRAY_DESTROY();
        return contactcount;
    }

    @Override
    public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
        return this.dCollideTrimeshPlane((DxGimpact)o1, (DxPlane)o2, flags, contacts, 1);
    }
}

