/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.ObjArray;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxCapsule;
import org.ode4j.ode.internal.DxGimpact;
import org.ode4j.ode.internal.DxTriMesh;
import org.ode4j.ode.internal.gimpact.GimContact;
import org.ode4j.ode.internal.gimpact.GimDynArray;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimTrimeshCapsuleCollision;

public class CollideTrimeshCCylinder
implements DColliderFn {
    private static final int nCAPSULE_AXIS = 2;

    int dCollideCCTL(DxTriMesh o1, DxCapsule o2, int flags, DContactGeomBuffer contacts, int skip) {
        int contactmax;
        DVector3C pDst;
        DMatrix3C pRot;
        Common.dIASSERT(skip >= 1);
        Common.dIASSERT((flags & 0xFFFF) >= 1);
        DxGimpact TriMesh = (DxGimpact)o1;
        DxCapsule gCylinder = o2;
        DVector3 vCapsuleAxis = null;
        DMatrix3C mCapsuleRotation = pRot = gCylinder.getRotation();
        DVector3C vCapsulePosition = pDst = gCylinder.getPosition();
        vCapsuleAxis = mCapsuleRotation.columnAsNewVector(2);
        double vCapsuleRadius = gCylinder.getRadius();
        double fCapsuleSize = gCylinder.getLength();
        GimTrimeshCapsuleCollision.GIM_CAPSULE_DATA capsule = new GimTrimeshCapsuleCollision.GIM_CAPSULE_DATA();
        capsule.m_radius = (float)vCapsuleRadius;
        CollideTrimeshCCylinder.VEC_SCALE(capsule.m_point1, fCapsuleSize *= 0.5, vCapsuleAxis);
        CollideTrimeshCCylinder.VEC_SUM(capsule.m_point1, vCapsulePosition, capsule.m_point1);
        CollideTrimeshCCylinder.VEC_SCALE(capsule.m_point2, -fCapsuleSize, vCapsuleAxis);
        CollideTrimeshCCylinder.VEC_SUM(capsule.m_point2, vCapsulePosition, capsule.m_point2);
        GimDynArray<GimContact> trimeshcontacts = GimContact.GIM_CREATE_CONTACT_LIST();
        TriMesh.m_collision_trimesh.gim_trimesh_capsule_collision(capsule, trimeshcontacts);
        if (trimeshcontacts.size() == 0) {
            trimeshcontacts.GIM_DYNARRAY_DESTROY();
            return 0;
        }
        ObjArray<GimContact> ptrimeshcontacts = trimeshcontacts.GIM_DYNARRAY_POINTER_V();
        int contactcount = trimeshcontacts.size();
        if (contactcount > (contactmax = flags & 0xFFFF)) {
            contactcount = contactmax;
        }
        int i = 0;
        while (i < contactcount) {
            DContactGeom pcontact = contacts.getSafe(flags, i);
            pcontact.pos.set(ptrimeshcontacts.at0().getPoint().f);
            pcontact.normal.set(ptrimeshcontacts.at0().getNormal().f);
            pcontact.depth = ptrimeshcontacts.at0().getDepth();
            pcontact.g1 = TriMesh;
            pcontact.g2 = gCylinder;
            pcontact.side1 = ptrimeshcontacts.at0().getFeature1();
            pcontact.side2 = -1;
            ptrimeshcontacts.inc();
            ++i;
        }
        trimeshcontacts.GIM_DYNARRAY_DESTROY();
        return contactcount;
    }

    @Override
    public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
        return this.dCollideCCTL((DxTriMesh)o1, (DxCapsule)o2, flags, contacts, 1);
    }

    private static final void VEC_SCALE(GimGeometry.vec3f c, double a, DVector3C x) {
        c.f[0] = (float)(a * x.get0());
        c.f[1] = (float)(a * x.get1());
        c.f[2] = (float)(a * x.get2());
    }

    private static final void VEC_SUM(GimGeometry.vec3f v21, DVector3C v2, GimGeometry.vec3f v1) {
        v21.f[0] = (float)(v2.get0() + (double)v1.f[0]);
        v21.f[1] = (float)(v2.get1() + (double)v1.f[1]);
        v21.f[2] = (float)(v2.get2() + (double)v1.f[2]);
    }
}

