/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.RefBoolean;
import org.cpp4j.java.RefDouble;
import org.cpp4j.java.RefInt;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.math.DVector4;
import org.ode4j.math.DVector4C;
import org.ode4j.ode.DAABBC;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBox;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxGimpact;
import org.ode4j.ode.internal.DxTriMesh;
import org.ode4j.ode.internal.gimpact.GimDynArrayInt;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimTrimesh;

public class CollideTrimeshBox
implements DColliderFn {
    private static final double MAXVALUE = Double.MAX_VALUE;

    @Override
    public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
        return this.dCollideBTL((DxTriMesh)o1, (DxBox)o2, flags, contacts, 1);
    }

    private void SUBTRACT(DVector3C a, DVector3C b, DVector3 r) {
        r.eqDiff(a, b);
    }

    private void SET(DVector3 a, DVector3C b) {
        a.set(b);
    }

    private void SETM(DMatrix3 a, DMatrix3C b) {
        a.set(b);
    }

    private void ADD(DVector3C a, DVector3C b, DVector3 r) {
        r.eqSum(a, b);
    }

    private void GETCOL(DMatrix3C m, int a, DVector3 v) {
        if (a == 0) {
            v.set(m.get00(), m.get10(), m.get20());
        } else if (a == 1) {
            v.set(m.get01(), m.get11(), m.get21());
        } else if (a == 2) {
            v.set(m.get02(), m.get12(), m.get22());
        } else {
            throw new IllegalArgumentException("col=" + a);
        }
    }

    private double POINTDISTANCE(DVector4C p, DVector3C v) {
        return p.get0() * v.get0() + p.get1() * v.get1() + p.get2() * v.get2() + p.get3();
    }

    private void CONSTRUCTPLANE(DVector4 plane, DVector3C n, double d) {
        plane.set(n.get0(), n.get1(), n.get2(), d);
    }

    private double LENGTHOF(DVector3C a) {
        return a.length();
    }

    int dCollideBTL(DxTriMesh g1, DxBox BoxGeom, int Flags, DContactGeomBuffer Contacts, int Stride) {
        Common.dIASSERT(Stride >= 1);
        Common.dIASSERT((Flags & 0xFFFF) >= 1);
        DxGimpact TriMesh = (DxGimpact)g1;
        g1.recomputeAABB();
        BoxGeom.recomputeAABB();
        sTrimeshBoxColliderData cData = new sTrimeshBoxColliderData();
        cData.SetupInitialContext(TriMesh, BoxGeom, Flags, Contacts, Stride);
        GimTrimesh ptrimesh = TriMesh.m_collision_trimesh;
        GimGeometry.aabb3f test_aabb = new GimGeometry.aabb3f();
        DAABBC aabb = BoxGeom.getAABB();
        test_aabb.minX = (float)aabb.getMin0();
        test_aabb.maxX = (float)aabb.getMax0();
        test_aabb.minY = (float)aabb.getMin1();
        test_aabb.maxY = (float)aabb.getMax1();
        test_aabb.minZ = (float)aabb.getMin2();
        test_aabb.maxZ = (float)aabb.getMax2();
        GimDynArrayInt collision_result = GimDynArrayInt.GIM_CREATE_BOXQUERY_LIST();
        ptrimesh.getAabbSet().gim_aabbset_box_collision(test_aabb, collision_result);
        if (collision_result.size() == 0) {
            collision_result.GIM_DYNARRAY_DESTROY();
            return 0;
        }
        int[] boxesresult = collision_result.GIM_DYNARRAY_POINTER();
        ptrimesh.gim_trimesh_locks_work_data();
        int ctContacts0 = 0;
        DVector3[] dvTZ = new DVector3[]{new DVector3(), new DVector3(), new DVector3()};
        GimGeometry.vec3f[] dv = new GimGeometry.vec3f[]{new GimGeometry.vec3f(), new GimGeometry.vec3f(), new GimGeometry.vec3f()};
        int i = 0;
        while (i < collision_result.size()) {
            int Triint = boxesresult[i];
            ptrimesh.gim_trimesh_get_triangle_vertices(Triint, dv[0], dv[1], dv[2]);
            RefBoolean bFinishSearching = new RefBoolean(false);
            dvTZ[0].set(dv[0].f);
            dvTZ[1].set(dv[1].f);
            dvTZ[2].set(dv[2].f);
            ctContacts0 = cData.TestCollisionForSingleTriangle(ctContacts0, Triint, dvTZ, bFinishSearching);
            if (bFinishSearching.b) break;
            ++i;
        }
        ptrimesh.gim_trimesh_unlocks_work_data();
        collision_result.GIM_DYNARRAY_DESTROY();
        return cData.m_ctContacts.i;
    }

    static void GenerateContact(int in_Flags, DContactGeomBuffer in_Contacts, int in_Stride, DxGeom in_g1, DxGeom in_g2, int TriIndex, DVector3C in_ContactPos, DVector3C in_Normal, double in_Depth, RefInt OutTriCount) {
        block6: {
            DContactGeom Contact;
            block5: {
                block4: {
                    if (in_Stride != 1) {
                        throw new IllegalArgumentException("in_Stride = " + in_Stride);
                    }
                    DVector3 diff = new DVector3();
                    if ((in_Flags & Integer.MIN_VALUE) != 0) break block4;
                    boolean duplicate = false;
                    int i = 0;
                    while (i < OutTriCount.i) {
                        Contact = in_Contacts.getSafe(in_Flags, i);
                        diff.eqDiff(in_ContactPos, Contact.pos);
                        if (diff.dot(diff) < Common.dEpsilon && 1.0 - Common.dFabs(in_Normal.dot(Contact.normal)) < Common.dEpsilon) {
                            if (in_Depth > Contact.depth) {
                                Contact.depth = in_Depth;
                            }
                            duplicate = true;
                        }
                        ++i;
                    }
                    if (!duplicate && OutTriCount.i != (in_Flags & 0xFFFF)) break block5;
                    break block6;
                }
                Common.dIASSERT(OutTriCount.i < (in_Flags & 0xFFFF));
            }
            Contact = in_Contacts.getSafe(in_Flags, OutTriCount.i);
            Contact.pos.set(in_ContactPos);
            Contact.normal.set(in_Normal);
            Contact.depth = in_Depth;
            Contact.g1 = in_g1;
            Contact.g2 = in_g2;
            Contact.side1 = TriIndex;
            Contact.side2 = -1;
            ++OutTriCount.i;
        }
    }

    private class sTrimeshBoxColliderData {
        final DMatrix3 m_mHullBoxRot = new DMatrix3();
        final DVector3 m_vHullBoxPos = new DVector3();
        final DVector3 m_vBoxHalfSize = new DVector3();
        final DVector3 m_vHullDstPos = new DVector3();
        final DVector3 m_vBestNormal = new DVector3();
        double m_fBestDepth;
        int m_iBestAxis = 0;
        int m_iExitAxis = 0;
        final DVector3 m_vE0 = new DVector3();
        final DVector3 m_vE1 = new DVector3();
        final DVector3 m_vE2 = new DVector3();
        final DVector3 m_vN = new DVector3();
        int m_iFlags;
        DContactGeomBuffer m_ContactGeoms;
        int m_iStride;
        DxGeom m_Geom1;
        DxGeom m_Geom2;
        RefInt m_ctContacts = new RefInt(0);

        sTrimeshBoxColliderData() {
        }

        boolean _cldTestNormal(double fp0, double fR, DVector3C vNormal, int iAxis) {
            double fOneOverLength;
            double fDepth = fR + fp0;
            if (fDepth < 0.0) {
                return false;
            }
            double fLength = CollideTrimeshBox.this.LENGTHOF(vNormal);
            if (fLength > 0.0 && (fDepth *= (fOneOverLength = 1.0 / fLength)) < this.m_fBestDepth) {
                this.m_vBestNormal.set(vNormal).scale(-fOneOverLength);
                this.m_iBestAxis = iAxis;
                this.m_fBestDepth = fDepth;
            }
            return true;
        }

        boolean _cldTestFace(double fp0, double fp1, double fp2, double fR, double fD, DVector3 vNormal, int iAxis) {
            double fMin = fp0 < fp1 ? (fp0 < fp2 ? fp0 : fp2) : (fp1 < fp2 ? fp1 : fp2);
            double fMax = fp0 > fp1 ? (fp0 > fp2 ? fp0 : fp2) : (fp1 > fp2 ? fp1 : fp2);
            double fDepthMin = fR - fMin;
            double fDepthMax = fMax + fR;
            if (fDepthMin < 0.0 || fDepthMax < 0.0) {
                return false;
            }
            double fDepth = 0.0;
            if (fDepthMin > fDepthMax) {
                fDepth = fDepthMax;
                vNormal.scale(-1.0);
                fD = -fD;
            } else {
                fDepth = fDepthMin;
            }
            if (fDepth < this.m_fBestDepth) {
                this.m_vBestNormal.set(vNormal);
                this.m_iBestAxis = iAxis;
                this.m_fBestDepth = fDepth;
            }
            return true;
        }

        boolean _cldTestEdge(double fp0, double fp1, double fR, double fD, DVector3 vNormal, int iAxis) {
            double fDepth;
            double fMax;
            double fMin = vNormal.lengthSquared();
            if (fMin <= Common.dEpsilon) {
                return true;
            }
            if (fp0 < fp1) {
                fMin = fp0;
                fMax = fp1;
            } else {
                fMin = fp1;
                fMax = fp0;
            }
            double fDepthMin = fR - fMin;
            double fDepthMax = fMax + fR;
            if (fDepthMin < 0.0 || fDepthMax < 0.0) {
                return false;
            }
            if (fDepthMin > fDepthMax) {
                fDepth = fDepthMax;
                vNormal.scale(-1.0);
                fD = -fD;
            } else {
                fDepth = fDepthMin;
            }
            double fLength = CollideTrimeshBox.this.LENGTHOF(vNormal);
            if (fLength > 0.0) {
                double fOneOverLength = 1.0 / fLength;
                fDepth *= fOneOverLength;
                fD *= fOneOverLength;
                if (fDepth * 1.5 < this.m_fBestDepth) {
                    this.m_vBestNormal.set(vNormal).scale(fOneOverLength);
                    this.m_iBestAxis = iAxis;
                    this.m_fBestDepth = fDepth;
                }
            }
            return true;
        }

        void _cldClipPolyToPlane(DVector3[] avArrayIn, int ctIn, DVector3[] avArrayOut, RefInt ctOut, DVector4C plPlane) {
            ctOut.i = 0;
            int i0 = ctIn - 1;
            int i1 = 0;
            while (i1 < ctIn) {
                double fDistance0 = CollideTrimeshBox.this.POINTDISTANCE(plPlane, avArrayIn[i0]);
                double fDistance1 = CollideTrimeshBox.this.POINTDISTANCE(plPlane, avArrayIn[i1]);
                if (fDistance0 >= 0.0) {
                    avArrayOut[ctOut.i].set(avArrayIn[i0]);
                    ++ctOut.i;
                }
                if (fDistance0 > 0.0 && fDistance1 < 0.0 || fDistance0 < 0.0 && fDistance1 > 0.0) {
                    DVector3 vIntersectionPoint = new DVector3();
                    vIntersectionPoint.eqDiff(avArrayIn[i0], avArrayIn[i1]);
                    vIntersectionPoint.scale(-fDistance0 / (fDistance0 - fDistance1));
                    vIntersectionPoint.add(avArrayIn[i0]);
                    avArrayOut[ctOut.i].set(vIntersectionPoint);
                    ++ctOut.i;
                }
                i0 = i1++;
            }
        }

        private final double dDOT(DVector3C a, DVector3C b) {
            return a.dot(b);
        }

        private final double dFabs(double d) {
            return Math.abs(d);
        }

        boolean _cldTestSeparatingAxes(DVector3C v0, DVector3C v1, DVector3C v2) {
            double fp0;
            this.m_iBestAxis = 0;
            this.m_iExitAxis = -1;
            this.m_fBestDepth = Double.MAX_VALUE;
            CollideTrimeshBox.this.SUBTRACT(v1, v0, this.m_vE0);
            CollideTrimeshBox.this.SUBTRACT(v2, v0, this.m_vE1);
            CollideTrimeshBox.this.SUBTRACT(this.m_vE1, this.m_vE0, this.m_vE2);
            this.m_vN.eqCross(this.m_vE0, this.m_vE1);
            double fNLen = CollideTrimeshBox.this.LENGTHOF(this.m_vN);
            if (fNLen == 0.0) {
                return false;
            }
            DVector3 vA0 = new DVector3();
            DVector3 vA1 = new DVector3();
            DVector3 vA2 = new DVector3();
            CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, 0, vA0);
            CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, 1, vA1);
            CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, 2, vA2);
            double fa0 = this.m_vBoxHalfSize.get0();
            double fa1 = this.m_vBoxHalfSize.get1();
            double fa2 = this.m_vBoxHalfSize.get2();
            DVector3 vD = new DVector3();
            CollideTrimeshBox.this.SUBTRACT(v0, this.m_vHullBoxPos, vD);
            DVector3 vL = new DVector3();
            CollideTrimeshBox.this.SET(vL, this.m_vN);
            double fp1 = fp0 = vL.dot(vD);
            double fp2 = fp0;
            double fR = fa0 * this.dFabs(this.m_vN.dot(vA0)) + fa1 * this.dFabs(this.m_vN.dot(vA1)) + fa2 * this.dFabs(this.m_vN.dot(vA2));
            if (!this._cldTestNormal(fp0, fR, vL, 1)) {
                this.m_iExitAxis = 1;
                return false;
            }
            CollideTrimeshBox.this.SET(vL, vA0);
            double fD = vL.dot(this.m_vN) / fNLen;
            fp0 = vL.dot(vD);
            fp1 = fp0 + vA0.dot(this.m_vE0);
            fp2 = fp0 + vA0.dot(this.m_vE1);
            fR = fa0;
            if (!this._cldTestFace(fp0, fp1, fp2, fR, fD, vL, 2)) {
                this.m_iExitAxis = 2;
                return false;
            }
            CollideTrimeshBox.this.SET(vL, vA1);
            fD = vL.dot(this.m_vN) / fNLen;
            fp0 = vL.dot(vD);
            fp1 = fp0 + vA1.dot(this.m_vE0);
            fp2 = fp0 + vA1.dot(this.m_vE1);
            fR = fa1;
            if (!this._cldTestFace(fp0, fp1, fp2, fR, fD, vL, 3)) {
                this.m_iExitAxis = 3;
                return false;
            }
            CollideTrimeshBox.this.SET(vL, vA2);
            fD = vL.dot(this.m_vN) / fNLen;
            fp0 = vL.dot(vD);
            fp1 = fp0 + vA2.dot(this.m_vE0);
            fp2 = fp0 + vA2.dot(this.m_vE1);
            fR = fa2;
            if (!this._cldTestFace(fp0, fp1, fp2, fR, fD, vL, 4)) {
                this.m_iExitAxis = 4;
                return false;
            }
            vL.eqCross(vA0, this.m_vE0);
            fD = vL.dot(this.m_vN) / fNLen;
            fp1 = fp0 = vL.dot(vD);
            fp2 = fp0 + vA0.dot(this.m_vN);
            fR = fa1 * this.dFabs(vA2.dot(this.m_vE0)) + fa2 * this.dFabs(vA1.dot(this.m_vE0));
            if (!this._cldTestEdge(fp1, fp2, fR, fD, vL, 5)) {
                this.m_iExitAxis = 5;
                return false;
            }
            vL.eqCross(vA0, this.m_vE1);
            fD = vL.dot(this.m_vN) / fNLen;
            fp0 = vL.dot(vD);
            fp1 = fp0 - vA0.dot(this.m_vN);
            fp2 = fp0;
            fR = fa1 * this.dFabs(vA2.dot(this.m_vE1)) + fa2 * this.dFabs(vA1.dot(this.m_vE1));
            if (!this._cldTestEdge(fp0, fp1, fR, fD, vL, 6)) {
                this.m_iExitAxis = 6;
                return false;
            }
            vL.eqCross(vA0, this.m_vE2);
            fD = vL.dot(this.m_vN) / fNLen;
            fp0 = vL.dot(vD);
            fp1 = fp0 - vA0.dot(this.m_vN);
            fp2 = fp0 - vA0.dot(this.m_vN);
            fR = fa1 * this.dFabs(vA2.dot(this.m_vE2)) + fa2 * this.dFabs(vA1.dot(this.m_vE2));
            if (!this._cldTestEdge(fp0, fp1, fR, fD, vL, 7)) {
                this.m_iExitAxis = 7;
                return false;
            }
            vL.eqCross(vA1, this.m_vE0);
            fD = vL.dot(this.m_vN) / fNLen;
            fp1 = fp0 = vL.dot(vD);
            fp2 = fp0 + vA1.dot(this.m_vN);
            fR = fa0 * this.dFabs(vA2.dot(this.m_vE0)) + fa2 * this.dFabs(vA0.dot(this.m_vE0));
            if (!this._cldTestEdge(fp0, fp2, fR, fD, vL, 8)) {
                this.m_iExitAxis = 8;
                return false;
            }
            vL.eqCross(vA1, this.m_vE1);
            fD = vL.dot(this.m_vN) / fNLen;
            fp0 = vL.dot(vD);
            fp1 = fp0 - vA1.dot(this.m_vN);
            fp2 = fp0;
            fR = fa0 * this.dFabs(vA2.dot(this.m_vE1)) + fa2 * this.dFabs(vA0.dot(this.m_vE1));
            if (!this._cldTestEdge(fp0, fp1, fR, fD, vL, 9)) {
                this.m_iExitAxis = 9;
                return false;
            }
            vL.eqCross(vA1, this.m_vE2);
            fD = vL.dot(this.m_vN) / fNLen;
            fp0 = vL.dot(vD);
            fp1 = fp0 - vA1.dot(this.m_vN);
            fp2 = fp0 - vA1.dot(this.m_vN);
            fR = fa0 * this.dFabs(vA2.dot(this.m_vE2)) + fa2 * this.dFabs(vA0.dot(this.m_vE2));
            if (!this._cldTestEdge(fp0, fp1, fR, fD, vL, 10)) {
                this.m_iExitAxis = 10;
                return false;
            }
            vL.eqCross(vA2, this.m_vE0);
            fD = vL.dot(this.m_vN) / fNLen;
            fp1 = fp0 = vL.dot(vD);
            fp2 = fp0 + vA2.dot(this.m_vN);
            fR = fa0 * this.dFabs(vA1.dot(this.m_vE0)) + fa1 * this.dFabs(vA0.dot(this.m_vE0));
            if (!this._cldTestEdge(fp0, fp2, fR, fD, vL, 11)) {
                this.m_iExitAxis = 11;
                return false;
            }
            vL.eqCross(vA2, this.m_vE1);
            fD = vL.dot(this.m_vN) / fNLen;
            fp0 = vL.dot(vD);
            fp1 = fp0 - vA2.dot(this.m_vN);
            fp2 = fp0;
            fR = fa0 * this.dFabs(vA1.dot(this.m_vE1)) + fa1 * this.dFabs(vA0.dot(this.m_vE1));
            if (!this._cldTestEdge(fp0, fp1, fR, fD, vL, 12)) {
                this.m_iExitAxis = 12;
                return false;
            }
            vL.eqCross(vA2, this.m_vE2);
            fD = vL.dot(this.m_vN) / fNLen;
            fp0 = vL.dot(vD);
            fp1 = fp0 - vA2.dot(this.m_vN);
            fp2 = fp0 - vA2.dot(this.m_vN);
            fR = fa0 * this.dFabs(vA1.dot(this.m_vE2)) + fa1 * this.dFabs(vA0.dot(this.m_vE2));
            if (!this._cldTestEdge(fp0, fp1, fR, fD, vL, 13)) {
                this.m_iExitAxis = 13;
                return false;
            }
            return true;
        }

        boolean _cldClosestPointOnTwoLines(DVector3C vPoint1, DVector3C vLenVec1, DVector3C vPoint2, DVector3C vLenVec2, RefDouble fvalue1, RefDouble fvalue2) {
            DVector3 vp = new DVector3();
            CollideTrimeshBox.this.SUBTRACT(vPoint2, vPoint1, vp);
            double fuaub = vLenVec1.dot(vLenVec2);
            double fq1 = vLenVec1.dot(vp);
            double fq2 = -vLenVec2.dot(vp);
            double fd = 1.0 - fuaub * fuaub;
            if (fd > 0.0) {
                fd = 1.0 / fd;
                fvalue1.d = (fq1 + fuaub * fq2) * fd;
                fvalue2.d = (fuaub * fq1 + fq2) * fd;
                return true;
            }
            fvalue1.d = 0.0;
            fvalue2.d = 0.0;
            return false;
        }

        void _cldClipping(DVector3C v0, DVector3C v1, DVector3C v2, int TriIndex) {
            Common.dIASSERT((this.m_iFlags & Integer.MIN_VALUE) == 0 || this.m_ctContacts.i < (this.m_iFlags & 0xFFFF));
            if (this.m_iBestAxis > 4) {
                DVector3 vub = new DVector3();
                DVector3 vPb = new DVector3();
                DVector3 vPa = new DVector3();
                CollideTrimeshBox.this.SET(vPa, this.m_vHullBoxPos);
                int i = 0;
                while (i < 3) {
                    DVector3 vRotCol = new DVector3();
                    CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, i, vRotCol);
                    double fSign = this.m_vBestNormal.dot(vRotCol) > 0.0 ? 1.0f : -1.0f;
                    vPa.addScaled(vRotCol, fSign * this.m_vBoxHalfSize.get(i));
                    ++i;
                }
                int iEdge = (this.m_iBestAxis - 5) % 3;
                if (iEdge == 0) {
                    CollideTrimeshBox.this.SET(vPb, v0);
                    CollideTrimeshBox.this.SET(vub, this.m_vE0);
                } else if (iEdge == 1) {
                    CollideTrimeshBox.this.SET(vPb, v2);
                    CollideTrimeshBox.this.SET(vub, this.m_vE1);
                } else {
                    CollideTrimeshBox.this.SET(vPb, v1);
                    CollideTrimeshBox.this.SET(vub, this.m_vE2);
                }
                vub.normalize();
                RefDouble fParam1 = new RefDouble();
                RefDouble fParam2 = new RefDouble();
                DVector3 vua = new DVector3();
                int col = (this.m_iBestAxis - 5) / 3;
                CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, col, vua);
                this._cldClosestPointOnTwoLines(vPa, vua, vPb, vub, fParam1, fParam2);
                vPa.addScaled(vua, fParam1.d);
                vPb.addScaled(vub, fParam2.d);
                DVector3 vPntTmp = new DVector3();
                CollideTrimeshBox.this.ADD(vPa, vPb, vPntTmp);
                vPntTmp.scale(0.5);
                CollideTrimeshBox.GenerateContact(this.m_iFlags, this.m_ContactGeoms, this.m_iStride, this.m_Geom1, this.m_Geom2, TriIndex, vPntTmp, this.m_vBestNormal, this.m_fBestDepth, this.m_ctContacts);
            } else if (this.m_iBestAxis == 1) {
                int iB2;
                int iB0;
                int iB1;
                DVector3 vNormal2 = new DVector3();
                vNormal2.set(this.m_vBestNormal).scale(-1.0);
                DMatrix3 mTransposed = this.m_mHullBoxRot.reTranspose();
                DVector3 vNr = new DVector3();
                vNr.eqProd(mTransposed, vNormal2);
                DVector3 vAbsNormal = new DVector3();
                vAbsNormal.set(vNr).eqAbs();
                if (vAbsNormal.get1() > vAbsNormal.get0()) {
                    if (vAbsNormal.get1() > vAbsNormal.get2()) {
                        iB1 = 0;
                        iB0 = 1;
                        iB2 = 2;
                    } else {
                        iB1 = 0;
                        iB2 = 1;
                        iB0 = 2;
                    }
                } else if (vAbsNormal.get0() > vAbsNormal.get2()) {
                    iB0 = 0;
                    iB1 = 1;
                    iB2 = 2;
                } else {
                    iB1 = 0;
                    iB2 = 1;
                    iB0 = 2;
                }
                DVector3 vCenter = new DVector3();
                DVector3 vRotCol = new DVector3();
                CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, iB0, vRotCol);
                if (vNr.get(iB0) > 0.0) {
                    vCenter.eqSum(v0, -1.0, (DVector3C)vRotCol, -this.m_vBoxHalfSize.get(iB0));
                    vCenter.add(this.m_vHullBoxPos);
                } else {
                    vCenter.eqSum(v0, -1.0, (DVector3C)vRotCol, this.m_vBoxHalfSize.get(iB0));
                    vCenter.add(this.m_vHullBoxPos);
                }
                DVector3[] avPoints = new DVector3[]{new DVector3(), new DVector3(), new DVector3(), new DVector3()};
                DVector3 vRotCol2 = new DVector3();
                CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, iB1, vRotCol);
                CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, iB2, vRotCol2);
                double tz1 = this.m_vBoxHalfSize.get(iB1);
                double tz2 = this.m_vBoxHalfSize.get(iB2);
                avPoints[0].eqSum(vRotCol, tz1, (DVector3C)vRotCol2, -tz2).add(vCenter);
                avPoints[1].eqSum(vRotCol, -tz1, (DVector3C)vRotCol2, -tz2).add(vCenter);
                avPoints[2].eqSum(vRotCol, -tz1, (DVector3C)vRotCol2, tz2).add(vCenter);
                avPoints[3].eqSum(vRotCol, tz1, (DVector3C)vRotCol2, tz2).add(vCenter);
                DVector3[] avTempArray1 = new DVector3[9];
                DVector3[] avTempArray2 = new DVector3[9];
                DVector4 plPlane = new DVector4();
                RefInt iTempCnt1 = new RefInt(0);
                RefInt iTempCnt2 = new RefInt(0);
                int i = 0;
                while (i < 9) {
                    avTempArray1[i] = new DVector3();
                    avTempArray2[i] = new DVector3();
                    ++i;
                }
                DVector3 vTemp = new DVector3();
                vTemp.set(this.m_vN).scale(-1.0);
                vTemp.normalize();
                CollideTrimeshBox.this.CONSTRUCTPLANE(plPlane, vTemp, 0.0);
                this._cldClipPolyToPlane(avPoints, 4, avTempArray1, iTempCnt1, plPlane);
                DVector3 vTemp2 = new DVector3();
                CollideTrimeshBox.this.SUBTRACT(v1, v0, vTemp2);
                vTemp.eqCross(this.m_vN, vTemp2);
                vTemp.normalize();
                CollideTrimeshBox.this.CONSTRUCTPLANE(plPlane, vTemp, 0.0);
                this._cldClipPolyToPlane(avTempArray1, iTempCnt1.i, avTempArray2, iTempCnt2, plPlane);
                CollideTrimeshBox.this.SUBTRACT(v2, v1, vTemp2);
                vTemp.eqCross(this.m_vN, vTemp2);
                vTemp.normalize();
                CollideTrimeshBox.this.SUBTRACT(v0, v2, vTemp2);
                CollideTrimeshBox.this.CONSTRUCTPLANE(plPlane, vTemp, vTemp2.dot(vTemp));
                this._cldClipPolyToPlane(avTempArray2, iTempCnt2.i, avTempArray1, iTempCnt1, plPlane);
                CollideTrimeshBox.this.SUBTRACT(v0, v2, vTemp2);
                vTemp.eqCross(this.m_vN, vTemp2);
                vTemp.normalize();
                CollideTrimeshBox.this.CONSTRUCTPLANE(plPlane, vTemp, 0.0);
                this._cldClipPolyToPlane(avTempArray1, iTempCnt1.i, avTempArray2, iTempCnt2, plPlane);
                int i2 = 0;
                while (i2 < iTempCnt2.i) {
                    double fTempDepth = vNormal2.dot(avTempArray2[i2]);
                    if (fTempDepth > 0.0) {
                        fTempDepth = 0.0;
                    }
                    DVector3 vPntTmp = new DVector3();
                    CollideTrimeshBox.this.ADD(avTempArray2[i2], v0, vPntTmp);
                    CollideTrimeshBox.GenerateContact(this.m_iFlags, this.m_ContactGeoms, this.m_iStride, this.m_Geom1, this.m_Geom2, TriIndex, vPntTmp, this.m_vBestNormal, -fTempDepth, this.m_ctContacts);
                    if ((this.m_ctContacts.i | Integer.MIN_VALUE) != (this.m_iFlags & 0x8000FFFF)) {
                        ++i2;
                        continue;
                    }
                    break;
                }
            } else {
                int iA2;
                int iA1;
                DVector3 vNormal2 = new DVector3();
                CollideTrimeshBox.this.SET(vNormal2, this.m_vBestNormal);
                int iA0 = this.m_iBestAxis - 2;
                if (iA0 == 0) {
                    iA1 = 1;
                    iA2 = 2;
                } else if (iA0 == 1) {
                    iA1 = 0;
                    iA2 = 2;
                } else {
                    iA1 = 0;
                    iA2 = 1;
                }
                DVector3[] avPoints = new DVector3[]{new DVector3(), new DVector3(), new DVector3()};
                CollideTrimeshBox.this.SUBTRACT(v0, this.m_vHullBoxPos, avPoints[0]);
                CollideTrimeshBox.this.SUBTRACT(v1, this.m_vHullBoxPos, avPoints[1]);
                CollideTrimeshBox.this.SUBTRACT(v2, this.m_vHullBoxPos, avPoints[2]);
                DVector3[] avTempArray1 = new DVector3[9];
                DVector3[] avTempArray2 = new DVector3[9];
                RefInt iTempCnt1 = new RefInt();
                RefInt iTempCnt2 = new RefInt();
                int i = 0;
                while (i < 9) {
                    avTempArray1[i] = new DVector3();
                    avTempArray2[i] = new DVector3();
                    ++i;
                }
                DVector4 plPlane = new DVector4();
                DVector3 vTemp = new DVector3();
                vTemp.set(vNormal2).scale(-1.0);
                CollideTrimeshBox.this.CONSTRUCTPLANE(plPlane, vTemp, this.m_vBoxHalfSize.get(iA0));
                this._cldClipPolyToPlane(avPoints, 3, avTempArray1, iTempCnt1, plPlane);
                CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, iA1, vTemp);
                CollideTrimeshBox.this.CONSTRUCTPLANE(plPlane, vTemp, this.m_vBoxHalfSize.get(iA1));
                this._cldClipPolyToPlane(avTempArray1, iTempCnt1.i, avTempArray2, iTempCnt2, plPlane);
                CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, iA1, vTemp);
                vTemp.scale(-1.0);
                CollideTrimeshBox.this.CONSTRUCTPLANE(plPlane, vTemp, this.m_vBoxHalfSize.get(iA1));
                this._cldClipPolyToPlane(avTempArray2, iTempCnt2.i, avTempArray1, iTempCnt1, plPlane);
                CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, iA2, vTemp);
                CollideTrimeshBox.this.CONSTRUCTPLANE(plPlane, vTemp, this.m_vBoxHalfSize.get(iA2));
                this._cldClipPolyToPlane(avTempArray1, iTempCnt1.i, avTempArray2, iTempCnt2, plPlane);
                CollideTrimeshBox.this.GETCOL(this.m_mHullBoxRot, iA2, vTemp);
                vTemp.scale(-1.0);
                CollideTrimeshBox.this.CONSTRUCTPLANE(plPlane, vTemp, this.m_vBoxHalfSize.get(iA2));
                this._cldClipPolyToPlane(avTempArray2, iTempCnt2.i, avTempArray1, iTempCnt1, plPlane);
                int i3 = 0;
                while (i3 < iTempCnt1.i) {
                    double fTempDepth = vNormal2.dot(avTempArray1[i3]) - this.m_vBoxHalfSize.get(iA0);
                    if (fTempDepth > 0.0) {
                        fTempDepth = 0.0;
                    }
                    DVector3 vPntTmp = new DVector3();
                    CollideTrimeshBox.this.ADD(avTempArray1[i3], this.m_vHullBoxPos, vPntTmp);
                    CollideTrimeshBox.GenerateContact(this.m_iFlags, this.m_ContactGeoms, this.m_iStride, this.m_Geom1, this.m_Geom2, TriIndex, vPntTmp, this.m_vBestNormal, -fTempDepth, this.m_ctContacts);
                    if ((this.m_ctContacts.i | Integer.MIN_VALUE) != (this.m_iFlags & 0x8000FFFF)) {
                        ++i3;
                        continue;
                    }
                    break;
                }
            }
        }

        private void _cldTestOneTriangle(DVector3C v0, DVector3C v1, DVector3C v2, int TriIndex) {
            if (!this._cldTestSeparatingAxes(v0, v1, v2)) {
                return;
            }
            if (this.m_iBestAxis == 0) {
                return;
            }
            this._cldClipping(v0, v1, v2, TriIndex);
        }

        void SetupInitialContext(DxTriMesh TriMesh, DxBox BoxGeom, int Flags, DContactGeomBuffer Contacts, int Stride) {
            this.m_mHullBoxRot.set(BoxGeom.getRotation());
            this.m_vHullBoxPos.set(BoxGeom.getPosition());
            this.m_vBoxHalfSize.set(BoxGeom.getLengths());
            this.m_vBoxHalfSize.scale(0.5);
            this.m_vHullDstPos.set(TriMesh.getPosition());
            this.m_ctContacts.i = 0;
            if (Stride != 1) {
                throw new IllegalArgumentException("stride = " + Stride);
            }
            this.m_iStride = Stride;
            this.m_iFlags = Flags;
            this.m_ContactGeoms = Contacts;
            this.m_Geom1 = TriMesh;
            this.m_Geom2 = BoxGeom;
            this.m_fBestDepth = Double.MAX_VALUE;
            this.m_vBestNormal.setZero();
        }

        private int TestCollisionForSingleTriangle(int ctContacts0, int Triint, DVector3[] dv, RefBoolean bOutFinishSearching) {
            this._cldTestOneTriangle(dv[0], dv[1], dv[2], Triint);
            while (ctContacts0 < this.m_ctContacts.i) {
                DContactGeom pContact = this.m_ContactGeoms.getSafe(this.m_iFlags, ctContacts0);
                pContact.side1 = Triint;
                pContact.side2 = -1;
                ++ctContacts0;
            }
            bOutFinishSearching.b = (this.m_ctContacts.i | Integer.MIN_VALUE) == (this.m_iFlags & 0x8000FFFF);
            return ctContacts0;
        }
    }
}

