/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.RefBoolean;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DQuaternionC;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.math.DVector4;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxCollisionUtil;
import org.ode4j.ode.internal.DxCylinder;
import org.ode4j.ode.internal.DxGimpact;
import org.ode4j.ode.internal.DxTriMesh;
import org.ode4j.ode.internal.gimpact.GimDynArrayInt;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimTrimesh;

public class CollideCylinderTrimesh
implements DColliderFn {
    private static final double MAX_REAL = Double.POSITIVE_INFINITY;
    private static final int nCYLINDER_AXIS = 2;
    private static final int nCYLINDER_CIRCLE_SEGMENTS = 8;
    private static final int nMAX_CYLINDER_TRIANGLE_CLIP_POINTS = 12;

    @Override
    public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
        return this.dCollideCylinderTrimesh((DxCylinder)o1, (DxGimpact)o2, flags, contacts, 1);
    }

    int dCollideCylinderTrimesh(DxCylinder o1, DxGimpact o2, int flags, DContactGeomBuffer contacts, int skip) {
        Common.dIASSERT(skip == 1);
        Common.dIASSERT((flags & 0xFFFF) >= 1);
        int nContactCount = 0;
        DxCylinder Cylinder = o1;
        DxGimpact Trimesh = o2;
        sCylinderTrimeshColliderData cData = new sCylinderTrimeshColliderData(flags, skip);
        cData._InitCylinderTrimeshData(Cylinder, Trimesh);
        GimGeometry.aabb3f test_aabb = new GimGeometry.aabb3f();
        test_aabb.minX = (float)o1._aabb.getMin0();
        test_aabb.maxX = (float)o1._aabb.getMax0();
        test_aabb.minY = (float)o1._aabb.getMin1();
        test_aabb.maxY = (float)o1._aabb.getMax1();
        test_aabb.minZ = (float)o1._aabb.getMin2();
        test_aabb.maxZ = (float)o1._aabb.getMax2();
        GimDynArrayInt collision_result = GimDynArrayInt.GIM_CREATE_BOXQUERY_LIST();
        Trimesh.m_collision_trimesh.getAabbSet().gim_aabbset_box_collision(test_aabb, collision_result);
        if (collision_result.size() != 0) {
            int ctContacts0 = 0;
            cData.m_gLocalContacts = new sLocalContactData[cData.m_iFlags & 0xFFFF];
            int i = 0;
            while (i < cData.m_gLocalContacts.length) {
                cData.m_gLocalContacts[i] = new sLocalContactData();
                ++i;
            }
            int[] boxesresult = collision_result.GIM_DYNARRAY_POINTER();
            GimTrimesh ptrimesh = Trimesh.m_collision_trimesh;
            ptrimesh.gim_trimesh_locks_work_data();
            int i2 = 0;
            while (i2 < collision_result.size()) {
                int Triint = boxesresult[i2];
                GimGeometry.vec3f[] dvf = new GimGeometry.vec3f[]{new GimGeometry.vec3f(), new GimGeometry.vec3f(), new GimGeometry.vec3f()};
                ptrimesh.gim_trimesh_get_triangle_vertices(Triint, dvf[0], dvf[1], dvf[2]);
                DVector3[] dv = new DVector3[]{new DVector3(), new DVector3(), new DVector3()};
                dv[0].set(dvf[0].f);
                dv[1].set(dvf[1].f);
                dv[2].set(dvf[2].f);
                RefBoolean bFinishSearching = new RefBoolean(false);
                ctContacts0 = cData.TestCollisionForSingleTriangle(ctContacts0, Triint, dv, bFinishSearching);
                if (bFinishSearching.b) break;
                ++i2;
            }
            ptrimesh.gim_trimesh_unlocks_work_data();
            if (cData.m_nContacts != 0) {
                nContactCount = cData._ProcessLocalContacts(contacts, Cylinder, Trimesh);
            }
        }
        collision_result.GIM_DYNARRAY_DESTROY();
        return nContactCount;
    }

    private static class sCylinderTrimeshColliderData {
        private final DMatrix3 m_mCylinderRot = new DMatrix3();
        private final DQuaternion m_qCylinderRot = new DQuaternion();
        private final DQuaternion m_qInvCylinderRot = new DQuaternion();
        private final DVector3 m_vCylinderPos = new DVector3();
        private final DVector3 m_vCylinderAxis = new DVector3();
        private double m_fCylinderRadius;
        private double m_fCylinderSize;
        private final DVector3[] m_avCylinderNormals = new DVector3[8];
        private DQuaternionC m_qTrimeshRot;
        private DQuaternion m_qInvTrimeshRot;
        private final DMatrix3 m_mTrimeshRot = new DMatrix3();
        private final DVector3 m_vTrimeshPos = new DVector3();
        private final DVector3 m_vBestPoint = new DVector3();
        private double m_fBestDepth;
        private double m_fBestCenter;
        private double m_fBestrt;
        private int m_iBestAxis;
        private final DVector3 m_vContactNormal = new DVector3();
        private final DVector3 m_vNormal = new DVector3();
        private final DVector3 m_vE0 = new DVector3();
        private final DVector3 m_vE1 = new DVector3();
        private final DVector3 m_vE2 = new DVector3();
        int m_iFlags;
        int m_nContacts;
        sLocalContactData[] m_gLocalContacts;
        private static final double fSameContactPositionEpsilon = 1.0E-4;
        private static final double fSameContactNormalEpsilon = 1.0E-4;

        sCylinderTrimeshColliderData(int flags, int skip) {
            this.m_iFlags = flags;
            this.m_nContacts = 0;
            this.m_gLocalContacts = null;
        }

        private static final boolean _IsNearContacts(sLocalContactData c1, sLocalContactData c2) {
            boolean bPosNear = false;
            boolean bSameDir = false;
            DVector3 vDiff = new DVector3();
            vDiff.eqDiff(c1.vPos, c2.vPos);
            if (Math.abs(vDiff.get0()) < 1.0E-4 && Math.abs(vDiff.get1()) < 1.0E-4 && Math.abs(vDiff.get2()) < 1.0E-4) {
                bPosNear = true;
            }
            vDiff.eqDiff(c1.vNormal, c2.vNormal);
            if (Math.abs(vDiff.get0()) < 1.0E-4 && Math.abs(vDiff.get1()) < 1.0E-4 && Math.abs(vDiff.get2()) < 1.0E-4) {
                bSameDir = true;
            }
            return bPosNear && bSameDir;
        }

        private static final boolean _IsBetter(sLocalContactData c1, sLocalContactData c2) {
            return c1.fDepth > c2.fDepth;
        }

        void _OptimizeLocalContacts() {
            int nContacts = this.m_nContacts;
            int i = 0;
            while (i < nContacts - 1) {
                int j = i + 1;
                while (j < nContacts) {
                    if (sCylinderTrimeshColliderData._IsNearContacts(this.m_gLocalContacts[i], this.m_gLocalContacts[j])) {
                        if (sCylinderTrimeshColliderData._IsBetter(this.m_gLocalContacts[j], this.m_gLocalContacts[i])) {
                            this.m_gLocalContacts[i].nFlags = 0;
                        } else {
                            this.m_gLocalContacts[j].nFlags = 0;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }

        int _ProcessLocalContacts(DContactGeomBuffer contacts, DxCylinder Cylinder, DxTriMesh Trimesh) {
            if (this.m_nContacts > 1 && (this.m_iFlags & Integer.MIN_VALUE) == 0) {
                this._OptimizeLocalContacts();
            }
            int iContact = 0;
            DContactGeom Contact = null;
            int nFinalContact = 0;
            iContact = 0;
            while (iContact < this.m_nContacts) {
                if (1 == this.m_gLocalContacts[iContact].nFlags) {
                    Contact = contacts.getSafe(this.m_iFlags, nFinalContact);
                    Contact.depth = this.m_gLocalContacts[iContact].fDepth;
                    Contact.normal.set(this.m_gLocalContacts[iContact].vNormal);
                    Contact.pos.set(this.m_gLocalContacts[iContact].vPos);
                    Contact.g1 = Cylinder;
                    Contact.g2 = Trimesh;
                    Contact.side1 = -1;
                    Contact.side2 = this.m_gLocalContacts[iContact].triIndex;
                    Contact.normal.scale(-1.0);
                    ++nFinalContact;
                }
                ++iContact;
            }
            return nFinalContact;
        }

        boolean _cldTestAxis(DVector3C v0, DVector3C v1, DVector3C v2, DVector3 vAxis, int iAxis, boolean bNoFlip) {
            double fL = vAxis.length();
            if (fL < 1.0E-5) {
                return true;
            }
            vAxis.scale(1.0 / fL);
            double fdot1 = this.m_vCylinderAxis.dot(vAxis);
            double frc = Math.abs(fdot1) > 1.0 ? Math.abs(this.m_fCylinderSize * 0.5) : Math.abs(this.m_fCylinderSize * 0.5 * fdot1) + this.m_fCylinderRadius * Math.sqrt(1.0 - fdot1 * fdot1);
            DVector3 vV0 = new DVector3();
            vV0.eqDiff(v0, this.m_vCylinderPos);
            DVector3 vV1 = new DVector3();
            vV1.eqDiff(v1, this.m_vCylinderPos);
            DVector3 vV2 = new DVector3();
            vV2.eqDiff(v2, this.m_vCylinderPos);
            double[] afv = new double[]{vV0.dot(vAxis), vV1.dot(vAxis), vV2.dot(vAxis)};
            double fMin = Double.POSITIVE_INFINITY;
            double fMax = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < 3) {
                if (afv[i] < fMin) {
                    fMin = afv[i];
                }
                if (afv[i] > fMax) {
                    fMax = afv[i];
                }
                ++i;
            }
            double fCenter = (fMin + fMax) * 0.5;
            double fTriangleRadius = (fMax - fMin) * 0.5;
            if (Math.abs(fCenter) > frc + fTriangleRadius) {
                return false;
            }
            double fDepth = -(Math.abs(fCenter) - (frc + fTriangleRadius));
            if (fDepth < this.m_fBestDepth) {
                this.m_fBestDepth = fDepth;
                this.m_fBestCenter = fCenter;
                this.m_fBestrt = frc;
                DxCollisionUtil.dVector3Copy(vAxis, this.m_vContactNormal);
                this.m_iBestAxis = iAxis;
                if (fCenter < 0.0 && !bNoFlip) {
                    DxCollisionUtil.dVector3Inv(this.m_vContactNormal);
                    this.m_fBestCenter = -fCenter;
                }
            }
            return true;
        }

        boolean _cldTestCircleToEdgeAxis(DVector3C v0, DVector3C v1, DVector3C v2, DVector3C vCenterPoint, DVector3C vCylinderAxis1, DVector3C vVx0, DVector3C vVx1, int iAxis) {
            DVector3 vkl = new DVector3();
            DxCollisionUtil.dVector3Subtract(vVx1, vVx0, vkl);
            vkl.normalize();
            DVector3 vol = new DVector3();
            DxCollisionUtil.dVector3Copy(vVx0, vol);
            double fdot2 = vkl.dot(vCylinderAxis1);
            if (Math.abs(fdot2) < 1.0E-5) {
                return true;
            }
            DVector3 vTemp = new DVector3();
            DxCollisionUtil.dVector3Subtract(vCenterPoint, vol, vTemp);
            double fdot1 = vTemp.dot(vCylinderAxis1);
            DVector3 vpnt = new DVector3();
            vpnt.eqSum((DVector3C)vol, vkl, fdot1 / fdot2);
            DVector3 vTangent = new DVector3();
            DxCollisionUtil.dVector3Subtract(vCenterPoint, vpnt, vTemp);
            DxCollisionUtil.dVector3Cross(vTemp, vCylinderAxis1, vTangent);
            DVector3 vAxis = new DVector3();
            DxCollisionUtil.dVector3Cross(vTangent, vkl, vAxis);
            return this._cldTestAxis(v0, v1, v2, vAxis, iAxis, false);
        }

        private static final void _CalculateAxis(DVector3C v1, DVector3C v2, DVector3C v3, DVector3 r) {
            DVector3 t1 = new DVector3();
            DVector3 t2 = new DVector3();
            t1.eqDiff(v1, v2);
            OdeMath.dCalcVectorCross3(t2, t1, v3);
            OdeMath.dCalcVectorCross3(r, t2, v3);
        }

        boolean _cldTestSeparatingAxes(DVector3C v0, DVector3C v1, DVector3C v2) {
            DxCollisionUtil.dVector3Subtract(v1, v0, this.m_vE0);
            DxCollisionUtil.dVector3Subtract(v0, v2, this.m_vE2);
            DVector3 vCp0 = new DVector3();
            vCp0.eqSum((DVector3C)this.m_vCylinderPos, this.m_vCylinderAxis, this.m_fCylinderSize * 0.5);
            DVector3 vCp1 = new DVector3();
            vCp1.eqSum((DVector3C)this.m_vCylinderPos, this.m_vCylinderAxis, -this.m_fCylinderSize * 0.5);
            this.m_iBestAxis = 0;
            DVector3 vAxis = new DVector3();
            vAxis.set(this.m_vNormal).scale(-1.0);
            if (!this._cldTestAxis(v0, v1, v2, vAxis, 1, true)) {
                return false;
            }
            DxCollisionUtil.dVector3Cross(this.m_vCylinderAxis, this.m_vE0, vAxis);
            if (!this._cldTestAxis(v0, v1, v2, vAxis, 2, false)) {
                return false;
            }
            DxCollisionUtil.dVector3Cross(this.m_vCylinderAxis, this.m_vE1, vAxis);
            if (!this._cldTestAxis(v0, v1, v2, vAxis, 3, false)) {
                return false;
            }
            DxCollisionUtil.dVector3Cross(this.m_vCylinderAxis, this.m_vE2, vAxis);
            if (!this._cldTestAxis(v0, v1, v2, vAxis, 4, false)) {
                return false;
            }
            sCylinderTrimeshColliderData._CalculateAxis(v0, vCp0, this.m_vCylinderAxis, vAxis);
            if (!this._cldTestAxis(v0, v1, v2, vAxis, 11, false)) {
                return false;
            }
            sCylinderTrimeshColliderData._CalculateAxis(v1, vCp0, this.m_vCylinderAxis, vAxis);
            if (!this._cldTestAxis(v0, v1, v2, vAxis, 12, false)) {
                return false;
            }
            sCylinderTrimeshColliderData._CalculateAxis(v2, vCp0, this.m_vCylinderAxis, vAxis);
            if (!this._cldTestAxis(v0, v1, v2, vAxis, 13, false)) {
                return false;
            }
            DxCollisionUtil.dVector3Copy(this.m_vCylinderAxis, vAxis);
            if (!this._cldTestAxis(v0, v1, v2, vAxis, 14, false)) {
                return false;
            }
            DVector3 vccATop = new DVector3();
            vccATop.eqSum((DVector3C)this.m_vCylinderPos, this.m_vCylinderAxis, this.m_fCylinderSize * 0.5);
            DVector3 vccABottom = new DVector3();
            vccABottom.eqSum((DVector3C)this.m_vCylinderPos, this.m_vCylinderAxis, -this.m_fCylinderSize * 0.5);
            if (!this._cldTestCircleToEdgeAxis(v0, v1, v2, vccATop, this.m_vCylinderAxis, v0, v1, 15)) {
                return false;
            }
            if (!this._cldTestCircleToEdgeAxis(v0, v1, v2, vccATop, this.m_vCylinderAxis, v1, v2, 16)) {
                return false;
            }
            if (!this._cldTestCircleToEdgeAxis(v0, v1, v2, vccATop, this.m_vCylinderAxis, v0, v2, 17)) {
                return false;
            }
            if (!this._cldTestCircleToEdgeAxis(v0, v1, v2, vccABottom, this.m_vCylinderAxis, v0, v1, 18)) {
                return false;
            }
            if (!this._cldTestCircleToEdgeAxis(v0, v1, v2, vccABottom, this.m_vCylinderAxis, v1, v2, 19)) {
                return false;
            }
            return this._cldTestCircleToEdgeAxis(v0, v1, v2, vccABottom, this.m_vCylinderAxis, v0, v2, 20);
        }

        boolean _cldClipCylinderEdgeToTriangle(DVector3C v0, DVector3C v1, DVector3C v2) {
            double fTemp = this.m_vCylinderAxis.dot(this.m_vContactNormal);
            DVector3 vN2 = new DVector3();
            vN2.eqSum((DVector3C)this.m_vContactNormal, this.m_vCylinderAxis, -fTemp);
            fTemp = vN2.length();
            if (fTemp < 1.0E-5) {
                return false;
            }
            vN2.scale(1.0 / fTemp);
            DVector3 vCposTrans = new DVector3();
            vCposTrans.eqSum((DVector3C)this.m_vCylinderPos, vN2, this.m_fCylinderRadius);
            DVector3 vCEdgePoint0 = new DVector3();
            vCEdgePoint0.eqSum((DVector3C)vCposTrans, this.m_vCylinderAxis, this.m_fCylinderSize * 0.5);
            DVector3 vCEdgePoint1 = new DVector3();
            vCEdgePoint1.eqSum((DVector3C)vCposTrans, this.m_vCylinderAxis, -this.m_fCylinderSize * 0.5);
            vCEdgePoint0.sub(v0);
            vCEdgePoint1.sub(v0);
            DVector4 plPlane = new DVector4();
            DVector3 vPlaneNormal = new DVector3();
            vPlaneNormal.set(this.m_vNormal).scale(-1.0);
            DxCollisionUtil.dConstructPlane(vPlaneNormal, 0.0, plPlane);
            if (!DxCollisionUtil.dClipEdgeToPlane(vCEdgePoint0, vCEdgePoint1, plPlane)) {
                return false;
            }
            DxCollisionUtil.dVector3Cross(this.m_vNormal, this.m_vE0, vPlaneNormal);
            DxCollisionUtil.dConstructPlane(vPlaneNormal, 1.0E-5, plPlane);
            if (!DxCollisionUtil.dClipEdgeToPlane(vCEdgePoint0, vCEdgePoint1, plPlane)) {
                return false;
            }
            DxCollisionUtil.dVector3Cross(this.m_vNormal, this.m_vE1, vPlaneNormal);
            fTemp = this.m_vE0.dot(vPlaneNormal) - 1.0E-5;
            DxCollisionUtil.dConstructPlane(vPlaneNormal, -fTemp, plPlane);
            if (!DxCollisionUtil.dClipEdgeToPlane(vCEdgePoint0, vCEdgePoint1, plPlane)) {
                return false;
            }
            DxCollisionUtil.dVector3Cross(this.m_vNormal, this.m_vE2, vPlaneNormal);
            DxCollisionUtil.dConstructPlane(vPlaneNormal, 1.0E-5, plPlane);
            if (!DxCollisionUtil.dClipEdgeToPlane(vCEdgePoint0, vCEdgePoint1, plPlane)) {
                return false;
            }
            vCEdgePoint0.add(v0);
            vCEdgePoint1.add(v0);
            DVector3 vTemp = new DVector3();
            DxCollisionUtil.dVector3Subtract(vCEdgePoint0, this.m_vCylinderPos, vTemp);
            double fRestDepth0 = -vTemp.dot(this.m_vContactNormal) + this.m_fBestrt;
            DxCollisionUtil.dVector3Subtract(vCEdgePoint1, this.m_vCylinderPos, vTemp);
            double fRestDepth1 = -vTemp.dot(this.m_vContactNormal) + this.m_fBestrt;
            double fDepth0 = this.m_fBestDepth - fRestDepth0;
            double fDepth1 = this.m_fBestDepth - fRestDepth1;
            if (fDepth0 < 0.0) {
                fDepth0 = 0.0;
            }
            if (fDepth1 < 0.0) {
                fDepth1 = 0.0;
            }
            if (this.m_gLocalContacts[this.m_nContacts] == null) {
                this.m_gLocalContacts[this.m_nContacts] = new sLocalContactData();
            }
            this.m_gLocalContacts[this.m_nContacts].fDepth = fDepth0;
            DxCollisionUtil.dVector3Copy(this.m_vContactNormal, this.m_gLocalContacts[this.m_nContacts].vNormal);
            DxCollisionUtil.dVector3Copy(vCEdgePoint0, this.m_gLocalContacts[this.m_nContacts].vPos);
            this.m_gLocalContacts[this.m_nContacts].nFlags = 1;
            ++this.m_nContacts;
            if (this.m_nContacts >= (this.m_iFlags & 0xFFFF)) {
                return true;
            }
            this.m_gLocalContacts[this.m_nContacts].fDepth = fDepth1;
            DxCollisionUtil.dVector3Copy(this.m_vContactNormal, this.m_gLocalContacts[this.m_nContacts].vNormal);
            DxCollisionUtil.dVector3Copy(vCEdgePoint1, this.m_gLocalContacts[this.m_nContacts].vPos);
            this.m_gLocalContacts[this.m_nContacts].nFlags = 1;
            ++this.m_nContacts;
            return true;
        }

        void _cldClipCylinderToTriangle(DVector3C v0, DVector3C v1, DVector3C v2) {
            int i = 0;
            DVector3[] avPoints = new DVector3[]{new DVector3(), new DVector3(), new DVector3()};
            DVector3[] avTempArray1 = new DVector3[12];
            DVector3[] avTempArray2 = new DVector3[12];
            int ii = 0;
            while (ii < 12) {
                avTempArray1[ii] = new DVector3();
                avTempArray2[ii] = new DVector3();
                ++ii;
            }
            DxCollisionUtil.dVector3Copy(v0, avPoints[0]);
            DxCollisionUtil.dVector3Copy(v1, avPoints[1]);
            DxCollisionUtil.dVector3Copy(v2, avPoints[2]);
            DVector3 vCylinderCirclePos = new DVector3();
            DVector3 vCylinderCircleNormal_Rel = new DVector3();
            vCylinderCircleNormal_Rel.setZero();
            if (this.m_vCylinderAxis.dot(this.m_vContactNormal) > 0.0) {
                vCylinderCirclePos.eqSum((DVector3C)this.m_vCylinderPos, this.m_vCylinderAxis, this.m_fCylinderSize * 0.5);
                vCylinderCircleNormal_Rel.set(2, -1.0);
            } else {
                vCylinderCirclePos.eqSum((DVector3C)this.m_vCylinderPos, this.m_vCylinderAxis, -this.m_fCylinderSize * 0.5);
                vCylinderCircleNormal_Rel.set(2, 1.0);
            }
            DVector3 vTemp = new DVector3();
            DxCollisionUtil.dQuatInv(this.m_qCylinderRot, this.m_qInvCylinderRot);
            i = 0;
            while (i < 3) {
                DxCollisionUtil.dVector3Subtract(avPoints[i], vCylinderCirclePos, vTemp);
                DxCollisionUtil.dQuatTransform(this.m_qInvCylinderRot, vTemp, avPoints[i]);
                ++i;
            }
            int iTmpCounter1 = 0;
            int iTmpCounter2 = 0;
            DVector4 plPlane = new DVector4();
            DxCollisionUtil.dConstructPlane(vCylinderCircleNormal_Rel, 0.0, plPlane);
            iTmpCounter1 = DxCollisionUtil.dClipPolyToPlane(avPoints, 3, avTempArray1, plPlane);
            int nCircleSegment = 0;
            nCircleSegment = 0;
            while (nCircleSegment < 8) {
                DxCollisionUtil.dConstructPlane(this.m_avCylinderNormals[nCircleSegment], this.m_fCylinderRadius, plPlane);
                if (nCircleSegment % 2 == 0) {
                    iTmpCounter2 = DxCollisionUtil.dClipPolyToPlane(avTempArray1, iTmpCounter1, avTempArray2, plPlane);
                } else {
                    iTmpCounter1 = DxCollisionUtil.dClipPolyToPlane(avTempArray2, iTmpCounter2, avTempArray1, plPlane);
                }
                Common.dIASSERT(iTmpCounter1 >= 0 && iTmpCounter1 <= 12);
                Common.dIASSERT(iTmpCounter2 >= 0 && iTmpCounter2 <= 12);
                ++nCircleSegment;
            }
            DVector3 vPoint = new DVector3();
            if (nCircleSegment % 2 != 0) {
                i = 0;
                while (i < iTmpCounter2) {
                    DxCollisionUtil.dQuatTransform(this.m_qCylinderRot, avTempArray2[i], vPoint);
                    vPoint.add(vCylinderCirclePos);
                    DxCollisionUtil.dVector3Subtract(vPoint, this.m_vCylinderPos, vTemp);
                    double ftmpdot = Math.abs(vTemp.dot(this.m_vContactNormal));
                    double fTempDepth = this.m_fBestrt - ftmpdot;
                    if (fTempDepth > 0.0) {
                        this.m_gLocalContacts[this.m_nContacts].fDepth = fTempDepth;
                        DxCollisionUtil.dVector3Copy(this.m_vContactNormal, this.m_gLocalContacts[this.m_nContacts].vNormal);
                        DxCollisionUtil.dVector3Copy(vPoint, this.m_gLocalContacts[this.m_nContacts].vPos);
                        this.m_gLocalContacts[this.m_nContacts].nFlags = 1;
                        ++this.m_nContacts;
                        if (this.m_nContacts >= (this.m_iFlags & 0xFFFF)) {
                            return;
                        }
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < iTmpCounter1) {
                    DxCollisionUtil.dQuatTransform(this.m_qCylinderRot, avTempArray1[i], vPoint);
                    vPoint.add(vCylinderCirclePos);
                    DxCollisionUtil.dVector3Subtract(vPoint, this.m_vCylinderPos, vTemp);
                    double ftmpdot = Math.abs(vTemp.dot(this.m_vContactNormal));
                    double fTempDepth = this.m_fBestrt - ftmpdot;
                    if (fTempDepth > 0.0) {
                        this.m_gLocalContacts[this.m_nContacts].fDepth = fTempDepth;
                        DxCollisionUtil.dVector3Copy(this.m_vContactNormal, this.m_gLocalContacts[this.m_nContacts].vNormal);
                        DxCollisionUtil.dVector3Copy(vPoint, this.m_gLocalContacts[this.m_nContacts].vPos);
                        this.m_gLocalContacts[this.m_nContacts].nFlags = 1;
                        ++this.m_nContacts;
                        if (this.m_nContacts >= (this.m_iFlags & 0xFFFF)) {
                            return;
                        }
                    }
                    ++i;
                }
            }
        }

        void TestOneTriangleVsCylinder(DVector3C v0, DVector3C v1, DVector3C v2, boolean bDoubleSided) {
            DxCollisionUtil.dVector3Subtract(v2, v1, this.m_vE1);
            DVector3 vTemp = new DVector3();
            DxCollisionUtil.dVector3Subtract(v0, v1, vTemp);
            DxCollisionUtil.dVector3Cross(this.m_vE1, vTemp, this.m_vNormal);
            if (!OdeMath.dSafeNormalize3(this.m_vNormal)) {
                return;
            }
            double plDistance = -v0.dot(this.m_vNormal);
            DVector4 plTrianglePlane = new DVector4();
            DxCollisionUtil.dConstructPlane(this.m_vNormal, plDistance, plTrianglePlane);
            double fDistanceCylinderCenterToPlane = DxCollisionUtil.dPointPlaneDistance(this.m_vCylinderPos, plTrianglePlane);
            if (fDistanceCylinderCenterToPlane < 0.0 && !bDoubleSided) {
                return;
            }
            DVector3 vPnt0 = new DVector3();
            DVector3 vPnt1 = new DVector3();
            DVector3 vPnt2 = new DVector3();
            if (fDistanceCylinderCenterToPlane < 0.0) {
                DxCollisionUtil.dVector3Copy(v0, vPnt0);
                DxCollisionUtil.dVector3Copy(v1, vPnt2);
                DxCollisionUtil.dVector3Copy(v2, vPnt1);
            } else {
                DxCollisionUtil.dVector3Copy(v0, vPnt0);
                DxCollisionUtil.dVector3Copy(v1, vPnt1);
                DxCollisionUtil.dVector3Copy(v2, vPnt2);
            }
            this.m_fBestDepth = Double.POSITIVE_INFINITY;
            if (!this._cldTestSeparatingAxes(vPnt0, vPnt1, vPnt2)) {
                return;
            }
            if (this.m_iBestAxis == 0) {
                Common.dIASSERT(false);
                return;
            }
            double fdot = this.m_vContactNormal.dot(this.m_vCylinderAxis);
            if (Math.abs(fdot) < 0.9) {
                if (!this._cldClipCylinderEdgeToTriangle(vPnt0, vPnt1, vPnt2)) {
                    return;
                }
            } else {
                this._cldClipCylinderToTriangle(vPnt0, vPnt1, vPnt2);
            }
        }

        void _InitCylinderTrimeshData(DxCylinder Cylinder, DxTriMesh Trimesh) {
            DMatrix3C pRotCyc = Cylinder.getRotation();
            DxCollisionUtil.dMatrix3Copy(pRotCyc, this.m_mCylinderRot);
            this.m_qCylinderRot.set(Cylinder.getQuaternion());
            DVector3C pPosCyc = Cylinder.getPosition();
            DxCollisionUtil.dVector3Copy(pPosCyc, this.m_vCylinderPos);
            DxCollisionUtil.dMat3GetCol(this.m_mCylinderRot, 2, this.m_vCylinderAxis);
            this.m_fCylinderRadius = Cylinder.getRadius();
            this.m_fCylinderSize = Cylinder.getLength();
            DMatrix3C pRotTris = Trimesh.getRotation();
            DxCollisionUtil.dMatrix3Copy(pRotTris, this.m_mTrimeshRot);
            this.m_qTrimeshRot = Trimesh.getQuaternion();
            DVector3C pPosTris = Trimesh.getPosition();
            DxCollisionUtil.dVector3Copy(pPosTris, this.m_vTrimeshPos);
            double fAngle = 0.39269908169872414;
            double fAngleIncrement = fAngle * 2.0;
            int i = 0;
            while (i < 8) {
                this.m_avCylinderNormals[i] = new DVector3();
                this.m_avCylinderNormals[i].set0(-Math.cos(fAngle));
                this.m_avCylinderNormals[i].set1(-Math.sin(fAngle));
                this.m_avCylinderNormals[i].set2(0.0);
                fAngle += fAngleIncrement;
                ++i;
            }
            this.m_vBestPoint.setZero();
            this.m_fBestCenter = 0.0;
        }

        int TestCollisionForSingleTriangle(int ctContacts0, int Triint, DVector3[] dv, RefBoolean bOutFinishSearching) {
            this.TestOneTriangleVsCylinder(dv[0], dv[1], dv[2], false);
            while (ctContacts0 < this.m_nContacts) {
                this.m_gLocalContacts[ctContacts0].triIndex = Triint;
                ++ctContacts0;
            }
            bOutFinishSearching.b = this.m_nContacts >= (this.m_iFlags & 0xFFFF);
            return ctContacts0;
        }
    }

    private static class sLocalContactData {
        final DVector3 vPos = new DVector3();
        final DVector3 vNormal = new DVector3();
        double fDepth;
        int triIndex;
        int nFlags;

        private sLocalContactData() {
        }
    }
}

