/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxCollisionUtil;
import org.ode4j.ode.internal.DxCylinder;
import org.ode4j.ode.internal.DxSphere;

class CollideCylinderSphere
extends DxCollisionUtil
implements DColliderFn {
    private static final double toleranz = 1.0E-4;

    CollideCylinderSphere() {
    }

    int dCollideCylinderSphere(DxCylinder Cylinder, DxSphere Sphere, int flags, DContactGeomBuffer contacts, int skip) {
        Common.dIASSERT(skip >= 1);
        Common.dIASSERT((flags & 0xFFFF) >= 1);
        int GeomCount = 0;
        double radius = Cylinder.getRadius();
        double length = Cylinder.getLength();
        DVector3C cylpos = Cylinder.final_posr().pos();
        double radius2 = Sphere.dGeomSphereGetRadius();
        DVector3C SpherePos = Sphere.dGeomGetPosition();
        DVector3 G1Pos1 = new DVector3();
        DVector3 G1Pos2 = new DVector3();
        DVector3 vDir1 = Cylinder.final_posr().R().columnAsNewVector(2);
        double s = length * 0.5;
        G1Pos2.eqSum(cylpos, vDir1, s);
        G1Pos1.eqSum(cylpos, vDir1, -s);
        DVector3 C = new DVector3();
        s = (SpherePos.get0() - G1Pos1.get0()) * vDir1.get0() - (G1Pos1.get1() - SpherePos.get1()) * vDir1.get1() - (G1Pos1.get2() - SpherePos.get2()) * vDir1.get2();
        if (s < -radius2 || s > length + radius2) {
            return 0;
        }
        C.eqSum((DVector3C)G1Pos1, vDir1, s).sub(SpherePos);
        double t = this.dVector3Length(C);
        if (t > radius + radius2) {
            return 0;
        }
        DContactGeom contact = contacts.get();
        if (t > radius && (s < 0.0 || s > length)) {
            if (s <= 0.0) {
                contact.depth = radius2 - Common.dSqrt(s * s + (t - radius) * (t - radius));
                if (contact.depth < 0.0) {
                    return 0;
                }
                contact.pos.eqSum((DVector3C)G1Pos1, C, -radius / t);
                contact.normal.eqDiff(contact.pos, SpherePos).scale(1.0 / (radius2 - contact.depth));
                contact.g1 = Cylinder;
                contact.g2 = Sphere;
                contact.side1 = -1;
                contact.side2 = -1;
                return ++GeomCount;
            }
            contact.depth = radius2 - Common.dSqrt((s - length) * (s - length) + (t - radius) * (t - radius));
            if (contact.depth < 0.0) {
                return 0;
            }
            contact.pos.eqSum((DVector3C)G1Pos2, C, -radius / t);
            contact.normal.eqDiff(contact.pos, SpherePos).scale(1.0 / (radius2 - contact.depth));
            contact.g1 = Cylinder;
            contact.g2 = Sphere;
            contact.side1 = -1;
            contact.side2 = -1;
            return ++GeomCount;
        }
        if (radius - t <= s && radius - t <= length - s) {
            if (t > radius2 + toleranz) {
                contact.depth = radius2 + radius - t;
                if (contact.depth < 0.0) {
                    return 0;
                }
                C.scale(1.0 / t);
                contact.pos.eqSum(SpherePos, C, radius2);
                contact.normal.set(C);
                contact.g1 = Cylinder;
                contact.g2 = Sphere;
                contact.side1 = -1;
                contact.side2 = -1;
                return ++GeomCount;
            }
            contact.depth = radius2 + radius - t;
            if (contact.depth < 0.0) {
                return 0;
            }
            contact.pos.eqSum(C, SpherePos);
            contact.normal.set(C).scale(1.0 / t);
            contact.g1 = Cylinder;
            contact.g2 = Sphere;
            contact.side1 = -1;
            contact.side2 = -1;
            return ++GeomCount;
        }
        if (s <= length * 0.5) {
            contact.depth = s + radius2;
            if (contact.depth < 0.0) {
                return 0;
            }
            contact.pos.eqSum(SpherePos, vDir1, radius2);
            contact.normal.set(vDir1);
            contact.g1 = Cylinder;
            contact.g2 = Sphere;
            contact.side1 = -1;
            contact.side2 = -1;
            return ++GeomCount;
        }
        contact.depth = radius2 + length - s;
        if (contact.depth < 0.0) {
            return 0;
        }
        contact.pos.eqSum(SpherePos, vDir1, -radius2);
        contact.normal.set(vDir1).scale(-1.0);
        contact.g1 = Cylinder;
        contact.g2 = Sphere;
        contact.side1 = -1;
        contact.side2 = -1;
        return ++GeomCount;
    }

    @Override
    public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
        return this.dCollideCylinderSphere((DxCylinder)o1, (DxSphere)o2, flags, contacts, 1);
    }
}

