/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxCollisionUtil;
import org.ode4j.ode.internal.DxCylinder;
import org.ode4j.ode.internal.DxPlane;

class CollideCylinderPlane
extends DxCollisionUtil
implements DColliderFn {
    private static final double toleranz = 1.0E-4;

    CollideCylinderPlane() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int dCollideCylinderPlane(DxCylinder cylinder, DxPlane plane, int flags, DContactGeomBuffer contacts, int skip) {
        Common.dIASSERT(skip == 1);
        Common.dIASSERT((flags & 0xFFFF) >= 1);
        int GeomCount = 0;
        double radius = cylinder.getRadius();
        double length = cylinder.getLength();
        DVector3C cylpos = cylinder.final_posr().pos();
        DVector3C planevec = plane.getNormal();
        double planeDepth = plane.getDepth();
        DVector3 PlaneNormal = new DVector3(planevec);
        DContactGeom contact = contacts.get();
        int contactPos = 0;
        DVector3 G1Pos1 = new DVector3();
        DVector3 G1Pos2 = new DVector3();
        DVector3 vDir1 = cylinder.final_posr().R().columnAsNewVector(2);
        double s = length * 0.5;
        G1Pos2.eqSum(cylpos, vDir1, s);
        G1Pos1.eqSum(cylpos, vDir1, -s);
        s = vDir1.dot(PlaneNormal);
        s = s < 0.0 ? (s += 1.0) : (s -= 1.0);
        if (s < toleranz && s > -toleranz) {
            double t;
            DVector3 P = new DVector3();
            s = planeDepth - planevec.dot(G1Pos1);
            if (s >= (t = planeDepth - planevec.dot(G1Pos2))) {
                if (!(s >= 0.0)) return GeomCount;
                P.set(G1Pos1);
            } else {
                if (!(t >= 0.0)) return GeomCount;
                P.set(G1Pos2);
            }
            DVector3 V1 = new DVector3();
            DVector3 V2 = new DVector3();
            if (vDir1.get0() < toleranz && vDir1.get0() > -toleranz) {
                V1.set(vDir1).add(0, 1.0);
            } else {
                V1.set(vDir1).add(1, 1.0);
            }
            CollideCylinderPlane.dVector3Cross(V1, vDir1, V2);
            t = this.dVector3Length(V2);
            t = radius / t;
            this.dVector3Scale(V2, t);
            CollideCylinderPlane.dVector3Cross(V2, vDir1, V1);
            this.dVector3Add(P, V1, contact.pos);
            contact.depth = planeDepth - planevec.dot(contact.pos);
            if (contact.depth > 0.0) {
                CollideCylinderPlane.dVector3Copy(PlaneNormal, contact.normal);
                contact.g1 = cylinder;
                contact.g2 = plane;
                contact.side1 = -1;
                contact.side2 = -1;
                if (++GeomCount >= (flags & 0xFFFF)) {
                    return GeomCount;
                }
                contact = contacts.get(contactPos += skip);
            }
            CollideCylinderPlane.dVector3Subtract(P, V1, contact.pos);
            contact.depth = planeDepth - this.dVector3Dot(planevec, contact.pos);
            if (contact.depth > 0.0) {
                CollideCylinderPlane.dVector3Copy(PlaneNormal, contact.normal);
                contact.g1 = cylinder;
                contact.g2 = plane;
                contact.side1 = -1;
                contact.side2 = -1;
                if (++GeomCount >= (flags & 0xFFFF)) {
                    return GeomCount;
                }
                contact = contacts.get(contactPos += skip);
            }
            this.dVector3Add(P, V2, contact.pos);
            contact.depth = planeDepth - this.dVector3Dot(planevec, contact.pos);
            if (contact.depth > 0.0) {
                CollideCylinderPlane.dVector3Copy(PlaneNormal, contact.normal);
                contact.g1 = cylinder;
                contact.g2 = plane;
                contact.side1 = -1;
                contact.side2 = -1;
                if (++GeomCount >= (flags & 0xFFFF)) {
                    return GeomCount;
                }
                contact = contacts.get(contactPos += skip);
            }
            CollideCylinderPlane.dVector3Subtract(P, V2, contact.pos);
            contact.depth = planeDepth - this.dVector3Dot(planevec, contact.pos);
            if (!(contact.depth > 0.0)) return GeomCount;
            CollideCylinderPlane.dVector3Copy(PlaneNormal, contact.normal);
            contact.g1 = cylinder;
            contact.g2 = plane;
            contact.side1 = -1;
            contact.side2 = -1;
            if (++GeomCount < (flags & 0xFFFF)) return GeomCount;
            return GeomCount;
        }
        double t = this.dVector3Dot(PlaneNormal, vDir1);
        DVector3 C = new DVector3();
        C.eqSum(vDir1, t, (DVector3C)PlaneNormal, -1.0);
        s = this.dVector3Length(C);
        s = radius / s;
        this.dVector3Scale(C, s);
        this.dVector3Add(C, G1Pos1, contact.pos);
        contact.depth = planeDepth - this.dVector3Dot(planevec, contact.pos);
        if (contact.depth >= 0.0) {
            CollideCylinderPlane.dVector3Copy(PlaneNormal, contact.normal);
            contact.g1 = cylinder;
            contact.g2 = plane;
            contact.side1 = -1;
            contact.side2 = -1;
            if (++GeomCount >= (flags & 0xFFFF)) {
                return GeomCount;
            }
            contact = contacts.get(contactPos += skip);
        }
        this.dVector3Add(C, G1Pos2, contact.pos);
        contact.depth = planeDepth - planevec.dot(contact.pos);
        if (!(contact.depth >= 0.0)) return GeomCount;
        CollideCylinderPlane.dVector3Copy(PlaneNormal, contact.normal);
        contact.g1 = cylinder;
        contact.g2 = plane;
        contact.side1 = -1;
        contact.side2 = -1;
        if (++GeomCount < (flags & 0xFFFF)) return GeomCount;
        return GeomCount;
    }

    @Override
    public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
        return this.dCollideCylinderPlane((DxCylinder)o1, (DxPlane)o2, flags, contacts, 1);
    }
}

