/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.math.DVector4;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBox;
import org.ode4j.ode.internal.DxCollisionUtil;
import org.ode4j.ode.internal.DxCylinder;

class CollideCylinderBox
extends DxCollisionUtil
implements DColliderFn {
    private static final int MAX_CYLBOX_CLIP_POINTS = 16;
    private static final int nCYLINDER_AXIS = 2;
    private static final int nCYLINDER_SEGMENT = 8;

    CollideCylinderBox() {
    }

    private int dCollideCylinderBox(DxCylinder o1, DxBox o2, int flags, DContactGeomBuffer contacts, int skip) {
        Common.dIASSERT(skip >= 1);
        Common.dIASSERT((flags & 0xFFFF) >= 1);
        sCylinderBoxData cData = new sCylinderBoxData(o1, o2, flags, contacts, skip);
        return cData.PerformCollisionChecking();
    }

    @Override
    public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
        return this.dCollideCylinderBox((DxCylinder)o1, (DxBox)o2, flags, contacts, 1);
    }

    private class sCylinderBoxData {
        private DMatrix3 m_mCylinderRot = new DMatrix3();
        private DVector3 m_vCylinderPos = new DVector3();
        private DVector3 m_vCylinderAxis = new DVector3();
        private double m_fCylinderRadius;
        private double m_fCylinderSize;
        private DVector3[] m_avCylinderNormals = new DVector3[8];
        private DMatrix3 m_mBoxRot = new DMatrix3();
        private DVector3 m_vBoxPos = new DVector3();
        private DVector3 m_vBoxHalfSize = new DVector3();
        private DVector3[] m_avBoxVertices = new DVector3[8];
        private DVector3 m_vDiff = new DVector3();
        private DVector3 m_vNormal = new DVector3();
        private double m_fBestDepth;
        private double m_fBestrb;
        private double m_fBestrc;
        private int m_iBestAxis;
        private DVector3 m_vEp0 = new DVector3();
        private DVector3 m_vEp1 = new DVector3();
        private double m_fDepth0;
        private double m_fDepth1;
        private DxBox m_gBox;
        private DxCylinder m_gCylinder;
        private DContactGeomBuffer m_gContact;
        private int m_iFlags;
        private int m_nContacts;

        private sCylinderBoxData(DxCylinder cylinder, DxBox box, int flags, DContactGeomBuffer contacts, int skip) {
            this.m_gBox = box;
            this.m_gCylinder = cylinder;
            this.m_gContact = contacts;
            this.m_iFlags = flags;
            if (skip != 1) {
                throw new IllegalArgumentException("'skip' should be 1, but is: " + skip);
            }
            this.m_nContacts = 0;
        }

        private void _cldInitCylinderBox() {
            this.m_mCylinderRot.set(this.m_gCylinder.dGeomGetRotation());
            DVector3C pPosCyc = this.m_gCylinder.dGeomGetPosition();
            CollideCylinderBox.dVector3Copy(pPosCyc, this.m_vCylinderPos);
            CollideCylinderBox.dMat3GetCol(this.m_mCylinderRot, 2, this.m_vCylinderAxis);
            this.m_fCylinderRadius = this.m_gCylinder.getRadius();
            this.m_fCylinderSize = this.m_gCylinder.getLength();
            this.m_mBoxRot.set(this.m_gBox.dGeomGetRotation());
            this.m_vBoxPos.set(this.m_gBox.dGeomGetPosition());
            this.m_gBox.dGeomBoxGetLengths(this.m_vBoxHalfSize);
            this.m_vBoxHalfSize.scale(0.5);
            this.m_avBoxVertices[0] = new DVector3(this.m_vBoxHalfSize).scale(-1.0, 1.0, -1.0);
            this.m_avBoxVertices[1] = new DVector3(this.m_vBoxHalfSize).scale(1.0, 1.0, -1.0);
            this.m_avBoxVertices[2] = new DVector3(this.m_vBoxHalfSize).scale(-1.0, -1.0, -1.0);
            this.m_avBoxVertices[3] = new DVector3(this.m_vBoxHalfSize).scale(1.0, -1.0, -1.0);
            this.m_avBoxVertices[4] = new DVector3(this.m_vBoxHalfSize).scale(1.0, 1.0, 1.0);
            this.m_avBoxVertices[5] = new DVector3(this.m_vBoxHalfSize).scale(1.0, -1.0, 1.0);
            this.m_avBoxVertices[6] = new DVector3(this.m_vBoxHalfSize).scale(-1.0, -1.0, 1.0);
            this.m_avBoxVertices[7] = new DVector3(this.m_vBoxHalfSize).scale(-1.0, 1.0, 1.0);
            int i = 0;
            DVector3[] vTempBoxVertices = new DVector3[8];
            i = 0;
            while (i < 8) {
                vTempBoxVertices[i] = new DVector3();
                CollideCylinderBox.this.dMultiplyMat3Vec3(this.m_mBoxRot, this.m_avBoxVertices[i], vTempBoxVertices[i]);
                CollideCylinderBox.this.dVector3Add(vTempBoxVertices[i], this.m_vBoxPos, this.m_avBoxVertices[i]);
                ++i;
            }
            CollideCylinderBox.dVector3Subtract(this.m_vCylinderPos, this.m_vBoxPos, this.m_vDiff);
            this.m_fBestDepth = Common.MAX_FLOAT;
            this.m_vNormal.setZero();
            double fAngle = 0.39269908169872414;
            double fAngleIncrement = fAngle * 2.0;
            i = 0;
            while (i < 8) {
                this.m_avCylinderNormals[i] = new DVector3(-Common.dCos(fAngle), -Common.dSin(fAngle), 0.0);
                fAngle += fAngleIncrement;
                ++i;
            }
            this.m_fBestrb = 0.0;
            this.m_fBestrc = 0.0;
            this.m_iBestAxis = 0;
            this.m_nContacts = 0;
        }

        private boolean _cldTestAxis(DVector3 vInputNormal, int iAxis) {
            double fL = CollideCylinderBox.this.dVector3Length(vInputNormal);
            if (fL < 1.0E-5) {
                return true;
            }
            vInputNormal.normalize();
            double fdot1 = CollideCylinderBox.this.dVector3Dot(this.m_vCylinderAxis, vInputNormal);
            double frc = fdot1 > 1.0 ? this.m_fCylinderSize * 0.5 : (fdot1 < -1.0 ? this.m_fCylinderSize * 0.5 : Common.dFabs(fdot1 * (this.m_fCylinderSize * 0.5)) + this.m_fCylinderRadius * Common.dSqrt(1.0 - fdot1 * fdot1));
            DVector3 vTemp1 = new DVector3();
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 0, vTemp1);
            double frb = Common.dFabs(CollideCylinderBox.this.dVector3Dot(vTemp1, vInputNormal)) * this.m_vBoxHalfSize.get0();
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 1, vTemp1);
            frb += Common.dFabs(CollideCylinderBox.this.dVector3Dot(vTemp1, vInputNormal)) * this.m_vBoxHalfSize.get1();
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 2, vTemp1);
            double fd = CollideCylinderBox.this.dVector3Dot(this.m_vDiff, vInputNormal);
            double fDepth = frc + (frb += Common.dFabs(CollideCylinderBox.this.dVector3Dot(vTemp1, vInputNormal)) * this.m_vBoxHalfSize.get2());
            if (Common.dFabs(fd) > fDepth) {
                return false;
            }
            if ((fDepth -= Common.dFabs(fd)) < this.m_fBestDepth) {
                this.m_fBestDepth = fDepth;
                CollideCylinderBox.dVector3Copy(vInputNormal, this.m_vNormal);
                this.m_iBestAxis = iAxis;
                this.m_fBestrb = frb;
                this.m_fBestrc = frc;
                if (fd > 0.0) {
                    CollideCylinderBox.dVector3Inv(this.m_vNormal);
                }
            }
            return true;
        }

        private boolean _cldTestEdgeCircleAxis(DVector3 vCenterPoint, DVector3 vVx0, DVector3 vVx1, int iAxis) {
            DVector3 vDirEdge = new DVector3();
            CollideCylinderBox.dVector3Subtract(vVx1, vVx0, vDirEdge);
            vDirEdge.normalize();
            DVector3 vEStart = new DVector3();
            CollideCylinderBox.dVector3Copy(vVx0, vEStart);
            double fdot2 = CollideCylinderBox.this.dVector3Dot(vDirEdge, this.m_vCylinderAxis);
            if (Common.dFabs(fdot2) < 1.0E-5) {
                return true;
            }
            DVector3 vTemp1 = new DVector3();
            CollideCylinderBox.dVector3Subtract(vCenterPoint, vEStart, vTemp1);
            double fdot1 = CollideCylinderBox.this.dVector3Dot(vTemp1, this.m_vCylinderAxis);
            DVector3 vpnt = new DVector3();
            vpnt.eqSum((DVector3C)vEStart, vDirEdge, fdot1 / fdot2);
            DVector3 vTangent = new DVector3();
            CollideCylinderBox.dVector3Subtract(vCenterPoint, vpnt, vTemp1);
            CollideCylinderBox.dVector3Cross(vTemp1, this.m_vCylinderAxis, vTangent);
            DVector3 vAxis = new DVector3();
            CollideCylinderBox.dVector3Cross(vTangent, vDirEdge, vAxis);
            return this._cldTestAxis(vAxis, iAxis);
        }

        private int _cldTestSeparatingAxes() {
            this.m_fBestDepth = Common.MAX_FLOAT;
            this.m_iBestAxis = 0;
            this.m_fBestrb = 0.0;
            this.m_fBestrc = 0.0;
            this.m_nContacts = 0;
            DVector3 vAxis = new DVector3();
            double fEpsilon = 1.0E-6;
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 0, vAxis);
            if (!this._cldTestAxis(vAxis, 1)) {
                return 0;
            }
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 1, vAxis);
            if (!this._cldTestAxis(vAxis, 2)) {
                return 0;
            }
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 2, vAxis);
            if (!this._cldTestAxis(vAxis, 3)) {
                return 0;
            }
            CollideCylinderBox.dVector3Copy(this.m_vCylinderAxis, vAxis);
            if (!this._cldTestAxis(vAxis, 4)) {
                return 0;
            }
            CollideCylinderBox.this.dVector3CrossMat3Col(this.m_mBoxRot, 0, this.m_vCylinderAxis, vAxis);
            if (CollideCylinderBox.this.dVector3LengthSquare(vAxis) > 1.0E-6 && !this._cldTestAxis(vAxis, 5)) {
                return 0;
            }
            CollideCylinderBox.this.dVector3CrossMat3Col(this.m_mBoxRot, 1, this.m_vCylinderAxis, vAxis);
            if (CollideCylinderBox.this.dVector3LengthSquare(vAxis) > 1.0E-6 && !this._cldTestAxis(vAxis, 6)) {
                return 0;
            }
            CollideCylinderBox.this.dVector3CrossMat3Col(this.m_mBoxRot, 2, this.m_vCylinderAxis, vAxis);
            if (CollideCylinderBox.this.dVector3LengthSquare(vAxis) > 1.0E-6 && !this._cldTestAxis(vAxis, 7)) {
                return 0;
            }
            int i = 0;
            DVector3 vTemp1 = new DVector3();
            DVector3 vTemp2 = new DVector3();
            i = 0;
            while (i < 8) {
                CollideCylinderBox.dVector3Subtract(this.m_avBoxVertices[i], this.m_vCylinderPos, vTemp1);
                CollideCylinderBox.dVector3Cross(this.m_vCylinderAxis, vTemp1, vTemp2);
                CollideCylinderBox.dVector3Cross(this.m_vCylinderAxis, vTemp2, vAxis);
                if (CollideCylinderBox.this.dVector3LengthSquare(vAxis) > 1.0E-6 && !this._cldTestAxis(vAxis, 8 + i)) {
                    return 0;
                }
                ++i;
            }
            DVector3 vcc = new DVector3();
            vcc.eqSum((DVector3C)this.m_vCylinderPos, this.m_vCylinderAxis, this.m_fCylinderSize * 0.5);
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[1], this.m_avBoxVertices[0], 16)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[1], this.m_avBoxVertices[3], 17)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[2], this.m_avBoxVertices[3], 18)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[2], this.m_avBoxVertices[0], 19)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[4], this.m_avBoxVertices[1], 20)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[4], this.m_avBoxVertices[7], 21)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[0], this.m_avBoxVertices[7], 22)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[5], this.m_avBoxVertices[3], 23)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[5], this.m_avBoxVertices[6], 24)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[2], this.m_avBoxVertices[6], 25)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[4], this.m_avBoxVertices[5], 26)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[6], this.m_avBoxVertices[7], 27)) {
                return 0;
            }
            vcc.eqSum((DVector3C)this.m_vCylinderPos, this.m_vCylinderAxis, -this.m_fCylinderSize * 0.5);
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[1], this.m_avBoxVertices[0], 28)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[1], this.m_avBoxVertices[3], 29)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[2], this.m_avBoxVertices[3], 30)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[2], this.m_avBoxVertices[0], 31)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[4], this.m_avBoxVertices[1], 32)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[4], this.m_avBoxVertices[7], 33)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[0], this.m_avBoxVertices[7], 34)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[5], this.m_avBoxVertices[3], 35)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[5], this.m_avBoxVertices[6], 36)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[2], this.m_avBoxVertices[6], 37)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[4], this.m_avBoxVertices[5], 38)) {
                return 0;
            }
            if (!this._cldTestEdgeCircleAxis(vcc, this.m_avBoxVertices[6], this.m_avBoxVertices[7], 39)) {
                return 0;
            }
            return 1;
        }

        private boolean _cldClipCylinderToBox() {
            Common.dIASSERT(this.m_nContacts != (this.m_iFlags & 0xFFFF));
            DVector3 vN = new DVector3();
            double fTemp1 = CollideCylinderBox.this.dVector3Dot(this.m_vCylinderAxis, this.m_vNormal);
            vN.eqSum((DVector3C)this.m_vNormal, this.m_vCylinderAxis, -fTemp1);
            OdeMath.dNormalize3(vN);
            DVector3 vCposTrans = new DVector3();
            vCposTrans.eqSum((DVector3C)this.m_vCylinderPos, vN, this.m_fCylinderRadius);
            this.m_vEp0.eqSum((DVector3C)vCposTrans, this.m_vCylinderAxis, this.m_fCylinderSize * 0.5);
            this.m_vEp1.eqSum((DVector3C)vCposTrans, this.m_vCylinderAxis, -this.m_fCylinderSize * 0.5);
            this.m_vEp0.sub(this.m_vBoxPos);
            this.m_vEp1.sub(this.m_vBoxPos);
            DVector3 vTemp1 = new DVector3();
            DVector4 plPlane = new DVector4();
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 0, vTemp1);
            CollideCylinderBox.dConstructPlane(vTemp1, this.m_vBoxHalfSize.get0(), plPlane);
            if (!CollideCylinderBox.dClipEdgeToPlane(this.m_vEp0, this.m_vEp1, plPlane)) {
                return false;
            }
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 1, vTemp1);
            CollideCylinderBox.dConstructPlane(vTemp1, this.m_vBoxHalfSize.get1(), plPlane);
            if (!CollideCylinderBox.dClipEdgeToPlane(this.m_vEp0, this.m_vEp1, plPlane)) {
                return false;
            }
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 2, vTemp1);
            CollideCylinderBox.dConstructPlane(vTemp1, this.m_vBoxHalfSize.get2(), plPlane);
            if (!CollideCylinderBox.dClipEdgeToPlane(this.m_vEp0, this.m_vEp1, plPlane)) {
                return false;
            }
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 0, vTemp1);
            CollideCylinderBox.dVector3Inv(vTemp1);
            CollideCylinderBox.dConstructPlane(vTemp1, this.m_vBoxHalfSize.get0(), plPlane);
            if (!CollideCylinderBox.dClipEdgeToPlane(this.m_vEp0, this.m_vEp1, plPlane)) {
                return false;
            }
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 1, vTemp1);
            CollideCylinderBox.dVector3Inv(vTemp1);
            CollideCylinderBox.dConstructPlane(vTemp1, this.m_vBoxHalfSize.get1(), plPlane);
            if (!CollideCylinderBox.dClipEdgeToPlane(this.m_vEp0, this.m_vEp1, plPlane)) {
                return false;
            }
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, 2, vTemp1);
            CollideCylinderBox.dVector3Inv(vTemp1);
            CollideCylinderBox.dConstructPlane(vTemp1, this.m_vBoxHalfSize.get2(), plPlane);
            if (!CollideCylinderBox.dClipEdgeToPlane(this.m_vEp0, this.m_vEp1, plPlane)) {
                return false;
            }
            this.m_fDepth0 = this.m_fBestrb + CollideCylinderBox.this.dVector3Dot(this.m_vEp0, this.m_vNormal);
            this.m_fDepth1 = this.m_fBestrb + CollideCylinderBox.this.dVector3Dot(this.m_vEp1, this.m_vNormal);
            if (this.m_fDepth0 < 0.0) {
                this.m_fDepth0 = 0.0;
            }
            if (this.m_fDepth1 < 0.0) {
                this.m_fDepth1 = 0.0;
            }
            this.m_vEp0.add(this.m_vBoxPos);
            this.m_vEp1.add(this.m_vBoxPos);
            DContactGeom Contact0 = this.m_gContact.getSafe(this.m_iFlags, this.m_nContacts);
            Contact0.depth = this.m_fDepth0;
            CollideCylinderBox.dVector3Copy(this.m_vNormal, Contact0.normal);
            CollideCylinderBox.dVector3Copy(this.m_vEp0, Contact0.pos);
            Contact0.g1 = this.m_gCylinder;
            Contact0.g2 = this.m_gBox;
            Contact0.side1 = -1;
            Contact0.side2 = -1;
            CollideCylinderBox.dVector3Inv(Contact0.normal);
            ++this.m_nContacts;
            if (this.m_nContacts != (this.m_iFlags & 0xFFFF)) {
                DContactGeom Contact1 = this.m_gContact.getSafe(this.m_iFlags, this.m_nContacts);
                Contact1.depth = this.m_fDepth1;
                CollideCylinderBox.dVector3Copy(this.m_vNormal, Contact1.normal);
                CollideCylinderBox.dVector3Copy(this.m_vEp1, Contact1.pos);
                Contact1.g1 = this.m_gCylinder;
                Contact1.g2 = this.m_gBox;
                Contact0.side1 = -1;
                Contact0.side2 = -1;
                CollideCylinderBox.dVector3Inv(Contact1.normal);
                ++this.m_nContacts;
            }
            return true;
        }

        private void _cldClipBoxToCylinder() {
            int iB2;
            int iB1;
            int iB0;
            Common.dIASSERT(this.m_nContacts != (this.m_iFlags & 0xFFFF));
            DVector3 vCylinderCirclePos = new DVector3();
            DVector3 vCylinderCircleNormal_Rel = new DVector3();
            if (CollideCylinderBox.this.dVector3Dot(this.m_vCylinderAxis, this.m_vNormal) > 0.0) {
                vCylinderCirclePos.eqSum((DVector3C)this.m_vCylinderPos, this.m_vCylinderAxis, this.m_fCylinderSize * 0.5);
                vCylinderCircleNormal_Rel.set(2, -1.0);
            } else {
                vCylinderCirclePos.eqSum((DVector3C)this.m_vCylinderPos, this.m_vCylinderAxis, -this.m_fCylinderSize * 0.5);
                vCylinderCircleNormal_Rel.set(2, 1.0);
            }
            DVector3 vNr = new DVector3();
            DMatrix3 mBoxInv = new DMatrix3();
            CollideCylinderBox.this.dMatrix3Inv(this.m_mBoxRot, mBoxInv);
            CollideCylinderBox.this.dMultiplyMat3Vec3(mBoxInv, this.m_vNormal, vNr);
            DVector3 vAbsNormal = new DVector3(vNr);
            vAbsNormal.eqAbs();
            if (vAbsNormal.get1() > vAbsNormal.get0()) {
                if (vAbsNormal.get0() > vAbsNormal.get2()) {
                    iB0 = 1;
                    iB1 = 0;
                    iB2 = 2;
                } else if (vAbsNormal.get1() > vAbsNormal.get2()) {
                    iB0 = 1;
                    iB1 = 2;
                    iB2 = 0;
                } else {
                    iB0 = 2;
                    iB1 = 1;
                    iB2 = 0;
                }
            } else if (vAbsNormal.get1() > vAbsNormal.get2()) {
                iB0 = 0;
                iB1 = 1;
                iB2 = 2;
            } else if (vAbsNormal.get0() > vAbsNormal.get2()) {
                iB0 = 0;
                iB1 = 2;
                iB2 = 1;
            } else {
                iB0 = 2;
                iB1 = 0;
                iB2 = 1;
            }
            DVector3 vCenter = new DVector3();
            DVector3 vTemp = new DVector3();
            if (vNr.get(iB0) > 0.0) {
                CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, iB0, vTemp);
                vCenter.eqSum((DVector3C)this.m_vBoxPos, vTemp, -this.m_vBoxHalfSize.get(iB0));
            } else {
                CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, iB0, vTemp);
                vCenter.eqSum((DVector3C)this.m_vBoxPos, vTemp, this.m_vBoxHalfSize.get(iB0));
            }
            DVector3[] avPoints = new DVector3[4];
            DVector3[] avTempArray1 = new DVector3[16];
            DVector3[] avTempArray2 = new DVector3[16];
            int ii = 0;
            while (ii < avPoints.length) {
                avPoints[ii] = new DVector3();
                ++ii;
            }
            int i = 0;
            i = 0;
            while (i < 16) {
                avTempArray1[i] = new DVector3();
                avTempArray2[i] = new DVector3();
                ++i;
            }
            DVector3 vAxis1 = new DVector3();
            DVector3 vAxis2 = new DVector3();
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, iB1, vAxis1);
            CollideCylinderBox.dMat3GetCol(this.m_mBoxRot, iB2, vAxis2);
            avPoints[0].eqSum(vAxis1, this.m_vBoxHalfSize.get(iB1), (DVector3C)vAxis2, -this.m_vBoxHalfSize.get(iB2));
            avPoints[0].add(vCenter);
            avPoints[1].eqSum(vAxis1, -this.m_vBoxHalfSize.get(iB1), (DVector3C)vAxis2, -this.m_vBoxHalfSize.get(iB2));
            avPoints[1].add(vCenter);
            avPoints[2].eqSum(vAxis1, -this.m_vBoxHalfSize.get(iB1), (DVector3C)vAxis2, this.m_vBoxHalfSize.get(iB2));
            avPoints[2].add(vCenter);
            avPoints[3].eqSum(vAxis1, this.m_vBoxHalfSize.get(iB1), (DVector3C)vAxis2, this.m_vBoxHalfSize.get(iB2));
            avPoints[3].add(vCenter);
            DMatrix3 mCylinderInv = new DMatrix3();
            CollideCylinderBox.this.dMatrix3Inv(this.m_mCylinderRot, mCylinderInv);
            i = 0;
            while (i < 4) {
                CollideCylinderBox.dVector3Subtract(avPoints[i], vCylinderCirclePos, vTemp);
                CollideCylinderBox.this.dMultiplyMat3Vec3(mCylinderInv, vTemp, avPoints[i]);
                ++i;
            }
            int iTmpCounter1 = 0;
            int iTmpCounter2 = 0;
            DVector4 plPlane = new DVector4();
            CollideCylinderBox.dConstructPlane(vCylinderCircleNormal_Rel, 0.0, plPlane);
            iTmpCounter1 = CollideCylinderBox.dClipPolyToPlane(avPoints, 4, avTempArray1, plPlane);
            int nCircleSegment = 0;
            nCircleSegment = 0;
            while (nCircleSegment < 8) {
                CollideCylinderBox.dConstructPlane(this.m_avCylinderNormals[nCircleSegment], this.m_fCylinderRadius, plPlane);
                if (nCircleSegment % 2 == 0) {
                    iTmpCounter2 = CollideCylinderBox.dClipPolyToPlane(avTempArray1, iTmpCounter1, avTempArray2, plPlane);
                } else {
                    iTmpCounter1 = CollideCylinderBox.dClipPolyToPlane(avTempArray2, iTmpCounter2, avTempArray1, plPlane);
                }
                Common.dIASSERT(iTmpCounter1 >= 0 && iTmpCounter1 <= 16);
                Common.dIASSERT(iTmpCounter2 >= 0 && iTmpCounter2 <= 16);
                ++nCircleSegment;
            }
            DVector3 vPoint = new DVector3();
            if (nCircleSegment % 2 != 0) {
                i = 0;
                while (i < iTmpCounter2) {
                    OdeMath.dMultiply0_331(vPoint, (DMatrix3C)this.m_mCylinderRot, (DVector3C)avTempArray2[i]);
                    vPoint.add(vCylinderCirclePos);
                    CollideCylinderBox.dVector3Subtract(vPoint, this.m_vCylinderPos, vTemp);
                    double ftmpdot = CollideCylinderBox.this.dVector3Dot(vTemp, this.m_vNormal);
                    double fTempDepth = this.m_fBestrc - ftmpdot;
                    if (fTempDepth > 0.0) {
                        DContactGeom Contact0 = this.m_gContact.getSafe(this.m_iFlags, this.m_nContacts);
                        Contact0.depth = fTempDepth;
                        CollideCylinderBox.dVector3Copy(this.m_vNormal, Contact0.normal);
                        CollideCylinderBox.dVector3Copy(vPoint, Contact0.pos);
                        Contact0.g1 = this.m_gCylinder;
                        Contact0.g2 = this.m_gBox;
                        Contact0.side1 = -1;
                        Contact0.side2 = -1;
                        CollideCylinderBox.dVector3Inv(Contact0.normal);
                        ++this.m_nContacts;
                        if (this.m_nContacts == (this.m_iFlags & 0xFFFF)) break;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < iTmpCounter1) {
                    OdeMath.dMultiply0_331(vPoint, (DMatrix3C)this.m_mCylinderRot, (DVector3C)avTempArray1[i]);
                    vPoint.add(vCylinderCirclePos);
                    CollideCylinderBox.dVector3Subtract(vPoint, this.m_vCylinderPos, vTemp);
                    double ftmpdot = CollideCylinderBox.this.dVector3Dot(vTemp, this.m_vNormal);
                    double fTempDepth = this.m_fBestrc - ftmpdot;
                    if (fTempDepth > 0.0) {
                        DContactGeom Contact0 = this.m_gContact.getSafe(this.m_iFlags, this.m_nContacts);
                        Contact0.depth = fTempDepth;
                        CollideCylinderBox.dVector3Copy(this.m_vNormal, Contact0.normal);
                        CollideCylinderBox.dVector3Copy(vPoint, Contact0.pos);
                        Contact0.g1 = this.m_gCylinder;
                        Contact0.g2 = this.m_gBox;
                        Contact0.side1 = -1;
                        Contact0.side2 = -1;
                        CollideCylinderBox.dVector3Inv(Contact0.normal);
                        ++this.m_nContacts;
                        if (this.m_nContacts == (this.m_iFlags & 0xFFFF)) break;
                    }
                    ++i;
                }
            }
        }

        private int PerformCollisionChecking() {
            this._cldInitCylinderBox();
            if (this._cldTestSeparatingAxes() == 0) {
                return 0;
            }
            if (this.m_iBestAxis == 0) {
                Common.dIASSERT(false);
                return 0;
            }
            double fdot = CollideCylinderBox.this.dVector3Dot(this.m_vNormal, this.m_vCylinderAxis);
            if (Common.dFabs(fdot) < 0.9) {
                if (!this._cldClipCylinderToBox()) {
                    return 0;
                }
            } else {
                this._cldClipBoxToCylinder();
            }
            return this.m_nContacts;
        }
    }
}

