/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal;

import org.cpp4j.java.RefDouble;
import org.cpp4j.java.RefInt;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DColliderFn;
import org.ode4j.ode.DContactGeom;
import org.ode4j.ode.DContactGeomBuffer;
import org.ode4j.ode.DGeom;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBox;
import org.ode4j.ode.internal.DxGeom;
import org.ode4j.ode.internal.DxPlane;

public class CollideBoxPlane
implements DColliderFn {
    int dCollideBoxPlane(DxBox o1, DxPlane o2, int flags, DContactGeomBuffer contacts, int skip) {
        int go;
        int p3;
        int p2;
        int p1;
        Common.dIASSERT(skip == 1);
        Common.dIASSERT((flags & 0xFFFF) >= 1);
        DxBox box = o1;
        DxPlane plane = o2;
        DContactGeom contact = contacts.get(0);
        contact.g1 = o1;
        contact.g2 = o2;
        contact.side1 = -1;
        contact.side2 = -1;
        RefInt ret = new RefInt();
        DMatrix3C R = o1.final_posr().R();
        DVector3C n = plane.getNormal();
        double Q1 = OdeMath.dCalcVectorDot3_14(n, R, 0);
        double Q2 = OdeMath.dCalcVectorDot3_14(n, R, 1);
        double Q3 = OdeMath.dCalcVectorDot3_14(n, R, 2);
        double[] A = new double[]{box.side.get0() * Q1, box.side.get1() * Q2, box.side.get2() * Q3};
        double[] B = new double[]{Common.dFabs(A[0]), Common.dFabs(A[1]), Common.dFabs(A[2])};
        RefDouble depth = new RefDouble(plane.getDepth() + 0.5 * (B[0] + B[1] + B[2]) - n.dot(o1.final_posr().pos()));
        if (depth.get() < 0.0) {
            return 0;
        }
        int maxc = flags & 0xFFFF;
        if (maxc > 4) {
            maxc = 4;
        }
        DVector3 p = new DVector3();
        p.set(o1.final_posr().pos());
        int i = 0;
        while (i < 3) {
            if (A[i] > 0.0) {
                p.eqSum((DVector3C)p, R.columnAsNewVector(i), -0.5 * box.side.get(i));
            } else {
                p.eqSum((DVector3C)p, R.columnAsNewVector(i), 0.5 * box.side.get(i));
            }
            ++i;
        }
        contact.pos.set(p);
        contact.depth = depth.get();
        ret.set(1);
        if (maxc == 1) {
            this.done(ret, contacts, skip, o1, o2, maxc, depth.get(), p, n);
            return ret.get();
        }
        if (B[0] < B[1]) {
            if (B[2] < B[0]) {
                p1 = 1;
                p2 = 2;
                p3 = 3;
                go = B[0] < B[1] ? 21 : 22;
            } else {
                p1 = 1;
                p2 = 0;
                p3 = 1;
                go = B[1] < B[2] ? 22 : 23;
            }
        } else if (B[2] < B[1]) {
            p1 = 1;
            p2 = 2;
            p3 = 3;
            go = B[0] < B[1] ? 21 : 22;
        } else {
            p1 = 1;
            p2 = 1;
            p3 = 2;
            go = B[0] < B[2] ? 21 : 23;
        }
        this.BAR2(p1, p2, p3, depth, ret, contacts, skip, A, B, o1, o2, p, R, box.side, maxc, n);
        if (maxc != 2) {
            if (go == 21) {
                if (!this.BAR2(2, 0, 1, depth, ret, contacts, skip, A, B, o1, o2, p, R, box.side, maxc, n)) {
                    return ret.get();
                }
            } else if (go == 22) {
                if (!this.BAR2(2, 1, 2, depth, ret, contacts, skip, A, B, o1, o2, p, R, box.side, maxc, n)) {
                    return ret.get();
                }
            } else if (go == 23) {
                if (!this.BAR2(2, 2, 3, depth, ret, contacts, skip, A, B, o1, o2, p, R, box.side, maxc, n)) {
                    return ret.get();
                }
            } else {
                throw new IllegalStateException("go=" + go);
            }
        }
        this.done(ret, contacts, skip, o1, o2, maxc, depth.get(), p, n);
        return ret.get();
    }

    private final void FOO2(int i, int j, int op, DContactGeomBuffer contacts, int skip, DVector3 p, DMatrix3C R, DVector3 side) {
        contacts.get((int)(i * skip)).pos.eqSum((DVector3C)p, R.viewCol(j), (double)op * side.get(j));
    }

    private final boolean BAR2(int ctact, int side, int sideinc, RefDouble depth, RefInt ret, DContactGeomBuffer contacts, int skip, double[] A, double[] B, DxGeom o1, DxGeom o2, DVector3 p, DMatrix3C R, DVector3 boxSide, int maxc, DVector3C n) {
        if (depth.get() - B[sideinc - 1] < 0.0) {
            this.done(ret, contacts, skip, o1, o2, maxc, depth.get(), p, n);
            return false;
        }
        if (A[sideinc - 1] > 0.0) {
            this.FOO2(ctact, side, 1, contacts, skip, p, R, boxSide);
        } else {
            this.FOO2(ctact, side, -1, contacts, skip, p, R, boxSide);
        }
        contacts.get((int)(ctact * skip)).depth = depth.get() - B[sideinc - 1];
        ret.inc();
        return true;
    }

    private final void done(RefInt ret, DContactGeomBuffer contacts, int skip, DxGeom o1, DxGeom o2, int maxc, double depth, DVector3C p, DVector3C n) {
        double d4;
        if (maxc == 4 && ret.get() == 3 && (d4 = contacts.get((int)(1 * skip)).depth + contacts.get((int)(2 * skip)).depth - depth) > 0.0) {
            DContactGeom c3 = contacts.get(3 * skip);
            c3.pos.set(contacts.get((int)(1 * skip)).pos).add(contacts.get((int)(2 * skip)).pos).sub(p);
            c3.depth = d4;
            ret.inc();
        }
        int i = 0;
        while (i < ret.get()) {
            DContactGeom contact = contacts.get(i * skip);
            contact.g1 = o1;
            contact.g2 = o2;
            contact.side1 = -1;
            contact.side2 = -1;
            contact.normal.set(n);
            ++i;
        }
    }

    @Override
    public int dColliderFn(DGeom o1, DGeom o2, int flags, DContactGeomBuffer contacts) {
        return this.dCollideBoxPlane((DxBox)o1, (DxPlane)o2, flags, contacts, 1);
    }
}

