/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode;

import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.math.DVector3View;
import org.ode4j.math.DVector4;
import org.ode4j.ode.DRotation;
import org.ode4j.ode.internal.Common;

public class OdeMath
extends DRotation {
    private OdeMath() {
    }

    public static void dAddScaledVectors3(DVector3 res, DVector3C a, DVector3C b, double a_scale, double b_scale) {
        double res_0 = a_scale * a.get0() + b_scale * b.get0();
        double res_1 = a_scale * a.get1() + b_scale * b.get1();
        double res_2 = a_scale * a.get2() + b_scale * b.get2();
        res.set(res_0, res_1, res_2);
    }

    public static void dNegateVector3(double[] a, int ofs) {
        a[ofs + 0] = -a[ofs + 0];
        a[ofs + 1] = -a[ofs + 1];
        a[ofs + 2] = -a[ofs + 2];
    }

    public static void dCopyVector3(double[] a, int ofs, DVector3C b) {
        a[0 + ofs] = b.get0();
        a[1 + ofs] = b.get1();
        a[2 + ofs] = b.get2();
    }

    public static void dCopyVector3(float[] a, int ofs, DVector3C b) {
        a[0 + ofs] = (float)b.get0();
        a[1 + ofs] = (float)b.get1();
        a[2 + ofs] = (float)b.get2();
    }

    public static void dCopyNegatedVector3(double[] a, int ofs, DVector3C b) {
        a[0 + ofs] = -b.get0();
        a[1 + ofs] = -b.get1();
        a[2 + ofs] = -b.get2();
    }

    private static double dDOTpq(double[] a, double[] b, int p, int q) {
        return a[0] * b[0] + a[p] * b[q] + a[2 * p] * b[2 * q];
    }

    private static double dDOTpq(double[] a, int o1, double[] b, int o2, int p, int q) {
        return a[0 + o1] * b[0 + o2] + a[p + o1] * b[q + o2] + a[2 * p + o1] * b[2 * q + o2];
    }

    private static double dDOTpq(double[] a, int o1, DVector3C b) {
        return a[o1] * b.get0() + a[1 + o1] * b.get1() + a[2 + o1] * b.get2();
    }

    private static double dDOTpq(DVector3C a, double[] b, int o2, int q) {
        return a.get0() * b[0 + o2] + a.get1() * b[q + o2] + a.get2() * b[2 * q + o2];
    }

    @Deprecated
    public static double dDOT(DVector3C a, DVector3C b) {
        return a.dot(b);
    }

    public static double dCalcVectorDot3(DVector3C a, DVector3C b) {
        return a.dot(b);
    }

    public static double dCalcVectorDot3(double[] a, int o1, DVector3C b) {
        return OdeMath.dDOTpq(a, o1, b);
    }

    public static double dCalcVectorDot3(DVector3C a, double[] b, int o2) {
        return OdeMath.dDOTpq(a, b, o2, 1);
    }

    public static double dCalcVectorDot3(double[] a, double[] b) {
        return OdeMath.dDOTpq(a, b, 1, 1);
    }

    public static double dCalcVectorDot3(double[] a, int o1, double[] b, int o2) {
        return OdeMath.dDOTpq(a, o1, b, o2, 1, 1);
    }

    public static double dCalcVectorDot3_14(DVector3C a, DMatrix3C b, int o2) {
        return a.dotCol(b, o2);
    }

    public static double dCalcVectorDot3_41(DMatrix3C a, int o1, DVector3C b) {
        return a.dotCol(o1, b);
    }

    public static double dCalcVectorDot3_44(DMatrix3C a, int o1, DMatrix3C b, int o2) {
        return a.dotColCol(o1, b, o2);
    }

    public static double dCalcVectorDot3_14(double[] a, int o1, double[] b, int o2) {
        return OdeMath.dDOTpq(a, o1, b, o2, 1, 4);
    }

    public static double dCalcVectorDot3_14(DVector3C a, double[] b, int o2) {
        return OdeMath.dDOTpq(a, b, o2, 4);
    }

    public static void dCROSS(DVector3 a, OP op, DVector3C b, DVector3C c) {
        if (op == OP.EQ) {
            OdeMath.dCalcVectorCross3(a, b, c);
        } else if (op == OP.ADD_EQ) {
            OdeMath.dAddVectorCross3(a, b, c);
        } else if (op == OP.SUB_EQ) {
            OdeMath.dSubtractVectorCross3(a, b, c);
        } else {
            throw new UnsupportedOperationException(op.name());
        }
    }

    public static void dCalcVectorCross3(DVector3 a, DVector3C b, DVector3C c) {
        a.set0(b.get1() * c.get2() - b.get2() * c.get1());
        a.set1(b.get2() * c.get0() - b.get0() * c.get2());
        a.set2(b.get0() * c.get1() - b.get1() * c.get0());
    }

    public static void dAddVectorCross3(DVector3 a, DVector3C b, DVector3C c) {
        a.add0(b.get1() * c.get2() - b.get2() * c.get1());
        a.add1(b.get2() * c.get0() - b.get0() * c.get2());
        a.add2(b.get0() * c.get1() - b.get1() * c.get0());
    }

    public static void dSubtractVectorCross3(DVector3 a, DVector3C b, DVector3C c) {
        a.add0(-b.get1() * c.get2() + b.get2() * c.get1());
        a.add1(-b.get2() * c.get0() + b.get0() * c.get2());
        a.add2(-b.get0() * c.get1() + b.get1() * c.get0());
    }

    public static void dCalcVectorCross3(double[] a, int ofs, DVector3C b, DVector3C c) {
        a[0 + ofs] = b.get1() * c.get2() - b.get2() * c.get1();
        a[1 + ofs] = b.get2() * c.get0() - b.get0() * c.get2();
        a[2 + ofs] = b.get0() * c.get1() - b.get1() * c.get0();
    }

    public static void dCalcVectorCross3(DVector3View a, DVector3View b, DVector3View c) {
        a.set0(b.get1() * c.get2() - b.get2() * c.get1());
        a.set1(b.get2() * c.get0() - b.get0() * c.get2());
        a.set2(b.get0() * c.get1() - b.get1() * c.get0());
    }

    public static void dSubtractVectorCross3(DVector3 a, DVector3C b, DMatrix3C c) {
        a.add0(-(b.get1() * c.get02() - b.get2() * c.get01()));
        a.add1(-(b.get2() * c.get00() - b.get0() * c.get02()));
        a.add2(-(b.get0() * c.get01() - b.get1() * c.get00()));
    }

    public static void dSetCrossMatrixPlus(DMatrix3 A, DVector3C a) {
        A.set01(-a.get2());
        A.set02(a.get1());
        A.set10(a.get2());
        A.set12(-a.get0());
        A.set20(-a.get1());
        A.set21(a.get0());
    }

    public static void dSetCrossMatrixMinus(DMatrix3 A, DVector3C a) {
        A.set01(a.get2());
        A.set02(-a.get1());
        A.set10(-a.get2());
        A.set12(a.get0());
        A.set20(a.get1());
        A.set21(-a.get0());
    }

    public static void dSetCrossMatrixPlus(double[] A, int ofs, DVector3C a, int skip) {
        A[ofs + 1] = -a.get2();
        A[ofs + 2] = a.get1();
        A[ofs + skip + 0] = a.get2();
        A[ofs + skip + 2] = -a.get0();
        A[ofs + 2 * skip + 0] = -a.get1();
        A[ofs + 2 * skip + 1] = a.get0();
    }

    public static void dSetCrossMatrixMinus(double[] A, int ofs, DVector3C a, int skip) {
        A[ofs + 1] = a.get2();
        A[ofs + 2] = -a.get1();
        A[ofs + skip + 0] = -a.get2();
        A[ofs + skip + 2] = a.get0();
        A[ofs + 2 * skip + 0] = a.get1();
        A[ofs + 2 * skip + 1] = -a.get0();
    }

    public static void dCROSSMAT(DMatrix3 A, DVector3C a, int skip, int plus, int minus) {
        A.set01((double)minus * a.get2());
        A.set02((double)plus * a.get1());
        A.set10((double)plus * a.get2());
        A.set12((double)minus * a.get0());
        A.set20((double)minus * a.get1());
        A.set21((double)plus * a.get0());
    }

    public static void dCROSSMAT(double[] A, int ofs, DVector3C a, int skip, int plus, int minus) {
        A[ofs + 1] = (double)minus * a.get2();
        A[ofs + 2] = (double)plus * a.get1();
        A[ofs + skip + 0] = (double)plus * a.get2();
        A[ofs + skip + 2] = (double)minus * a.get0();
        A[ofs + 2 * skip + 0] = (double)minus * a.get1();
        A[ofs + 2 * skip + 1] = (double)plus * a.get0();
    }

    public static double dCalcPointsDistance3(DVector3C a, DVector3C b) {
        return a.distance(b);
    }

    @Deprecated
    public static double dDISTANCE(DVector3C a, DVector3C b) {
        return a.distance(b);
    }

    private static void dMULTIPLYOP0_331(DVector3 A, DMatrix3C B, DVector3C C) {
        A.set0(B.dotRow(0, C));
        A.set1(B.dotRow(1, C));
        A.set2(B.dotRow(2, C));
    }

    private static void dMULTIPLYOP0_331(DMatrix3 A, DMatrix3C B, DVector3C C) {
        A.set00(B.dotRow(0, C));
        A.set01(B.dotRow(1, C));
        A.set02(B.dotRow(2, C));
    }

    private static void dMULTIPLYOP0_331(DVector3 A, DMatrix3C B, double[] C, int c) {
        A.set0(B.dotRow(0, C, c));
        A.set1(B.dotRow(1, C, c));
        A.set2(B.dotRow(2, C, c));
    }

    private static void dMULTIPLYOP0_331(double[] A, int a, double[] B, int b, double[] C, int c) {
        A[0 + a] = OdeMath.dCalcVectorDot3(B, 0 + b, C, c);
        A[1 + a] = OdeMath.dCalcVectorDot3(B, 4 + b, C, c);
        A[2 + a] = OdeMath.dCalcVectorDot3(B, 8 + b, C, c);
    }

    private static void dMULTIPLYOP0_331(double[] A, int a, double[] B, int b, DVector3C C) {
        A[0 + a] = OdeMath.dCalcVectorDot3(B, 0 + b, C);
        A[1 + a] = OdeMath.dCalcVectorDot3(B, 4 + b, C);
        A[2 + a] = OdeMath.dCalcVectorDot3(B, 8 + b, C);
    }

    private static void dMULTIPLYOP1_331(DVector3 A, DMatrix3C B, DVector3C C) {
        A.set0(B.dotCol(0, C));
        A.set1(B.dotCol(1, C));
        A.set2(B.dotCol(2, C));
    }

    private static void dMULTIPLYOP0_133(DVector3 A, DVector3C B, DMatrix3C C) {
        A.set0(B.dotCol(C, 0));
        A.set1(B.dotCol(C, 1));
        A.set2(B.dotCol(C, 2));
    }

    private static void dMULTIPLYOP0_333(double[] A, int a, DMatrix3C B, DMatrix3C C) {
        A[0 + a] = B.dotRowCol(0, C, 0);
        A[1 + a] = B.dotRowCol(0, C, 1);
        A[2 + a] = B.dotRowCol(0, C, 2);
        A[4 + a] = B.dotRowCol(1, C, 0);
        A[5 + a] = B.dotRowCol(1, C, 1);
        A[6 + a] = B.dotRowCol(1, C, 2);
        A[8 + a] = B.dotRowCol(2, C, 0);
        A[9 + a] = B.dotRowCol(2, C, 1);
        A[10 + a] = B.dotRowCol(2, C, 2);
    }

    private static void dMULTIPLYOP0_333(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        A.set00(B.dotRowCol(0, C, 0));
        A.set01(B.dotRowCol(0, C, 1));
        A.set02(B.dotRowCol(0, C, 2));
        A.set10(B.dotRowCol(1, C, 0));
        A.set11(B.dotRowCol(1, C, 1));
        A.set12(B.dotRowCol(1, C, 2));
        A.set20(B.dotRowCol(2, C, 0));
        A.set21(B.dotRowCol(2, C, 1));
        A.set22(B.dotRowCol(2, C, 2));
    }

    private static void dMULTIPLYOP1_333(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        A.set00(OdeMath.dCalcVectorDot3_44(B, 0, C, 0));
        A.set01(OdeMath.dCalcVectorDot3_44(B, 0, C, 1));
        A.set02(OdeMath.dCalcVectorDot3_44(B, 0, C, 2));
        A.set10(OdeMath.dCalcVectorDot3_44(B, 1, C, 0));
        A.set11(OdeMath.dCalcVectorDot3_44(B, 1, C, 1));
        A.set12(OdeMath.dCalcVectorDot3_44(B, 1, C, 2));
        A.set20(OdeMath.dCalcVectorDot3_44(B, 2, C, 0));
        A.set21(OdeMath.dCalcVectorDot3_44(B, 2, C, 1));
        A.set22(OdeMath.dCalcVectorDot3_44(B, 2, C, 2));
    }

    private static void dMULTIPLYOP2_333(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        A.set00(B.dotRowRow(0, C, 0));
        A.set01(B.dotRowRow(0, C, 1));
        A.set02(B.dotRowRow(0, C, 2));
        A.set10(B.dotRowRow(1, C, 0));
        A.set11(B.dotRowRow(1, C, 1));
        A.set12(B.dotRowRow(1, C, 2));
        A.set20(B.dotRowRow(2, C, 0));
        A.set21(B.dotRowRow(2, C, 1));
        A.set22(B.dotRowRow(2, C, 2));
    }

    public static void dMultiply0_331(DVector3 A, DMatrix3C B, DVector3C C) {
        OdeMath.dMULTIPLYOP0_331(A, B, C);
    }

    public static void dMultiply0_331(DMatrix3 A, DMatrix3C B, DVector3C C) {
        OdeMath.dMULTIPLYOP0_331(A, B, C);
    }

    public static void dMultiply0_331(DVector3 A, DMatrix3C B, double[] C, int c) {
        OdeMath.dMULTIPLYOP0_331(A, B, C, c);
    }

    public static void dMultiply0_331(double[] A, int a, double[] B, int b, DVector3C C) {
        OdeMath.dMULTIPLYOP0_331(A, a, B, b, C);
    }

    public static void dMultiply0_331(double[] A, int a, double[] B, int b, double[] C, int c) {
        OdeMath.dMULTIPLYOP0_331(A, a, B, b, C, c);
    }

    @Deprecated
    public static void dMULTIPLY0_331(DVector3 A, DMatrix3C B, DVector3C C) {
        OdeMath.dMultiply0_331(A, B, C);
    }

    @Deprecated
    public static void dMULTIPLY0_331(DMatrix3 A, DMatrix3C B, DVector3C C) {
        OdeMath.dMultiply0_331(A, B, C);
    }

    @Deprecated
    public static void dMULTIPLY0_331(DVector3 A, DMatrix3C B, double[] C, int c) {
        OdeMath.dMultiply0_331(A, B, C, c);
    }

    @Deprecated
    public static void dMULTIPLY0_331(double[] A, int a, double[] B, int b, DVector3C C) {
        OdeMath.dMultiply0_331(A, a, B, b, C);
    }

    @Deprecated
    public static void dMULTIPLY0_331(double[] A, int a, double[] B, int b, double[] C, int c) {
        OdeMath.dMultiply0_331(A, a, B, b, C, c);
    }

    public static void dMultiply1_331(DVector3 A, DMatrix3C B, DVector3C C) {
        OdeMath.dMULTIPLYOP1_331(A, B, C);
    }

    public static void dMultiply0_133(DVector3 A, DVector3C B, DMatrix3C C) {
        OdeMath.dMULTIPLYOP0_133(A, B, C);
    }

    public static void dMultiply0_133(double[] A, int a, double[] B, int b, double[] C, int c) {
        A[0 + a] = OdeMath.dCalcVectorDot3_14(B, b, C, 0 + c);
        A[1 + a] = OdeMath.dCalcVectorDot3_14(B, b, C, 1 + c);
        A[2 + a] = OdeMath.dCalcVectorDot3_14(B, b, C, 2 + c);
    }

    public static void dMultiply0_333(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        OdeMath.dMULTIPLYOP0_333(A, B, C);
    }

    public static void dMultiply0_333(double[] A, int a, DMatrix3C B, DMatrix3C C) {
        OdeMath.dMULTIPLYOP0_333(A, a, B, C);
    }

    @Deprecated
    public static void dMULTIPLY1_331(DVector3 A, DMatrix3C B, DVector3C C) {
        OdeMath.dMultiply1_331(A, B, C);
    }

    @Deprecated
    public static void dMULTIPLY0_133(DVector3 A, DVector3C B, DMatrix3C C) {
        OdeMath.dMultiply0_133(A, B, C);
    }

    @Deprecated
    public static void dMULTIPLY0_133(double[] A, int a, double[] B, int b, double[] C, int c) {
        OdeMath.dMultiply0_133(A, a, B, b, C, c);
    }

    @Deprecated
    public static void dMULTIPLY0_333(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        OdeMath.dMultiply0_333(A, B, C);
    }

    @Deprecated
    public static void dMULTIPLY0_333(double[] A, int a, DMatrix3C B, DMatrix3C C) {
        OdeMath.dMultiply0_333(A, a, B, C);
    }

    public static void dMultiply1_333(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        OdeMath.dMULTIPLYOP1_333(A, B, C);
    }

    public static void dMultiply2_333(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        OdeMath.dMULTIPLYOP2_333(A, B, C);
    }

    @Deprecated
    public static void dMULTIPLY1_333(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        OdeMath.dMultiply1_333(A, B, C);
    }

    @Deprecated
    public static void dMULTIPLY2_333(DMatrix3 A, DMatrix3C B, DMatrix3C C) {
        OdeMath.dMultiply2_333(A, B, C);
    }

    public static void dMultiplyAdd0_331(DVector3 A, double[] B, int b, DVector3C C) {
        A.add0(OdeMath.dCalcVectorDot3(B, b + 0, C));
        A.add1(OdeMath.dCalcVectorDot3(B, b + 4, C));
        A.add2(OdeMath.dCalcVectorDot3(B, b + 8, C));
    }

    public static void dMultiplyAdd0_331(DVector3 A, double[] B, int b, double[] C, int c) {
        A.add0(OdeMath.dCalcVectorDot3(B, b + 0, C, c));
        A.add1(OdeMath.dCalcVectorDot3(B, b + 4, C, c));
        A.add2(OdeMath.dCalcVectorDot3(B, b + 8, C, c));
    }

    @Deprecated
    public static void dMULTIPLYADD0_331(DVector3 A, double[] B, int b, DVector3C C) {
        OdeMath.dMultiplyAdd0_331(A, B, b, C);
    }

    @Deprecated
    public static void dMULTIPLYADD0_331(DVector3 A, double[] B, int b, double[] C, int c) {
        OdeMath.dMultiplyAdd0_331(A, B, b, C, c);
    }

    private static void _dNormalize3(DVector3 a) {
        boolean bNormalizationResult = OdeMath._dSafeNormalize3(a);
        Common.dIASSERT(bNormalizationResult);
    }

    static boolean _dSafeNormalize3(DVector3 a) {
        double s;
        double aa0 = Math.abs(a.get0());
        double aa1 = Math.abs(a.get1());
        double aa2 = Math.abs(a.get2());
        if (aa1 > aa0) {
            s = aa2 > aa1 ? aa2 : aa1;
        } else if (aa2 > aa0) {
            s = aa2;
        } else {
            if (aa0 <= 0.0) {
                a.set(1.0, 0.0, 0.0);
                return false;
            }
            s = aa0;
        }
        a.scale(1.0 / s);
        a.scale(1.0 / a.length());
        return true;
    }

    static boolean _dSafeNormalize3(DVector3View a) {
        double s;
        double aa0 = Math.abs(a.get0());
        double aa1 = Math.abs(a.get1());
        double aa2 = Math.abs(a.get2());
        if (aa1 > aa0) {
            s = aa2 > aa1 ? aa2 : aa1;
        } else if (aa2 > aa0) {
            s = aa2;
        } else {
            if (aa0 <= 0.0) {
                a.set(1.0, 0.0, 0.0);
                return false;
            }
            s = aa0;
        }
        a.scale(1.0 / s);
        a.scale(1.0 / a.length());
        return true;
    }

    public static boolean dSafeNormalize3(DVector3 a) {
        return OdeMath._dSafeNormalize3(a);
    }

    public static boolean dSafeNormalize3(DVector3View a) {
        return OdeMath._dSafeNormalize3(a);
    }

    public static void dNormalize3(DVector3 a) {
        OdeMath._dNormalize3(a);
    }

    public static boolean dSafeNormalize4(DVector4 a) {
        return a.safeNormalize4();
    }

    public static void dNormalize4(DVector4 a) {
        a.normalize();
    }

    public static void dNormalize4(DQuaternion a) {
        a.normalize();
    }

    public static void dPlaneSpace(DVector3C n, DVector3 p, DVector3 q) {
        Common.dAASSERT(n, p, q);
        if (Math.abs(n.get2()) > 0.7071067811865476) {
            double a = n.get1() * n.get1() + n.get2() * n.get2();
            double k = Common.dRecipSqrt(a);
            p.set(0.0, -n.get2() * k, n.get1() * k);
            q.set0(a * k);
            q.set1(-n.get0() * p.get2());
            q.set2(n.get0() * p.get1());
        } else {
            double a = n.get0() * n.get0() + n.get1() * n.get1();
            double k = Common.dRecipSqrt(a);
            p.set0(-n.get1() * k);
            p.set1(n.get0() * k);
            p.set2(0.0);
            q.set0(-n.get2() * p.get1());
            q.set1(n.get2() * p.get0());
            q.set2(a * k);
        }
    }

    public static void dOrthogonalizeR(DMatrix3 m) {
        double n1;
        DMatrix3.DVector3RowTView row1;
        double proj;
        DMatrix3.DVector3RowTView row0 = m.viewRowT(0);
        double n0 = row0.length();
        if (n0 != 1.0) {
            OdeMath.dSafeNormalize3(row0);
        }
        if ((proj = row0.dot(row1 = m.viewRowT(1))) != 0.0) {
            m.set10(m.get10() - proj * m.get00());
            m.set11(m.get11() - proj * m.get01());
            m.set12(m.get12() - proj * m.get02());
        }
        if ((n1 = row1.dot(row1)) != 1.0) {
            OdeMath.dSafeNormalize3(row1);
        }
        DMatrix3.DVector3RowTView row2 = m.viewRowT(2);
        OdeMath.dCalcVectorCross3(row2, row0, row1);
    }

    @Deprecated
    public static enum OP {
        ADD,
        SUB,
        MUL,
        DIV,
        EQ,
        ADD_EQ,
        EQ_SUB,
        MUL_EQ,
        SUB_EQ;

    }
}

